/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.util;

import crazydev.common.collection.CdCollections;
import crazydev.iccube.collection.OlapIterator;
import crazydev.iccube.olap.component.naming.ONames;
import crazydev.iccube.olap.component.naming.OlapNameContext;
import crazydev.iccube.olap.entity.dimension.OlapDimension;
import crazydev.iccube.olap.entity.hierarchy.OlapHierarchy;
import crazydev.iccube.olap.entity.level.OlapLevel;
import crazydev.iccube.olap.entity.member.OlapMember;
import crazydev.iccube.olap.entity.tuple.IOlapTuple;
import crazydev.iccube.olap.entity.tuple.OlapTuple;
import crazydev.iccube.olap.entity.tuple.dimensionality.OlapTupleDimensionality;
import crazydev.iccube.olap.index.bitmap.OlapBitmap;
import crazydev.iccube.olap.index.bitmap.OlapBitmapAggregation;
import crazydev.iccube.olap.index.bitmap.tor.IBitmapAndTor;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.Nullable;

public abstract class OlapExistHelper {
    @Nullable
    public static OlapMember autoExists(OlapNameContext nameContext, @Nullable OlapMember baseHierarchyMember, OlapHierarchy secondaryHierarchy, @Nullable OlapTuple tupleForExist) {
        if (baseHierarchyMember == null || tupleForExist == null) {
            return null;
        }
        OlapMember matchingMember = null;
        OlapLevel level = secondaryHierarchy.unfilteredLookupLevelByName(nameContext, ONames.name4Log(baseHierarchyMember.getLevel()));
        OlapIterator secondaryHierarchyIterator = level != null ? level.getMembers(null).getIterator(false) : secondaryHierarchy.getLastLevel().getMembers(null).getIterator(false);
        if (secondaryHierarchyIterator != null) {
            OlapMember member;
            secondaryHierarchyIterator.reset();
            while ((member = (OlapMember)secondaryHierarchyIterator.next()) != null) {
                if (member.isAll() || !OlapExistHelper.existsSameDim(tupleForExist, member)) continue;
                if (matchingMember != null) {
                    return null;
                }
                matchingMember = member;
            }
        }
        return matchingMember;
    }

    private static boolean existsSameDim(OlapTuple tuple, OlapMember member) {
        ArrayList<OlapMember> members = new ArrayList<OlapMember>();
        members.add(member);
        for (int i = 0; i < tuple.getMemberCount(); ++i) {
            members.add(tuple.getMember(i));
        }
        return OlapExistHelper.existsSameDim(members, false);
    }

    public static boolean existsSameDim(List<OlapMember> members, boolean acceptSameHierarchy) {
        if (members.isEmpty()) {
            return false;
        }
        if (members.size() == 1) {
            return true;
        }
        int relevantMemberCount = 0;
        BitSet hierarchyBitSet = new BitSet();
        boolean sameHierarchy = false;
        for (int ii = 0; ii < members.size(); ++ii) {
            OlapMember member = members.get(ii);
            if (!sameHierarchy) {
                int hierIndex = member.getHierarchy().getTupleDimensionalityIndex();
                if (hierarchyBitSet.get(hierIndex)) {
                    sameHierarchy = true;
                }
                hierarchyBitSet.set(hierIndex);
            }
            if (!OlapExistHelper.isExistsSameDimRelevant(member)) continue;
            ++relevantMemberCount;
        }
        if (relevantMemberCount <= 1) {
            return true;
        }
        if (sameHierarchy && !OlapExistHelper.existsSameHierarchy(members)) {
            return false;
        }
        IBitmapAndTor andtor = OlapBitmapAggregation.createOlapBitmapAndtor();
        for (int ii = 0; ii < members.size(); ++ii) {
            OlapMember member = members.get(ii);
            if (!OlapExistHelper.isExistsSameDimRelevant(member)) continue;
            OlapBitmap bitmap = acceptSameHierarchy ? member.getFullMemberBitmap() : member.getBaseMemberBitmap4Exist();
            andtor.addForAnd(bitmap);
        }
        return andtor.isNoEmpty();
    }

    private static boolean existsSameHierarchy(List<OlapMember> members) {
        HashMap<OlapHierarchy, ArrayList<OlapMember>> membersByHierarchy = new HashMap<OlapHierarchy, ArrayList<OlapMember>>();
        for (OlapMember member : members) {
            ArrayList<OlapMember> list = (ArrayList<OlapMember>)membersByHierarchy.get(member.getHierarchy());
            if (list == null) {
                list = new ArrayList<OlapMember>();
                membersByHierarchy.put(member.getHierarchy(), list);
            }
            list.add(member);
        }
        for (List memberPerHierarchy : membersByHierarchy.values()) {
            if (memberPerHierarchy.size() <= 1 || !OlapExistHelper.sameHierarchyNotExists(memberPerHierarchy)) continue;
            return false;
        }
        return true;
    }

    private static boolean sameHierarchyNotExists(List<OlapMember> hierarchy) {
        int size = hierarchy.size();
        for (int i = 0; i < size; ++i) {
            OlapMember member = hierarchy.get(i);
            for (int j = i + 1; j < size; ++j) {
                OlapMember member2 = hierarchy.get(j);
                if (member.isSameBranch(member2)) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean isExistsSameDimRelevant(OlapMember member) {
        return !member.isAll();
    }

    public static boolean __existsSameDimForTest(OlapMember member1, OlapMember member2) {
        OlapBitmap bitmap1 = member1.getBaseMemberBitmap();
        OlapBitmap bitmap2 = member2.getBaseMemberBitmap();
        if (OlapBitmap.isOneBitmap(bitmap1) || OlapBitmap.isOneBitmap(bitmap2)) {
            return true;
        }
        IBitmapAndTor andtor = OlapBitmapAggregation.createOlapBitmapAndtor();
        andtor.addForAnd(bitmap1);
        andtor.addForAnd(bitmap2);
        return andtor.isNoEmpty();
    }

    public static boolean existsForSubSelect(IOlapTuple tuple, IOlapTuple filterTuple) {
        HashMap<OlapDimension, List<OlapMember>> membersByDimension = new HashMap<OlapDimension, List<OlapMember>>();
        HashSet<OlapDimension> filterCalcMembers = new HashSet<OlapDimension>();
        HashSet<OlapDimension> calcMembers = new HashSet<OlapDimension>();
        OlapExistHelper.setupMembersByDimension(membersByDimension, tuple, calcMembers);
        OlapExistHelper.setupMembersByDimension(membersByDimension, filterTuple, filterCalcMembers);
        for (OlapDimension calcMemberDimension : filterCalcMembers) {
            List members = (List)membersByDimension.remove(calcMemberDimension);
            if (CdCollections.allEquals((List)members)) continue;
            return false;
        }
        for (OlapDimension olapDimension : calcMembers) {
            membersByDimension.remove(olapDimension);
        }
        return OlapExistHelper.exists(membersByDimension, false);
    }

    public static boolean exists(IOlapTuple tuple1, IOlapTuple tuple2) {
        HashMap<OlapDimension, List<OlapMember>> membersByDimension = new HashMap<OlapDimension, List<OlapMember>>();
        OlapExistHelper.setupMembersByDimension(membersByDimension, tuple1, null);
        OlapExistHelper.setupMembersByDimension(membersByDimension, tuple2, null);
        return OlapExistHelper.exists(membersByDimension, false);
    }

    public static boolean exists(IOlapTuple tuple) {
        HashMap<OlapDimension, List<OlapMember>> membersByDimension = new HashMap<OlapDimension, List<OlapMember>>();
        OlapExistHelper.setupMembersByDimension(membersByDimension, tuple, null);
        return OlapExistHelper.exists(membersByDimension, false);
    }

    private static void setupMembersByDimension(Map<OlapDimension, List<OlapMember>> membersByDimension, IOlapTuple tuple, @Nullable Set<OlapDimension> calcDimensions) {
        int count = tuple.getMemberCount();
        for (int idx = 0; idx < count; ++idx) {
            List<OlapMember> xmembers;
            OlapMember member = tuple.getMember(idx);
            OlapDimension memberDimension = member.getDimension();
            if (calcDimensions == null && member.existAllways()) continue;
            if (member.isCalculated()) {
                if (calcDimensions == null) continue;
                calcDimensions.add(memberDimension);
            }
            if ((xmembers = membersByDimension.get(memberDimension)) == null) {
                xmembers = new ArrayList<OlapMember>();
                membersByDimension.put(memberDimension, xmembers);
            }
            if (xmembers.contains(member)) continue;
            xmembers.add(member);
        }
    }

    private static boolean exists(Map<OlapDimension, List<OlapMember>> membersByDimension, boolean acceptSameHierarchy) {
        for (OlapDimension dimension : membersByDimension.keySet()) {
            List<OlapMember> xmembers = membersByDimension.get(dimension);
            if (xmembers.size() <= 1 || OlapExistHelper.existsSameDim(xmembers, acceptSameHierarchy)) continue;
            return false;
        }
        return true;
    }

    public static boolean forExistsFunction(OlapTuple tuple, OlapTuple tuple2) {
        boolean sameDim = OlapTupleDimensionality.same(tuple, tuple2);
        HashMap<OlapDimension, List<OlapMember>> membersByDimension = new HashMap<OlapDimension, List<OlapMember>>();
        OlapExistHelper.setupMembersByDimension(membersByDimension, tuple, null);
        OlapExistHelper.setupMembersByDimension(membersByDimension, tuple2, null);
        return OlapExistHelper.exists(membersByDimension, sameDim);
    }
}

