/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.schema.stats;

import crazydev.common.utils.CdStringUtils;
import crazydev.common.utils.CdTimeUtils;
import crazydev.iccube.olap.schema.stats.OlapSchemaStats;
import crazydev.iccube.olap.schema.stats.OlapStatsFields;
import java.util.List;

public class OlapSchemaTableStats {
    private final List<Info> dimInfos;
    private final List<Info> factsInfos;

    public OlapSchemaTableStats(List<Info> dimInfos, List<Info> factsInfos) {
        this.dimInfos = dimInfos;
        this.factsInfos = factsInfos;
        this.dimInfos.sort((o1, o2) -> -Long.compare(o1.processingElapsedMS, o2.processingElapsedMS));
        this.factsInfos.sort((o1, o2) -> -Long.compare(o1.processingElapsedMS, o2.processingElapsedMS));
    }

    public void print(StringBuilder sb) {
        OlapStatsFields fieldsF = new OlapStatsFields();
        fieldsF.addFields("Dimension Table", "Row Count", "Reading", "Processing", "Speed");
        fieldsF.addFields("---------------", "---------", "-------", "----------", "-----");
        for (Info info : this.dimInfos) {
            fieldsF.addFields(info.name, info.rowCountS(), info.readingElapsedS(), info.processingElapsedS(), info.rowSecS());
        }
        OlapSchemaStats.println(sb, "");
        OlapSchemaStats.println(sb, fieldsF.toString());
        fieldsF = new OlapStatsFields();
        fieldsF.addFields("Facts Table", "Row Count", "Reading", "Processing", "Speed");
        fieldsF.addFields("-----------", "---------", "-------", "----------", "-----");
        for (Info info : this.factsInfos) {
            fieldsF.addFields(info.name, info.rowCountS(), info.readingElapsedS(), info.processingElapsedS(), info.rowSecS());
        }
        OlapSchemaStats.println(sb, "");
        OlapSchemaStats.println(sb, fieldsF.toString());
    }

    public static class Info {
        private final String name;
        private final long rowCount;
        private final long readingElapsedMS;
        private final long processingElapsedMS;

        public Info(String name, long rowCount, long readingElapsedMS, long processingElapsedMS) {
            this.name = name;
            this.rowCount = rowCount;
            this.readingElapsedMS = readingElapsedMS;
            this.processingElapsedMS = processingElapsedMS;
        }

        public String rowCountS() {
            return this.rowCount != -1L ? CdStringUtils.formatNice((long)this.rowCount) : "-";
        }

        public String readingElapsedS() {
            return this.readingElapsedMS != -1L ? CdTimeUtils.formatMillis((long)this.readingElapsedMS) : "-";
        }

        public String processingElapsedS() {
            return this.processingElapsedMS != -1L ? CdTimeUtils.formatMillis((long)this.processingElapsedMS) : "-";
        }

        public String rowSecS() {
            if (this.processingElapsedMS == 0L || this.processingElapsedMS == -1L || this.rowCount == -1L) {
                return "-";
            }
            long rowSec = (int)((double)this.rowCount * 1000.0 / (double)this.processingElapsedMS);
            return CdStringUtils.formatNice((long)rowSec) + " row/sec";
        }

        public String toString() {
            return String.format("%s [rowCount : %s] [reading = %s] [processing = %s]", this.name, this.rowCountS(), this.readingElapsedS(), this.processingElapsedS());
        }
    }
}

