/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.schema.stats;

import crazydev.common.utils.CdSizeUtils;
import crazydev.common.utils.CdTimeUtils;
import crazydev.iccube.olap.schema.stats.OlapSchemaStats;
import crazydev.iccube.olap.schema.stats.OlapStatsFields;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class OlapSchemaFullLoadGCStats {
    private static final String FACTS_PROCESSING = "ic3 Facts Proc. Started";
    private final Object LOCK = new Object();
    private final List<GCEvent> events = new ArrayList<GCEvent>();
    @Nullable
    private GCEvent lastEvent;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onGCActivity(String name, long elapsedMS, long freeM, long totalM, long maxM) {
        Object object = this.LOCK;
        synchronized (object) {
            this.lastEvent = new GCEvent(name, elapsedMS, freeM, totalM, maxM);
            if (this.events.isEmpty()) {
                this.events.add(this.lastEvent);
            } else {
                GCEvent event = this.events.getLast();
                if (totalM != event.totalM) {
                    this.events.add(this.lastEvent);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onFactsProcessingStarted() {
        Object object = this.LOCK;
        synchronized (object) {
            this.events.add(new GCEvent(FACTS_PROCESSING, 0L, 0L, 0L, 0L));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void print(StringBuilder sb) {
        Object object = this.LOCK;
        synchronized (object) {
            OlapStatsFields fieldsF = new OlapStatsFields();
            fieldsF.addFields("Name", "Free", "Total", "Max", "Elapsed");
            fieldsF.addFields("----", "----", "-----", "---", "-------");
            for (GCEvent event : this.events) {
                fieldsF.addFields(event.name, CdSizeUtils.format((double)event.freeM), CdSizeUtils.format((double)event.totalM), CdSizeUtils.format((double)event.maxM), CdTimeUtils.formatMillis((long)event.elapsedMS));
            }
            if (this.lastEvent != null) {
                fieldsF.addFields(this.lastEvent.name, CdSizeUtils.format((double)this.lastEvent.freeM), CdSizeUtils.format((double)this.lastEvent.totalM), CdSizeUtils.format((double)this.lastEvent.maxM), CdTimeUtils.formatMillis((long)this.lastEvent.elapsedMS));
            }
            OlapSchemaStats.println(sb, "");
            OlapSchemaStats.println(sb, fieldsF.toString());
        }
    }

    private static class GCEvent {
        private final String name;
        private final long elapsedMS;
        private final long freeM;
        private final long totalM;
        private final long maxM;

        public GCEvent(String name, long elapsedMS, long freeM, long totalM, long maxM) {
            this.name = name;
            this.elapsedMS = elapsedMS;
            this.freeM = freeM;
            this.totalM = totalM;
            this.maxM = maxM;
        }
    }
}

