/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.schema.stats;

import crazydev.common.cache.CdLRUCacheStats;
import crazydev.common.utils.CdStringUtils;
import crazydev.common.utils.CdTimeUtils;
import crazydev.iccube.builder.OlapBuilderContext;
import crazydev.iccube.builder.datasource.facts.OlapBuilderFacts;
import crazydev.iccube.builder.executor.rowprocessing.OlapBuilderTableRowProcessingTaskExecutor;
import crazydev.iccube.builder.model.def.IOlapBuilderDataViewLinksDef;
import crazydev.iccube.builder.model.def.IOlapBuilderDimensionDef;
import crazydev.iccube.builder.model.def.IOlapBuilderMeasureDef;
import crazydev.iccube.builder.model.def.OlapBuilderDataViewLinksType;
import crazydev.iccube.olap.component.context.IOlapContextLoggers;
import crazydev.iccube.olap.cube.OlapRegularCube;
import crazydev.iccube.olap.loggers.OlapLoggers;
import crazydev.iccube.olap.schema.stats.OlapSchemaStats;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.Nullable;

public class OlapSchemaFactsBuilderStats {
    public static final int BOUND_CHECK = 100000;
    private final String configuration;
    private final String facts;
    private final int colCount;
    private final String colCountSource;
    private final AtomicLong startTimeMS = new AtomicLong();
    private final AtomicLong completionTimeMS = new AtomicLong();
    private final AtomicBoolean firstCall = new AtomicBoolean();
    private final AtomicLong callCount = new AtomicLong();
    private final AtomicLong rowCount = new AtomicLong();
    private final AtomicLong fullNS = new AtomicLong();
    private final AtomicLong resolveNS = new AtomicLong();
    private final AtomicLong pageNS = new AtomicLong();
    private final AtomicLong pageLockCount = new AtomicLong();
    private final AtomicLong pageLockNS = new AtomicLong();
    private final AtomicLong boundCheck = new AtomicLong();
    private final AtomicLong queueTaskCountSum = new AtomicLong();
    private final AtomicLong queueTaskCountCount = new AtomicLong();
    private final Object reportedResolveMemberCacheStatsLOCK = new Object();
    @Nullable
    private CdLRUCacheStats[] reportedResolveMemberCacheStats;
    @Nullable
    private String reportedResolveMemberCacheStatsError;

    public OlapSchemaFactsBuilderStats(String configuration, OlapRegularCube cube, OlapBuilderFacts facts) {
        this.configuration = configuration;
        this.facts = cube.getNameX() + "." + facts.getMeasureGroupName();
        Object table = facts.getDataView();
        if (table != null) {
            int count = table.getSelectedColumnsCountForStats();
            if (count != -1) {
                this.colCount = count;
                this.colCountSource = "table";
            } else {
                this.colCount = OlapSchemaFactsBuilderStats.estimateColCountFromOlapEntities(facts);
                this.colCountSource = "measures (table-error)";
            }
        } else {
            this.colCount = OlapSchemaFactsBuilderStats.estimateColCountFromOlapEntities(facts);
            this.colCountSource = "measures";
        }
        this.firstCall.set(false);
        this.startTimeMS.set(System.currentTimeMillis());
        this.completionTimeMS.set(-1L);
        this.boundCheck.set(100000L);
    }

    private static int estimateColCountFromOlapEntities(OlapBuilderFacts facts) {
        try {
            int colCount = 0;
            List<IOlapBuilderMeasureDef> measures = facts.getMeasures();
            colCount += measures.size();
            Map<IOlapBuilderDimensionDef, IOlapBuilderDataViewLinksDef> links = facts.getDimensionMap();
            for (IOlapBuilderDataViewLinksDef value : links.values()) {
                OlapBuilderDataViewLinksType linkType;
                if (value == null || (linkType = value.getType()) == OlapBuilderDataViewLinksType.NOT_MAPPED) continue;
                ++colCount;
            }
            return colCount;
        }
        catch (RuntimeException ex) {
            OlapLoggers.BUILDER.error((Object)("[facts] could not determine col-count : " + facts.getMeasureGroupName()), (Throwable)ex);
            return -1;
        }
    }

    public String getName() {
        return this.facts;
    }

    public long getElapsedTimeMS() {
        long completionTimeMS_ = this.completionTimeMS.get();
        if (completionTimeMS_ == -1L) {
            return -1L;
        }
        return completionTimeMS_ - this.startTimeMS.get();
    }

    public void onFactsProcessingCompleted(IOlapContextLoggers loggers) {
        Logger logger = loggers.builder();
        if (!logger.isDebugEnabled()) {
            return;
        }
        try {
            logger.debug((Object)("[builder] facts processing completed : " + this.facts + "\n" + this.print(null).toString()));
        }
        catch (RuntimeException ex) {
            logger.warn((Object)"unexpected error while generating loading stats", (Throwable)ex);
        }
    }

    public void onFullProcessed(OlapBuilderContext builderContext, int rowCount, long ns) {
        OlapBuilderTableRowProcessingTaskExecutor executor;
        long nowMS = System.currentTimeMillis();
        if (this.firstCall.compareAndSet(false, true)) {
            this.startTimeMS.set(nowMS - TimeUnit.NANOSECONDS.toMillis(ns));
        }
        this.completionTimeMS.set(nowMS);
        this.fullNS.addAndGet(ns);
        this.callCount.incrementAndGet();
        long rowCount_ = this.rowCount.addAndGet(rowCount);
        long boundCheck_ = this.boundCheck.get();
        if (rowCount_ >= boundCheck_ && this.boundCheck.compareAndSet(boundCheck_, boundCheck_ + 100000L) && (executor = builderContext.getBuilderProcessingExecutorX()) != null) {
            int taskCount = executor.getQueuedTaskCount();
            this.queueTaskCountSum.addAndGet(taskCount);
            this.queueTaskCountCount.incrementAndGet();
            if (OlapLoggers.BUILDER.isInfoEnabled()) {
                OlapLoggers.BUILDER.info((Object)("[facts] " + this.facts + " has processed [" + rowCount_ + "] rows [processing-queue:" + taskCount + "]"));
            }
        }
    }

    public void onResolveProcessed(long ns) {
        this.resolveNS.addAndGet(ns);
    }

    public void onPageProcessed(long ns) {
        this.pageNS.addAndGet(ns);
    }

    public void onPageLock() {
        this.pageLockCount.incrementAndGet();
    }

    public void onPageLockNS(long ns) {
        this.pageLockNS.addAndGet(ns);
    }

    private static String formatTime(Date timestamp) {
        return new SimpleDateFormat("MMM-dd HH:mm:ss").format(timestamp);
    }

    public String formatStartTime() {
        long ms = this.startTimeMS.get();
        return OlapSchemaFactsBuilderStats.formatTime(new Date(ms));
    }

    public String formatCompletionTime() {
        long ms = this.completionTimeMS.get();
        if (ms == -1L) {
            return "-1";
        }
        return OlapSchemaFactsBuilderStats.formatTime(new Date(ms));
    }

    public String formatElapsedTime() {
        long ms = this.getElapsedTimeMS();
        if (ms == -1L) {
            return "-1";
        }
        return CdTimeUtils.formatMillis((long)ms);
    }

    private String formatBatchSize() {
        long callCount_ = this.callCount.get();
        long rowCount_ = this.rowCount.get();
        if (callCount_ == 0L) {
            return "-1";
        }
        return "" + (int)(rowCount_ / callCount_);
    }

    private String formatRowsSec() {
        long elapsedMS = this.getElapsedTimeMS();
        if (elapsedMS == 0L || elapsedMS == -1L) {
            return "-1";
        }
        return CdStringUtils.formatNice((long)(1000L * this.rowCount.get() / elapsedMS));
    }

    private String formatTaskQueue() {
        long count = this.queueTaskCountCount.get();
        if (count == 0L) {
            return "-1";
        }
        return "" + this.queueTaskCountSum.get() / this.queueTaskCountCount.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reportResolveMemberCacheStats(CdLRUCacheStats[] stats) {
        Object object = this.reportedResolveMemberCacheStatsLOCK;
        synchronized (object) {
            if (this.reportedResolveMemberCacheStatsError != null) {
                return;
            }
            try {
                this.reportedResolveMemberCacheStats = CdLRUCacheStats.merge((CdLRUCacheStats[])this.reportedResolveMemberCacheStats, (CdLRUCacheStats[])stats);
            }
            catch (RuntimeException ex) {
                OlapLoggers.BUILDER.error((Object)"[stats] could not report resolve member cache stats", (Throwable)ex);
                this.reportedResolveMemberCacheStatsError = "stats on error (check logs for more details) : " + ex.getMessage();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StringBuilder print(@Nullable StringBuilder sb) {
        if (sb == null) {
            sb = new StringBuilder();
        }
        OlapSchemaStats.println(sb, "");
        OlapSchemaStats.println(sb, "  Start Time         : " + this.formatStartTime());
        OlapSchemaStats.println(sb, "  Completion Time    : " + this.formatCompletionTime());
        OlapSchemaStats.println(sb, "");
        OlapSchemaStats.println(sb, "  Configuration      : " + this.configuration);
        OlapSchemaStats.println(sb, "");
        OlapSchemaStats.println(sb, "  Elapsed            : " + this.formatElapsedTime());
        OlapSchemaStats.println(sb, "  - whole processing : " + CdTimeUtils.formatNanos((long)this.fullNS.get()));
        OlapSchemaStats.println(sb, "  - resolve members  : " + CdTimeUtils.formatNanos((long)this.resolveNS.get()));
        OlapSchemaStats.println(sb, "  - index & columns  : " + CdTimeUtils.formatNanos((long)this.pageNS.get()));
        OlapSchemaStats.println(sb, "");
        OlapSchemaStats.println(sb, "  Page Lock Time     : " + CdTimeUtils.formatNanos((long)this.pageLockNS.get()));
        OlapSchemaStats.println(sb, "  Page Lock Count    : " + this.pageLockCount.get());
        OlapSchemaStats.println(sb, "");
        OlapSchemaStats.println(sb, "  Batch Size         : " + this.formatBatchSize());
        OlapSchemaStats.println(sb, "");
        OlapSchemaStats.println(sb, "  Rows Count         : " + CdStringUtils.formatNice((long)this.rowCount.get()));
        OlapSchemaStats.println(sb, "  Rows/Sec           : " + this.formatRowsSec());
        OlapSchemaStats.println(sb, "");
        OlapSchemaStats.println(sb, "  Row Col. Count     : " + this.colCount + " [" + this.colCountSource + "]");
        OlapSchemaStats.println(sb, "");
        OlapSchemaStats.println(sb, "  Task Queue         : " + this.formatTaskQueue());
        Object object = this.reportedResolveMemberCacheStatsLOCK;
        synchronized (object) {
            if (this.reportedResolveMemberCacheStatsError != null) {
                OlapSchemaStats.println(sb, "");
                OlapSchemaStats.println(sb, "  RM. Cache Error    : " + this.reportedResolveMemberCacheStatsError);
            } else if (this.reportedResolveMemberCacheStats != null) {
                long resolveMemberNil = OlapSchemaFactsBuilderStats.getResolveMemberNil(this.reportedResolveMemberCacheStats);
                long resolveMemberPrevHit = OlapSchemaFactsBuilderStats.getResolveMemberPrevHit(this.reportedResolveMemberCacheStats);
                long resolveMemberCacheHit = OlapSchemaFactsBuilderStats.getResolveMemberCacheHit(this.reportedResolveMemberCacheStats);
                long resolveMemberCacheMiss = OlapSchemaFactsBuilderStats.getResolveMemberCacheMiss(this.reportedResolveMemberCacheStats);
                long resolveMemberCacheTotal = resolveMemberNil + resolveMemberPrevHit + resolveMemberCacheHit + resolveMemberCacheMiss;
                OlapSchemaStats.println(sb, "");
                OlapSchemaStats.println(sb, "  RM. Nil            : " + CdStringUtils.formatNice((long)resolveMemberNil));
                OlapSchemaStats.println(sb, "  RM. Prev. Hit      : " + CdStringUtils.formatNice((long)resolveMemberPrevHit));
                OlapSchemaStats.println(sb, "  RM. Cache Hit      : " + CdStringUtils.formatNice((long)resolveMemberCacheHit));
                OlapSchemaStats.println(sb, "  RM. Cache Miss     : " + CdStringUtils.formatNice((long)resolveMemberCacheMiss));
                OlapSchemaStats.println(sb, "  RM. Total          : " + CdStringUtils.formatNice((long)resolveMemberCacheTotal));
                int dimNameLenMax = 6;
                int typeInfoLenMax = 6;
                int ltLenMax = 2;
                int nilLenMax = 6;
                int prevHitLenMax = 6;
                int cacheHitLenMax = 6;
                int cacheMissLenMax = 6;
                OlapSchemaStats.println(sb, "");
                for (int ii = 0; ii < this.reportedResolveMemberCacheStats.length; ++ii) {
                    CdLRUCacheStats stats = this.reportedResolveMemberCacheStats[ii];
                    typeInfoLenMax = Math.max(typeInfoLenMax, stats.getTypeInfo().length());
                    dimNameLenMax = Math.max(dimNameLenMax, stats.getName().length());
                    nilLenMax = Math.max(nilLenMax, CdStringUtils.formatNice((long)stats.getResolveMemberNil()).length());
                    prevHitLenMax = Math.max(prevHitLenMax, CdStringUtils.formatNice((long)stats.getResolveMemberPrevHit()).length());
                    cacheHitLenMax = Math.max(cacheHitLenMax, CdStringUtils.formatNice((long)stats.getResolveMemberCacheHit()).length());
                    cacheMissLenMax = Math.max(cacheMissLenMax, CdStringUtils.formatNice((long)stats.getResolveMemberCacheMiss()).length());
                }
                String format = "%" + dimNameLenMax + "s | %" + typeInfoLenMax + "s | %" + ltLenMax + "s | %" + nilLenMax + "s | %" + prevHitLenMax + "s | %" + cacheHitLenMax + "s | %" + cacheMissLenMax + "s";
                OlapSchemaStats.println(sb, "");
                OlapSchemaStats.println(sb, String.format("  RM. Cache Dim      : " + format, "dim", "type", "LT", "nil", "prev", "hit", "miss"));
                List<CdLRUCacheStats> ordered = Arrays.asList(this.reportedResolveMemberCacheStats);
                ordered.sort(Comparator.comparing(CdLRUCacheStats::getName));
                for (int ii = 0; ii < ordered.size(); ++ii) {
                    CdLRUCacheStats stats = ordered.get(ii);
                    OlapSchemaStats.println(sb, String.format("                     : " + format, stats.getName(), stats.getTypeInfo(), stats.isWithLT() ? "+" : (stats.isWithBridge() ? "-" : ""), CdStringUtils.formatNice((long)stats.getResolveMemberNil()), CdStringUtils.formatNice((long)stats.getResolveMemberPrevHit()), CdStringUtils.formatNice((long)stats.getResolveMemberCacheHit()), CdStringUtils.formatNice((long)stats.getResolveMemberCacheMiss())));
                }
            }
        }
        return sb;
    }

    private static long getResolveMemberNil(CdLRUCacheStats[] stats) {
        long value = 0L;
        for (int ii = 0; ii < stats.length; ++ii) {
            value += stats[ii].getResolveMemberNil();
        }
        return value;
    }

    private static long getResolveMemberPrevHit(CdLRUCacheStats[] stats) {
        long value = 0L;
        for (int ii = 0; ii < stats.length; ++ii) {
            value += stats[ii].getResolveMemberPrevHit();
        }
        return value;
    }

    private static long getResolveMemberCacheHit(CdLRUCacheStats[] stats) {
        long value = 0L;
        for (int ii = 0; ii < stats.length; ++ii) {
            value += stats[ii].getResolveMemberCacheHit();
        }
        return value;
    }

    private static long getResolveMemberCacheMiss(CdLRUCacheStats[] stats) {
        long value = 0L;
        for (int ii = 0; ii < stats.length; ++ii) {
            value += stats[ii].getResolveMemberCacheMiss();
        }
        return value;
    }
}

