/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.schema.stats;

import crazydev.iccube.cluster.node.facts.N_FactPageBitmapGutsBitmapCount;
import crazydev.iccube.cluster.node.facts.N_FactPageBitmapGutsSizeOf;
import crazydev.iccube.olap.schema.stats.OlapFactsLevelsBitmapsStats;
import crazydev.iccube.olap.schema.stats.OlapFactsPartitionStats;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class OlapFactsStats {
    private final String name;
    private final boolean tablePartitioned;
    private final boolean levelPartitioned;
    private final boolean indexInFiles;
    private final boolean factsInFiles;
    @Nullable
    private final Double cellCount;
    private final long unresolvedRowCount;
    private final long unresolvedRowRamSize;
    private final List<OlapFactsPartitionStats> partitions;
    private final OlapFactsLevelsBitmapsStats statsPerLevel;

    public OlapFactsStats(String name, boolean tablePartitioned, boolean levelPartitioned, boolean indexInFiles, boolean factsInFiles, @Nullable Double cellCount, long unresolvedRowCount, long unresolvedRowRamSize, List<OlapFactsPartitionStats> partitions, OlapFactsLevelsBitmapsStats statsPerLevel) {
        this.name = name;
        this.tablePartitioned = tablePartitioned;
        this.levelPartitioned = levelPartitioned;
        this.indexInFiles = indexInFiles;
        this.factsInFiles = factsInFiles;
        this.cellCount = cellCount;
        this.unresolvedRowCount = unresolvedRowCount;
        this.unresolvedRowRamSize = unresolvedRowRamSize;
        this.partitions = partitions;
        this.statsPerLevel = statsPerLevel;
    }

    public String getName() {
        return this.name;
    }

    public boolean isPartitioned() {
        return this.isTablePartitioned() || this.isLevelPartitioned();
    }

    public boolean isTablePartitioned() {
        return this.tablePartitioned;
    }

    public boolean isLevelPartitioned() {
        return this.levelPartitioned;
    }

    public boolean isIndexInFiles() {
        return this.indexInFiles;
    }

    public boolean isFactsInFiles() {
        return this.factsInFiles;
    }

    @Nullable
    public Double getCellCount() {
        return this.cellCount;
    }

    public long getUnresolvedRowCount() {
        return this.unresolvedRowCount;
    }

    public long getUnresolvedRowRamSize() {
        return this.unresolvedRowRamSize;
    }

    public List<OlapFactsPartitionStats> getPartitions() {
        return this.partitions;
    }

    public long getPartitionCount() {
        return this.partitions.size();
    }

    public boolean isRestoredFromConvertedBackup() {
        for (OlapFactsPartitionStats partition : this.partitions) {
            if (!partition.isRestoredFromConvertedBackup()) continue;
            return true;
        }
        return false;
    }

    public long getRowCount() {
        long count = 0L;
        for (OlapFactsPartitionStats partition : this.partitions) {
            count += partition.getRowCount();
        }
        return count;
    }

    public long getMetaTemporarySize() {
        long count = 0L;
        for (OlapFactsPartitionStats partition : this.partitions) {
            count += partition.getMetaTemporarySize();
        }
        return count;
    }

    public N_FactPageBitmapGutsBitmapCount getBitmapCount() {
        N_FactPageBitmapGutsBitmapCount count = new N_FactPageBitmapGutsBitmapCount();
        for (OlapFactsPartitionStats partition : this.partitions) {
            count.add(partition.getBitmapCount());
        }
        return count;
    }

    public N_FactPageBitmapGutsSizeOf getBitmapsRamSize() {
        N_FactPageBitmapGutsSizeOf size = new N_FactPageBitmapGutsSizeOf();
        for (OlapFactsPartitionStats partition : this.partitions) {
            size.add(partition.getBitmapsRamSize());
        }
        return size;
    }

    public long getColumnsRamSize() {
        long size = 0L;
        for (OlapFactsPartitionStats partition : this.partitions) {
            size += partition.getColumnsRamSize();
        }
        return size;
    }

    public long getColumnsFilesSize() {
        long size = 0L;
        for (OlapFactsPartitionStats partition : this.partitions) {
            size += partition.getColumnsFilesSize();
        }
        return size;
    }

    public OlapFactsLevelsBitmapsStats getStatsPerLevel() {
        return this.statsPerLevel;
    }

    public long getRamSize() {
        return this.getBitmapsRamSize().total + this.getColumnsRamSize() + this.getUnresolvedRowRamSize();
    }
}

