/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.schema.stats;

import crazydev.iccube.olap.schema.stats.OlapFactsLevelBitmapStats;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.Nullable;

public class OlapFactsLevelsBitmapsStats {
    private final Map<String, Map<String, OlapFactsLevelBitmapStats>> statsPerLevel = new HashMap<String, Map<String, OlapFactsLevelBitmapStats>>();

    public Set<String> getHierarchyNames() {
        return this.statsPerLevel.keySet();
    }

    public Map<String, OlapFactsLevelBitmapStats> getOrCreateHierarchy(String hierarchy) {
        return this.statsPerLevel.computeIfAbsent(hierarchy, hierarchy_ -> new HashMap());
    }

    public Map<String, OlapFactsLevelBitmapStats> getHierarchy(String name) {
        return this.statsPerLevel.get(name);
    }

    @Nullable
    public Stats getHierarchyX(String name) {
        Map<String, OlapFactsLevelBitmapStats> stats = this.statsPerLevel.get(name);
        if (stats != null) {
            return new Stats(name, stats);
        }
        return null;
    }

    public static class Stats {
        private String hierName;
        final Map<String, OlapFactsLevelBitmapStats> levels;

        public Stats(String hierName, Map<String, OlapFactsLevelBitmapStats> levels) {
            this.hierName = hierName;
            this.levels = levels;
        }

        public String getHierName() {
            return this.hierName;
        }

        public long getBitmapCount() {
            long count = 0L;
            for (OlapFactsLevelBitmapStats value : this.levels.values()) {
                count += value.getMemberCount();
            }
            return count;
        }

        public long getBitmapsSerializedSize() {
            long size = 0L;
            for (OlapFactsLevelBitmapStats value : this.levels.values()) {
                size += value.getBitmapsSerializedSize();
            }
            return size;
        }
    }
}

