/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.schema.stats;

import crazydev.iccube.olap.schema.stats.OlapHierarchyStats;
import crazydev.iccube.olap.util.OlapCaseInsensitiveName;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class OlapDimensionStats {
    private final String name;
    @Nullable
    private final OlapHierarchyStats baseHierarchy;
    private final List<OlapHierarchyStats> hierarchies;
    private final long elapsedMS;

    public OlapDimensionStats(String name, List<OlapHierarchyStats> hierarchies, long elapsedMS) {
        this.name = name;
        OlapHierarchyStats baseHierarchy = null;
        for (OlapHierarchyStats hierarchy : hierarchies) {
            if (!hierarchy.isBase()) continue;
            baseHierarchy = hierarchy;
        }
        this.baseHierarchy = baseHierarchy;
        this.hierarchies = hierarchies;
        this.elapsedMS = elapsedMS;
    }

    public String getName() {
        return this.name;
    }

    @Nullable
    public OlapHierarchyStats getBaseHierarchy() {
        return this.baseHierarchy;
    }

    public List<OlapHierarchyStats> getHierarchies() {
        return this.hierarchies;
    }

    @Nullable
    public OlapHierarchyStats getHierarchy(String name) {
        for (OlapHierarchyStats hierarchy : this.hierarchies) {
            if (!OlapCaseInsensitiveName.equals(hierarchy.getName(), name)) continue;
            return hierarchy;
        }
        return null;
    }

    public long getHierarchyCount() {
        return this.hierarchies.size();
    }

    public long getLevelCount() {
        long count = 0L;
        for (OlapHierarchyStats hierarchy : this.hierarchies) {
            count += hierarchy.getLevelCount();
        }
        return count;
    }

    public long getMemberCount() {
        long count = 0L;
        for (OlapHierarchyStats hierarchy : this.hierarchies) {
            count += hierarchy.getMemberCount();
        }
        return count;
    }

    public long getRamSize() {
        long count = 0L;
        for (OlapHierarchyStats hierarchy : this.hierarchies) {
            count += hierarchy.getRamSize();
        }
        return count;
    }

    public long getElapsedMS() {
        return this.elapsedMS;
    }
}

