/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.schema.localization;

import crazydev.common.utils.CdLocaleUtils;
import crazydev.iccube.authorizationx.permissions.schema.OlapRoleSchemaPermissions;
import crazydev.iccube.mdx.parser.MdxParserIdentifierHelper;
import crazydev.iccube.olap.component.naming.OlapNameContext;
import crazydev.iccube.olap.cube.OlapCube;
import crazydev.iccube.olap.cube.OlapRegularCube;
import crazydev.iccube.olap.entity.OlapEntity;
import crazydev.iccube.olap.entity.cmember.OlapCubeCalculatedMemberManager;
import crazydev.iccube.olap.entity.cmember.OlapSchemaCalculatedMemberManager;
import crazydev.iccube.olap.entity.dimension.OlapDimension;
import crazydev.iccube.olap.entity.dimension.OlapMeasuresDimension;
import crazydev.iccube.olap.entity.hierarchy.OlapHierarchy;
import crazydev.iccube.olap.entity.id.OlapEntityIdentifier;
import crazydev.iccube.olap.entity.id.OlapEntityIdentifierPart;
import crazydev.iccube.olap.entity.level.OlapLevel;
import crazydev.iccube.olap.entity.member.OlapMember;
import crazydev.iccube.olap.entity.permissions.IOlapDimensionsPermission;
import crazydev.iccube.olap.entity.scalar.OlapNonScalarEntity;
import crazydev.iccube.olap.schema.OlapSchema;
import crazydev.iccube.olap.util.OlapCaseInsensitiveName;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.Nullable;

class OlapSchemaLocalizationGuts {
    private static final OlapNameContext NC = OlapNameContext.DEFAULT_VALUES;
    @Nullable
    private final Locale fallbackLocale;
    private final Set<String> allLocalizationKeys = new HashSet<String>();
    private final Map<String, Map<String, String>> allLocalizationValues = new HashMap<String, Map<String, String>>();
    private final Map<String, Map<OlapEntity, String>> allLocalizationEntityValues = new HashMap<String, Map<OlapEntity, String>>();

    OlapSchemaLocalizationGuts(@Nullable Locale fallbackLocale) {
        this.fallbackLocale = fallbackLocale;
    }

    void onProcessingStarted() {
        this.allLocalizationKeys.clear();
        this.allLocalizationValues.clear();
        this.allLocalizationEntityValues.clear();
    }

    void addLocalization(String locale, String keyAsString, String valueAsString) {
        Map localeValues = this.allLocalizationValues.computeIfAbsent(locale, k -> new HashMap());
        localeValues.put(keyAsString, valueAsString);
        this.allLocalizationKeys.add(keyAsString);
    }

    void onProcessingDone() {
    }

    void resolveLocalisationKeys(Logger logger, OlapSchema schema) {
        try {
            this.unsafeResolveLocalisationKeys(schema);
        }
        catch (RuntimeException ex) {
            logger.warn((Object)("[schema] schema [" + schema.getName() + "] localization post-processing error: "), (Throwable)ex);
        }
    }

    private void unsafeResolveLocalisationKeys(OlapSchema schema) {
        HashMap<String, List<OlapEntity>> allEntities = new HashMap<String, List<OlapEntity>>();
        for (String string : this.allLocalizationKeys) {
            List<OlapEntity> entities = OlapSchemaLocalizationGuts.resolveLocalisationKey(schema, string);
            if (entities.isEmpty()) continue;
            allEntities.put(string, entities);
        }
        for (Map.Entry entry : this.allLocalizationValues.entrySet()) {
            String locale = (String)entry.getKey();
            Map localeValues = (Map)entry.getValue();
            HashMap<OlapEntity, String> entityValues = new HashMap<OlapEntity, String>();
            for (Map.Entry localizationEntry : localeValues.entrySet()) {
                String localizationKey = (String)localizationEntry.getKey();
                String caption = (String)localizationEntry.getValue();
                List entities = (List)allEntities.get(localizationKey);
                if (entities == null) continue;
                for (OlapEntity entity : entities) {
                    entityValues.put(entity, caption);
                }
            }
            this.allLocalizationEntityValues.put(locale, entityValues);
        }
    }

    private static List<OlapEntity> resolveLocalisationKey(OlapSchema schema, String localizationKey) {
        boolean isMeasures_;
        String part1asName;
        OlapEntityIdentifierPart part1;
        OlapEntityIdentifier identifier = MdxParserIdentifierHelper.parseIdentifier(localizationKey, "localization key [" + localizationKey + "]");
        if (identifier == null) {
            return Collections.emptyList();
        }
        OlapEntityIdentifierPart part0 = identifier.getPart(0);
        if (part0.isAll() || part0.isKey()) {
            return Collections.emptyList();
        }
        String part0asName = part0.asName();
        if (part0asName == null) {
            return Collections.emptyList();
        }
        boolean isMeasures = OlapCaseInsensitiveName.equals("Measures", part0asName);
        if (isMeasures) {
            return OlapSchemaLocalizationGuts.resolveMeasureLocalisationKey(schema, localizationKey, null, identifier);
        }
        if (identifier.getPartCount() > 1 && !(part1 = identifier.getPart(1)).isAll() && !part1.isKey() && (part1asName = part1.asName()) != null && (isMeasures_ = OlapCaseInsensitiveName.equals("Measures", part1asName))) {
            return OlapSchemaLocalizationGuts.resolveMeasureLocalisationKey(schema, localizationKey, part0asName, identifier.subIdentifier(1));
        }
        return OlapSchemaLocalizationGuts.resolveOtherLocalisationKey(schema, localizationKey, identifier);
    }

    private static List<OlapEntity> resolveMeasureLocalisationKey(OlapSchema schema, String localizationKey, @Nullable String cubeName, OlapEntityIdentifier identifier) {
        OlapRoleSchemaPermissions permissions = schema.getFullControlPermissions();
        ArrayList<OlapEntity> entities = new ArrayList<OlapEntity>();
        List<OlapRegularCube> cubes = schema.getCubes();
        for (OlapRegularCube cube : cubes) {
            if (cubeName != null && !OlapCaseInsensitiveName.equals(cubeName, cube.getNameX())) continue;
            OlapCubeCalculatedMemberManager calcMeasures = cube.getCalcMemberManager();
            OlapMember calcMeasure = calcMeasures.lookupCalculatedMember(NC, identifier);
            if (calcMeasure != null) {
                entities.add(calcMeasure);
            }
            if (!OlapSchemaLocalizationGuts.isMeasures(OlapSchemaLocalizationGuts.resolve(entities, permissions, cube, identifier))) continue;
            break;
        }
        return entities;
    }

    private static OlapNonScalarEntity resolve(List<OlapEntity> entities, IOlapDimensionsPermission permissions, OlapRegularCube cube, OlapEntityIdentifier identifier) {
        OlapMeasuresDimension measures = cube.getMeasuresDimension();
        ArrayList<OlapDimension> dimensions = new ArrayList<OlapDimension>();
        dimensions.add(measures);
        OlapNonScalarEntity entity = OlapCube.lookupEntityByMdxIdentifier(OlapNameContext.DEFAULT_VALUES, permissions, null, null, dimensions, dimensions, identifier);
        if (!entity.isMdxNull()) {
            entities.add(entity);
        }
        return entity;
    }

    private static boolean isMeasures(OlapNonScalarEntity entity) {
        return entity instanceof OlapDimension || entity instanceof OlapHierarchy || entity instanceof OlapLevel;
    }

    private static List<OlapEntity> resolveOtherLocalisationKey(OlapSchema schema, String localizationKey, OlapEntityIdentifier identifier) {
        List<OlapDimension> dimensions;
        OlapRoleSchemaPermissions permissions;
        OlapNonScalarEntity entity;
        ArrayList<OlapEntity> entities = new ArrayList<OlapEntity>();
        OlapSchemaCalculatedMemberManager calcMembers = schema.getCalcMemberManager();
        OlapMember calcMember = calcMembers.lookupCalculatedMember(NC, identifier);
        if (calcMember != null) {
            entities.add(calcMember);
        }
        if (!(entity = OlapCube.lookupEntityByMdxIdentifier(OlapNameContext.DEFAULT_VALUES, permissions = schema.getFullControlPermissions(), null, null, dimensions = schema.getDimensions(), dimensions, identifier)).isMdxNull()) {
            entities.add(entity);
        }
        return entities;
    }

    Set<String> getLocaleNames() {
        return this.allLocalizationValues.keySet();
    }

    Set<String> getTags(String locale) {
        Map<String, String> values = this.allLocalizationValues.get(locale);
        return values.keySet();
    }

    @Nullable
    String getValue(String locale, String name) {
        Map<String, String> values = this.allLocalizationValues.get(locale);
        return values.get(name);
    }

    @Nullable
    String getCaption(Locale locale, String key) {
        String caption = this.doGetCaption(locale, key);
        if (caption == null && this.fallbackLocale != null && CdLocaleUtils.isNotFallback((Locale)this.fallbackLocale, (Locale)locale)) {
            caption = this.doGetCaption(this.fallbackLocale, key);
        }
        return caption;
    }

    @Nullable
    private String doGetCaption(Locale locale, String key) {
        List localeNames = CdLocaleUtils.resolveNameForLocalizationLookup((Locale)locale);
        if (localeNames.isEmpty()) {
            return null;
        }
        for (int ii = 0; ii < localeNames.size(); ++ii) {
            String value;
            String localeName = (String)localeNames.get(ii);
            Map<String, String> values = this.allLocalizationValues.get(localeName);
            if (values == null || (value = values.get(key)) == null) continue;
            return value;
        }
        return null;
    }

    @Nullable
    String getCaption(Locale locale, OlapEntity entity) {
        String caption = this.doGetCaption(locale, entity);
        if (caption == null && this.fallbackLocale != null && CdLocaleUtils.isNotFallback((Locale)this.fallbackLocale, (Locale)locale)) {
            caption = this.doGetCaption(this.fallbackLocale, entity);
        }
        return caption;
    }

    private String doGetCaption(Locale locale, OlapEntity entity) {
        List localeNames = CdLocaleUtils.resolveNameForLocalizationLookup((Locale)locale);
        if (localeNames.isEmpty()) {
            return null;
        }
        for (int ii = 0; ii < localeNames.size(); ++ii) {
            String value;
            String localeName = (String)localeNames.get(ii);
            Map<OlapEntity, String> values = this.allLocalizationEntityValues.get(localeName);
            if (values == null || (value = values.get(entity)) == null) continue;
            return value;
        }
        return null;
    }
}

