/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.schema.localization;

import crazydev.common.mdx.CdMdxUtils;
import crazydev.iccube.olap.component.naming.OlapDefaultNamesContext;
import crazydev.iccube.olap.component.naming.OlapNameContext;
import crazydev.iccube.olap.cube.OlapCube;
import crazydev.iccube.olap.entity.OlapEntity;
import crazydev.iccube.olap.entity.dimension.OlapDimension;
import crazydev.iccube.olap.entity.hierarchy.OlapHierarchy;
import crazydev.iccube.olap.entity.level.OlapLevel;
import crazydev.iccube.olap.entity.member.OlapDefaultStatsMember;
import crazydev.iccube.olap.entity.member.OlapMeasureMember;
import crazydev.iccube.olap.entity.member.OlapMember;
import crazydev.iccube.olap.entity.member.OlapSchemaCalculatedMember;
import crazydev.iccube.olap.eval.set.OlapSetDeclaration;
import crazydev.iccube.olap.loggers.OlapLoggers;
import crazydev.iccube.olap.schema.OlapSchema;
import crazydev.iccube.olap.schema.localization.OlapSchemaLocalization;
import crazydev.iccube.olap.schema.localization.OlapSchemaLocalizationGuts;
import java.util.Locale;
import java.util.Set;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.Nullable;

public class OlapDefaultSchemaLocalization
extends OlapSchemaLocalization {
    private static final OlapNameContext NC = OlapNameContext.DEFAULT_VALUES;
    private final OlapSchemaLocalizationGuts captions;
    private final OlapSchemaLocalizationGuts descriptions;

    public OlapDefaultSchemaLocalization(@Nullable Locale fallbackLocale) {
        this.captions = new OlapSchemaLocalizationGuts(fallbackLocale);
        this.descriptions = new OlapSchemaLocalizationGuts(fallbackLocale);
    }

    @Override
    public void onProcessingStarted() {
        this.captions.onProcessingStarted();
        this.descriptions.onProcessingStarted();
    }

    @Override
    public void addLocalization(String locale, String keyAsString, String valueAsString) {
        if ("NAME".equalsIgnoreCase(locale)) {
            return;
        }
        if (keyAsString.endsWith(".description")) {
            this.descriptions.addLocalization(locale, OlapDefaultSchemaLocalization.fixDescriptionKey(keyAsString), valueAsString);
        } else {
            this.captions.addLocalization(locale, keyAsString, valueAsString);
        }
    }

    @Override
    public void onProcessingDone() {
        this.captions.onProcessingDone();
        this.descriptions.onProcessingDone();
    }

    @Override
    public void resolveLocalisationKeys(Logger logger, OlapSchema schema) {
        this.captions.resolveLocalisationKeys(logger, schema);
        this.descriptions.resolveLocalisationKeys(logger, schema);
    }

    @Override
    public Set<String> getLocaleNames() {
        return this.captions.getLocaleNames();
    }

    @Override
    public Set<String> getTags(String locale) {
        return this.captions.getTags(locale);
    }

    @Override
    @Nullable
    public String getValue(String locale, String name) {
        return this.captions.getValue(locale, name);
    }

    @Override
    @Nullable
    public String getDimensionCaption(Locale locale, OlapDimension dimension) {
        return this.getCaption(locale, dimension);
    }

    @Override
    @Nullable
    public String getDimensionDescription(Locale locale, OlapDimension dimension) {
        return this.getDescription(locale, dimension);
    }

    @Override
    @Nullable
    public String getHierarchyCaption(Locale locale, OlapHierarchy hierarchy) {
        return this.getCaption(locale, hierarchy);
    }

    @Override
    @Nullable
    public String getHierarchyDescription(Locale locale, OlapHierarchy hierarchy) {
        return this.getDescription(locale, hierarchy);
    }

    @Override
    @Nullable
    public String getLevelCaption(Locale locale, OlapLevel level) {
        return this.getCaption(locale, level);
    }

    @Override
    @Nullable
    public String getLevelDescription(Locale locale, OlapLevel level) {
        return this.getDescription(locale, level);
    }

    @Override
    @Nullable
    public String getAllMemberCaption(Locale locale, OlapMember member) {
        return this.getCaption(locale, member);
    }

    @Override
    @Nullable
    public String getAllMemberDescription(Locale locale, OlapMember member) {
        return this.getDescription(locale, member);
    }

    @Override
    @Nullable
    public String getMemberCaption(Locale locale, OlapMember member) {
        return this.getCaption(locale, member);
    }

    @Override
    @Nullable
    public String getMemberDescription(Locale locale, OlapMember member) {
        return this.getDescription(locale, member);
    }

    @Override
    @Nullable
    public String getAllLevelCaption(Locale locale, OlapLevel level) {
        return this.getCaption(locale, level);
    }

    @Override
    @Nullable
    public String getAllLevelDescription(Locale locale, OlapLevel level) {
        return this.getDescription(locale, level);
    }

    @Override
    @Nullable
    public String getCubeCaption(Locale locale, OlapCube cube) {
        String un = cube.getUniqueName(NC);
        return this.getCaption(locale, un);
    }

    @Override
    @Nullable
    public String getMeasureCaption(Locale locale, OlapMeasureMember measure) {
        return this.getCaption(locale, measure);
    }

    @Override
    @Nullable
    public String getMeasureDescription(Locale locale, OlapMeasureMember measure) {
        return this.getDescription(locale, measure);
    }

    @Override
    @Nullable
    public String getMeasureDisplayFolder(Locale locale, OlapMember measure) {
        if (!measure.isMeasure()) {
            return null;
        }
        try {
            OlapCube cube = measure.getCube();
            String cubeUN = cube.getUniqueName(NC);
            String un = cubeUN + "." + measure.getUniqueName(OlapDefaultNamesContext.DEFAULT_VALUES);
            String caption = this.getMeasureDisplayFolder(locale, un);
            if (caption != null) {
                return caption;
            }
            String un2 = measure.getUniqueName(OlapDefaultNamesContext.DEFAULT_VALUES);
            String caption2 = this.getMeasureDisplayFolder(locale, un2);
            if (caption2 != null) {
                return caption2;
            }
            return this.getMeasureDisplayFolder(locale, "[" + CdMdxUtils.escape((String)measure.getNameX()) + "]");
        }
        catch (RuntimeException ex) {
            OlapLoggers.GENERAL.warn((Object)"DISPLAY_FOLDER retrieval error", (Throwable)ex);
            return null;
        }
    }

    private String getMeasureDisplayFolder(Locale locale, String key) {
        String caption = this.getCaption(locale, key + ".[DISPLAY_FOLDER]");
        return caption;
    }

    @Override
    @Nullable
    public String getMeasureGroupCaption(Locale locale, OlapCube cube, String measureGroupName) {
        String cubeUN = cube.getUniqueName(NC);
        String un = cubeUN + ".[" + CdMdxUtils.escape((String)measureGroupName) + "]";
        String caption = this.getCaption(locale, un);
        if (caption != null) {
            return caption;
        }
        String un2 = "[" + CdMdxUtils.escape((String)measureGroupName) + "]";
        return this.getCaption(locale, un2);
    }

    @Override
    @Nullable
    public String getSchemaCalculatedMemberCaption(Locale locale, OlapSchemaCalculatedMember member) {
        return this.getCaption(locale, member);
    }

    @Override
    @Nullable
    public String getSchemaCalculatedMemberDescription(Locale locale, OlapSchemaCalculatedMember member) {
        return this.getDescription(locale, member);
    }

    @Override
    @Nullable
    public String getSchemaStatsMemberCaption(Locale locale, OlapDefaultStatsMember member) {
        return this.getCaption(locale, member);
    }

    @Override
    @Nullable
    public String getSchemaStatsMemberDescription(Locale locale, OlapDefaultStatsMember member) {
        return this.getDescription(locale, member);
    }

    @Override
    @Nullable
    public String getSchemaSetCaption(Locale locale, OlapSetDeclaration set) {
        String un = "[" + CdMdxUtils.escape((String)set.getSetName()) + "]";
        return this.getCaption(locale, un);
    }

    @Override
    @Nullable
    public String getSchemaSetDescription(Locale locale, OlapSetDeclaration set) {
        String un = "[" + CdMdxUtils.escape((String)set.getSetName()) + "]";
        return this.getDescription(locale, un);
    }

    @Override
    @Nullable
    public String getCaption(Locale locale, String key) {
        return this.captions.getCaption(locale, key);
    }

    @Nullable
    private String getCaption(Locale locale, OlapEntity entity) {
        return this.captions.getCaption(locale, entity);
    }

    @Nullable
    public String getDescription(Locale locale, String key) {
        return this.descriptions.getCaption(locale, key);
    }

    @Nullable
    private String getDescription(Locale locale, OlapEntity entity) {
        return this.descriptions.getCaption(locale, entity);
    }

    private static String fixDescriptionKey(String keyAsString) {
        return keyAsString.substring(0, keyAsString.length() - ".description".length());
    }
}

