/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.schema;

import crazydev.common.babylon.CdBabylonService;
import crazydev.common.exception.CdError;
import crazydev.iccube.olap.schema.OlapSchemaInformation;
import crazydev.iccube.request.status.IcCubeRequestStatusManager;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;
import org.jetbrains.annotations.Nullable;

public class OlapSchemaInformationEx {
    private final Status status;
    @Nullable
    private final OlapSchemaInformation info;
    @Nullable
    private final String name;
    @Nullable
    private final File factoryFile;
    @Nullable
    private final Date startDate;
    @Nullable
    private volatile String error;
    @Nullable
    private volatile String errorTimeUTC;

    public OlapSchemaInformationEx(Status status, OlapSchemaInformation info) {
        this.status = status;
        this.info = info;
        this.name = null;
        this.factoryFile = null;
        this.startDate = null;
    }

    public OlapSchemaInformationEx(Status status, @Nullable String name, @Nullable File factoryFile) {
        this.status = status;
        this.info = null;
        this.name = name;
        this.factoryFile = factoryFile;
        this.startDate = null;
    }

    public OlapSchemaInformationEx(Status status, String name, Date startDate) {
        this.status = status;
        this.info = null;
        this.name = name;
        this.factoryFile = null;
        this.startDate = startDate;
    }

    public boolean isLoading() {
        return this.status == Status.LOADING;
    }

    public String getStatus() {
        return this.status.name();
    }

    public String getName() {
        if (this.info != null) {
            return this.info.getName();
        }
        if (this.name != null) {
            return this.name;
        }
        return "";
    }

    @Nullable
    public File getFactoryFile() {
        if (this.info != null) {
            return this.info.getFactoryFile();
        }
        return this.factoryFile;
    }

    public String getFactoryFileName() {
        if (this.info != null) {
            return this.info.getFactoryFile().getName();
        }
        if (this.factoryFile != null) {
            return this.factoryFile.getName();
        }
        return "";
    }

    public String getRefreshTimeStart_UTC() {
        if (this.startDate != null) {
            return OlapSchemaInformation.getRefreshTimeStart_UTC(this.startDate);
        }
        if (this.info != null) {
            return this.info.getRefreshTimeStart_UTC();
        }
        return "";
    }

    public String getRefreshTimeEnd_UTC() {
        if (this.info != null) {
            return this.info.getRefreshTimeEnd_UTC();
        }
        return "";
    }

    public String getDataUpdateTimeEnd_UTC() {
        if (this.info != null) {
            return this.info.getDataUpdateTimeEnd_UTC();
        }
        return "";
    }

    public void setError(CdBabylonService babylon, IcCubeRequestStatusManager.LatestErrors latestErrors) {
        if (latestErrors == null) {
            return;
        }
        Date timestamp = latestErrors.getStartDate();
        List<CdError> errors = latestErrors.getErrors();
        CdError error = errors.get(0);
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        df.setTimeZone(TimeZone.getTimeZone("UTC"));
        this.errorTimeUTC = df.format(timestamp);
        this.error = error.asMessage(babylon);
    }

    public String getErrorTime_UTC() {
        String err = this.errorTimeUTC;
        if (err != null) {
            return err;
        }
        return "";
    }

    public String getError() {
        String err = this.error;
        if (err != null) {
            return err;
        }
        return "";
    }

    public static enum Status {
        LOADED,
        LOADING,
        UNLOADED;

    }
}

