/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.schema;

import crazydev.iccube.builder.factory.schema.IOlapBuilderSchemaDefFactory;
import crazydev.iccube.cluster.shared.backup.S_BackupHelper;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import org.jetbrains.annotations.Nullable;

public class OlapSchemaInformation {
    @Nullable
    private final String group;
    private final String name;
    private final File factoryFile;
    private final IOlapBuilderSchemaDefFactory factory;
    private final boolean incremental;
    @Nullable
    private final String offlineSnapshot;
    @Nullable
    private volatile Date offlineSnapshotTimestamp;
    @Nullable
    private volatile String writtenOfflineSnapshot;
    @Nullable
    private volatile String backupStatus;
    @Nullable
    private volatile String backupError;
    private volatile String requestUuid;
    private volatile Date refreshTimeStart = new Date();
    private volatile Date refreshTimeEnd;
    private volatile Date refreshTimeEnd_;
    private volatile Date lastDataUpdatedTime;
    private volatile boolean deActivatedOnError;
    @Nullable
    private volatile File mmapDirectory;
    @Nullable
    private volatile String mmapDirectoryForStats;
    @Nullable
    private volatile String restoredBackupTimestamp;
    @Nullable
    private volatile Date restoredBackupTimestampD;

    public OlapSchemaInformation(String requestUuid, @Nullable String group, String name, File factoryFile, IOlapBuilderSchemaDefFactory factory, boolean incremental, @Nullable String offlineSnapshot) {
        this.requestUuid = requestUuid;
        this.group = group;
        this.name = name;
        this.factoryFile = factoryFile;
        this.factory = factory;
        this.incremental = incremental;
        this.offlineSnapshot = offlineSnapshot;
    }

    public String getRequestUuid() {
        return this.requestUuid;
    }

    public Date getLastDataUpdatedTime() {
        return this.lastDataUpdatedTime;
    }

    public void setLastDataUpdatedTime(Date lastUpdateTime) {
        this.lastDataUpdatedTime = lastUpdateTime;
    }

    public long getLastDataUpdatedTimeX() {
        Date timestamp = this.lastDataUpdatedTime;
        return timestamp != null ? timestamp.getTime() : -1L;
    }

    public Date getRefreshTimeStart() {
        return this.refreshTimeStart;
    }

    public String getRefreshTimeStart_UTC() {
        return OlapSchemaInformation.getRefreshTimeStart_UTC(this.refreshTimeStart);
    }

    public static String getRefreshTimeStart_UTC(Date refreshTimeStart) {
        if (refreshTimeStart == null) {
            return "";
        }
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        df.setTimeZone(TimeZone.getTimeZone("UTC"));
        return df.format(refreshTimeStart);
    }

    @Nullable
    public Date getRefreshTimeEnd_() {
        return this.refreshTimeEnd_;
    }

    @Nullable
    public Date getRefreshTimeEnd() {
        return this.refreshTimeEnd;
    }

    @Nullable
    public Long getLoadTime() {
        if (this.refreshTimeEnd == null) {
            return null;
        }
        return this.refreshTimeEnd.getTime() - this.refreshTimeStart.getTime();
    }

    public String getRefreshTimeEnd_UTC() {
        if (this.refreshTimeEnd == null) {
            return "";
        }
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        df.setTimeZone(TimeZone.getTimeZone("UTC"));
        return df.format(this.refreshTimeEnd);
    }

    public String getDataUpdateTimeEnd_UTC() {
        if (this.lastDataUpdatedTime == null) {
            return "";
        }
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        df.setTimeZone(TimeZone.getTimeZone("UTC"));
        return df.format(this.lastDataUpdatedTime);
    }

    public void onSchemaLoaded() {
        this.refreshTimeEnd = new Date();
        this.refreshTimeEnd_ = this.offlineSnapshotTimestamp != null ? this.offlineSnapshotTimestamp : this.refreshTimeEnd;
    }

    public void onSchemaLoaded(OlapSchemaInformation that) {
        this.requestUuid = that.requestUuid;
        this.refreshTimeStart = that.refreshTimeStart;
        this.refreshTimeEnd = that.refreshTimeEnd;
    }

    @Nullable
    public String getOfflineSnapshot() {
        return this.offlineSnapshot;
    }

    @Nullable
    public Date getOfflineSnapshotTimestamp() {
        return this.offlineSnapshotTimestamp;
    }

    public void setOfflineSnapshotTimestamp(long timestamp) {
        this.offlineSnapshotTimestamp = new Date(timestamp);
    }

    @Nullable
    public String getWrittenOfflineSnapshot() {
        return this.writtenOfflineSnapshot;
    }

    public void setWrittenOfflineSnapshot(@Nullable String writtenOfflineSnapshot) {
        this.writtenOfflineSnapshot = writtenOfflineSnapshot;
    }

    @Nullable
    public String getBackupStatus() {
        return this.backupStatus;
    }

    public void setBackupStatus(@Nullable String backupStatus) {
        this.backupStatus = backupStatus;
    }

    @Nullable
    public String getBackupError() {
        return this.backupError;
    }

    public void setBackupError(@Nullable String backupError) {
        this.backupError = backupError;
    }

    public String getName() {
        return this.name;
    }

    @Nullable
    public String getGroup() {
        return this.group;
    }

    public File getFactoryFile() {
        return this.factoryFile;
    }

    public IOlapBuilderSchemaDefFactory getFactory() {
        return this.factory;
    }

    public boolean isIncremental() {
        return this.incremental;
    }

    public boolean isIncrLoadDeActivatedOnError() {
        return this.deActivatedOnError;
    }

    public void deActivateIncrLoadOnError() {
        this.deActivatedOnError = true;
    }

    @Nullable
    public File getMmapDirectory() {
        return this.mmapDirectory;
    }

    @Nullable
    public String getMmapDirectoryForStats() {
        return this.mmapDirectoryForStats;
    }

    public void setMmapDirectory(@Nullable File mmapDirectory, @Nullable String mmapDirectoryForStats) {
        this.mmapDirectory = mmapDirectory;
        this.mmapDirectoryForStats = mmapDirectoryForStats;
    }

    public void setRestoreTimestamp(String backupTimestamp) {
        this.restoredBackupTimestamp = backupTimestamp;
        this.restoredBackupTimestampD = S_BackupHelper.getTimestamp(backupTimestamp);
    }

    @Nullable
    public String getRestoredBackupTimestamp() {
        return this.restoredBackupTimestamp;
    }

    @Nullable
    public Date getRestoredBackupTimestampD() {
        return this.restoredBackupTimestampD;
    }

    public String toString() {
        return this.name;
    }
}

