/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.schema;

import crazydev.common.collection.CdActionEx;
import crazydev.common.exception.CdError;
import crazydev.common.exception.CdRuntimeException;
import crazydev.common.exception.programming.CdProgrammingException;
import crazydev.common.javacompiler.CompiledCode;
import crazydev.common.javacompiler.DynamicClassLoader;
import crazydev.common.utils.CdSizeUtils;
import crazydev.common.utils.CdStringUtils;
import crazydev.common.utils.CdTimeUtils;
import crazydev.iccube.authorizationx.permissions.schema.OlapRoleSchemaFullControlPermissions;
import crazydev.iccube.authorizationx.permissions.schema.OlapRoleSchemaNotCreatedPermissions;
import crazydev.iccube.authorizationx.permissions.schema.OlapRoleSchemaOnErrorPermissions;
import crazydev.iccube.authorizationx.permissions.schema.OlapRoleSchemaPermissions;
import crazydev.iccube.authorizationx.permissions.schemas.OlapRoleSchemasRegularPermissions;
import crazydev.iccube.builder.OlapBuilderContext;
import crazydev.iccube.builder.OlapBuilderLoadMeasureGroupContext;
import crazydev.iccube.builder.errors.OlapBuilderErrorCode;
import crazydev.iccube.builder.errors.OlapBuilderErrorException;
import crazydev.iccube.builder.factory.schema.IOlapBuilderSchemaDefFactory;
import crazydev.iccube.builder.model.builders.IOlapBuilderTableListener;
import crazydev.iccube.builder.model.builders.bridge.IOlapBridgeResolver;
import crazydev.iccube.builder.model.builders.bridge.OlapBridgeDef;
import crazydev.iccube.builder.model.builders.bridge.OlapBridgeMapContainer;
import crazydev.iccube.builder.model.builders.bridge.OlapBridgeResolver;
import crazydev.iccube.builder.model.builders.bridge.OlapSingleBridgeBaseMap;
import crazydev.iccube.builder.model.builders.bridge.OlapSingleBridgeDef;
import crazydev.iccube.builder.model.builders.facts.OlapBuilderFactSolveRowError;
import crazydev.iccube.builder.model.builders.lookuptable.OlapLookupTable;
import crazydev.iccube.builder.model.builders.lookuptable.OlapLookupTableKey;
import crazydev.iccube.builder.model.builders.lookuptable.OlapLookupTableSizeHelper;
import crazydev.iccube.builder.model.def.IOlapBuilderBaseFactsDef;
import crazydev.iccube.builder.model.def.IOlapBuilderDataColumnDef;
import crazydev.iccube.builder.model.def.IOlapBuilderDataTableDef;
import crazydev.iccube.builder.model.def.IOlapBuilderDataViewLinksDef;
import crazydev.iccube.builder.model.def.IOlapBuilderDimensionDef;
import crazydev.iccube.builder.model.def.IOlapBuilderSchemaDef;
import crazydev.iccube.builder.model.def.OlapBuilderStoragePolicy;
import crazydev.iccube.builder.model.impl.OlapBuilderBaseDataSource;
import crazydev.iccube.builder.model.impl.OlapBuilderDataSourceVisibility;
import crazydev.iccube.builder.model.impl.OlapBuilderSchema;
import crazydev.iccube.builder.model.impl.OlapBuilderScript;
import crazydev.iccube.builder.model.impl.hierarchy.OlapBuilderHierarchyUniqueNameStyle;
import crazydev.iccube.builder.type.BackupType;
import crazydev.iccube.builder.type.DistinctCountOptimType;
import crazydev.iccube.builder.type.MemberPropertyConsistencyCheckType;
import crazydev.iccube.builder.type.MembersUpperLowerStrategyType;
import crazydev.iccube.builder.type.SchemaGarbageCollectorType;
import crazydev.iccube.cleaner.OlapFileCleaner;
import crazydev.iccube.cluster.master.backup.restore.M_RestoreContext;
import crazydev.iccube.cluster.master.backup.restore.M_RestorePartitionManager;
import crazydev.iccube.cluster.master.backup.save.M_BackupContext;
import crazydev.iccube.cluster.master.backup.save.M_BackupShrinker;
import crazydev.iccube.cluster.node.schema.N_Schema;
import crazydev.iccube.cluster.shared.schema.S_SchemaDef;
import crazydev.iccube.cluster.shared.schema.S_SchemaRef;
import crazydev.iccube.configuration.component.OlapUserDefinedProperties;
import crazydev.iccube.configuration.component.properties.OlapProperties;
import crazydev.iccube.exception.OlapErrorCode;
import crazydev.iccube.exception.OlapErrorLocation;
import crazydev.iccube.mdx.parser.ast.expression.function.MdxFunctionNativeBodyExpression;
import crazydev.iccube.olap.compiler.ast.MdxEntityCompiler;
import crazydev.iccube.olap.compiler.ast.function.MdxNativeFunctionExpressionCompiler;
import crazydev.iccube.olap.compiler.exception.OlapCompilationExceptionContext;
import crazydev.iccube.olap.component.context.OlapEngineApplicationContext;
import crazydev.iccube.olap.component.context.OlapEngineRequestContext;
import crazydev.iccube.olap.component.naming.ONames;
import crazydev.iccube.olap.component.naming.OlapNameContext;
import crazydev.iccube.olap.cube.OlapCube;
import crazydev.iccube.olap.cube.OlapPerspectiveCube;
import crazydev.iccube.olap.cube.OlapRegularCube;
import crazydev.iccube.olap.entity.OlapMeasureGroup;
import crazydev.iccube.olap.entity.cmember.OlapCubeCalculatedMemberManager;
import crazydev.iccube.olap.entity.cmember.OlapSchemaCalculatedMemberManager;
import crazydev.iccube.olap.entity.dimension.OlapDimension;
import crazydev.iccube.olap.entity.dimension.OlapDimensionality;
import crazydev.iccube.olap.entity.dimension.OlapMeasuresDimension;
import crazydev.iccube.olap.entity.hierarchy.OlapHierarchy;
import crazydev.iccube.olap.entity.id.OlapEntityIdentifier;
import crazydev.iccube.olap.entity.level.OlapLevel;
import crazydev.iccube.olap.entity.member.OlapMeasureMember;
import crazydev.iccube.olap.entity.member.OlapMember;
import crazydev.iccube.olap.entity.member.OlapValidateMarkerMember;
import crazydev.iccube.olap.entity.memory.IOlapAutoExistBitmapProvider;
import crazydev.iccube.olap.entity.memory.autoexist.OlapAutoExistGutsContainer;
import crazydev.iccube.olap.entity.permissions.IOlapCubePermission;
import crazydev.iccube.olap.entity.permissions.IOlapDimensionPermission;
import crazydev.iccube.olap.entity.permissions.IOlapDimensionsPermission;
import crazydev.iccube.olap.entity.permissions.IOlapSchemaPermission;
import crazydev.iccube.olap.entity.permissions.IOlapSchemasPermission;
import crazydev.iccube.olap.entity.properties.member.OlapMemberPropertyManager;
import crazydev.iccube.olap.entity.scalar.OlapScalarEntity;
import crazydev.iccube.olap.entity.tuple.OlapTuple;
import crazydev.iccube.olap.entity.tuple.dimensionality.OlapTupleDimensionality;
import crazydev.iccube.olap.entity.tuple.dimensionality.OlapTupleDimensionalityHelper;
import crazydev.iccube.olap.eval.action.OlapActionManager;
import crazydev.iccube.olap.eval.action.OlapDrillthroughAction;
import crazydev.iccube.olap.eval.catmember.OlapSchemaCategoryMemberManager;
import crazydev.iccube.olap.eval.exception.OlapEvaluationException;
import crazydev.iccube.olap.eval.function.OlapFunctionRepository;
import crazydev.iccube.olap.eval.function.mdx.OlapDeclaredFunction;
import crazydev.iccube.olap.eval.instr.OlapInstr;
import crazydev.iccube.olap.eval.instr.OlapInstrLocationRange;
import crazydev.iccube.olap.eval.script.OlapScriptInformation;
import crazydev.iccube.olap.eval.select.context.OlapCreateFunctionStatementExecutionContext;
import crazydev.iccube.olap.eval.select.context.OlapEvaluationContext;
import crazydev.iccube.olap.eval.select.context.sets.OlapSetEvaluation;
import crazydev.iccube.olap.eval.select.context.sets.OlapSetEvaluationController;
import crazydev.iccube.olap.eval.set.OlapSchemaSetManager;
import crazydev.iccube.olap.eval.set.OlapSetDeclaration;
import crazydev.iccube.olap.eval.set.OlapSetDeclarationManager;
import crazydev.iccube.olap.eval.set.OlapSetInfo;
import crazydev.iccube.olap.eval.set.OlapSetInfoEx;
import crazydev.iccube.olap.facts.IOlapFactMeasureGroupManagerForEval;
import crazydev.iccube.olap.facts.OlapFactCubeManager;
import crazydev.iccube.olap.goodies.drillthrough.OlapDrillthroughReturn;
import crazydev.iccube.olap.goodies.incrload.IncrLoadInstanceManager;
import crazydev.iccube.olap.goodies.incrload.IncrLoadSavePoints;
import crazydev.iccube.olap.goodies.incrload.IncrLoadTableSavePoint;
import crazydev.iccube.olap.goodies.perspective.OlapPerspective;
import crazydev.iccube.olap.goodies.perspective.OlapPerspectiveManager;
import crazydev.iccube.olap.goodies.unresolverows.OlapUnresolvedRowsManager;
import crazydev.iccube.olap.loggers.OlapLoggers;
import crazydev.iccube.olap.schema.IOlapSchema;
import crazydev.iccube.olap.schema.OlapSchemaDumpIndexHierarchies;
import crazydev.iccube.olap.schema.OlapSchemaFunctionRepository;
import crazydev.iccube.olap.schema.OlapSchemaFunctionRepositorySnapshot;
import crazydev.iccube.olap.schema.OlapSchemaIncrLoadInfo;
import crazydev.iccube.olap.schema.OlapSchemaInformation;
import crazydev.iccube.olap.schema.OlapSchemaInformationForTests;
import crazydev.iccube.olap.schema.OlapSchemaLoadPartitionsInfo;
import crazydev.iccube.olap.schema.OlapSchemaPartitionInformation;
import crazydev.iccube.olap.schema.OlapSchemaUnloadPartitionsInfo;
import crazydev.iccube.olap.schema.colors.OlapSchemaColors;
import crazydev.iccube.olap.schema.localization.OlapSchemaLocalization;
import crazydev.iccube.olap.schema.stats.OlapCategoryStats;
import crazydev.iccube.olap.schema.stats.OlapDimensionStats;
import crazydev.iccube.olap.schema.stats.OlapFactsStats;
import crazydev.iccube.olap.schema.stats.OlapIncrLoadStats;
import crazydev.iccube.olap.schema.stats.OlapSavePointStats;
import crazydev.iccube.olap.schema.stats.OlapSchemaFullLoadGCStats;
import crazydev.iccube.olap.schema.stats.OlapSchemaFullLoadStats;
import crazydev.iccube.olap.schema.stats.OlapSchemaStats;
import crazydev.iccube.olap.schema.stats.OlapSchemaStatsHolder;
import crazydev.iccube.olap.schema.stats.OlapSchemaTableStats;
import crazydev.iccube.olap.schema.stats.OlapSchemaTimingStats;
import crazydev.iccube.olap.schema.stats.OlapStatsContext;
import crazydev.iccube.olap.util.OlapCaseInsensitiveName;
import crazydev.iccube.request.status.IcCubeRequestStatusManager;
import java.io.BufferedOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.text.Collator;
import java.time.LocalDate;
import java.time.ZoneId;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.jetbrains.annotations.Nullable;

public class OlapSchema
implements IOlapSchema {
    public static OlapBuilderStoragePolicy TEST_STORAGE_POLICY = null;
    private final S_SchemaRef clusterRef;
    private final String uuid = UUID.randomUUID().toString();
    private final OlapSchemaInformation information;
    private final String name;
    private final String description;
    private final String group;
    private final OlapSchemaLocalization localization;
    private final OlapSchemaColors colors;
    private final OlapRoleSchemaFullControlPermissions fullControlPermissions;
    @Nullable
    private final IOlapBuilderSchemaDefFactory definitionFactory;
    @Nullable
    private final OlapUserDefinedProperties userDefinedProperties;
    private final OlapSchemaCalculatedMemberManager calcMemberManager = new OlapSchemaCalculatedMemberManager();
    private final OlapMemberPropertyManager memberPropertyManager;
    private final OlapSchemaFunctionRepository functionRepository;
    private final List<OlapDimension> dimensions = new ArrayList<OlapDimension>();
    private final Map<String, IOlapBuilderDimensionDef> dimDefinitions = new HashMap<String, IOlapBuilderDimensionDef>();
    private final Map<Integer, OlapLevel> levels = new HashMap<Integer, OlapLevel>();
    private final List<OlapRegularCube> allCubesForSaveRestore = new ArrayList<OlapRegularCube>();
    private final List<OlapRegularCube> cubes;
    private final OlapActionManager actions;
    private final OlapSetDeclarationManager setDeclarations = new OlapSetDeclarationManager();
    private final OlapSetEvaluationController setEvaluationController = new OlapSetEvaluationController();
    private final OlapSchemaSetManager staticSetManager = new OlapSchemaSetManager(this);
    private final OlapSchemaCategoryMemberManager categoryMemberManager = new OlapSchemaCategoryMemberManager(this);
    private final Map<String, OlapBuilderBaseDataSource> dataSources = new HashMap<String, OlapBuilderBaseDataSource>();
    private final boolean useUnknownMembers;
    private final OlapPerspectiveManager perspectivesManager = new OlapPerspectiveManager(this);
    private final Map<IOlapSchemasPermission, IOlapSchemaPermission> allSchemaPermissions = new HashMap<IOlapSchemasPermission, IOlapSchemaPermission>();
    private final IncrLoadSavePoints incrementalLoad;
    private final OlapUnresolvedRowsManager unresolvedRows;
    private final AtomicInteger nextDimensionIndex = new AtomicInteger(0);
    private final Object nextHierarchyIndexLOCK = new Object();
    private final ArrayDeque<Integer> availableHierarchyIndex = new ArrayDeque();
    private final AtomicInteger nextLevelIndex = new AtomicInteger(0);
    private final AtomicInteger nextPartitionIndex = new AtomicInteger(0);
    private final AtomicLong nextCalcMemberDeclarationOrder = new AtomicLong(0L);
    private final OlapBridgeMapContainer bridges = new OlapBridgeMapContainer();
    private final ConcurrentHashMap<OlapBridgeDef, OlapBridgeResolver> bridgeResolvers = new ConcurrentHashMap();
    private final ConcurrentHashMap<OlapLookupTableKey, OlapLookupTable> lookupTables = new ConcurrentHashMap();
    private final OlapSchemaStatsHolder statsHolder;
    @Nullable
    private final Locale localeForStringCompare;
    private final ConcurrentHashMap<Integer, OlapValidateMarkerMember> validateMarkerMember = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, OlapCacheValue> cache = new ConcurrentHashMap();
    private final OlapAutoExistGutsContainer autoExistContainer = new OlapAutoExistGutsContainer();
    @Nullable
    private N_Schema n_schema;
    private int nextMaxHierarchyIndex = OlapTupleDimensionalityHelper.SINGLE_MEASURE_DIMENSIONALITY_OFF ? 0 : 1;
    private volatile boolean dimDefinitionsSetup = false;
    private volatile boolean levelsSetup = false;
    @Nullable
    private volatile OlapSchemaTimingStats timingStats;
    private volatile boolean requiresLoadSchemaMembersPostProcessing = true;
    private volatile S_SchemaDef clusterDef;
    @Nullable
    private volatile File backupDir;
    private volatile boolean backupDisabledOnError;
    private volatile boolean restoring;
    private volatile M_RestorePartitionManager restoringPartitionManager;
    private volatile DynamicClassLoader nativeFunctionsCL;
    private volatile M_BackupShrinker backupShrinker;

    public OlapSchema(OlapEngineApplicationContext context, OlapProperties properties, IncrLoadInstanceManager manager, String name, String description, String group, OlapFunctionRepository functionRepository, OlapSchemaLocalization localization, OlapSchemaColors colors) {
        this(context, properties, manager, null, name, description, group, null, functionRepository, localization, colors);
    }

    public OlapSchema(OlapEngineApplicationContext context, OlapProperties properties, IncrLoadInstanceManager manager, OlapSchemaInformation information, IOlapBuilderSchemaDefFactory definitionFactory, OlapFunctionRepository functionRepository, OlapSchemaLocalization localization, OlapSchemaColors colors) {
        this(context, properties, manager, information, definitionFactory.getSchemaName(), definitionFactory.getSchemaDescription(), definitionFactory.getSchemaGroup(), definitionFactory, functionRepository, localization, colors);
    }

    private OlapSchema(OlapEngineApplicationContext context, OlapProperties properties, IncrLoadInstanceManager manager, @Nullable OlapSchemaInformation information, String name, String description, String group, @Nullable IOlapBuilderSchemaDefFactory definitionFactory, OlapFunctionRepository functionRepository, OlapSchemaLocalization localization, OlapSchemaColors colors) {
        this.clusterRef = new S_SchemaRef(name, this);
        this.fullControlPermissions = new OlapRoleSchemaFullControlPermissions(this);
        this.information = information;
        this.name = name;
        this.statsHolder = new OlapSchemaStatsHolder(name);
        this.localization = localization;
        this.colors = colors;
        if (this.name == null || this.name.trim().isEmpty()) {
            throw new CdRuntimeException("Missing schema name!");
        }
        this.description = description;
        this.group = group;
        this.definitionFactory = definitionFactory;
        this.userDefinedProperties = context != null ? context.getUserDefinedProperties() : null;
        this.memberPropertyManager = new OlapMemberPropertyManager(definitionFactory != null ? definitionFactory.getSchemaLocalizationFallbackLocale() : null);
        this.functionRepository = new OlapSchemaFunctionRepository(functionRepository);
        this.cubes = new ArrayList<OlapRegularCube>();
        this.useUnknownMembers = definitionFactory != null && definitionFactory.useUnknownMembersInFacts();
        this.incrementalLoad = definitionFactory != null && definitionFactory.incrementalLoadActive() ? new IncrLoadSavePoints(manager, name) : null;
        this.localeForStringCompare = definitionFactory == null ? null : definitionFactory.getLocaleForStringCompare();
        this.unresolvedRows = new OlapUnresolvedRowsManager(name, properties.getMaxUnresolvedRowsCount());
        File xmlFile = definitionFactory == null ? null : definitionFactory.getXmlFile();
        this.backupDir = null;
        this.backupDisabledOnError = false;
        this.restoring = false;
        this.restoringPartitionManager = null;
        this.actions = new OlapActionManager(this);
        if (OlapLoggers.SCHEMA.isInfoEnabled()) {
            OlapLoggers.SCHEMA.info((Object)("[schema] schema [" + name + "] created (" + (xmlFile == null ? "no-factory-file" : xmlFile.getAbsolutePath()) + ")"));
        }
    }

    public void registerNSchema(N_Schema schema) {
        this.n_schema = schema;
    }

    public OlapSchemaLocalization getLocalization() {
        return this.localization;
    }

    public OlapSchemaColors getColors() {
        return this.colors;
    }

    public boolean isMonitoring() {
        return this.definitionFactory != null && this.definitionFactory.isMonitoring();
    }

    public boolean isMonitoringUsingSchemaPerms() {
        return this.definitionFactory != null && this.definitionFactory.isMonitoringUsingSchemaPerms();
    }

    public boolean excludeDimensionName() {
        return this.definitionFactory != null && this.definitionFactory.getHierarchyUniqueNameStyle() == OlapBuilderHierarchyUniqueNameStyle.ExcludeDimensionName;
    }

    public boolean disableAutoAttributes() {
        return this.definitionFactory != null && this.definitionFactory.disableAutoAttributes();
    }

    public MembersUpperLowerStrategyType membersUpperLowerCaseStrategy() {
        if (this.definitionFactory == null) {
            return MembersUpperLowerStrategyType.getDefault();
        }
        MembersUpperLowerStrategyType type = this.definitionFactory.membersUpperLowerCaseStrategy();
        return type == null ? MembersUpperLowerStrategyType.getDefault() : type;
    }

    public boolean isIncrLoadActive() {
        return this.definitionFactory != null && this.definitionFactory.incrementalLoadActive();
    }

    public DistinctCountOptimType getDistinctCountOptim() {
        if (this.definitionFactory != null && this.definitionFactory.getDistinctCountOptim() != null) {
            return this.definitionFactory.getDistinctCountOptim();
        }
        return DistinctCountOptimType.DEFAULT;
    }

    public boolean isIndexInFiles() {
        if (TEST_STORAGE_POLICY != null && TEST_STORAGE_POLICY.isIndexInFiles()) {
            return true;
        }
        if (this.definitionFactory == null) {
            return false;
        }
        OlapBuilderStoragePolicy storagePolicy = this.definitionFactory.getStoragePolicy();
        return storagePolicy.isIndexInFiles();
    }

    public boolean isFactsInFiles() {
        if (TEST_STORAGE_POLICY != null && TEST_STORAGE_POLICY.isFactsInFiles()) {
            return true;
        }
        if (this.definitionFactory == null) {
            return false;
        }
        OlapBuilderStoragePolicy storagePolicy = this.definitionFactory.getStoragePolicy();
        return storagePolicy.isFactsInFiles();
    }

    public boolean useFactsPartitioning() {
        return this.definitionFactory != null && this.definitionFactory.useFactPartitioning();
    }

    public SchemaGarbageCollectorType getCallGC() {
        return this.definitionFactory == null ? SchemaGarbageCollectorType.NONE : this.definitionFactory.callGarbageCollector();
    }

    public boolean hasMemberPropertyConsistencyCheck() {
        return this.definitionFactory != null && this.definitionFactory.memberPropertyConsistencyCheck() == MemberPropertyConsistencyCheckType.ACTIVE;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj);
    }

    public final int hashCode() {
        return super.hashCode();
    }

    public S_SchemaRef getClusterRef() {
        return this.clusterRef;
    }

    public String getUuid() {
        return this.uuid;
    }

    @Nullable
    public String getOfflineSnapshot() {
        if (this.information == null) {
            return null;
        }
        return this.information.getOfflineSnapshot();
    }

    public OlapRoleSchemaPermissions getFullControlPermissions() {
        return this.fullControlPermissions;
    }

    public OlapSchemaCategoryMemberManager getCategoryMemberManager() {
        return this.categoryMemberManager;
    }

    public OlapSchemaCalculatedMemberManager getCalcMemberManager() {
        return this.calcMemberManager;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description == null ? "" : this.description;
    }

    public String getGroup() {
        return this.group;
    }

    @Nullable
    public OlapSchemaTimingStats getTimingStats() {
        return this.timingStats;
    }

    public void setTimingStats(OlapSchemaTimingStats timingStats) {
        this.timingStats = timingStats;
    }

    public OlapSchemaStatsHolder getStatsHolder() {
        return this.statsHolder;
    }

    public OlapSchemaFullLoadGCStats getFullLoadGCStats() {
        return this.statsHolder.getFullLoadGCStats();
    }

    @Nullable
    public OlapSchemaFullLoadStats getFullLoadStats() {
        return this.statsHolder.getFullLoadStats();
    }

    public void setFullLoadStats(OlapSchemaFullLoadStats stats) {
        this.statsHolder.setFullLoadStats(stats);
    }

    @Nullable
    public OlapSchemaStats getStats() {
        return this.statsHolder.getStats();
    }

    public List<OlapSchemaPartitionInformation> listPartitions() {
        ArrayList<OlapSchemaPartitionInformation> partitions = new ArrayList<OlapSchemaPartitionInformation>();
        for (OlapRegularCube cube : this.cubes) {
            cube.listPartitions(partitions);
        }
        return partitions;
    }

    public String dumpFactsIndex(OlapEngineRequestContext context) throws IOException {
        File file = new File("/tmp/ic3-index/", this.getName() + ".icc-index");
        if (file.exists()) {
            throw new IOException("[DumpSchemaIndex] delete first: " + file.getAbsolutePath());
        }
        try (FileOutputStream out = new FileOutputStream(file);){
            OlapLoggers.GENERAL.info((Object)("[DumpSchemaIndex] schema : " + this.getName() + " writing index to : " + file.getAbsolutePath()));
            OlapSchemaDumpIndexHierarchies hierarchies = new OlapSchemaDumpIndexHierarchies();
            this.getDimensions().forEach(d -> d.getHierarchies().forEach(hierarchies::add));
            for (OlapRegularCube cube : this.cubes) {
                cube.dumpIndex(out, hierarchies);
            }
            DataOutputStream dOut = new DataOutputStream(new BufferedOutputStream(out));
            dOut.writeInt(-43);
            dOut.flush();
        }
        return file.getAbsolutePath();
    }

    public OlapSchemaStats refreshStats(@Nullable IcCubeRequestStatusManager requests) {
        OlapSchemaStats stats = this.statsHolder.refreshStats(requests, this);
        long ram = stats.getTotalRamSize();
        OlapLoggers.BUILDER.info((Object)String.format("[stats] " + this.name + " RAM : %s %s", CdSizeUtils.format((double)ram), CdStringUtils.formatNice((long)ram)));
        return stats;
    }

    public OlapSchemaInformation getInformation() {
        return this.information;
    }

    public OlapSchemaInformationForTests getInformationForPerformanceTests() {
        long expiryMS = System.currentTimeMillis() + 10000L;
        while (this.timingStats == null && System.currentTimeMillis() < expiryMS) {
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException ex) {
                throw new RuntimeException(ex);
            }
        }
        OlapSchemaStats stats = this.refreshStats(null);
        long totalRamSize = stats.getTotalRamSize();
        OlapSchemaInformationForTests info = new OlapSchemaInformationForTests(this.information, this.timingStats, totalRamSize);
        for (OlapRegularCube cube : this.cubes) {
            cube.getInformationForPerformanceTests(info);
        }
        return info;
    }

    public IOlapBuilderSchemaDefFactory getDefinitionFactory() {
        if (this.definitionFactory == null) {
            throw new CdProgrammingException("missing schema-def-factory [" + this.getName() + "]");
        }
        return this.definitionFactory;
    }

    public void addCube(OlapRegularCube cube) {
        this.allCubesForSaveRestore.add(cube);
        if (OlapLoggers.SCHEMA.isInfoEnabled()) {
            OlapLoggers.SCHEMA.info((Object)("[schema] schema [" + this.name + "] : add cube [" + ONames.name4Log(cube) + "]"));
        }
        this.cubes.add(cube);
    }

    @Nullable
    public OlapPerspectiveCube lookupCubePerspectiveByName(OlapNameContext nameContext, String name) {
        List<OlapPerspectiveCube> perspectives = this.perspectivesManager.getCubePerspectives();
        for (OlapPerspectiveCube perspective : perspectives) {
            if (!perspective.getName(nameContext).equals(name)) continue;
            return perspective;
        }
        return null;
    }

    @Nullable
    public OlapRegularCube lookupCubeByName(OlapNameContext nameContext, String name) {
        int size = this.cubes.size();
        for (int ii = 0; ii < size; ++ii) {
            OlapRegularCube cube = this.cubes.get(ii);
            if (!cube.getName(nameContext).equalsIgnoreCase(name)) continue;
            return cube;
        }
        return null;
    }

    @Override
    public boolean hasCubes() {
        return this.getCubeCount() != 0;
    }

    public int getCubeCount() {
        return this.cubes.size();
    }

    public List<OlapRegularCube> getCubes() {
        return this.cubes;
    }

    public OlapUnresolvedRowsManager getUnresolvedRowsManager() {
        return this.unresolvedRows;
    }

    public OlapSetEvaluationController getSetEvaluationController() {
        return this.setEvaluationController;
    }

    public OlapPerspectiveManager getPerspectiveManager() {
        return this.perspectivesManager;
    }

    public OlapMemberPropertyManager getMemberPropertyManager() {
        return this.memberPropertyManager;
    }

    public OlapSetDeclarationManager getSetDeclarationManager() {
        return this.setDeclarations;
    }

    public OlapSchemaFunctionRepository getFunctionRepository() {
        return this.functionRepository;
    }

    public OlapSchemaFunctionRepositorySnapshot getFunctionRepositorySnapshot() {
        return this.functionRepository.createSnapshot();
    }

    public void addDimension(OlapDimension dimension) {
        this.dimensions.add(dimension);
    }

    @Override
    public boolean hasDimensions() {
        return !this.dimensions.isEmpty();
    }

    public List<OlapDimension> getDimensions() {
        return this.dimensions;
    }

    public List<OlapDimension> getDimensions(IOlapDimensionsPermission permissions) {
        ArrayList<OlapDimension> authorized = new ArrayList<OlapDimension>();
        int size = this.dimensions.size();
        for (int ii = 0; ii < size; ++ii) {
            OlapDimension dimension = this.dimensions.get(ii);
            if (!dimension.isMeasures() && !permissions.isDimensionAuthorized(dimension)) continue;
            authorized.add(dimension);
        }
        return authorized;
    }

    @Nullable
    public OlapDimension lookupDimensionByName(OlapNameContext nameContext, String name) {
        return this.lookupDimensionByName(this.fullControlPermissions, nameContext, name);
    }

    @Nullable
    public OlapDimension lookupDimensionByName(IOlapDimensionsPermission schemaPermissions, OlapNameContext nameContext, String name) {
        List<OlapDimension> authDimensions = this.getDimensions(schemaPermissions);
        int size = authDimensions.size();
        for (int ii = 0; ii < size; ++ii) {
            OlapDimension dimension = authDimensions.get(ii);
            if (!OlapCaseInsensitiveName.equals(dimension.getName(nameContext), name)) continue;
            return dimension;
        }
        return null;
    }

    @Nullable
    public OlapHierarchy lookupHierarchyByUniqueName(IOlapDimensionsPermission permissions, OlapNameContext nameContext, String uniqueName) {
        List<OlapDimension> authDimensions = this.getDimensions(permissions);
        block0: for (OlapDimension dimension : authDimensions) {
            for (OlapHierarchy hierarchy : dimension.getHierarchies()) {
                String hUN = hierarchy.getUniqueName(nameContext);
                if (!hUN.equals(uniqueName)) continue;
                IOlapDimensionPermission perms = permissions.getDimensionPermissions(dimension);
                if (!perms.isHierarchyAuthorized(hierarchy)) continue block0;
                return hierarchy;
            }
        }
        return null;
    }

    @Nullable
    public OlapSetDeclaration lookupSetDeclaration(String name) {
        return this.setDeclarations.get(name);
    }

    public IOlapBuilderDimensionDef getDimensionDefinition(String id) {
        IOlapBuilderDimensionDef dim;
        if (!this.dimDefinitionsSetup) {
            this.setupDimensionDefinitions();
        }
        if ((dim = this.dimDefinitions.get(id)) == null) {
            throw new OlapBuilderErrorException(OlapBuilderErrorCode.UNEXPECTED_ERROR, new Serializable[]{"schema [" + this.name + "] missing dimension definition [" + id + "]"});
        }
        return dim;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setupDimensionDefinitions() {
        Map<String, IOlapBuilderDimensionDef> map = this.dimDefinitions;
        synchronized (map) {
            if (this.dimDefinitionsSetup) {
                return;
            }
            IOlapBuilderSchemaDefFactory factory = this.getDefinitionFactory();
            IOlapBuilderSchemaDef definition = factory.createSchemaDefinition(null, null);
            for (IOlapBuilderDimensionDef dimDef : definition.getDimensions()) {
                this.dimDefinitions.put(dimDef.getId(), dimDef);
            }
            this.dimDefinitionsSetup = true;
        }
    }

    public OlapMember getMember(int levelIndex, int uniqueLevelMemberIndex) {
        OlapLevel level;
        if (!this.levelsSetup) {
            this.setupLevels();
        }
        if ((level = this.levels.get(levelIndex)) == null) {
            throw new OlapBuilderErrorException(OlapBuilderErrorCode.UNEXPECTED_ERROR, new Serializable[]{"schema [" + this.name + "] missing level [" + levelIndex + "]"});
        }
        try {
            OlapMember member = level.getMemberAtDataIdx(uniqueLevelMemberIndex);
            return member;
        }
        catch (IndexOutOfBoundsException ex) {
            throw new OlapBuilderErrorException(OlapBuilderErrorCode.UNEXPECTED_ERROR, new Serializable[]{"schema [" + this.name + "] level [" + level.getNameX() + "] missing member [" + uniqueLevelMemberIndex + "]"});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setupLevels() {
        Map<Integer, OlapLevel> map = this.levels;
        synchronized (map) {
            if (this.levelsSetup) {
                return;
            }
            for (OlapDimension dimension : this.dimensions) {
                for (OlapHierarchy hierarchy : dimension.getHierarchies()) {
                    for (OlapLevel level : hierarchy.getLevels()) {
                        this.levels.put(level.getUniqueIndex(), level);
                    }
                }
            }
            for (OlapRegularCube cube : this.cubes) {
                OlapMeasuresDimension dimension = cube.getMeasuresDimension();
                for (OlapHierarchy hierarchy : dimension.getHierarchies()) {
                    for (OlapLevel level : hierarchy.getLevels()) {
                        this.levels.put(level.getUniqueIndex(), level);
                    }
                }
            }
            this.levelsSetup = true;
        }
    }

    public List<OlapSetDeclaration> getSetDeclarations() {
        return this.setDeclarations.getDeclarations(null);
    }

    public List<OlapSetDeclaration> getSetDeclarations(@Nullable IOlapSchemaPermission perms) {
        return this.setDeclarations.getDeclarations(perms);
    }

    public void addSetDeclarationIfNotContained(OlapInstrLocationRange definitionRange, IOlapSchemaPermission schemaPermissions, @Nullable String cube, String name, boolean sessionScoped, boolean dynamicEvaluation, String mdx, OlapInstr formula, @Nullable String displayFolder, @Nullable String description) {
        this.setDeclarations.addIfNotContained(definitionRange, schemaPermissions, cube, name, sessionScoped, dynamicEvaluation, mdx, formula, displayFolder, description);
    }

    public void removeSetDeclaration(@Nullable OlapErrorLocation errorLocation, IOlapSchemaPermission schemaPermissions, String name) {
        OlapSetDeclaration declaration = this.setDeclarations.remove(errorLocation, schemaPermissions, name);
        if (declaration != null) {
            this.staticSetManager.removeSetDeclaration(errorLocation, schemaPermissions, declaration);
        }
    }

    @Nullable
    public OlapSetInfoEx getSetInfoEx(OlapNameContext context, IOlapSchemaPermission perms, OlapSetDeclaration set) {
        OlapSetInfo info = this.staticSetManager.getSetInfo(perms, set);
        if (info == null) {
            return null;
        }
        ArrayList<String> dimensionalityEx = null;
        if (info.dimensionality != null) {
            dimensionalityEx = new ArrayList<String>();
            List<OlapHierarchy> hierarchies = this.getHierarchies(info.dimensionality);
            for (OlapHierarchy hierarchy : hierarchies) {
                dimensionalityEx.add(hierarchy.getUniqueName(context));
            }
        }
        return new OlapSetInfoEx(info.name, dimensionalityEx, info.estimatedSize);
    }

    public int getDrillthroughActionCount() {
        return this.actions.getDrillthroughActionCount();
    }

    public List<OlapDrillthroughAction> getDrillthroughActions(String cubeName, OlapTuple tuple) {
        return this.actions.getDrillthroughActions(cubeName, tuple);
    }

    public void addDrillthroughActionIfNotContained(OlapInstrLocationRange definitionRange, IOlapSchemaPermission schemaPermissions, String name, @Nullable Long maxRows, List<OlapDrillthroughReturn> returns, @Nullable OlapEntityIdentifier target) {
        this.actions.addDrillthroughIfNotContained(definitionRange, schemaPermissions, name, maxRows, returns, target);
    }

    public void removeAction(@Nullable OlapErrorLocation errorLocation, IOlapSchemaPermission schemaPermissions, String name) {
        this.actions.remove(errorLocation, schemaPermissions, name);
    }

    public void removeAllDeclaredFunctions(@Nullable OlapErrorLocation errorLocation, IOlapSchemaPermission schemaPermissions) {
        this.functionRepository.removeAllDeclaredFunctions(errorLocation, schemaPermissions);
        this.nativeFunctionsCL = null;
    }

    public void removeDeclaredFunction(@Nullable OlapErrorLocation errorLocation, IOlapSchemaPermission schemaPermissions, String name) {
        this.functionRepository.removeDeclaredFunction(errorLocation, schemaPermissions, name);
        if (this.nativeFunctionsCL != null) {
            this.nativeFunctionsCL = this.nativeFunctionsCL.dropCode("icCube.nativeFunctions." + name);
        }
    }

    public void removeAllCalcMembers(@Nullable OlapErrorLocation errorLocation, IOlapSchemaPermission schemaPermissions) {
        this.calcMemberManager.deleteAll(errorLocation, schemaPermissions);
        for (OlapCube olapCube : this.cubes) {
            OlapCubeCalculatedMemberManager cubeCalcMemberManager = olapCube.getCalcMemberManager();
            IOlapCubePermission cubePermissions = schemaPermissions.getCubePermissions(olapCube);
            cubeCalcMemberManager.deleteAll(errorLocation, cubePermissions);
        }
    }

    public void removeAllUserMeasures(@Nullable OlapErrorLocation errorLocation, IOlapSchemaPermission schemaPermissions) {
        for (OlapCube olapCube : this.cubes) {
            OlapCubeCalculatedMemberManager cubeCalcMemberManager = olapCube.getCalcMemberManager();
            IOlapCubePermission cubePermissions = schemaPermissions.getCubePermissions(olapCube);
            cubeCalcMemberManager.deleteAllUserMeasures(errorLocation, cubePermissions);
        }
    }

    public void removeAllSetDeclarations(@Nullable OlapErrorLocation errorLocation, IOlapSchemaPermission schemaPermissions) {
        List<String> names = this.setDeclarations.getNames();
        for (String name : names) {
            this.removeSetDeclaration(errorLocation, schemaPermissions, name);
        }
    }

    public void removeAllCategoryHierarchies(@Nullable OlapErrorLocation errorLocation, IOlapSchemaPermission schemaPermissions) {
        for (OlapDimension dimension : this.dimensions) {
            dimension.removeAllCategoryHierarchies();
        }
    }

    public void removeAllActions(@Nullable OlapErrorLocation errorLocation, IOlapSchemaPermission schemaPermissions) {
        this.actions.clear(errorLocation, schemaPermissions);
    }

    public String toString() {
        return this.name;
    }

    public void addDataSource(OlapBuilderBaseDataSource dataSource) {
        this.dataSources.put(dataSource.getName(), dataSource);
    }

    public boolean onSchemaUnloaded(OlapFileCleaner cleaner) {
        this.categoryMemberManager.onSchemaUnloaded();
        this.cleanupResources(cleaner);
        return true;
    }

    public void onBuildError(OlapFileCleaner cleaner) {
        this.cleanupResources(cleaner);
    }

    private void cleanupResources(OlapFileCleaner cleaner) {
    }

    public boolean useUnknownMembers() {
        return this.useUnknownMembers;
    }

    public int getNextDimensionIndexAndIncrement() {
        return this.nextDimensionIndex.getAndIncrement();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getNextHierarchyIndexAndIncrement() {
        Object object = this.nextHierarchyIndexLOCK;
        synchronized (object) {
            if (!this.availableHierarchyIndex.isEmpty()) {
                return this.availableHierarchyIndex.pop();
            }
            return this.nextMaxHierarchyIndex++;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseNextHierarchyIndex(int index) {
        Object object = this.nextHierarchyIndexLOCK;
        synchronized (object) {
            this.availableHierarchyIndex.push(index);
        }
    }

    public int getNextLevelIndexAndIncrement() {
        return this.nextLevelIndex.getAndIncrement();
    }

    public int getNextDimensionIndex() {
        return this.nextDimensionIndex.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getNextHierarchyIndex() {
        Object object = this.nextHierarchyIndexLOCK;
        synchronized (object) {
            return this.nextMaxHierarchyIndex;
        }
    }

    public long getNextCalcMemberDeclarationOrder() {
        return this.nextCalcMemberDeclarationOrder.getAndIncrement();
    }

    public int getDimensionCount() {
        return this.dimensions.size();
    }

    public int getHierarchyCount() {
        int count = 0;
        for (OlapDimension dimension : this.getDimensions()) {
            count += dimension.getHierarchyCount();
        }
        return count;
    }

    public Date getLastDataUpdatedTime() {
        if (this.information == null) {
            return Date.from(LocalDate.of(2000, 1, 1).atStartOfDay(ZoneId.systemDefault()).toInstant());
        }
        return this.information.getLastDataUpdatedTime();
    }

    public void setLastDataUpdatedTime(Date lastUpdate) {
        if (this.information != null) {
            this.information.setLastDataUpdatedTime(lastUpdate);
        }
    }

    public long getLastDataUpdatedTimeX() {
        if (this.information == null) {
            return -1L;
        }
        return this.information.getLastDataUpdatedTimeX();
    }

    @Nullable
    public Date getNullableLastDataUpdatedTime() {
        if (this.information == null) {
            return null;
        }
        return this.information.getLastDataUpdatedTime();
    }

    @Nullable
    public Date getNullableLastRefreshTime() {
        if (this.information == null) {
            return null;
        }
        return this.information.getRefreshTimeStart();
    }

    public void addPerspective(OlapPerspective perspective) {
        this.perspectivesManager.addPerspective(perspective);
    }

    @Nullable
    public OlapPerspective getDefaultPerspective() {
        return this.perspectivesManager.getDefaultPerspective();
    }

    public IOlapSchemaPermission decorateWithPerspective(IOlapSchemaPermission rolePermission) {
        return this.perspectivesManager.decorateWithPerspective(rolePermission);
    }

    public List<OlapBuilderBaseDataSource<?>> getReportingDataSources(@Nullable IOlapSchemaPermission permissions) {
        ArrayList sources = new ArrayList();
        for (OlapBuilderBaseDataSource dataSource : this.dataSources.values()) {
            OlapBuilderDataSourceVisibility visibility = dataSource.getVisibility();
            if (visibility != OlapBuilderDataSourceVisibility.REPORTING || permissions != null && !permissions.isReportingDataSourceAuthorized(dataSource)) continue;
            sources.add(dataSource);
        }
        return sources;
    }

    @Nullable
    public OlapBuilderBaseDataSource<?> getReportingDataSource(@Nullable IOlapSchemaPermission permissions, String name) {
        for (OlapBuilderBaseDataSource dataSource : this.dataSources.values()) {
            OlapBuilderDataSourceVisibility visibility = dataSource.getVisibility();
            if (visibility != OlapBuilderDataSourceVisibility.REPORTING || !dataSource.getName().equals(name)) continue;
            if (permissions != null && !permissions.isReportingDataSourceAuthorized(dataSource)) break;
            return dataSource;
        }
        return null;
    }

    @Nullable
    public OlapBuilderBaseDataSource<?> getDataSource(String name) {
        for (OlapBuilderBaseDataSource dataSource : this.dataSources.values()) {
            if (!dataSource.getName().equals(name)) continue;
            return dataSource;
        }
        return null;
    }

    public List<OlapCube> getCubes(IOlapSchemaPermission permissions) {
        OlapNameContext nameContext = OlapNameContext.DEFAULT_VALUES;
        ArrayList<OlapCube> allCubes = new ArrayList<OlapCube>();
        HashSet<String> authorizedCubePerspectiveNames = new HashSet<String>();
        List<OlapPerspectiveCube> perspectiveCubes = this.perspectivesManager.getCubePerspectives();
        for (OlapPerspectiveCube olapPerspectiveCube : perspectiveCubes) {
            boolean authorized = permissions.isPerspectiveAuthorized(olapPerspectiveCube);
            if (!authorized) continue;
            OlapRegularCube actualCube = olapPerspectiveCube.getRegularCube();
            IOlapSchemaPermission security = permissions.security();
            if (!security.isCubeAuthorized(actualCube)) continue;
            authorizedCubePerspectiveNames.add(olapPerspectiveCube.getName(nameContext).toUpperCase());
            allCubes.add(olapPerspectiveCube);
        }
        for (OlapCube olapCube : this.cubes) {
            String cubeName = olapCube.getName(nameContext).toUpperCase();
            boolean authorized = permissions.isCubeAuthorized(olapCube);
            boolean withAuthorizedPerspectiveOverwrite = authorizedCubePerspectiveNames.contains(cubeName);
            if (!authorized || withAuthorizedPerspectiveOverwrite) continue;
            allCubes.add(olapCube);
        }
        return allCubes;
    }

    @Nullable
    public OlapCube lookupCubeByName(IOlapSchemaPermission permissions, OlapNameContext nameContext, @Nullable String name) {
        if (name != null) {
            List<OlapCube> cubes = this.getCubes(permissions);
            for (OlapCube cube : cubes) {
                if (!OlapCaseInsensitiveName.equals(cube.getName(nameContext), name)) continue;
                return cube;
            }
            if (!cubes.isEmpty() && "$default$".equalsIgnoreCase(name)) {
                return cubes.get(0);
            }
        }
        return null;
    }

    @Nullable
    public OlapCube lookupCubeByNameEx(IOlapSchemaPermission permissions, OlapNameContext nameContext, @Nullable String name) {
        List<OlapCube> cubes = this.getCubes(permissions);
        if (name != null) {
            for (OlapCube cube : cubes) {
                if (!OlapCaseInsensitiveName.equals(cube.getName(nameContext), name)) continue;
                return cube;
            }
            if (!cubes.isEmpty() && "$default$".equalsIgnoreCase(name)) {
                return cubes.getFirst();
            }
        } else if (cubes.size() == 1) {
            return cubes.getFirst();
        }
        return null;
    }

    public OlapRegularCube getFirstCube() {
        return this.cubes.getFirst();
    }

    @Nullable
    public OlapCube getFirstNullableCube() {
        return this.cubes.isEmpty() ? null : (OlapCube)this.cubes.getFirst();
    }

    public IOlapFactMeasureGroupManagerForEval getFactManager(OlapMeasureMember measure) {
        for (OlapRegularCube cube : this.cubes) {
            OlapFactCubeManager cubeFactManager = cube.getCubeFactManager();
            IOlapFactMeasureGroupManagerForEval factManager = cubeFactManager.getFactManager(measure);
            if (factManager == null) continue;
            return factManager;
        }
        throw new RuntimeException("internal error: missing facts manager for measure [" + measure.getName(OlapNameContext.DEFAULT_VALUES) + "]");
    }

    @Nullable
    public OlapSetEvaluation getEvaluatedStaticSetDeclaration(OlapEvaluationContext context, OlapSetDeclaration setDeclaration) {
        return this.staticSetManager.getEvaluatedStaticSetDeclaration(context, setDeclaration);
    }

    public OlapSetEvaluation evaluateStaticSetDeclaration(OlapEvaluationContext context, OlapSetDeclaration setDeclaration) {
        return this.staticSetManager.evaluateStaticSetDeclaration(context, setDeclaration);
    }

    public void onSchemaPartitionsUnloaded(OlapSchemaUnloadPartitionsInfo unloadPartitionsInfo) {
        this.staticSetManager.onSchemaPartitionsUnloaded(unloadPartitionsInfo);
        this.perspectivesManager.onSchemaPartitionsUnloaded(unloadPartitionsInfo);
        this.categoryMemberManager.onSchemaPartitionsUnloaded(unloadPartitionsInfo);
    }

    public void onSchemaPartitionsLoaded(OlapSchemaLoadPartitionsInfo loadPartitionsInfo) {
        this.staticSetManager.onSchemaPartitionsLoaded(loadPartitionsInfo);
        this.perspectivesManager.onSchemaPartitionsLoaded(loadPartitionsInfo);
        this.categoryMemberManager.onSchemaPartitionsLoaded(loadPartitionsInfo);
    }

    public void onSchemaPartitionsLoadError() {
        this.staticSetManager.onSchemaPartitionsLoadError();
        this.perspectivesManager.onSchemaPartitionsLoadError();
        this.categoryMemberManager.onSchemaPartitionsLoadError();
    }

    public void onSchemaIncrLoaded(OlapEngineRequestContext context, OlapSchemaIncrLoadInfo incrLoadInfo) {
        this.staticSetManager.onSchemaIncrLoaded(context, incrLoadInfo);
        this.perspectivesManager.onSchemaIncrLoaded(incrLoadInfo);
        this.categoryMemberManager.onSchemaIncrLoaded(incrLoadInfo);
        IncrLoadInstanceManager manager = this.incrementalLoad.getManager();
        manager.onIncrLoadSucceeded();
    }

    public void onSchemaIncrLoadedOnError() {
        this.staticSetManager.onSchemaIncrLoadedOnError();
        this.perspectivesManager.onSchemaIncrLoadedOnError();
        this.categoryMemberManager.onSchemaIncrLoadedOnError();
    }

    public void onScriptStatementApplied(OlapScriptInformation information) {
        this.staticSetManager.onScriptStatementApplied(information);
        this.perspectivesManager.onScriptStatementApplied();
        this.categoryMemberManager.onScriptStatementApplied(information);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsSecurityPermissions(IOlapSchemaPermission schemaPermission) {
        schemaPermission = schemaPermission.security();
        Map<IOlapSchemasPermission, IOlapSchemaPermission> map = this.allSchemaPermissions;
        synchronized (map) {
            if (this.fullControlPermissions.equals(schemaPermission)) {
                return true;
            }
            for (IOlapSchemaPermission permissions : this.allSchemaPermissions.values()) {
                if (!permissions.equals(schemaPermission)) continue;
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public IOlapSchemaPermission getPermissions(OlapRoleSchemasRegularPermissions schemasPermissions) {
        Map<IOlapSchemasPermission, IOlapSchemaPermission> map = this.allSchemaPermissions;
        synchronized (map) {
            IOlapSchemaPermission perms = this.allSchemaPermissions.get(schemasPermissions);
            return perms;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPermissions(OlapRoleSchemasRegularPermissions schemasPermissions, OlapRoleSchemaNotCreatedPermissions permissions) {
        Map<IOlapSchemasPermission, IOlapSchemaPermission> map = this.allSchemaPermissions;
        synchronized (map) {
            this.allSchemaPermissions.put(schemasPermissions, permissions);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public IOlapSchemaPermission switchPermissions(OlapRoleSchemasRegularPermissions schemasPermissions, IOlapSchemaPermission permissions) {
        Map<IOlapSchemasPermission, IOlapSchemaPermission> map = this.allSchemaPermissions;
        synchronized (map) {
            if (this.allSchemaPermissions.containsKey(schemasPermissions)) {
                return this.allSchemaPermissions.put(schemasPermissions, permissions);
            }
            IOlapSchemasPermission perms = schemasPermissions.getOnTheFlyTemplate();
            if (perms != null && this.allSchemaPermissions.containsKey(perms)) {
                return this.allSchemaPermissions.put(schemasPermissions, permissions);
            }
            if (perms != null && permissions.isCreated()) {
                return this.allSchemaPermissions.put(schemasPermissions, permissions);
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAllPermissions() {
        Map<IOlapSchemasPermission, IOlapSchemaPermission> map = this.allSchemaPermissions;
        synchronized (map) {
            this.allSchemaPermissions.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePermissions(List<IOlapSchemasPermission> allPerms) {
        Map<IOlapSchemasPermission, IOlapSchemaPermission> map = this.allSchemaPermissions;
        synchronized (map) {
            for (IOlapSchemasPermission perms : allPerms) {
                this.allSchemaPermissions.remove(perms);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, List<? extends CdError>> getPermsErrors() {
        Map<IOlapSchemasPermission, IOlapSchemaPermission> map = this.allSchemaPermissions;
        synchronized (map) {
            HashMap<String, List<? extends CdError>> errors = new HashMap<String, List<? extends CdError>>();
            for (IOlapSchemaPermission permissions : this.allSchemaPermissions.values()) {
                if (!(permissions instanceof OlapRoleSchemaOnErrorPermissions)) continue;
                OlapRoleSchemaOnErrorPermissions errPermissions = (OlapRoleSchemaOnErrorPermissions)permissions;
                errors.put(errPermissions.getRoleName(), Collections.unmodifiableList(errPermissions.getErrors()));
            }
            return errors;
        }
    }

    public IncrLoadSavePoints getIncrementalLoad() {
        return this.incrementalLoad;
    }

    public void upgradeToRealTime() {
        this.incrementalLoad.upgradeToRealTime();
    }

    public boolean acceptIncrLoad() {
        IncrLoadInstanceManager manager = this.incrementalLoad.getManager();
        return manager.acceptIncrLoad();
    }

    public String incrLoads() {
        IncrLoadInstanceManager manager = this.incrementalLoad.getManager();
        return manager.incrLoads();
    }

    public boolean isIncrLoadDeActivatedOnError() {
        return this.incrementalLoad.isIncrLoadDeActivatedOnError();
    }

    public void deActivateIncrLoadOnError() {
        this.incrementalLoad.deActivateIncrLoadOnError();
        this.information.deActivateIncrLoadOnError();
    }

    public void onSecurityAllPermissionsRemoved() {
        this.perspectivesManager.onSecurityPermissionsRemoved();
        this.staticSetManager.onSecurityAllPermissionsRemoved();
        this.categoryMemberManager.onSecurityPermissionsRemoved();
    }

    public void onSecurityPermissionsSwitched(OlapEngineRequestContext context, @Nullable IOlapSchemaPermission permissions) {
        this.perspectivesManager.onSecurityPermissionsRemoved();
        this.staticSetManager.onSecurityPermissionsSwitched(context, permissions);
        this.categoryMemberManager.onSecurityPermissionsSwitched(permissions);
    }

    public void requiresLoadSchemaMembersPostProcessing(boolean flag) {
        this.requiresLoadSchemaMembersPostProcessing = flag;
    }

    public boolean requiresLoadSchemaMembersPostProcessing() {
        return this.requiresLoadSchemaMembersPostProcessing;
    }

    public void onLoadSchemaMembersPostProcessingDone() {
        this.requiresLoadSchemaMembersPostProcessing = false;
    }

    public void deleteAllCategoryHierarchyBitmaps() {
        for (OlapDimension dimension : this.dimensions) {
            List<OlapHierarchy> hierarchies = dimension.getHierarchies();
            for (OlapHierarchy hierarchy : hierarchies) {
                if (!hierarchy.acceptCategoryMembers()) continue;
                for (OlapRegularCube cube : this.cubes) {
                    cube.deleteCategoryHierarchyBitmaps(hierarchy);
                }
            }
        }
    }

    public void deleteCategoryHierarchyBitmaps(OlapHierarchy hierarchy) {
        for (OlapRegularCube cube : this.cubes) {
            cube.deleteCategoryHierarchyBitmaps(hierarchy);
        }
    }

    public void resetAllCategoryMembers() {
        for (OlapDimension dimension : this.dimensions) {
            List<OlapHierarchy> hierarchies = dimension.getHierarchies();
            for (OlapHierarchy hierarchy : hierarchies) {
                if (!hierarchy.acceptCategoryMembers()) continue;
                hierarchy.resetCategoryMembers();
            }
        }
        this.calcMemberManager.resetCategoryMembers();
    }

    public OlapSchemaStats createStats(@Nullable OlapSchemaTableStats tStats) {
        try {
            long startMS = System.currentTimeMillis();
            if (OlapLoggers.BUILDER.isDebugEnabled()) {
                OlapLoggers.BUILDER.debug((Object)("[stats] starting for schema : " + this.name));
            }
            Date backupTimestamp = this.information.getRestoredBackupTimestampD();
            Date lastUpdateTimestamp = this.information.getLastDataUpdatedTime();
            Date refreshTimestamp = this.information.getRefreshTimeStart();
            OlapStatsContext context = new OlapStatsContext(this.getUnresolvedRowsManager());
            if (OlapLoggers.BUILDER.isDebugEnabled()) {
                OlapLoggers.BUILDER.debug((Object)"[stats] non-indexing dimensions");
            }
            List<String> nonIndexingDimensions = this.extractNonIndexingDimensions();
            if (OlapLoggers.BUILDER.isDebugEnabled()) {
                OlapLoggers.BUILDER.debug((Object)"[stats] dimensions");
            }
            HashMap<String, OlapDimensionStats> indexedDimensionsStats = new HashMap<String, OlapDimensionStats>();
            ArrayList<OlapDimensionStats> dimensionsStats = new ArrayList<OlapDimensionStats>();
            for (OlapDimension dimension : this.dimensions) {
                OlapDimensionStats dimensionStats = dimension.createStats();
                indexedDimensionsStats.put(dimension.getName(OlapNameContext.DEFAULT_VALUES), dimensionStats);
                dimensionsStats.add(dimensionStats);
            }
            OlapCategoryStats categoryStats = null;
            if (this.n_schema != null) {
                categoryStats = this.n_schema.createCategoryStats();
            }
            ArrayList<OlapFactsStats> factsStats = new ArrayList<OlapFactsStats>();
            if (OlapLoggers.BUILDER.isDebugEnabled()) {
                OlapLoggers.BUILDER.debug((Object)"[stats] facts");
            }
            for (OlapRegularCube cube : this.cubes) {
                factsStats.addAll(cube.createStats(context, indexedDimensionsStats));
            }
            if (OlapLoggers.BUILDER.isDebugEnabled()) {
                OlapLoggers.BUILDER.debug((Object)"[stats] others");
            }
            long savePointsRamSize = this.incrLoadSizeOf();
            long bridgeSize = this.bridgeSizeOf();
            long lookupTableSize = this.lookupTableSizeOf();
            List<OlapSavePointStats> savePoints = this.createSavePointsStats();
            long autoExistRamSize = this.autoExistContainer.sizeOf();
            if (OlapLoggers.BUILDER.isDebugEnabled()) {
                OlapLoggers.BUILDER.debug((Object)"[stats] done");
            }
            OlapSchemaStats stats = new OlapSchemaStats(this.getFullLoadGCStats(), this.getFullLoadStats(), tStats, backupTimestamp, lastUpdateTimestamp, refreshTimestamp, this.name, context.getWarnings(), this.timingStats, this.isIncrLoadActive(), nonIndexingDimensions, dimensionsStats, categoryStats, factsStats, savePointsRamSize, bridgeSize, lookupTableSize, savePoints, autoExistRamSize);
            if (OlapLoggers.BUILDER.isDebugEnabled()) {
                OlapLoggers.BUILDER.debug((Object)("[stats] completed for schema [" + this.name + "] in " + CdTimeUtils.formatMillisEx((long)startMS)));
            }
            if (OlapLoggers.BUILDER.isInfoEnabled()) {
                OlapLoggers.BUILDER.info((Object)("[stats] schema statistics\n" + stats.print(true)));
            }
            if (OlapLoggers.BUILDER_STATS.isInfoEnabled()) {
                OlapLoggers.BUILDER_STATS.info((Object)("[stats] schema statistics\n" + stats.print(false)));
            }
            return stats;
        }
        catch (RuntimeException ex) {
            OlapLoggers.BUILDER.error((Object)("[builder] creates schema [" + this.name + "] stats error"), (Throwable)ex);
            ArrayList<String> warnings = new ArrayList<String>();
            warnings.add("Statistics not available due to an unexpected error (check the logs for more details).");
            List<String> nonIndexingDimensions = Collections.emptyList();
            List<OlapDimensionStats> dimensionsStats = Collections.emptyList();
            List<OlapFactsStats> factsStats = Collections.emptyList();
            OlapSchemaStats stats = new OlapSchemaStats(this.getFullLoadGCStats(), this.getFullLoadStats(), tStats, null, new Date(), new Date(), this.name, warnings, this.timingStats, this.isIncrLoadActive(), nonIndexingDimensions, dimensionsStats, null, factsStats, 0L, 0L, 0L, null, 0L);
            return stats;
        }
    }

    public long lookupTableSizeOf() {
        return OlapLookupTableSizeHelper.sizeOf(this.lookupTables.values());
    }

    public long bridgeSizeOf() {
        return this.bridges.sizeOf();
    }

    public long incrLoadSizeOf() {
        return this.incrementalLoad != null ? this.incrementalLoad.sizeOf() : 0L;
    }

    private List<String> extractNonIndexingDimensions() {
        HashSet<OlapDimension> indexingDimensions = new HashSet<OlapDimension>();
        for (OlapRegularCube cube : this.cubes) {
            indexingDimensions.addAll(cube.getIndexingDimensions());
        }
        ArrayList<String> nonIndexingDimensions = new ArrayList<String>();
        for (OlapDimension dimension : this.dimensions) {
            if (!dimension.isFactIndexing() || indexingDimensions.contains(dimension)) continue;
            nonIndexingDimensions.add(dimension.getName(OlapNameContext.DEFAULT_VALUES));
        }
        nonIndexingDimensions.sort(String::compareTo);
        return nonIndexingDimensions;
    }

    public OlapIncrLoadStats createIncrLoadStats() {
        OlapStatsContext context = new OlapStatsContext(this.getUnresolvedRowsManager());
        ArrayList<OlapDimensionStats> dimensionsStats = new ArrayList<OlapDimensionStats>();
        for (OlapDimension olapDimension : this.dimensions) {
            dimensionsStats.add(olapDimension.createIncrLoadStats());
        }
        ArrayList<OlapFactsStats> factsStats = new ArrayList<OlapFactsStats>();
        for (OlapRegularCube cube : this.cubes) {
            factsStats.addAll(cube.createIncrLoadStats(context));
        }
        List<OlapSavePointStats> list = this.createSavePointsStats();
        return new OlapIncrLoadStats(dimensionsStats, factsStats, list);
    }

    @Nullable
    private List<OlapSavePointStats> createSavePointsStats() {
        if (this.incrementalLoad == null) {
            return null;
        }
        return this.incrementalLoad.createStats();
    }

    public OlapDimensionality toDimensionality(OlapTupleDimensionality tupleDimensionality) {
        OlapDimensionality dim = new OlapDimensionality();
        for (OlapDimension dimension : this.dimensions) {
            for (OlapHierarchy hierarchy : dimension.getHierarchies()) {
                if (!tupleDimensionality.isIn(hierarchy)) continue;
                dim.add(dimension);
            }
        }
        return dim;
    }

    public void forEachHierarchy(OlapTupleDimensionality tupleDimensionality, CdActionEx<OlapHierarchy> action) {
        for (OlapDimension dimension : this.dimensions) {
            List<OlapHierarchy> hierarchies = dimension.getHierarchies();
            for (int ii = 0; ii < hierarchies.size(); ++ii) {
                OlapHierarchy hierarchy = hierarchies.get(ii);
                if (!tupleDimensionality.isIn(hierarchy) || action.apply(ii, (Object)hierarchy)) continue;
                return;
            }
        }
    }

    public List<OlapHierarchy> getHierarchies(OlapTupleDimensionality dimensionality) {
        ArrayList<OlapHierarchy> hierarchies = new ArrayList<OlapHierarchy>();
        this.forEachHierarchy(dimensionality, (CdActionEx<OlapHierarchy>)((CdActionEx)(idx, olapHierarchy) -> {
            hierarchies.add((OlapHierarchy)olapHierarchy);
            return true;
        }));
        return hierarchies;
    }

    public void updateIncrLoadSavePoints(OlapBuilderLoadMeasureGroupContext context, IOlapBuilderDataTableDef tableDef, IncrLoadTableSavePoint savePoint) {
        this.incrementalLoad.updateIncrLoadSavePoints(context, tableDef, savePoint);
    }

    public void setClusterDef(S_SchemaDef schemaDef) {
        this.clusterDef = schemaDef;
    }

    public S_SchemaDef getClusterSchemaDef() {
        if (this.clusterDef == null) {
            throw new RuntimeException("internal error: inconsistent schema ( " + this.getName() + " ) cluster setup");
        }
        return this.clusterDef;
    }

    public boolean hasClusterSchemaDef() {
        return this.clusterDef != null;
    }

    public boolean isBackupActivated() {
        return this.definitionFactory != null && this.definitionFactory.backup() == BackupType.ACTIVE;
    }

    public void setBackupDir(File backupDir, boolean restoring, @Nullable M_RestorePartitionManager restoringPartitionManager) {
        this.backupDir = backupDir;
        this.restoring = restoring;
        if (restoring && this.information != null) {
            this.information.setRestoreTimestamp(backupDir.getName());
        }
        this.restoringPartitionManager = restoringPartitionManager;
    }

    @Nullable
    public File getBackupDir() {
        return this.backupDir;
    }

    public void disableBackupOnError() {
        OlapLoggers.BACKUP.error((Object)("[backup] backup disabled (on-error) for schema [" + this.name + "]"));
        this.backupDisabledOnError = true;
    }

    public void resetDisableBackupOnError() {
        OlapLoggers.BACKUP.error((Object)("[backup] backup re-activated because of incr. load recoverable error for schema [" + this.name + "]"));
        this.backupDisabledOnError = false;
    }

    public boolean isBackupDisabledOnError() {
        return this.backupDisabledOnError;
    }

    public boolean isBackuping() {
        return !this.backupDisabledOnError && this.backupDir != null && !this.restoring;
    }

    public boolean isRestoring() {
        return this.restoring;
    }

    public void setRestoring(boolean restoring, boolean backupOff) {
        this.restoring = restoring;
        if (!restoring) {
            this.restoringPartitionManager = null;
        }
        if (!restoring && backupOff) {
            OlapLoggers.BACKUP.warn((Object)("[backup] backup disabled (from restore params.) for schema [" + this.name + "]"));
            this.backupDir = null;
        }
    }

    public M_RestorePartitionManager getRestoringPartitionManager() {
        if (this.restoringPartitionManager == null) {
            throw new RuntimeException("internal error : missing restoring partition manager");
        }
        return this.restoringPartitionManager;
    }

    public void setRestoreTimestamp(String timestamp) {
        if (this.information != null) {
            this.information.setRestoreTimestamp(timestamp);
        }
    }

    public void commitBridgesDiff() {
        this.bridges.commitDiff();
    }

    public void saveBridges(M_BackupContext context) throws IOException {
        this.bridges.save(context);
    }

    public void restoreBridges(M_RestoreContext context) throws IOException {
        this.bridges.restore(context);
        context.getSchema().getDefinitionFactory().getSchemaDefinition().getCubes().forEach(cube -> cube.getFacts().forEach(facts -> {
            Map<IOlapBuilderDimensionDef, IOlapBuilderDataViewLinksDef> dimensionMap = facts.getDimensionMap();
            dimensionMap.forEach((k, link) -> {
                OlapBridgeDef bridge;
                if (link.isBridge() && !(bridge = link.buildBridge()).isLookupTable((IOlapBuilderDataViewLinksDef)link)) {
                    List<OlapSingleBridgeBaseMap> maps = bridge.getSingleBridgeDefs().stream().map(singleBridge -> this.bridges.getForBuilding((OlapSingleBridgeDef)singleBridge, false)).collect(Collectors.toList());
                    OlapBridgeResolver resolver = new OlapBridgeResolver(maps);
                    this.bridgeResolvers.put(bridge, resolver);
                }
            });
        }));
    }

    public void setupBridges(Function<String, String> tableNames, IOlapBuilderDataViewLinksDef link, OlapBridgeDef bridge) {
        if (bridge == null) {
            return;
        }
        if (bridge.isLookupTable(link)) {
            String tableId = bridge.getLookupTableTableId();
            IOlapBuilderDataColumnDef from = bridge.getLookupTableFrom();
            IOlapBuilderDataColumnDef to = bridge.getLookupTableTo();
            OlapLookupTableKey key = new OlapLookupTableKey(tableId, from);
            OlapLookupTable table = this.lookupTables.computeIfAbsent(key, key_ -> {
                String tableName = (String)tableNames.apply(tableId);
                return new OlapLookupTable(tableName, tableId, from);
            });
            table.addTo(to);
        } else {
            this.bridgeResolvers.computeIfAbsent(bridge, olapBridge -> {
                List<OlapSingleBridgeBaseMap> maps = bridge.getSingleBridgeDefs().stream().map(singleBridge -> this.bridges.getOrCreateForSetup((OlapSingleBridgeDef)singleBridge)).collect(Collectors.toList());
                return new OlapBridgeResolver(maps);
            });
        }
    }

    public IOlapBuilderTableListener getBridgeTableListenerForBuilding(OlapBuilderContext context, @Nullable OlapSingleBridgeDef definition) {
        boolean useIncrMap = context.isIncrLoad() && context.isBackuping();
        OlapSingleBridgeBaseMap singleMap = this.bridges.getForBuilding(definition, useIncrMap);
        return definition == null ? null : definition.createListener(singleMap);
    }

    @Nullable
    public IOlapBridgeResolver getBridgeResolverForFacts(OlapBridgeDef bridge, final OlapDimension dimension) {
        if (bridge == null) {
            return null;
        }
        OlapBridgeResolver resolver = this.bridgeResolvers.get(bridge);
        if (resolver == null) {
            return null;
        }
        if (resolver.canUseDimKeyForFactCache(dimension.getFactIndexingHierarchy().getMaxUniqueMemberIndex())) {
            final IOlapBridgeResolver forFacts = resolver.getForFacts();
            return new IOlapBridgeResolver(){
                {
                    Objects.requireNonNull(this$0);
                }

                @Override
                public Comparable getValues(OlapDimension dimension2, Comparable key, boolean useUnknownMembers) throws OlapBuilderFactSolveRowError {
                    return forFacts.getValues(dimension2, key, useUnknownMembers);
                }

                @Override
                public Comparable getValuesForCache(Comparable nativeKeyValue, boolean useUnknownMembers) throws OlapBuilderFactSolveRowError {
                    return forFacts.getValues(dimension, nativeKeyValue, useUnknownMembers);
                }
            };
        }
        return resolver.getForFacts();
    }

    public OlapBridgeResolver getResolverForTest(OlapBridgeDef bridge) {
        return bridge == null ? null : this.bridgeResolvers.get(bridge);
    }

    public Collection<OlapBridgeDef> getBridgeResolverDefinitions() {
        return Collections.list(this.bridgeResolvers.keys());
    }

    @Nullable
    public OlapSingleBridgeDef lookupBridgeDefinitions(String tableId, List<String> keyColNames, List<String> valColNames) {
        return this.bridges.lookupDefinition(tableId, keyColNames, valColNames);
    }

    public Collection<OlapLookupTable> getLookupTables() {
        return Collections.unmodifiableCollection(this.lookupTables.values());
    }

    @Nullable
    public OlapLookupTable getLookupTable(OlapLookupTableKey key) {
        return this.lookupTables.get(key);
    }

    public void clearMany2ManyAndBridges() {
        this.bridges.clear();
        this.bridgeResolvers.clear();
        this.lookupTables.clear();
    }

    @Nullable
    public DynamicClassLoader getNativeFunctionsCL() {
        return this.nativeFunctionsCL;
    }

    public void registerScriptNativeFunctions() {
        if (this.definitionFactory == null) {
            return;
        }
        OlapLoggers.BUILDER.info((Object)("[native] schema [" + this.getName() + "] registering SCRIPT native functions"));
        this.nativeFunctionsCL = new DynamicClassLoader(this.getClass().getClassLoader(), 0);
        OlapBuilderSchema def = (OlapBuilderSchema)this.definitionFactory.getSchemaDefinition();
        if (def != null) {
            OlapBuilderScript script = def.getScript();
            List<CompiledCode> codes = script.getCompiledCodes();
            for (CompiledCode code : codes) {
                OlapLoggers.BUILDER.info((Object)("[native] schema [" + this.getName() + "] registering SCRIPT native functions : " + code.getClassNames()));
                this.nativeFunctionsCL.addCode(code);
            }
        }
    }

    public CompiledCode generateNativeFunctionByteCode(OlapCreateFunctionStatementExecutionContext context, OlapDeclaredFunction function) throws OlapEvaluationException {
        MdxFunctionNativeBodyExpression sourceCode = function.getNativeFunctionSourceCode();
        if (sourceCode == null) {
            throw new RuntimeException("internal error: missing source code for JAVA native function [" + function.getName() + "]");
        }
        try {
            OlapCompilationExceptionContext errContext = () -> MdxEntityCompiler.createRange(sourceCode);
            MdxNativeFunctionExpressionCompiler.NativeInfo info = MdxNativeFunctionExpressionCompiler.extractNativeInfo(errContext, sourceCode);
            if (!"JAVA".equals(info.moduleName) && !"J".equals(info.moduleName)) {
                throw new RuntimeException("internal error: not a JAVA native function [" + function.getName() + "]");
            }
            if (this.definitionFactory == null) {
                throw new RuntimeException("internal error: missing schema [" + this.getName() + "] definition factory");
            }
            OlapBuilderSchema def = (OlapBuilderSchema)this.definitionFactory.getSchemaDefinition();
            if (def == null) {
                throw new RuntimeException("internal error: missing schema [" + this.getName() + "] definition");
            }
            return OlapBuilderScript.generateNativeByteCode(context, this.nativeFunctionsCL, function, info);
        }
        catch (IOException ex) {
            OlapLoggers.MDX_EVALUATION.error((Object)("JAVA native function (" + function.getName() + ") error"), (Throwable)ex);
            throw new OlapEvaluationException(function.getLocationRange(), OlapErrorCode.SELECT_EVAL_UNEXPECTED_ERROR, new Serializable[]{"JAVA native function (" + function.getName() + ") IO error : " + ex.getMessage()});
        }
    }

    public void registerNativeFunctions(CompiledCode code) {
        OlapLoggers.BUILDER.info((Object)("[native] schema [" + this.getName() + "] registering native functions : " + code.getClassNames()));
        if (this.nativeFunctionsCL == null) {
            this.nativeFunctionsCL = new DynamicClassLoader(this.getClass().getClassLoader(), 0);
        }
        this.nativeFunctionsCL.addCode(code);
    }

    public M_BackupShrinker getBackupShrinker() {
        return this.backupShrinker;
    }

    public void setBackupShrinker(M_BackupShrinker backupShrinker) {
        this.backupShrinker = backupShrinker;
    }

    public boolean deleteAllCategoryCalculatedMembers(OlapHierarchy hierarchy) {
        return this.calcMemberManager.deleteAllCategoryCalculatedMembers(hierarchy);
    }

    public boolean measureHasNullsInFactColumns(OlapMeasureMember member) {
        return this.getFactManager(member).measureHasNullsInFactColumns(member);
    }

    public Comparator<String> getLocalizedStringComparator() {
        if (this.localeForStringCompare == null) {
            return null;
        }
        return Collator.getInstance(this.localeForStringCompare)::compare;
    }

    public static Comparator<String> getNameComparator(Locale locale) {
        return Collator.getInstance(locale)::compare;
    }

    public List<String> getLinkingMeasureGroups(OlapDimension dimension) {
        ArrayList<String> names = new ArrayList<String>();
        for (OlapRegularCube cube : this.cubes) {
            OlapFactCubeManager cubeFactManager = cube.getCubeFactManager();
            List<String> cubeNames = cubeFactManager.getLinkingMeasureGroups(dimension);
            cubeNames.sort(String::compareToIgnoreCase);
            if (this.cubes.size() == 1) {
                return cubeNames;
            }
            cubeNames.forEach(n -> names.add(cube.getNameX() + ":" + n));
        }
        return names;
    }

    public Set<String> getMeasureGroupQNamesU() {
        HashSet<String> names = new HashSet<String>();
        for (OlapRegularCube cube : this.getCubes()) {
            List<IOlapBuilderBaseFactsDef> cubeFacts = cube.getCubeFacts();
            for (IOlapBuilderBaseFactsDef facts : cubeFacts) {
                String qName = cube.getNameX() + "." + facts.getMeasureGroupName();
                names.add(qName.toUpperCase());
            }
        }
        return names;
    }

    public OlapMember getOrCreateValidateMemberMarker() {
        return this.validateMarkerMember.computeIfAbsent(1, k -> OlapValidateMarkerMember.create(this));
    }

    public OlapAutoExistGutsContainer getAutoExistContainer() {
        return this.autoExistContainer;
    }

    public IOlapAutoExistBitmapProvider getAutoExistContainer(OlapHierarchy hierarchy) {
        return this.autoExistContainer.getContainer(hierarchy);
    }

    public void onAllDimensionsProcessingCompleted() {
    }

    public void addCache(OlapMeasureGroup measureGroup, String cacheName, OlapScalarEntity value) {
        this.cache.put(cacheName, new OlapCacheValue(this, measureGroup, value));
    }

    @Nullable
    public OlapScalarEntity getCacheValue(String cacheName) {
        OlapCacheValue c = this.cache.get(cacheName);
        return c == null ? null : c.value;
    }

    public class OlapCacheValue {
        private final OlapMeasureGroup measureGroup;
        private final OlapScalarEntity value;

        public OlapCacheValue(OlapSchema this$0, OlapMeasureGroup measureGroup, OlapScalarEntity value) {
            Objects.requireNonNull(this$0);
            this.measureGroup = measureGroup;
            this.value = value;
        }
    }
}

