/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.schema;

import crazydev.iccube.olap.entity.hierarchy.OlapHierarchy;
import crazydev.iccube.olap.entity.tuple.dimensionality.OlapTupleDimensionality;
import crazydev.iccube.olap.entity.tuple.dimensionality.OlapTupleDimensionalityFactory;
import crazydev.iccube.olap.schema.OlapSchema;
import crazydev.iccube.olap.schema.OlapSchemaHierarchyIndex;

public class OlapDynamicSchemaHierarchyIndex
extends OlapSchemaHierarchyIndex {
    private final OlapSchema schema;
    private final OlapHierarchy hierarchy;
    private final int offset;
    private final Object lock = new Object();
    private int latestValue = -1;
    private OlapTupleDimensionality latestDimensionality;

    public OlapDynamicSchemaHierarchyIndex(OlapSchema schema, OlapHierarchy hierarchy, int offset) {
        this.schema = schema;
        this.hierarchy = hierarchy;
        this.offset = offset;
        this.updateLatestValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateLatestValue() {
        Object object = this.lock;
        synchronized (object) {
            int currentValue = this.schema.getNextHierarchyIndex() + this.offset;
            if (currentValue != this.latestValue) {
                this.latestValue = currentValue;
                this.latestDimensionality = OlapTupleDimensionalityFactory.createForHierarchy(this.latestValue);
            }
        }
    }

    @Override
    public void resetForDynamicHierarchy(int index) {
        throw new RuntimeException("internal error : session / request category hierarchy not supported");
    }

    @Override
    public void resetForSchema(OlapSchema otherSchema, int nextHierarchyIndexOffset) {
        throw new RuntimeException("internal error : session / request category hierarchy not supported in schema merge");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getValue() {
        Object object = this.lock;
        synchronized (object) {
            this.updateLatestValue();
            return this.latestValue;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OlapTupleDimensionality getDimensionality() {
        Object object = this.lock;
        synchronized (object) {
            this.updateLatestValue();
            return this.latestDimensionality;
        }
    }
}

