/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.index.bitmap.tor;

import crazydev.common.exception.programming.CdShouldNotBeHereProgrammingException;
import crazydev.iccube.olap.index.bitmap.facts.OlapFactsBitmap;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public abstract class OlapBitmapTor {
    protected List<OlapFactsBitmap> bitmaps = new ArrayList<OlapFactsBitmap>();
    private boolean freeze;

    protected OlapBitmapTor() {
    }

    protected OlapBitmapTor asBasicOperation() {
        return this;
    }

    public boolean isEmpty() {
        return this.bitmaps.isEmpty();
    }

    protected boolean isSimpleBitmap() {
        return this.isEmpty() || this.bitmaps.size() == 1;
    }

    private void addBitmap(OlapFactsBitmap bitmap) {
        if (this.freeze) {
            throw new CdShouldNotBeHereProgrammingException();
        }
        this.bitmaps.add(bitmap);
        if (this.bitmaps.size() > this.getBitmapSizeBeforeSolving()) {
            OlapFactsBitmap res = this.compactExisting();
            this.bitmaps.clear();
            this.bitmaps.add(res);
        }
    }

    protected OlapFactsBitmap compactExisting() {
        return this.solve();
    }

    abstract int getBitmapSizeBeforeSolving();

    private void addAlgebra(OlapBitmapTor algebra) {
        if (this.freeze) {
            throw new CdShouldNotBeHereProgrammingException();
        }
        algebra.freeze();
        this.bitmaps.add(algebra.solve());
    }

    private void freeze() {
        this.freeze = true;
    }

    public void add(@Nullable OlapFactsBitmap bitmap) {
        if (this.freeze) {
            throw new CdShouldNotBeHereProgrammingException();
        }
        if (bitmap == null) {
            return;
        }
        this.addBitmap(bitmap);
    }

    public void add(OlapBitmapTor algebra) {
        if (this.freeze) {
            throw new CdShouldNotBeHereProgrammingException();
        }
        if (algebra.isEmpty()) {
            return;
        }
        OlapBitmapTor representation = algebra.asBasicOperation();
        if (representation.getClass() == this.getClass() || representation.isSimpleBitmap()) {
            if (!representation.bitmaps.isEmpty()) {
                for (OlapFactsBitmap bitmap : representation.bitmaps) {
                    this.addBitmap(bitmap);
                }
            }
        } else {
            this.addAlgebra(algebra);
        }
    }

    public abstract OlapFactsBitmap solve();

    public static interface Builder {
        public OlapBitmapTor asTor();

        public void add(OlapBitmapTor var1);

        public void add(@Nullable OlapFactsBitmap var1);
    }
}

