/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.index.bitmap.tor;

import crazydev.common.exception.programming.CdDoNotCallMeProgrammingException;
import crazydev.common.exception.programming.CdProgrammingException;
import crazydev.iccube.olap.index.bitmap.OlapBitmap;
import crazydev.iccube.olap.index.bitmap.OlapOneBitmap;
import crazydev.iccube.olap.index.bitmap.tor.IBitmapOrTor;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.Nullable;
import org.roaringbitmap.buffer.MutableRoaringBitmap;

public abstract class OlapAbstractOrtor
implements IBitmapOrTor {
    @Nullable
    public ArrayList<OlapBitmap> bitmaps;
    @Nullable
    private MutableRoaringBitmap singlePointCollector;
    @Nullable
    private OlapBitmap asBitmap;
    private boolean needsRebuild = true;
    private boolean noAdds = true;
    private boolean isOne;

    protected OlapAbstractOrtor() {
    }

    protected List<OlapBitmap> getBitmapsForApply() {
        ArrayList<OlapBitmap> allBitmaps = new ArrayList<OlapBitmap>();
        if (this.bitmaps != null) {
            allBitmaps.addAll(this.bitmaps);
        }
        if (this.singlePointCollector != null) {
            OlapBitmap singlePoint = OlapAbstractOrtor.asOlapBitmap(this.singlePointCollector);
            allBitmaps.add(singlePoint);
        }
        return allBitmaps;
    }

    private static OlapBitmap asOlapBitmap(MutableRoaringBitmap pointCollector) {
        MutableRoaringBitmap singlePoint = OlapBitmap.createBitmap();
        if (pointCollector != null) {
            pointCollector.forEach(singlePoint::setBit);
        }
        return singlePoint;
    }

    @Override
    public void addPoint(int position) {
        this.noAdds = false;
        if (this.isOne) {
            return;
        }
        if (this.asBitmap != null) {
            this.asBitmap.setBit(position);
            return;
        }
        if (this.singlePointCollector == null) {
            this.singlePointCollector = new MutableRoaringBitmap();
        }
        this.singlePointCollector.add(position);
        this.needsRebuild = true;
    }

    @Override
    public void addForOr(@Nullable OlapBitmap bitmap) {
        if (bitmap == null || this.isOne) {
            return;
        }
        this.noAdds = false;
        if (bitmap.isNoEmpty()) {
            if (OlapOneBitmap.isOneBitmap(bitmap)) {
                this.isOne = true;
                this.asBitmap = bitmap;
                if (this.bitmaps != null) {
                    this.bitmaps.clear();
                }
                this.needsRebuild = false;
            } else {
                if (this.bitmaps == null) {
                    this.bitmaps = new ArrayList();
                }
                if (this.bitmaps.size() < 64) {
                    if (!this.bitmaps.contains(bitmap)) {
                        this.bitmaps.add(bitmap);
                        this.needsRebuild = true;
                    }
                } else {
                    this.bitmaps.add(bitmap);
                    this.needsRebuild = true;
                }
            }
        }
    }

    @Override
    public boolean noAdds() {
        return this.noAdds;
    }

    @Override
    public OlapBitmap asBitmap() {
        if (this.needsRebuild || this.asBitmap == null) {
            this.buildBitmap();
        }
        if (this.asBitmap == null) {
            throw new CdProgrammingException("internal error : bitmap inconsistency");
        }
        return this.asBitmap;
    }

    private synchronized void buildBitmap() {
        if (this.needsRebuild || this.asBitmap == null) {
            this.asBitmap = this.applyOr();
            this.singlePointCollector = null;
            this.needsRebuild = false;
        }
    }

    private OlapBitmap applyOr() {
        OlapBitmap res;
        if (this.bitmaps == null || this.bitmaps.isEmpty()) {
            OlapBitmap singlePoint = OlapAbstractOrtor.asOlapBitmap(this.singlePointCollector);
            singlePoint.compact();
            res = singlePoint;
        } else {
            res = this.bitmaps.size() == 1 && this.singlePointCollector == null ? this.bitmaps.getFirst() : this.doApply();
        }
        return res;
    }

    protected abstract OlapBitmap doApply();

    @Override
    public long _getBitmapCountForTest() {
        if (this.asBitmap != null) {
            throw new CdDoNotCallMeProgrammingException();
        }
        int bitmapsCount = this.bitmaps == null ? 0 : this.bitmaps.size();
        long count = bitmapsCount + (this.singlePointCollector != null ? this.singlePointCollector.getCardinality() : 0);
        return count;
    }

    @Override
    public boolean isEmpty() {
        return !(!this.noAdds && (this.asBitmap != null && !this.asBitmap.isEmpty() || this.bitmaps != null && !this.bitmaps.isEmpty() || this.singlePointCollector != null && !this.singlePointCollector.isEmpty()));
    }
}

