/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.index.bitmap.tor;

import crazydev.iccube.olap.index.bitmap.OlapBitmap;
import crazydev.iccube.olap.index.bitmap.OlapBitmapCallback;
import crazydev.iccube.olap.index.bitmap.OlapBitmapNotStoppableCallback;
import crazydev.iccube.olap.index.bitmap.OlapEmptyBitmap;
import crazydev.iccube.olap.index.bitmap.OlapOneBitmap;
import crazydev.iccube.olap.index.bitmap.tor.IBitmapAndTor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.mutable.MutableInt;
import org.jetbrains.annotations.Nullable;

public abstract class OlapAbstractAndtor
implements IBitmapAndTor {
    protected final int rowId;
    protected final List<OlapBitmap> bitmaps;
    protected int cardinality = -1;
    private OlapBitmap asBitmap = null;
    private volatile boolean isZeroBitmap;
    private boolean noAdds = true;
    private boolean addOneIdentity = false;

    protected OlapAbstractAndtor() {
        this(-1);
    }

    protected OlapAbstractAndtor(int rowId) {
        this.rowId = rowId;
        this.bitmaps = new ArrayList<OlapBitmap>();
    }

    public OlapAbstractAndtor(OlapBitmap[] bitmaps) {
        this.rowId = -1;
        this.bitmaps = new ArrayList<OlapBitmap>(bitmaps.length);
        Collections.addAll(this.bitmaps, bitmaps);
    }

    protected OlapAbstractAndtor(OlapAbstractAndtor other) {
        this.rowId = other.rowId;
        this.bitmaps = new ArrayList<OlapBitmap>();
        this.bitmaps.addAll(other.bitmaps);
        this.cardinality = other.cardinality;
        this.asBitmap = other.asBitmap;
        this.noAdds = other.noAdds;
        this.addOneIdentity = other.addOneIdentity;
        this.isZeroBitmap = other.isZeroBitmap;
    }

    @Override
    public void clear() {
        this.bitmaps.clear();
        this.cardinality = -1;
        this.asBitmap = null;
        this.noAdds = true;
        this.addOneIdentity = false;
        this.isZeroBitmap = false;
    }

    @Override
    public void add(@Nullable OlapBitmap bitmap) {
        this.addForAnd(bitmap);
    }

    @Override
    public void addForAnd(@Nullable OlapBitmap bitmap) {
        if (this.isZeroBitmap || bitmap == null) {
            return;
        }
        this.noAdds = false;
        if (bitmap.isNoEmpty()) {
            this.addOneIdentity |= OlapOneBitmap.isOneBitmap(bitmap);
            if (!OlapOneBitmap.isOneBitmap(bitmap)) {
                this.bitmaps.add(bitmap);
                this.cardinality = -1;
            }
        } else {
            this.addOneIdentity = false;
            this.isZeroBitmap = true;
            this.cardinality = 0;
            this.bitmaps.clear();
        }
    }

    @Override
    public boolean noAdds() {
        return this.noAdds;
    }

    @Override
    public final boolean apply(OlapBitmapCallback callback) {
        if (this.doApply(callback, true)) {
            return callback.onApplied();
        }
        return false;
    }

    @Override
    public boolean isZero() {
        return this.isZeroBitmap || this.noAdds;
    }

    @Override
    public boolean isEmpty() {
        return !this.isNoEmpty();
    }

    @Override
    public boolean isNoEmpty() {
        if (this.isZeroBitmap) {
            return false;
        }
        if (this.bitmaps.isEmpty()) {
            return this.addOneIdentity;
        }
        if (this.bitmaps.size() == 1) {
            return this.bitmaps.getFirst().isNoEmpty();
        }
        if (this.cardinality != -1) {
            return this.cardinality > 0;
        }
        return !this.doApply(NoEmptyCallBack.INSTANCE, false);
    }

    @Override
    public long cardinality() {
        if (this.cardinality != -1) {
            return this.cardinality;
        }
        return this.calculateCardinality();
    }

    private boolean doApply(OlapBitmapCallback callback, boolean sort) {
        boolean res;
        if (this.bitmaps.isEmpty()) {
            if (this.addOneIdentity) {
                if (this.rowId == -1) {
                    throw new RuntimeException("internal error: missing row-id");
                }
                OlapBitmap bitmap = OlapBitmap.createBitmapAllOnes(this.rowId);
                res = bitmap.apply(callback);
            } else {
                res = true;
            }
        } else if (this.bitmaps.size() == 1) {
            OlapBitmap bitmap = this.bitmaps.getFirst();
            res = bitmap.apply(callback);
        } else {
            res = this.applyOnBitmaps(callback);
        }
        return res;
    }

    private synchronized int calculateCardinality() {
        if (this.cardinality == -1) {
            final MutableInt mutableInt = new MutableInt();
            this.apply(new OlapBitmapNotStoppableCallback(){
                {
                    Objects.requireNonNull(this$0);
                }

                @Override
                public boolean onRange(int startRowId, int endRowId) {
                    mutableInt.add(endRowId - startRowId);
                    return true;
                }
            });
            this.cardinality = mutableInt.intValue();
        }
        return this.cardinality;
    }

    protected abstract boolean applyOnBitmaps(OlapBitmapCallback var1);

    @Override
    public OlapBitmap asBitmap() {
        if (this.asBitmap == null) {
            return this.getAsBitmap();
        }
        return this.asBitmap;
    }

    private synchronized OlapBitmap getAsBitmap() {
        if (this.asBitmap == null) {
            int bitmapsSize = this.bitmaps.size();
            this.asBitmap = bitmapsSize == 0 ? (this.addOneIdentity ? OlapOneBitmap.INSTANCE : OlapEmptyBitmap.EMPTY) : (bitmapsSize == 1 ? this.bitmaps.get(0) : this.calculateSingleBitmap());
        }
        return this.asBitmap;
    }

    protected abstract OlapBitmap calculateSingleBitmap();

    @Override
    public boolean noBitmaps() {
        return this.bitmaps.isEmpty();
    }

    public static final class NoEmptyCallBack
    implements OlapBitmapCallback {
        public static NoEmptyCallBack INSTANCE = new NoEmptyCallBack();

        private NoEmptyCallBack() {
        }

        @Override
        public boolean onPoint(int point) {
            return false;
        }

        @Override
        public boolean onRange(int startRowId, int endRowId) {
            return false;
        }
    }
}

