/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.index.bitmap.facts.roaring;

import crazydev.iccube.olap.index.bitmap.OlapBitmapCallback;
import crazydev.iccube.olap.index.bitmap.facts.IFactsBitmapAndTor;
import crazydev.iccube.olap.index.bitmap.facts.OlapFactsBitmap;
import crazydev.iccube.olap.index.bitmap.facts.OlapFactsBitmapFactory;
import crazydev.iccube.olap.index.bitmap.facts.roaring.OlapFactsBitmapRoaringBuffer;
import crazydev.iccube.olap.index.bitmap.facts.roaring.OlapFactsBitmapRoaringBufferEmpty;
import crazydev.iccube.olap.index.bitmap.facts.roaring.OlapFactsBitmapRoaringBufferOne;
import crazydev.iccube.olap.index.bitmap.tor.OlapAbstractAndtor;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.Nullable;
import org.roaringbitmap.buffer.BitmapFastAggregation;
import org.roaringbitmap.buffer.ImmutableRoaringBitmap;
import org.roaringbitmap.buffer.MutableRoaringBitmap;
import org.roaringbitmap.buffer.RoaringBufferFastAggregation;

public class OlapFactsBitmapRoaringBufferAndTor
implements IFactsBitmapAndTor {
    private final int rowId;
    private final List<ImmutableRoaringBitmap> bitmaps;
    protected int cardinality = -1;
    private OlapFactsBitmap asBitmap;
    private volatile boolean isZeroBitmap;
    private boolean noAdds = true;
    private boolean addOneIdentity = false;

    public OlapFactsBitmapRoaringBufferAndTor(int rowId) {
        this.rowId = rowId;
        this.bitmaps = new ArrayList<ImmutableRoaringBitmap>();
    }

    public OlapFactsBitmapRoaringBufferAndTor() {
        this(-1);
    }

    @Override
    public boolean noAdds() {
        return this.noAdds;
    }

    @Override
    public boolean isNoEmpty() {
        if (this.isZeroBitmap) {
            return false;
        }
        if (this.bitmaps.isEmpty()) {
            return this.addOneIdentity;
        }
        if (this.bitmaps.size() == 1) {
            return !this.bitmaps.getFirst().isEmpty();
        }
        if (this.cardinality != -1) {
            return this.cardinality > 0;
        }
        return !this.apply(OlapAbstractAndtor.NoEmptyCallBack.INSTANCE);
    }

    @Override
    public long cardinality() {
        if (this.cardinality != -1) {
            return this.cardinality;
        }
        return this.doCalculateCardinality();
    }

    @Override
    public void clear() {
        this.bitmaps.clear();
        this.cardinality = -1;
        this.asBitmap = null;
        this.noAdds = true;
        this.addOneIdentity = false;
        this.isZeroBitmap = false;
    }

    @Override
    public void add(@Nullable OlapFactsBitmap bitmap) {
        if (this.isZeroBitmap || bitmap == null) {
            return;
        }
        this.noAdds = false;
        if (bitmap.isNoEmpty()) {
            boolean isOneBitmap = bitmap.isOne();
            this.addOneIdentity |= isOneBitmap;
            if (!isOneBitmap) {
                this.bitmaps.add(((OlapFactsBitmapRoaringBuffer)bitmap).asRoaring());
                this.cardinality = -1;
            }
        } else {
            this.addOneIdentity = false;
            this.isZeroBitmap = true;
            this.cardinality = 0;
            this.bitmaps.clear();
        }
    }

    @Override
    public boolean apply(OlapBitmapCallback callback) {
        boolean res;
        if (this.bitmaps.isEmpty()) {
            if (this.addOneIdentity) {
                if (this.rowId == -1) {
                    throw new RuntimeException("internal error: missing row-id");
                }
                OlapFactsBitmap bitmap = OlapFactsBitmapFactory.facts_createBitmapAllOnes(this.rowId);
                res = bitmap.apply(callback);
            } else {
                res = true;
            }
        } else if (this.bitmaps.size() == 1) {
            ImmutableRoaringBitmap bitmap = this.bitmaps.getFirst();
            OlapFactsBitmapRoaringBuffer.apply(bitmap, callback);
            res = true;
        } else {
            res = this.doApplyBitmaps(callback);
        }
        return res;
    }

    @Override
    public OlapFactsBitmap facts_asBitmap() {
        if (this.asBitmap != null) {
            return this.asBitmap;
        }
        return this.doAsBitmap();
    }

    private synchronized long doCalculateCardinality() {
        int count = this.bitmaps.size();
        if (count == 0) {
            if (this.addOneIdentity) {
                if (this.rowId == -1) {
                    throw new RuntimeException("internal error: missing row-id");
                }
                this.cardinality = this.rowId;
            } else {
                this.cardinality = 0;
            }
        } else {
            this.cardinality = count == 1 ? this.bitmaps.getFirst().getCardinality() : BitmapFastAggregation.andCardinality((ImmutableRoaringBitmap[])this.bitmaps.toArray(ImmutableRoaringBitmap[]::new));
        }
        return this.cardinality;
    }

    private boolean doApplyBitmaps(OlapBitmapCallback callback) {
        return RoaringBufferFastAggregation.and(this.bitmaps.toArray(new ImmutableRoaringBitmap[0]), callback);
    }

    private synchronized OlapFactsBitmap doAsBitmap() {
        if (this.noAdds) {
            throw new RuntimeException();
        }
        if (this.asBitmap == null) {
            int bitmapsSize = this.bitmaps.size();
            if (bitmapsSize == 0) {
                this.asBitmap = this.addOneIdentity ? OlapFactsBitmapRoaringBufferOne.INSTANCE : OlapFactsBitmapRoaringBufferEmpty.INSTANCE;
            } else if (bitmapsSize == 1) {
                this.asBitmap = new OlapFactsBitmapRoaringBuffer(this.bitmaps.getFirst());
            } else {
                MutableRoaringBitmap bitmap = BitmapFastAggregation.and((ImmutableRoaringBitmap[])this.bitmaps.toArray(ImmutableRoaringBitmap[]::new));
                this.asBitmap = new OlapFactsBitmapRoaringBuffer(bitmap.toImmutableRoaringBitmap());
            }
        }
        return this.asBitmap;
    }
}

