/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.index.bitmap.facts.roaring;

import crazydev.iccube.olap.index.bitmap.OlapBitmapCallback;
import crazydev.iccube.olap.index.bitmap.facts.OlapFactsBitmap;
import org.roaringbitmap.PeekableIntIterator;
import org.roaringbitmap.buffer.ImmutableRoaringBitmap;
import org.roaringbitmap.buffer.MutableRoaringBitmap;

public class OlapFactsBitmapRoaringBuffer
implements OlapFactsBitmap {
    protected final ImmutableRoaringBitmap underlying;

    public OlapFactsBitmapRoaringBuffer(ImmutableRoaringBitmap underlying) {
        this.underlying = underlying;
    }

    public static OlapFactsBitmap createAllOnes(int count) {
        MutableRoaringBitmap ones = MutableRoaringBitmap.bitmapOfRange(0L, count);
        return new OlapFactsBitmapRoaringBuffer(ones.toImmutableRoaringBitmap());
    }

    public static boolean apply(ImmutableRoaringBitmap bitmap, OlapBitmapCallback callback) {
        boolean applied = true;
        PeekableIntIterator bits = bitmap.getIntIterator();
        while (bits.hasNext()) {
            int bit = bits.next();
            if (callback.onPoint(bit)) continue;
            applied = false;
            break;
        }
        if (applied) {
            callback.onApplied();
        }
        return applied;
    }

    public ImmutableRoaringBitmap asRoaring() {
        return this.underlying;
    }

    public int serializedSizeInBytesForStats() {
        return this.underlying.serializedSizeInBytesForStats();
    }

    @Override
    public boolean isOne() {
        return false;
    }

    @Override
    public boolean isZero() {
        return false;
    }

    @Override
    public boolean isEmpty() {
        return this.underlying.isEmpty();
    }

    @Override
    public boolean isNoEmpty() {
        return !this.underlying.isEmpty();
    }

    @Override
    public long cardinality() {
        return this.underlying.getLongCardinality();
    }

    @Override
    public boolean getBit(int index) {
        return this.underlying.contains(index);
    }

    @Override
    public boolean apply(OlapBitmapCallback callback) {
        return OlapFactsBitmapRoaringBuffer.apply(this.underlying, callback);
    }

    @Override
    public OlapFactsBitmap facts_not(int lastBit) {
        MutableRoaringBitmap not = ImmutableRoaringBitmap.flip(this.underlying, 0L, lastBit + 1);
        return new OlapFactsBitmapRoaringBuffer(not);
    }

    public String toString() {
        return this.underlying.toString();
    }
}

