/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.index.bitmap.facts.concise;

import crazydev.iccube.olap.index.bitmap.OlapBitmapCallback;
import crazydev.iccube.olap.index.bitmap.facts.concise.ConciseMaths;
import crazydev.iccube.olap.index.bitmap.facts.concise.OlapConciseBitmapArrayGuts;
import org.jetbrains.annotations.Nullable;

public class OlapConciseBitmap {
    public static final int POSITION_EACH = 32;
    public static final int POSITION_EACH_MASK = 31;
    public static final int START_WORD = 3;
    protected OlapConciseBitmapArrayGuts words;

    public OlapConciseBitmap(@Nullable OlapConciseBitmapArrayGuts word) {
        this.words = word;
    }

    static boolean isPositionWord(int i) {
        return i != 0 && (i & 0x1F) == 0;
    }

    int getWord(int i) {
        return this.words.getWord(3 + i);
    }

    int getLastWordArrayPos() {
        return this.words.getLastWordArrayPos();
    }

    public final boolean apply(OlapBitmapCallback callback) {
        return this.doApply(callback) && callback.onApplied();
    }

    private boolean doApply(OlapBitmapCallback callback) {
        if (this.words == null) {
            return true;
        }
        int lastWordArrayPos = this.getLastWordArrayPos();
        int currentPos = 0;
        boolean cont = true;
        for (int i = 0; i <= lastWordArrayPos && cont; ++i) {
            if (OlapConciseBitmap.isPositionWord(i)) continue;
            int word = this.getWord(i);
            if (ConciseMaths.isLiteral(word)) {
                cont = callback.onBlock(currentPos, word);
                currentPos += 31;
                continue;
            }
            if (ConciseMaths.isOneSequence(word)) {
                int sequenceLength = 31;
                int asLiteral = ConciseMaths.getLiteral(word);
                if (asLiteral != -1) {
                    if (!callback.onBlock(currentPos, asLiteral)) {
                        return false;
                    }
                    sequenceLength = 0;
                    currentPos += 31;
                }
                cont = callback.onRange(currentPos, currentPos + (sequenceLength += ConciseMaths.literalLengthMultiplication(ConciseMaths.getSequenceBlockCount(word))));
                currentPos += sequenceLength;
                continue;
            }
            int bitPos = ConciseMaths.getSequenceBitPos(word);
            if (bitPos >= 0) {
                cont = callback.onPoint(currentPos + bitPos);
            }
            int sequenceLength = 31 + ConciseMaths.literalLengthMultiplication(ConciseMaths.getSequenceBlockCount(word));
            currentPos += sequenceLength;
        }
        return cont;
    }
}

