/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.index.bitmap;

@FunctionalInterface
public interface OlapBitmapCallback {
    default public boolean onBlock(int blockStartRowId, int block) {
        int start = -1;
        for (int ii = 0; ii < 31; ++ii) {
            boolean isSet;
            boolean bl = isSet = (1 << ii & block) != 0;
            if (isSet) {
                start = start == -1 ? ii : start;
                continue;
            }
            if (start == -1) continue;
            if (!this.onRange(blockStartRowId + start, blockStartRowId + ii)) {
                return false;
            }
            start = -1;
        }
        return start == -1 || this.onRange(blockStartRowId + start, blockStartRowId + 31);
    }

    public boolean onRange(int var1, int var2);

    default public boolean onPoint(int point) {
        return this.onRange(point, point + 1);
    }

    default public boolean onApplied() {
        return true;
    }

    default public boolean neverStops() {
        return false;
    }

    default public boolean onBitmap(OlapBitmapCallback cb, int offset, long bitmap) {
        while (bitmap != 0L) {
            if (!cb.onPoint(offset + Long.numberOfTrailingZeros(bitmap))) {
                return true;
            }
            bitmap &= bitmap - 1L;
        }
        return false;
    }
}

