/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.goodies.unresolverows;

import crazydev.iccube.builder.OlapBuilderContext;
import crazydev.iccube.builder.OlapBuilderLoadEntityContext;
import crazydev.iccube.builder.datasource.buffer.OlapBuilderBufferDataTable;
import crazydev.iccube.builder.datasource.reader.IOlapBuilderTablePartitionKey;
import crazydev.iccube.builder.errors.OlapBuilderErrorCode;
import crazydev.iccube.builder.errors.OlapBuilderErrorException;
import crazydev.iccube.builder.model.def.IOlapBuilderBaseFactsDef;
import crazydev.iccube.builder.model.def.IOlapBuilderDataTableDef;
import crazydev.iccube.builder.model.def.IOlapBuilderTableRow;
import crazydev.iccube.builder.model.def.IOlapBuilderTabularDataDef;
import crazydev.iccube.cluster.master.backup.save.M_DefaultBackupManager;
import crazydev.iccube.cluster.master.local.facts.M_FactsLocalMeasureGroupManager;
import crazydev.iccube.cluster.shared.backup.S_BackupInputStream;
import crazydev.iccube.cluster.shared.backup.S_BackupOutputStream;
import crazydev.iccube.enums.OlapUnresolvedRowsBehavior;
import crazydev.iccube.olap.cube.OlapCube;
import crazydev.iccube.olap.cube.OlapRegularCube;
import crazydev.iccube.olap.facts.OlapFactMeasureGroupBaseManager;
import crazydev.iccube.olap.goodies.incrload.IncrLoadUnresolvedRows;
import crazydev.iccube.olap.goodies.incrload.IncrLoadUnresolvedRowsM2Ms;
import crazydev.iccube.olap.goodies.unresolverows.OlapIgnoredUnresolvedRows;
import crazydev.iccube.olap.goodies.unresolverows.OlapInMemoryUnresolvedRows;
import crazydev.iccube.olap.goodies.unresolverows.OlapUnresolvedRows;
import crazydev.iccube.olap.goodies.unresolverows.OlapUnresolvedRowsKey;
import crazydev.iccube.olap.loggers.OlapLoggers;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.io.IOUtils;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.Nullable;

public class OlapUnresolvedRowsManager {
    private final String schemaName;
    private final int maxRowCount;
    private final Object globalLOCK = new ArrayList();
    private final AtomicBoolean cubesHasNewMembers = new AtomicBoolean(false);
    private final AtomicBoolean m2msHasNewMembers = new AtomicBoolean(false);
    private final Map<OlapUnresolvedRowsKey, OlapInMemoryUnresolvedRows> cubesKeptRowsByFacts = new HashMap<OlapUnresolvedRowsKey, OlapInMemoryUnresolvedRows>();
    private final Map<OlapUnresolvedRowsKey, OlapIgnoredUnresolvedRows> cubesIgnoredRowsByFacts = new HashMap<OlapUnresolvedRowsKey, OlapIgnoredUnresolvedRows>();
    private final Map<String, OlapInMemoryUnresolvedRows> m2msKeptRowsByFacts = new HashMap<String, OlapInMemoryUnresolvedRows>();
    private final Map<String, OlapIgnoredUnresolvedRows> m2msIgnoredRowsByFacts = new HashMap<String, OlapIgnoredUnresolvedRows>();

    public OlapUnresolvedRowsManager(String schemaName, int maxRowCount) {
        this.schemaName = schemaName;
        this.maxRowCount = maxRowCount;
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    public int getMaxRowCount() {
        return this.maxRowCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getTotalUnresolvedRowsCount(String cube) {
        Object object = this.globalLOCK;
        synchronized (object) {
            OlapUnresolvedRows rows;
            OlapUnresolvedRowsKey key;
            int count = 0;
            for (Map.Entry<OlapUnresolvedRowsKey, OlapInMemoryUnresolvedRows> entry : this.cubesKeptRowsByFacts.entrySet()) {
                key = entry.getKey();
                if (!key.getCube().equals(cube)) continue;
                rows = entry.getValue();
                count += ((OlapInMemoryUnresolvedRows)rows).getRowCount();
            }
            for (Map.Entry<OlapUnresolvedRowsKey, OlapUnresolvedRows> entry : this.cubesIgnoredRowsByFacts.entrySet()) {
                key = entry.getKey();
                if (!key.getCube().equals(cube)) continue;
                rows = (OlapIgnoredUnresolvedRows)entry.getValue();
                count += ((OlapIgnoredUnresolvedRows)rows).getRowCount();
            }
            return count;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getTotalActualUnresolvedRowsCount(String cube) {
        Object object = this.globalLOCK;
        synchronized (object) {
            int count = 0;
            for (Map.Entry<OlapUnresolvedRowsKey, OlapInMemoryUnresolvedRows> entry : this.cubesKeptRowsByFacts.entrySet()) {
                OlapUnresolvedRowsKey key = entry.getKey();
                if (!key.getCube().equals(cube)) continue;
                OlapInMemoryUnresolvedRows rows = entry.getValue();
                count += rows.getActualRowsCount();
            }
            return count;
        }
    }

    public void reportUnresolvedRow(OlapBuilderContext context, @Nullable OlapCube cube, IOlapBuilderBaseFactsDef facts, IOlapBuilderTabularDataDef tabularData, @Nullable IOlapBuilderTablePartitionKey partition, IOlapBuilderTableRow row) {
        String tableId;
        String factsId = facts.getDataView().getId();
        if (!factsId.equals(tableId = tabularData.getId())) {
            throw new RuntimeException("internal error : inconsistent facts table [" + factsId + "][" + tableId + "]");
        }
        OlapUnresolvedRowsBehavior behavior = facts.getUnresolvedRowsBehavior();
        if (cube != null) {
            if (behavior.isProcessUnresolvedRows()) {
                this.reportCubesUnresolvedRowForKeeping(context, cube, facts, tabularData, partition, row);
            } else {
                this.reportCubesUnresolvedRowForIgnoring(cube, facts, partition);
            }
        } else if (behavior.isProcessUnresolvedRows()) {
            this.reportM2MsUnresolvedRowForKeeping(context, facts, tabularData, partition, row);
        } else {
            this.reportM2MsUnresolvedRowForIgnoring(facts, partition);
        }
    }

    private void reportCubesUnresolvedRowForKeeping(OlapBuilderContext context, OlapCube cube, IOlapBuilderBaseFactsDef facts, IOlapBuilderTabularDataDef tabularData, @Nullable IOlapBuilderTablePartitionKey partition, IOlapBuilderTableRow row) {
        Object object = this.globalLOCK;
        synchronized (object) {
            OlapUnresolvedRowsKey key = new OlapUnresolvedRowsKey(cube.getNameX(), facts.getName());
            OlapInMemoryUnresolvedRows keptRows = this.getOrCreateCubesKeptRows(key, tabularData);
            if (keptRows.getActualRowsCount() < this.maxRowCount) {
                keptRows.reportUnresolvedRow(partition, row);
                return;
            }
            Logger logger = context.getLoggers().builderFacts();
            logger.error((Object)("Max. unresolved rows count reached for facts [" + facts.getName() + "] : " + this.maxRowCount));
            this.cubesKeptRowsByFacts.remove(key);
            this.cubesIgnoredRowsByFacts.put(key, keptRows.asIgnoredUnresolvedRows());
            throw new OlapBuilderErrorException(OlapBuilderErrorCode.UNRESOLVED_ROWS_MAX, new Serializable[]{facts.getName(), Integer.valueOf(this.maxRowCount)});
        }
    }

    private OlapInMemoryUnresolvedRows getOrCreateCubesKeptRows(OlapUnresolvedRowsKey key, IOlapBuilderTabularDataDef tabularData) {
        OlapInMemoryUnresolvedRows keptRows = this.cubesKeptRowsByFacts.computeIfAbsent(key, k -> new OlapInMemoryUnresolvedRows(tabularData));
        return keptRows;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void reportCubesUnresolvedRowForIgnoring(OlapCube cube, IOlapBuilderBaseFactsDef facts, @Nullable IOlapBuilderTablePartitionKey partition) {
        Object object = this.globalLOCK;
        synchronized (object) {
            OlapUnresolvedRowsKey key = new OlapUnresolvedRowsKey(cube.getNameX(), facts.getName());
            OlapIgnoredUnresolvedRows ignoredRows = this.getOrCreateCubesIgnoredRows(key);
            ignoredRows.reportUnresolvedRow(partition, null);
        }
    }

    private OlapIgnoredUnresolvedRows getOrCreateCubesIgnoredRows(OlapUnresolvedRowsKey key) {
        OlapIgnoredUnresolvedRows ignoredRows = this.cubesIgnoredRowsByFacts.computeIfAbsent(key, k -> new OlapIgnoredUnresolvedRows());
        return ignoredRows;
    }

    private void reportM2MsUnresolvedRowForKeeping(OlapBuilderContext context, IOlapBuilderBaseFactsDef facts, IOlapBuilderTabularDataDef tabularData, @Nullable IOlapBuilderTablePartitionKey partition, IOlapBuilderTableRow row) {
        Object object = this.globalLOCK;
        synchronized (object) {
            String key = facts.getName();
            OlapInMemoryUnresolvedRows keptRows = this.getOrCreateM2MsKeptRows(key, tabularData);
            if (keptRows.getActualRowsCount() < this.maxRowCount) {
                keptRows.reportUnresolvedRow(partition, row);
                return;
            }
            Logger logger = context.getLoggers().builderFacts();
            logger.error((Object)("Max. unresolved rows count reached for m2m [" + facts.getName() + "] : " + this.maxRowCount));
            this.m2msKeptRowsByFacts.remove(key);
            this.m2msIgnoredRowsByFacts.put(key, keptRows.asIgnoredUnresolvedRows());
            throw new OlapBuilderErrorException(OlapBuilderErrorCode.UNRESOLVED_ROWS_MAX, new Serializable[]{facts.getName(), Integer.valueOf(this.maxRowCount)});
        }
    }

    private OlapInMemoryUnresolvedRows getOrCreateM2MsKeptRows(String key, IOlapBuilderTabularDataDef tabularData) {
        OlapInMemoryUnresolvedRows keptRows = this.m2msKeptRowsByFacts.computeIfAbsent(key, k -> new OlapInMemoryUnresolvedRows(tabularData));
        return keptRows;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reportM2MsUnresolvedRowForIgnoring(IOlapBuilderBaseFactsDef facts, @Nullable IOlapBuilderTablePartitionKey partition) {
        Object object = this.globalLOCK;
        synchronized (object) {
            String key = facts.getName();
            OlapIgnoredUnresolvedRows ignoredRows = this.getOrCreateM2MsIgnoredRows(key);
            ignoredRows.reportUnresolvedRow(partition, null);
        }
    }

    private OlapIgnoredUnresolvedRows getOrCreateM2MsIgnoredRows(String key) {
        OlapIgnoredUnresolvedRows ignoredRows = this.m2msIgnoredRowsByFacts.computeIfAbsent(key, k -> new OlapIgnoredUnresolvedRows());
        return ignoredRows;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onIncrLoadNewMembers() {
        Object object = this.globalLOCK;
        synchronized (object) {
            this.cubesHasNewMembers.set(true);
            this.m2msHasNewMembers.set(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean requiresCubesRowsProcessing(OlapBuilderContext context) {
        Logger logger = context.getLoggers().builder();
        Object object = this.globalLOCK;
        synchronized (object) {
            if (this.cubesKeptRowsByFacts.isEmpty()) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)"[u-rows] processing not required (empty)");
                }
                return false;
            }
            if (!this.cubesHasNewMembers.get()) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)"[u-rows] processing not required (no new members)");
                }
                return false;
            }
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean requiresM2MsRowsProcessing() {
        Object object = this.globalLOCK;
        synchronized (object) {
            if (this.m2msKeptRowsByFacts.isEmpty()) {
                if (OlapLoggers.BUILDER.isDebugEnabled()) {
                    OlapLoggers.BUILDER.debug((Object)"[u-rows] processing not required (empty)");
                }
                return false;
            }
            if (!this.m2msHasNewMembers.get()) {
                if (OlapLoggers.BUILDER.isDebugEnabled()) {
                    OlapLoggers.BUILDER.debug((Object)"[u-rows] processing not required (no new members)");
                }
                return false;
            }
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<OlapUnresolvedRowsKey, IncrLoadUnresolvedRows> getCubesUnresolvedRowsForProcessing() {
        HashMap<OlapUnresolvedRowsKey, IncrLoadUnresolvedRows> uRowsByCubeFacts = new HashMap<OlapUnresolvedRowsKey, IncrLoadUnresolvedRows>();
        Object object = this.globalLOCK;
        synchronized (object) {
            for (Map.Entry<OlapUnresolvedRowsKey, OlapInMemoryUnresolvedRows> entry : this.cubesKeptRowsByFacts.entrySet()) {
                OlapUnresolvedRowsKey key = entry.getKey();
                OlapInMemoryUnresolvedRows uRows = entry.getValue();
                OlapBuilderBufferDataTable uRowsAsTable = uRows.asTableForIncrLoadProcessing();
                Map<IOlapBuilderTablePartitionKey, OlapBuilderBufferDataTable> uRowsAsTables = uRows.asPartitionTablesForIncrLoadProcessing();
                uRowsByCubeFacts.put(key, new IncrLoadUnresolvedRows(key, uRowsAsTable, uRowsAsTables));
            }
            this.cubesKeptRowsByFacts.clear();
            this.cubesHasNewMembers.set(false);
            return uRowsByCubeFacts;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, IncrLoadUnresolvedRowsM2Ms> getM2MsUnresolvedRowsForProcessing() {
        HashMap<String, IncrLoadUnresolvedRowsM2Ms> uRowsByCubeFacts = new HashMap<String, IncrLoadUnresolvedRowsM2Ms>();
        Object object = this.globalLOCK;
        synchronized (object) {
            for (Map.Entry<String, OlapInMemoryUnresolvedRows> entry : this.m2msKeptRowsByFacts.entrySet()) {
                String key = entry.getKey();
                OlapInMemoryUnresolvedRows uRows = entry.getValue();
                OlapBuilderBufferDataTable uRowsAsTable = uRows.asTableForIncrLoadProcessing();
                Map<IOlapBuilderTablePartitionKey, OlapBuilderBufferDataTable> uRowsAsTables = uRows.asPartitionTablesForIncrLoadProcessing();
                uRowsByCubeFacts.put(key, new IncrLoadUnresolvedRowsM2Ms(key, uRowsAsTable, uRowsAsTables));
            }
            this.m2msKeptRowsByFacts.clear();
            this.m2msHasNewMembers.set(false);
            return uRowsByCubeFacts;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getCubesUnresolvedRowsCountForStatistics(OlapCube cube, IOlapBuilderBaseFactsDef factsDefinition) {
        OlapUnresolvedRowsKey key = new OlapUnresolvedRowsKey(cube.getNameX(), factsDefinition.getName());
        Object object = this.globalLOCK;
        synchronized (object) {
            OlapUnresolvedRows rows = this.cubesKeptRowsByFacts.get(key);
            if (rows != null) {
                return ((OlapInMemoryUnresolvedRows)rows).getRowCount();
            }
            rows = this.cubesIgnoredRowsByFacts.get(key);
            if (rows != null) {
                return ((OlapIgnoredUnresolvedRows)rows).getRowCount();
            }
            return 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getCubesUnresolvedRowsRamSizeForStatistics(OlapCube cube, IOlapBuilderBaseFactsDef factsDefinition) {
        OlapUnresolvedRowsKey key = new OlapUnresolvedRowsKey(cube.getNameX(), factsDefinition.getName());
        Object object = this.globalLOCK;
        synchronized (object) {
            OlapUnresolvedRows rows = this.cubesKeptRowsByFacts.get(key);
            if (rows != null) {
                return ((OlapInMemoryUnresolvedRows)rows).sizeOf();
            }
            rows = this.cubesIgnoredRowsByFacts.get(key);
            if (rows != null) {
                return ((OlapIgnoredUnresolvedRows)rows).sizeOf();
            }
            return 0L;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getM2MsUnresolvedRowsCountForStatistics(IOlapBuilderBaseFactsDef factsDefinition) {
        String key = factsDefinition.getName();
        Object object = this.globalLOCK;
        synchronized (object) {
            OlapUnresolvedRows rows = this.m2msKeptRowsByFacts.get(key);
            if (rows != null) {
                return ((OlapInMemoryUnresolvedRows)rows).getRowCount();
            }
            rows = this.m2msIgnoredRowsByFacts.get(key);
            if (rows != null) {
                return ((OlapIgnoredUnresolvedRows)rows).getRowCount();
            }
            return 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getM2MsUnresolvedRowsRamSizeForStatistics(IOlapBuilderBaseFactsDef factsDefinition) {
        String key = factsDefinition.getName();
        Object object = this.globalLOCK;
        synchronized (object) {
            OlapUnresolvedRows rows = this.m2msKeptRowsByFacts.get(key);
            if (rows != null) {
                return ((OlapInMemoryUnresolvedRows)rows).sizeOf();
            }
            rows = this.m2msIgnoredRowsByFacts.get(key);
            if (rows != null) {
                return ((OlapIgnoredUnresolvedRows)rows).sizeOf();
            }
            return 0L;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveCubes(M_DefaultBackupManager backupManager, File dir) throws IOException {
        OlapLoggers.BACKUP.info((Object)("[backup] saving unresolved rows [" + this.cubesIgnoredRowsByFacts.size() + "/" + this.cubesKeptRowsByFacts.size() + "] for schema [" + this.schemaName + "]"));
        S_BackupOutputStream out = null;
        DataOutputStream dOut = null;
        try {
            OlapUnresolvedRows rows;
            String facts;
            String cube;
            OlapUnresolvedRowsKey key;
            out = new S_BackupOutputStream(backupManager.getConfiguration(), new File(dir, "rows.icc-data"));
            dOut = new DataOutputStream(out);
            dOut.writeInt(this.cubesIgnoredRowsByFacts.size());
            for (Map.Entry<OlapUnresolvedRowsKey, OlapIgnoredUnresolvedRows> entry : this.cubesIgnoredRowsByFacts.entrySet()) {
                key = entry.getKey();
                cube = key.getCube();
                facts = key.getFacts();
                dOut.writeUTF(cube);
                dOut.writeUTF(facts);
                rows = entry.getValue();
                ((OlapIgnoredUnresolvedRows)rows).save(dOut);
            }
            dOut.writeInt(this.cubesKeptRowsByFacts.size());
            for (Map.Entry<OlapUnresolvedRowsKey, OlapUnresolvedRows> entry : this.cubesKeptRowsByFacts.entrySet()) {
                key = entry.getKey();
                cube = key.getCube();
                facts = key.getFacts();
                dOut.writeUTF(cube);
                dOut.writeUTF(facts);
                rows = (OlapInMemoryUnresolvedRows)entry.getValue();
                dOut.writeUTF(((OlapInMemoryUnresolvedRows)rows).getTable().getId());
                ((OlapInMemoryUnresolvedRows)rows).save(dOut);
            }
            dOut.flush();
            out.sync();
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(out);
            throw throwable;
        }
        IOUtils.closeQuietly((OutputStream)out);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveM2Ms(M_DefaultBackupManager backupManager, File dir) throws IOException {
        OlapLoggers.BACKUP.info((Object)("[backup] saving m2m unresolved rows [" + this.m2msIgnoredRowsByFacts.size() + "/" + this.m2msKeptRowsByFacts.size() + "] for schema [" + this.schemaName + "]"));
        S_BackupOutputStream out = null;
        DataOutputStream dOut = null;
        try {
            OlapUnresolvedRows rows;
            String key;
            out = new S_BackupOutputStream(backupManager.getConfiguration(), new File(dir, "urows.icc-data"));
            dOut = new DataOutputStream(out);
            dOut.writeInt(this.m2msIgnoredRowsByFacts.size());
            for (Map.Entry<String, OlapIgnoredUnresolvedRows> entry : this.m2msIgnoredRowsByFacts.entrySet()) {
                key = entry.getKey();
                dOut.writeUTF(key);
                rows = entry.getValue();
                ((OlapIgnoredUnresolvedRows)rows).save(dOut);
            }
            dOut.writeInt(this.m2msKeptRowsByFacts.size());
            for (Map.Entry<String, OlapUnresolvedRows> entry : this.m2msKeptRowsByFacts.entrySet()) {
                key = entry.getKey();
                dOut.writeUTF(key);
                rows = (OlapInMemoryUnresolvedRows)entry.getValue();
                dOut.writeUTF(((OlapInMemoryUnresolvedRows)rows).getTable().getId());
                ((OlapInMemoryUnresolvedRows)rows).save(dOut);
            }
            dOut.flush();
            out.sync();
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(out);
            throw throwable;
        }
        IOUtils.closeQuietly((OutputStream)out);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void restoreCubes(M_DefaultBackupManager backupManager, File dir, Collection<IOlapBuilderDataTableDef> factsTables) throws IOException {
        HashMap<String, IOlapBuilderDataTableDef> tables = new HashMap<String, IOlapBuilderDataTableDef>();
        for (IOlapBuilderDataTableDef factsTable : factsTables) {
            tables.put(factsTable.getId(), factsTable);
        }
        DataInputStream in = null;
        try {
            S_BackupInputStream in_ = new S_BackupInputStream(backupManager.getConfiguration(), new File(dir, "rows.icc-data"));
            in = new DataInputStream(in_);
            this.restoreCubesIgnoredRows(in);
            this.restoreCubesKeptRows(in, tables);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(in);
            throw throwable;
        }
        IOUtils.closeQuietly((InputStream)in);
    }

    private void restoreCubesIgnoredRows(DataInputStream in) throws IOException {
        int count = in.readInt();
        for (int ii = 0; ii < count; ++ii) {
            String cube = in.readUTF();
            String facts = in.readUTF();
            OlapUnresolvedRowsKey key = new OlapUnresolvedRowsKey(cube, facts);
            OlapIgnoredUnresolvedRows rows = new OlapIgnoredUnresolvedRows();
            rows.restore(in);
            this.cubesIgnoredRowsByFacts.put(key, rows);
        }
    }

    private void restoreCubesKeptRows(DataInputStream in, Map<String, IOlapBuilderDataTableDef> tables) throws IOException {
        int count = in.readInt();
        for (int ii = 0; ii < count; ++ii) {
            String cube = in.readUTF();
            String facts = in.readUTF();
            String tableId = in.readUTF();
            IOlapBuilderDataTableDef table = tables.get(tableId);
            if (table == null) {
                throw new IOException("missing table [" + tableId + "]");
            }
            OlapUnresolvedRowsKey key = new OlapUnresolvedRowsKey(cube, facts);
            OlapInMemoryUnresolvedRows keptRows = new OlapInMemoryUnresolvedRows(table);
            keptRows.restore(in);
            this.cubesKeptRowsByFacts.put(key, keptRows);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void restoreM2Ms(M_DefaultBackupManager backupManager, File dir, List<IOlapBuilderDataTableDef> factsTables) throws IOException {
        HashMap<String, IOlapBuilderDataTableDef> tables = new HashMap<String, IOlapBuilderDataTableDef>();
        for (IOlapBuilderDataTableDef factsTable : factsTables) {
            tables.put(factsTable.getId(), factsTable);
        }
        DataInputStream in = null;
        try {
            File file = new File(dir, "urows.icc-data");
            if (file.exists()) {
                S_BackupInputStream in_ = new S_BackupInputStream(backupManager.getConfiguration(), file);
                in = new DataInputStream(in_);
                this.restoreM2MsIgnoredRows(in);
                this.restoreM2MsKeptRows(in, tables);
            }
        }
        finally {
            IOUtils.closeQuietly(in);
        }
    }

    private void restoreM2MsIgnoredRows(DataInputStream in) throws IOException {
        int count = in.readInt();
        for (int ii = 0; ii < count; ++ii) {
            String key = in.readUTF();
            OlapIgnoredUnresolvedRows rows = new OlapIgnoredUnresolvedRows();
            rows.restore(in);
            this.m2msIgnoredRowsByFacts.put(key, rows);
        }
    }

    private void restoreM2MsKeptRows(DataInputStream in, Map<String, IOlapBuilderDataTableDef> tables) throws IOException {
        int count = in.readInt();
        for (int ii = 0; ii < count; ++ii) {
            String key = in.readUTF();
            String tableId = in.readUTF();
            IOlapBuilderDataTableDef table = tables.get(tableId);
            if (table == null) {
                throw new IOException("missing table [" + tableId + "]");
            }
            OlapInMemoryUnresolvedRows keptRows = new OlapInMemoryUnresolvedRows(table);
            keptRows.restore(in);
            this.m2msKeptRowsByFacts.put(key, keptRows);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean unloadPartitions(OlapRegularCube cube, OlapFactMeasureGroupBaseManager measureGroup, List<String> partitionKeys) {
        Object object = this.globalLOCK;
        synchronized (object) {
            boolean unloaded = false;
            OlapUnresolvedRowsKey key = new OlapUnresolvedRowsKey(cube.getNameX(), measureGroup.getMeasureGroupName());
            OlapInMemoryUnresolvedRows rowsK = this.cubesKeptRowsByFacts.get(key);
            if (rowsK != null) {
                OlapLoggers.SCHEMA.debug((Object)("[u-rows] schema [" + cube.getSchemaName() + "] cube [" + cube.getNameX() + "] facts [" + measureGroup.getMeasureGroupName() + "] unloading partitions for kept u-rows"));
                unloaded = rowsK.unloadPartitions(cube, measureGroup, partitionKeys);
            } else {
                OlapLoggers.SCHEMA.debug((Object)("[u-rows] schema [" + cube.getSchemaName() + "] cube [" + cube.getNameX() + "] facts [" + measureGroup.getMeasureGroupName() + "] unloading partitions for kept u-rows (not required)"));
            }
            OlapIgnoredUnresolvedRows rowsI = this.cubesIgnoredRowsByFacts.get(key);
            if (rowsI != null) {
                OlapLoggers.SCHEMA.debug((Object)("[u-rows] schema [" + cube.getSchemaName() + "] cube [" + cube.getNameX() + "] facts [" + measureGroup.getMeasureGroupName() + "] unloading partitions for ignored u-rows"));
                unloaded = rowsI.unloadPartitions(cube, measureGroup, partitionKeys);
            } else {
                OlapLoggers.SCHEMA.debug((Object)("[u-rows] schema [" + cube.getSchemaName() + "] cube [" + cube.getNameX() + "] facts [" + measureGroup.getMeasureGroupName() + "] unloading partitions for ignored u-rows (not required)"));
            }
            return unloaded;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean unloadTable(OlapRegularCube cube, OlapFactMeasureGroupBaseManager measureGroup) {
        Object object = this.globalLOCK;
        synchronized (object) {
            boolean unloaded = false;
            OlapUnresolvedRowsKey key = new OlapUnresolvedRowsKey(cube.getNameX(), measureGroup.getMeasureGroupName());
            OlapInMemoryUnresolvedRows rowsK = this.cubesKeptRowsByFacts.get(key);
            if (rowsK != null) {
                OlapLoggers.SCHEMA.debug((Object)("[u-rows] schema [" + cube.getSchemaName() + "] cube [" + cube.getNameX() + "] facts [" + measureGroup.getMeasureGroupName() + "] unloading table for kept u-rows"));
                unloaded = rowsK.unloadPartitions(cube, measureGroup, null);
            } else {
                OlapLoggers.SCHEMA.debug((Object)("[u-rows] schema [" + cube.getSchemaName() + "] cube [" + cube.getNameX() + "] facts [" + measureGroup.getMeasureGroupName() + "] unloading table for kept u-rows (not required)"));
            }
            OlapIgnoredUnresolvedRows rowsI = this.cubesIgnoredRowsByFacts.get(key);
            if (rowsI != null) {
                OlapLoggers.SCHEMA.debug((Object)("[u-rows] schema [" + cube.getSchemaName() + "] cube [" + cube.getNameX() + "] facts [" + measureGroup.getMeasureGroupName() + "] unloading table for ignored u-rows"));
                unloaded = rowsI.unloadPartitions(cube, measureGroup, null);
            } else {
                OlapLoggers.SCHEMA.debug((Object)("[u-rows] schema [" + cube.getSchemaName() + "] cube [" + cube.getNameX() + "] facts [" + measureGroup.getMeasureGroupName() + "] unloading table for ignored u-rows (not required)"));
            }
            return unloaded;
        }
    }

    public void adoptRemoveMeasureGroup(OlapBuilderLoadEntityContext context, OlapBuilderContext bContext, Logger schemaLogger, OlapUnresolvedRowsManager loadedUnresolvedRows, M_FactsLocalMeasureGroupManager measureGroup) {
        OlapCube cube = measureGroup.getCube();
        OlapUnresolvedRowsKey key = new OlapUnresolvedRowsKey(cube.getNameX(), measureGroup.getMeasureGroupName());
        OlapInMemoryUnresolvedRows rowsK = this.cubesKeptRowsByFacts.get(key);
        if (rowsK != null) {
            OlapLoggers.SCHEMA.debug((Object)("[u-rows] schema [" + cube.getSchemaName() + "] cube [" + cube.getNameX() + "] unloading facts [" + measureGroup.getMeasureGroupName() + "] unloading table for kept u-rows"));
            rowsK.unloadMeasureGroup(cube, measureGroup);
        } else {
            OlapLoggers.SCHEMA.debug((Object)("[u-rows] schema [" + cube.getSchemaName() + "] cube [" + cube.getNameX() + "] unloading facts [" + measureGroup.getMeasureGroupName() + "] unloading table for kept u-rows (not required)"));
        }
        OlapIgnoredUnresolvedRows rowsI = this.cubesIgnoredRowsByFacts.get(key);
        if (rowsI != null) {
            OlapLoggers.SCHEMA.debug((Object)("[u-rows] schema [" + cube.getSchemaName() + "] cube [" + cube.getNameX() + "] unloading facts [" + measureGroup.getMeasureGroupName() + "] unloading table for ignored u-rows"));
            rowsI.unloadMeasureGroup(cube, measureGroup);
        } else {
            OlapLoggers.SCHEMA.debug((Object)("[u-rows] schema [" + cube.getSchemaName() + "] cube [" + cube.getNameX() + "] unloading facts [" + measureGroup.getMeasureGroupName() + "] unloading table for ignored u-rows (not required)"));
        }
    }

    public void adopt1(OlapBuilderLoadEntityContext context, OlapBuilderContext bContext, Logger schemaLogger, OlapUnresolvedRowsManager loadedUnresolvedRows, M_FactsLocalMeasureGroupManager measureGroup, @Nullable IOlapBuilderTablePartitionKey tablePartitionKey) {
        if (tablePartitionKey != null) {
            this.adoptForPartition1(context, bContext, schemaLogger, loadedUnresolvedRows, measureGroup, tablePartitionKey);
        } else {
            this.adoptForTable1(context, bContext, schemaLogger, loadedUnresolvedRows, measureGroup);
        }
    }

    private void adoptForPartition1(OlapBuilderLoadEntityContext context, OlapBuilderContext bContext, Logger schemaLogger, OlapUnresolvedRowsManager loadedUnresolvedRows, M_FactsLocalMeasureGroupManager measureGroup, IOlapBuilderTablePartitionKey tablePartitionKey) {
        OlapCube cube;
        if (schemaLogger.isInfoEnabled()) {
            schemaLogger.info((Object)("[schema] " + context.commandForLogsAndErrors() + " facts [" + measureGroup.getMeasureGroupName() + "] manager adopting (1) table partition [" + tablePartitionKey.getName() + "] u-rows."));
        }
        if (!((cube = measureGroup.getCube()) instanceof OlapRegularCube)) {
            if (schemaLogger.isInfoEnabled()) {
                schemaLogger.info((Object)("[schema] " + context.commandForLogsAndErrors() + " facts [" + measureGroup.getMeasureGroupName() + "] manager adopting (1) table partition [" + tablePartitionKey.getName() + "] u-rows - ignored for cube [" + cube.getNameX() + "] [" + cube.getClass().getName() + "]"));
            }
            return;
        }
        OlapRegularCube cube_ = (OlapRegularCube)cube;
        List<String> partitionKeys = Collections.singletonList(tablePartitionKey.getStrValue());
        this.unloadPartitions(cube_, measureGroup, partitionKeys);
        context.registerUnresolvedRowsCommand(cube_, measureGroup, tablePartitionKey);
    }

    private void adoptForTable1(OlapBuilderLoadEntityContext context, OlapBuilderContext bContext, Logger schemaLogger, OlapUnresolvedRowsManager loadedUnresolvedRows, M_FactsLocalMeasureGroupManager measureGroup) {
        OlapCube cube;
        if (schemaLogger.isInfoEnabled()) {
            schemaLogger.info((Object)("[schema] " + context.commandForLogsAndErrors() + " facts [" + measureGroup.getMeasureGroupName() + "] manager adopting (1) u-rows."));
        }
        if (!((cube = measureGroup.getCube()) instanceof OlapRegularCube)) {
            if (schemaLogger.isInfoEnabled()) {
                schemaLogger.info((Object)("[schema] " + context.commandForLogsAndErrors() + " facts [" + measureGroup.getMeasureGroupName() + "] manager adopting (1) u-rows - ignored for cube [" + cube.getNameX() + "] [" + cube.getClass().getName() + "]"));
            }
            return;
        }
        OlapRegularCube cube_ = (OlapRegularCube)cube;
        this.unloadTable(cube_, measureGroup);
        context.registerUnresolvedRowsCommand(cube_, measureGroup, null);
    }

    public void adopt2(OlapBuilderLoadEntityContext context, OlapBuilderContext bContext, Logger schemaLogger, OlapUnresolvedRowsManager loadedUnresolvedRows, List<OlapBuilderLoadEntityContext.URowsCommand> commands) {
        for (OlapBuilderLoadEntityContext.URowsCommand command : commands) {
            OlapIgnoredUnresolvedRows loadedIgnoredRows;
            OlapUnresolvedRowsKey key;
            OlapInMemoryUnresolvedRows loadedKeptRows;
            if (command.tablePartitionKey != null) {
                if (schemaLogger.isInfoEnabled()) {
                    schemaLogger.info((Object)("[schema] " + context.commandForLogsAndErrors() + " facts [" + command.measureGroup.getMeasureGroupName() + "] manager adopting (2) table partition [" + command.tablePartitionKey.getName() + "] u-rows."));
                }
                if ((loadedKeptRows = loadedUnresolvedRows.cubesKeptRowsByFacts.get(key = new OlapUnresolvedRowsKey(command.cube.getNameX(), command.measureGroup.getMeasureGroupName()))) != null) {
                    loadedKeptRows.reportTo(context, bContext, schemaLogger, command.cube, command.measureGroup, command.tablePartitionKey, this);
                }
                if ((loadedIgnoredRows = loadedUnresolvedRows.cubesIgnoredRowsByFacts.get(key)) == null) continue;
                loadedIgnoredRows.reportTo(context, bContext, schemaLogger, command.cube, command.measureGroup, command.tablePartitionKey, this);
                continue;
            }
            if (schemaLogger.isInfoEnabled()) {
                schemaLogger.info((Object)("[schema] " + context.commandForLogsAndErrors() + " facts [" + command.measureGroup.getMeasureGroupName() + "] manager adopting (2) u-rows."));
            }
            if ((loadedKeptRows = loadedUnresolvedRows.cubesKeptRowsByFacts.get(key = new OlapUnresolvedRowsKey(command.cube.getNameX(), command.measureGroup.getMeasureGroupName()))) != null) {
                loadedKeptRows.reportTo(context, bContext, schemaLogger, command.cube, command.measureGroup, null, this);
            }
            if ((loadedIgnoredRows = loadedUnresolvedRows.cubesIgnoredRowsByFacts.get(key)) == null) continue;
            loadedIgnoredRows.reportTo(context, bContext, schemaLogger, command.cube, command.measureGroup, null, this);
        }
    }
}

