/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.goodies.unresolverows;

import crazydev.iccube.builder.OlapBuilderContext;
import crazydev.iccube.builder.OlapBuilderLoadEntityContext;
import crazydev.iccube.builder.datasource.buffer.OlapBuilderBufferDataTable;
import crazydev.iccube.builder.datasource.buffer.OlapBuilderBufferDataTableRow;
import crazydev.iccube.builder.datasource.jdbc.OlapBuilderBackupTablePartitionKey;
import crazydev.iccube.builder.datasource.reader.IOlapBuilderTablePartitionKey;
import crazydev.iccube.builder.model.def.IOlapBuilderDataColumnDef;
import crazydev.iccube.builder.model.def.IOlapBuilderTableRow;
import crazydev.iccube.builder.model.def.IOlapBuilderTabularDataDef;
import crazydev.iccube.builder.offline.common.OlapBuilderOfflineSerializer;
import crazydev.iccube.builder.type.OlapBuilderInputType;
import crazydev.iccube.cluster.master.local.facts.M_FactsLocalMeasureGroupManager;
import crazydev.iccube.olap.cube.OlapCube;
import crazydev.iccube.olap.cube.OlapRegularCube;
import crazydev.iccube.olap.facts.OlapFactMeasureGroupBaseManager;
import crazydev.iccube.olap.goodies.unresolverows.OlapIgnoredUnresolvedRows;
import crazydev.iccube.olap.goodies.unresolverows.OlapUnresolvedRows;
import crazydev.iccube.olap.goodies.unresolverows.OlapUnresolvedRowsManager;
import crazydev.iccube.olap.loggers.OlapLoggers;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.Nullable;

class OlapInMemoryUnresolvedRows
extends OlapUnresolvedRows {
    private final IOlapBuilderTabularDataDef tabularData;
    private final OlapBuilderBufferDataTable table;
    private final Map<IOlapBuilderTablePartitionKey, OlapBuilderBufferDataTable> pTables = new HashMap<IOlapBuilderTablePartitionKey, OlapBuilderBufferDataTable>();

    OlapInMemoryUnresolvedRows(IOlapBuilderTabularDataDef tabularData) {
        this.tabularData = tabularData;
        this.table = new OlapBuilderBufferDataTable(tabularData.getId(), tabularData.getName() + " (unresolved rows)", tabularData.getAllColumns());
        List<IOlapBuilderDataColumnDef> columns = this.table.getSelectedColumns();
        for (IOlapBuilderDataColumnDef column : columns) {
            if (column.getIndex() != -1) continue;
            throw new RuntimeException("internal error: table columns not setup [" + this.table.getName() + "]");
        }
    }

    public long sizeOf() {
        long sizeOf = this.table.sizeOf();
        for (OlapBuilderBufferDataTable pTable : this.pTables.values()) {
            sizeOf += pTable.sizeOf();
        }
        return sizeOf;
    }

    public OlapBuilderBufferDataTable getTable() {
        return this.table;
    }

    @Override
    int getRowCount() {
        int size = this.table.size();
        for (OlapBuilderBufferDataTable pTable : this.pTables.values()) {
            size += pTable.size();
        }
        return size;
    }

    @Override
    int getActualRowsCount() {
        int size = this.table.size();
        for (OlapBuilderBufferDataTable pTable : this.pTables.values()) {
            size += pTable.size();
        }
        return size;
    }

    @Override
    void reportUnresolvedRow(@Nullable IOlapBuilderTablePartitionKey partition, IOlapBuilderTableRow row) {
        if (partition == null) {
            this.table.addRow(row);
            return;
        }
        OlapBuilderBufferDataTable pTable = this.pTables.get(partition);
        if (pTable == null) {
            pTable = new OlapBuilderBufferDataTable(this.tabularData.getId() + "(" + partition.getName() + ")", this.tabularData.getName() + " (unresolved rows) (" + partition.getName() + ")", this.tabularData.getSelectedColumns());
            this.pTables.put(partition, pTable);
        }
        pTable.addRow(row);
    }

    OlapBuilderBufferDataTable asTableForIncrLoadProcessing() {
        return this.table;
    }

    Map<IOlapBuilderTablePartitionKey, OlapBuilderBufferDataTable> asPartitionTablesForIncrLoadProcessing() {
        return this.pTables;
    }

    OlapIgnoredUnresolvedRows asIgnoredUnresolvedRows() {
        int noPartitionRowCount = this.table.size();
        HashMap<IOlapBuilderTablePartitionKey, Integer> partitionRowCounts = new HashMap<IOlapBuilderTablePartitionKey, Integer>();
        for (Map.Entry<IOlapBuilderTablePartitionKey, OlapBuilderBufferDataTable> entry : this.pTables.entrySet()) {
            IOlapBuilderTablePartitionKey pKey = entry.getKey();
            OlapBuilderBufferDataTable pTable = entry.getValue();
            partitionRowCounts.put(pKey, pTable.size());
        }
        return new OlapIgnoredUnresolvedRows(noPartitionRowCount, partitionRowCounts);
    }

    public void save(DataOutputStream out) throws IOException {
        this.saveRows(out, this.table);
        out.writeInt(this.pTables.size());
        for (Map.Entry<IOlapBuilderTablePartitionKey, OlapBuilderBufferDataTable> entry : this.pTables.entrySet()) {
            IOlapBuilderTablePartitionKey partition = entry.getKey();
            OlapBuilderBufferDataTable table = entry.getValue();
            this.savePartition(out, partition);
            this.saveRows(out, table);
        }
    }

    private void saveRows(DataOutputStream out, OlapBuilderBufferDataTable table) throws IOException {
        List<OlapBuilderBufferDataTableRow> rows = table.getData();
        out.writeInt(rows.size());
        for (OlapBuilderBufferDataTableRow row : rows) {
            Comparable[] values = row.getValues();
            out.writeInt(values.length);
            for (int vv = 0; vv < values.length; ++vv) {
                Comparable value = values[vv];
                OlapBuilderOfflineSerializer.Serializer serializer = OlapBuilderOfflineSerializer.getSerializerForNativeValue(value);
                serializer.write(out, value);
            }
        }
    }

    private void savePartition(DataOutputStream out, IOlapBuilderTablePartitionKey partition) throws IOException {
        out.writeUTF(partition.getColumnType().name());
        out.writeUTF(partition.getStrValue());
    }

    public void restore(DataInputStream in) throws IOException {
        this.restoreRows(in, null);
        int count = in.readInt();
        for (int ii = 0; ii < count; ++ii) {
            IOlapBuilderTablePartitionKey partition = this.restorePartition(in);
            this.restoreRows(in, partition);
        }
    }

    private IOlapBuilderTablePartitionKey restorePartition(DataInputStream in) throws IOException {
        OlapBuilderInputType keyInputType = OlapBuilderInputType.valueOf(in.readUTF());
        String keyValue = in.readUTF();
        return new OlapBuilderBackupTablePartitionKey(keyInputType, keyValue);
    }

    private void restoreRows(DataInputStream in, @Nullable IOlapBuilderTablePartitionKey partition) throws IOException {
        int rowCount = in.readInt();
        for (int ii = 0; ii < rowCount; ++ii) {
            int valuesLen = in.readInt();
            Comparable[] values = new Comparable[valuesLen];
            for (int vv = 0; vv < values.length; ++vv) {
                byte type = in.readByte();
                OlapBuilderOfflineSerializer.Serializer serializer = OlapBuilderOfflineSerializer.getSerializerForType(type);
                values[vv] = serializer.read(in);
            }
            OlapBuilderBufferDataTableRow row = new OlapBuilderBufferDataTableRow(values);
            this.reportUnresolvedRow(partition, row);
        }
    }

    public void unloadMeasureGroup(OlapCube cube, OlapFactMeasureGroupBaseManager measureGroup) {
        OlapLoggers.SCHEMA.debug((Object)("[u-rows] schema [" + cube.getSchemaName() + "] cube [" + cube.getNameX() + "] facts [" + measureGroup.getMeasureGroupName() + "] unloading all (kept)"));
        this.pTables.clear();
        this.table.clearData();
    }

    public boolean unloadPartitions(OlapRegularCube cube, OlapFactMeasureGroupBaseManager measureGroup, @Nullable List<String> partitionKeys) {
        boolean unloaded = false;
        if (partitionKeys != null) {
            List<IOlapBuilderTablePartitionKey> pKeys = this.getKeys(partitionKeys);
            for (IOlapBuilderTablePartitionKey pKey : pKeys) {
                if (this.pTables.remove(pKey) != null) {
                    OlapLoggers.SCHEMA.debug((Object)("[u-rows] schema [" + cube.getSchemaName() + "] cube [" + cube.getNameX() + "] facts [" + measureGroup.getMeasureGroupName() + "] unloading partitions [" + pKey.getName() + "]"));
                    unloaded = true;
                    continue;
                }
                OlapLoggers.SCHEMA.debug((Object)("[u-rows] schema [" + cube.getSchemaName() + "] cube [" + cube.getNameX() + "] facts [" + measureGroup.getMeasureGroupName() + "] unloading partitions [" + pKey.getName() + "] (IGNORED)"));
            }
        } else {
            OlapLoggers.SCHEMA.debug((Object)("[u-rows] schema [" + cube.getSchemaName() + "] cube [" + cube.getNameX() + "] facts [" + measureGroup.getMeasureGroupName() + "] unloading table"));
            if (this.table.size() > 0) {
                this.table.clearData();
                unloaded = true;
            }
        }
        return unloaded;
    }

    @Override
    void reportTo(OlapBuilderLoadEntityContext context, OlapBuilderContext bContext, Logger schemaLogger, OlapCube cube, M_FactsLocalMeasureGroupManager measureGroup, @Nullable IOlapBuilderTablePartitionKey tablePartitionKey, OlapUnresolvedRowsManager uRows) {
        if (tablePartitionKey != null) {
            OlapBuilderBufferDataTable pTable = this.pTables.get(tablePartitionKey);
            if (pTable == null) {
                if (schemaLogger.isInfoEnabled()) {
                    schemaLogger.info((Object)("[u-rows] " + context.commandForLogsAndErrors() + " facts manager adopting (table) partition [" + tablePartitionKey.getName() + "] u-rows [0]"));
                }
                return;
            }
            List<OlapBuilderBufferDataTableRow> pTableRows = pTable.getData();
            if (schemaLogger.isInfoEnabled()) {
                schemaLogger.info((Object)("[u-rows] " + context.commandForLogsAndErrors() + " facts manager adopting (table) partition [" + tablePartitionKey.getName() + "] u-rows [" + pTableRows.size() + "]"));
            }
            for (OlapBuilderBufferDataTableRow pTableRow : pTableRows) {
                uRows.reportUnresolvedRow(bContext, cube, measureGroup.getFactsDefinition(), this.tabularData, tablePartitionKey, pTableRow);
            }
        } else {
            List<OlapBuilderBufferDataTableRow> tableRows = this.table.getData();
            if (schemaLogger.isInfoEnabled()) {
                schemaLogger.info((Object)("[u-rows] " + context.commandForLogsAndErrors() + " facts manager adopting table u-rows [" + tableRows.size() + "]"));
            }
            for (OlapBuilderBufferDataTableRow pTableRow : tableRows) {
                uRows.reportUnresolvedRow(bContext, cube, measureGroup.getFactsDefinition(), this.tabularData, null, pTableRow);
            }
        }
    }

    private List<IOlapBuilderTablePartitionKey> getKeys(List<String> partitionKeys) {
        Set<IOlapBuilderTablePartitionKey> pTableKeys = this.pTables.keySet();
        ArrayList<IOlapBuilderTablePartitionKey> pKeys = new ArrayList<IOlapBuilderTablePartitionKey>();
        for (String partitionKey : partitionKeys) {
            for (IOlapBuilderTablePartitionKey pTableKey : pTableKeys) {
                if (!pTableKey.getStrValue().equals(partitionKey)) continue;
                pKeys.add(pTableKey);
            }
        }
        return pKeys;
    }
}

