/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.goodies.unresolverows;

import crazydev.common.system.CdRamUsageEstimator;
import crazydev.iccube.builder.OlapBuilderContext;
import crazydev.iccube.builder.OlapBuilderLoadEntityContext;
import crazydev.iccube.builder.datasource.jdbc.OlapBuilderBackupTablePartitionKey;
import crazydev.iccube.builder.datasource.reader.IOlapBuilderTablePartitionKey;
import crazydev.iccube.builder.model.def.IOlapBuilderTableRow;
import crazydev.iccube.builder.type.OlapBuilderInputType;
import crazydev.iccube.cluster.master.local.facts.M_FactsLocalMeasureGroupManager;
import crazydev.iccube.olap.cube.OlapCube;
import crazydev.iccube.olap.cube.OlapRegularCube;
import crazydev.iccube.olap.facts.OlapFactMeasureGroupBaseManager;
import crazydev.iccube.olap.goodies.unresolverows.OlapUnresolvedRows;
import crazydev.iccube.olap.goodies.unresolverows.OlapUnresolvedRowsManager;
import crazydev.iccube.olap.loggers.OlapLoggers;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.Nullable;

class OlapIgnoredUnresolvedRows
extends OlapUnresolvedRows {
    private static long SHALLOW_SIZE_OF = -1L;
    private final Map<IOlapBuilderTablePartitionKey, Integer> partitionRowCounts = new HashMap<IOlapBuilderTablePartitionKey, Integer>();
    private int noPartitionRowCount;

    OlapIgnoredUnresolvedRows() {
        this(0, Collections.emptyMap());
    }

    OlapIgnoredUnresolvedRows(int noPartitionRowCount, Map<IOlapBuilderTablePartitionKey, Integer> partitionRowCounts) {
        this.noPartitionRowCount = noPartitionRowCount;
        this.partitionRowCounts.putAll(partitionRowCounts);
    }

    public long sizeOf() {
        return SHALLOW_SIZE_OF != -1L ? SHALLOW_SIZE_OF : (SHALLOW_SIZE_OF = CdRamUsageEstimator.shallowSizeOf((Object)this));
    }

    @Override
    int getRowCount() {
        int size = this.noPartitionRowCount;
        for (Integer rowCount : this.partitionRowCounts.values()) {
            size += rowCount.intValue();
        }
        return size;
    }

    @Override
    int getActualRowsCount() {
        return 0;
    }

    @Override
    void reportUnresolvedRow(@Nullable IOlapBuilderTablePartitionKey partition, IOlapBuilderTableRow row) {
        if (partition == null) {
            ++this.noPartitionRowCount;
            return;
        }
        Integer rowCount = this.partitionRowCounts.get(partition);
        if (rowCount == null) {
            rowCount = 0;
        }
        this.partitionRowCounts.put(partition, rowCount + 1);
    }

    public void save(DataOutputStream out) throws IOException {
        out.writeInt(this.noPartitionRowCount);
        out.writeInt(this.partitionRowCounts.size());
        for (Map.Entry<IOlapBuilderTablePartitionKey, Integer> entry : this.partitionRowCounts.entrySet()) {
            IOlapBuilderTablePartitionKey partition = entry.getKey();
            Integer rowCount = entry.getValue();
            out.writeUTF(partition.getColumnType().name());
            out.writeUTF(partition.getStrValue());
            out.writeInt(rowCount);
        }
    }

    public void restore(DataInputStream in) throws IOException {
        this.noPartitionRowCount = in.readInt();
        int count = in.readInt();
        for (int ii = 0; ii < count; ++ii) {
            OlapBuilderInputType keyInputType = OlapBuilderInputType.valueOf(in.readUTF());
            String keyValue = in.readUTF();
            OlapBuilderBackupTablePartitionKey partition = new OlapBuilderBackupTablePartitionKey(keyInputType, keyValue);
            int rowCount = in.readInt();
            this.partitionRowCounts.put(partition, rowCount);
        }
    }

    public void unloadMeasureGroup(OlapCube cube, OlapFactMeasureGroupBaseManager measureGroup) {
        OlapLoggers.SCHEMA.debug((Object)("[u-rows] schema [" + cube.getSchemaName() + "] cube [" + cube.getNameX() + "] facts [" + measureGroup.getMeasureGroupName() + "] unloading all (ignored)"));
        this.partitionRowCounts.clear();
        this.noPartitionRowCount = 0;
    }

    public boolean unloadPartitions(OlapRegularCube cube, OlapFactMeasureGroupBaseManager measureGroup, @Nullable List<String> partitionKeys) {
        boolean unloaded = false;
        if (partitionKeys != null) {
            List<IOlapBuilderTablePartitionKey> pKeys = this.getKeys(partitionKeys);
            for (IOlapBuilderTablePartitionKey pKey : pKeys) {
                if (this.partitionRowCounts.remove(pKey) != null) {
                    OlapLoggers.SCHEMA.debug((Object)("[u-rows] schema [" + cube.getSchemaName() + "] cube [" + cube.getNameX() + "] facts [" + measureGroup.getMeasureGroupName() + "] unloading (ignored) partitions [" + pKey.getName() + "]"));
                    unloaded = true;
                    continue;
                }
                OlapLoggers.SCHEMA.debug((Object)("[u-rows] schema [" + cube.getSchemaName() + "] cube [" + cube.getNameX() + "] facts [" + measureGroup.getMeasureGroupName() + "] unloading (ignored) partitions [" + pKey.getName() + "] (IGNORED)"));
            }
        } else {
            OlapLoggers.SCHEMA.debug((Object)("[u-rows] schema [" + cube.getSchemaName() + "] cube [" + cube.getNameX() + "] facts [" + measureGroup.getMeasureGroupName() + "] unloading (ignored) table"));
            if (this.noPartitionRowCount > 0) {
                this.noPartitionRowCount = 0;
                unloaded = true;
            }
        }
        return unloaded;
    }

    @Override
    void reportTo(OlapBuilderLoadEntityContext context, OlapBuilderContext bContext, Logger schemaLogger, OlapCube cube, M_FactsLocalMeasureGroupManager measureGroup, @Nullable IOlapBuilderTablePartitionKey tablePartitionKey, OlapUnresolvedRowsManager uRows) {
        if (tablePartitionKey != null) {
            Integer rowCount = this.partitionRowCounts.get(tablePartitionKey);
            if (rowCount == null) {
                if (schemaLogger.isInfoEnabled()) {
                    schemaLogger.info((Object)("[u-rows] " + context.commandForLogsAndErrors() + " facts manager adopting (table) (ignored) partition [" + tablePartitionKey.getName() + "] u-rows [0]"));
                }
                return;
            }
            if (schemaLogger.isInfoEnabled()) {
                schemaLogger.info((Object)("[u-rows] " + context.commandForLogsAndErrors() + " facts manager adopting (table) (ignored) partition [" + tablePartitionKey.getName() + "] u-rows [" + rowCount + "]"));
            }
            uRows.reportCubesUnresolvedRowForIgnoring(cube, measureGroup.getFactsDefinition(), tablePartitionKey);
        } else {
            if (schemaLogger.isInfoEnabled()) {
                schemaLogger.info((Object)("[u-rows] " + context.commandForLogsAndErrors() + " facts manager adopting (ignored) table u-rows [" + this.noPartitionRowCount + "]"));
            }
            uRows.reportCubesUnresolvedRowForIgnoring(cube, measureGroup.getFactsDefinition(), null);
        }
    }

    private List<IOlapBuilderTablePartitionKey> getKeys(List<String> partitionKeys) {
        Set<IOlapBuilderTablePartitionKey> pTableKeys = this.partitionRowCounts.keySet();
        ArrayList<IOlapBuilderTablePartitionKey> pKeys = new ArrayList<IOlapBuilderTablePartitionKey>();
        for (String partitionKey : partitionKeys) {
            for (IOlapBuilderTablePartitionKey pTableKey : pTableKeys) {
                if (!pTableKey.getStrValue().equals(partitionKey)) continue;
                pKeys.add(pTableKey);
            }
        }
        return pKeys;
    }
}

