/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.goodies.perspective.permissions;

import crazydev.iccube.olap.entity.hierarchy.OlapHierarchy;
import crazydev.iccube.olap.entity.level.OlapLevel;
import crazydev.iccube.olap.entity.member.OlapMember;
import crazydev.iccube.olap.entity.permissions.IOlapDimensionPermission;
import crazydev.iccube.olap.entity.permissions.IOlapHierarchyPermission;
import crazydev.iccube.olap.goodies.perspective.OlapPerspective;

public class OlapPerspectiveHierarchyPermission
implements IOlapHierarchyPermission {
    private OlapHierarchy hierarchy;
    private final IOlapHierarchyPermission permissions;
    private final OlapPerspective perspective;

    public OlapPerspectiveHierarchyPermission(OlapHierarchy hierarchy, IOlapDimensionPermission permissions, OlapPerspective perspective) {
        this.hierarchy = hierarchy;
        this.perspective = perspective;
        this.permissions = permissions.getHierarchyPermission(hierarchy);
    }

    @Override
    public OlapHierarchy getHierarchy() {
        return this.hierarchy;
    }

    @Override
    public OlapMember getDefaultMember() {
        return this.permissions.getDefaultMember();
    }

    @Override
    public boolean isLevelAuthorized(OlapLevel level) {
        return this.isLevelAccepted(level) && this.permissions.isLevelAuthorized(level);
    }

    @Override
    public boolean isLevelInvisible(OlapLevel level) {
        return !this.isLevelAccepted(level) && this.permissions.isLevelAuthorized(level);
    }

    private boolean isLevelAccepted(OlapLevel level) {
        return this.perspective.isLevelVisible(level);
    }
}

