/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.goodies.perspective;

import crazydev.iccube.olap.entity.dimension.OlapDimension;
import crazydev.iccube.olap.entity.hierarchy.OlapHierarchy;
import crazydev.iccube.olap.entity.level.OlapLevel;
import crazydev.iccube.olap.entity.member.OlapMember;
import crazydev.iccube.olap.util.OlapCaseInsensitiveName;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.Nullable;

public class OlapPerspectiveRenames {
    private final Map<OlapDimension, String> dimensionNames = new HashMap<OlapDimension, String>();
    private final Map<OlapHierarchy, String> hierarchyNames = new HashMap<OlapHierarchy, String>();
    private final Map<OlapLevel, String> levelNames = new HashMap<OlapLevel, String>();
    private final Map<OlapMember, String> memberNames = new HashMap<OlapMember, String>();

    public boolean isEmpty() {
        return this.dimensionNames.isEmpty() && this.hierarchyNames.isEmpty() && this.levelNames.isEmpty() && this.memberNames.isEmpty();
    }

    public boolean renamesDimensions() {
        return !this.dimensionNames.isEmpty();
    }

    public boolean renamesHierarchies() {
        return !this.hierarchyNames.isEmpty();
    }

    public boolean renamesLevels() {
        return !this.levelNames.isEmpty();
    }

    public boolean renamesMembers() {
        return !this.memberNames.isEmpty();
    }

    public boolean isRenamingMember(OlapLevel level) {
        if (this.memberNames.isEmpty()) {
            return false;
        }
        for (OlapMember member : this.memberNames.keySet()) {
            if (!member.getLevel().equals(level)) continue;
            return true;
        }
        return false;
    }

    @Nullable
    public String getName(OlapDimension dimension) {
        return this.dimensionNames.get(dimension);
    }

    @Nullable
    public String getName(OlapHierarchy hierarchy) {
        return this.hierarchyNames.get(hierarchy);
    }

    @Nullable
    public String getName(OlapLevel level) {
        return this.levelNames.get(level);
    }

    @Nullable
    public String getName(OlapMember member) {
        return this.memberNames.get(member);
    }

    public void addName(String name, OlapDimension dimension) {
        this.dimensionNames.put(dimension, name);
    }

    public void addName(String name, OlapHierarchy hierarchy) {
        this.hierarchyNames.put(hierarchy, name);
    }

    public void addName(String name, OlapLevel level) {
        this.levelNames.put(level, name);
    }

    public void addName(String name, OlapMember member) {
        this.memberNames.put(member, name);
    }

    public boolean containsDimensionName(String name) {
        for (String dimensionName : this.dimensionNames.values()) {
            if (!OlapCaseInsensitiveName.equals(name, dimensionName)) continue;
            return true;
        }
        return false;
    }

    public boolean containsHierarchyName(OlapDimension dimension, String name) {
        for (Map.Entry<OlapHierarchy, String> entry : this.hierarchyNames.entrySet()) {
            OlapHierarchy hierarchy = entry.getKey();
            String hierarchyName = entry.getValue();
            if (!dimension.equals(hierarchy.getDimension()) || !OlapCaseInsensitiveName.equals(name, hierarchyName)) continue;
            return true;
        }
        return false;
    }

    public boolean containsLevelName(OlapHierarchy hierarchy, String name) {
        for (Map.Entry<OlapLevel, String> entry : this.levelNames.entrySet()) {
            OlapLevel level = entry.getKey();
            String levelName = entry.getValue();
            if (!hierarchy.equals(level.getHierarchy()) || !OlapCaseInsensitiveName.equals(name, levelName)) continue;
            return true;
        }
        return false;
    }

    public boolean containsMemberName(OlapLevel level, String name) {
        for (Map.Entry<OlapMember, String> entry : this.memberNames.entrySet()) {
            OlapMember member = entry.getKey();
            String memberName = entry.getValue();
            if (!level.equals(member.getLevel()) || !OlapCaseInsensitiveName.equals(name, memberName)) continue;
            return true;
        }
        return false;
    }

    public boolean containsMemberName(OlapMember parent, String name) {
        for (Map.Entry<OlapMember, String> entry : this.memberNames.entrySet()) {
            OlapMember member = entry.getKey();
            String memberName = entry.getValue();
            OlapMember memberParent = member.getParent();
            if (memberParent == null || !parent.equals(memberParent) || !OlapCaseInsensitiveName.equals(name, memberName)) continue;
            return true;
        }
        return false;
    }
}

