/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.goodies.perspective;

import crazydev.iccube.olap.entity.hierarchy.OlapHierarchy;
import crazydev.iccube.olap.entity.member.OlapMember;
import crazydev.iccube.olap.eval.filter.dimension.OlapMemberFilter;
import crazydev.iccube.olap.goodies.perspective.OlapPerspectiveMemberFilter;

public class OlapPerspectiveDecoratingMemberFilter
extends OlapPerspectiveMemberFilter {
    private final OlapMemberFilter permissionsFilter;

    public OlapPerspectiveDecoratingMemberFilter(OlapPerspectiveMemberFilter filter, OlapMemberFilter permissionsFilter) {
        super(filter, "decorating-" + permissionsFilter.getName());
        this.permissionsFilter = permissionsFilter;
    }

    @Override
    public boolean isNotFiltering(OlapHierarchy hierarchy) {
        return super.isNotFiltering(hierarchy) == Boolean.TRUE.booleanValue() && this.permissionsFilter.isNotFiltering(hierarchy) == Boolean.TRUE.booleanValue();
    }

    @Override
    public boolean isAccepting(OlapMember member) {
        return super.isAccepting(member) && this.permissionsFilter.isAccepting(member);
    }

    @Override
    public OlapMember getRedefinedDefaultMember(OlapHierarchy hierarchy) {
        OlapMember defaultMember = this.getPerspectiveDefaultMember(hierarchy);
        if (defaultMember != null && this.permissionsFilter.isAccepting(defaultMember)) {
            return defaultMember;
        }
        return this.permissionsFilter.getRedefinedDefaultMember(hierarchy);
    }
}

