/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.goodies.incrload;

import crazydev.common.exception.programming.CdShouldNotBeHereProgrammingException;
import crazydev.common.utils.CdStringUtils;
import crazydev.iccube.builder.OlapBuilderContext;
import crazydev.iccube.builder.datasource.buffer.OlapBuilderBufferDataTable;
import crazydev.iccube.builder.datasource.reader.IOlapBuilderTablePartitionKey;
import crazydev.iccube.builder.model.builders.IOlapBuilderTableFilter;
import crazydev.iccube.builder.model.builders.OlapBuilderAbstractTableListener;
import crazydev.iccube.builder.model.def.IOlapBuilderDataColumnDef;
import crazydev.iccube.builder.model.def.IOlapBuilderDataTableDef;
import crazydev.iccube.builder.model.def.IOlapBuilderTableRow;
import crazydev.iccube.builder.model.def.IOlapBuilderTabularDataDef;
import crazydev.iccube.builder.model.impl.table.OlapBuilderBaseDataTable;
import crazydev.iccube.enums.OlapIncrementalLoadStrategy;
import crazydev.iccube.olap.goodies.incrload.IncrLoadDefaultMarker;
import crazydev.iccube.olap.goodies.incrload.IncrLoadMarker;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.Nullable;

public class IncrLoadTableSavePoint {
    private final OlapBuilderBufferDataTable table;
    private final OlapIncrementalLoadStrategy strategy;
    @Nullable
    private final String columnName;
    private IOlapBuilderDataColumnDef incrLoadColumn;
    @Nullable
    private OlapBuilderBaseDataTable shortcutTable;
    private IncrLoadMarker marker_;

    public IncrLoadTableSavePoint(IOlapBuilderDataTableDef dataTable) {
        this.columnName = IncrLoadTableSavePoint.setupColumnName(dataTable);
        this.strategy = dataTable.getIncrementalLoadStrategy();
        this.table = new OlapBuilderBufferDataTable(dataTable.getId(), dataTable.getName() + " (buffer)", dataTable.getAllColumns(), dataTable.getIncrementalLoadStrategy());
        this.marker_ = dataTable.createIncrLoadMarker(this);
    }

    @Nullable
    private static String setupColumnName(IOlapBuilderDataTableDef dataTable) {
        String columnName = dataTable.getIncrementalLoadColumnName();
        columnName = CdStringUtils.isNotNullAndNotBlank((String)columnName) ? columnName : null;
        return columnName;
    }

    public void onFullLoadStartDataProcessing(IOlapBuilderDataTableDef dataTable) {
        if (this.columnName != null) {
            dataTable.addListener(new IncrLoadTableMarkerListener(this));
        }
    }

    public void addListener(OlapBuilderBaseDataTable dataTable) {
        this.table.clearData();
        this.marker_.resetLoadingMarker();
        if (dataTable.notCacheInIncrementalLoad()) {
            this.shortcutTable = dataTable;
        } else {
            dataTable.addListener(new IncrLoadTableBuilderListener(this));
            if (dataTable.getIncrementalLoadStrategy().filtersDataOnIncrementalLoad()) {
                dataTable.addRowFilter(new IncrLoadTableFilterListener(this));
            }
        }
    }

    public void addListenerForLoadFacts(IOlapBuilderDataTableDef tableDef) {
        this.marker_.resetLoadingMarker();
        if (this.columnName != null) {
            tableDef.addListener(new IncrLoadTableMarkerListener(this));
        }
    }

    void onIncrLoadFinishAllDataProcessing() {
        this.marker_.toggleLoadingMarker();
    }

    public void updateMarker(IncrLoadTableSavePoint savePoint) {
        this.marker_.setMarker(savePoint.marker_);
    }

    public void cleanup() {
        this.table.clearData();
    }

    private IOlapBuilderDataColumnDef getIncrLoadColumn(List<IOlapBuilderDataColumnDef> columns) {
        if (this.incrLoadColumn != null) {
            return this.incrLoadColumn;
        }
        for (IOlapBuilderDataColumnDef column : columns) {
            if (!column.getName().equals(this.columnName)) continue;
            this.incrLoadColumn = column;
            return this.incrLoadColumn;
        }
        throw new CdShouldNotBeHereProgrammingException();
    }

    public OlapBuilderBaseDataTable getTable() {
        return this.shortcutTable != null ? this.shortcutTable : this.table;
    }

    public IncrLoadMarker getMarkers() {
        return this.marker_;
    }

    public String getMarkerDebugInfo() {
        return this.marker_.getMarkerDebugInfo();
    }

    public Comparable getMarker() {
        if (this.marker_ instanceof IncrLoadDefaultMarker) {
            return ((IncrLoadDefaultMarker)this.marker_).getMarker();
        }
        throw new RuntimeException("internal error : incr. load marker type mismatch [" + this.marker_.getClass().getName() + "]");
    }

    public Comparable getLoadingMarker() {
        if (this.marker_ instanceof IncrLoadDefaultMarker) {
            return ((IncrLoadDefaultMarker)this.marker_).getLoadingMarker();
        }
        throw new RuntimeException("internal error : incr. load marker type mismatch [" + this.marker_.getClass().getName() + "]");
    }

    public void saveMarker(DataOutputStream out) throws IOException {
        this.marker_.save(out);
    }

    public void restoreMarker(DataInputStream in) throws IOException {
        this.marker_.restore(in);
    }

    public boolean hasData() {
        return this.shortcutTable != null || this.table != null && this.table.hasData();
    }

    public boolean redefinesTables() {
        return this.shortcutTable == null && this.strategy.loadDataOnIncrementalLoad();
    }

    @Nullable
    public String createStats() {
        return this.marker_.createStats();
    }

    class IncrLoadTableMarkerListener
    extends OlapBuilderAbstractTableListener {
        final /* synthetic */ IncrLoadTableSavePoint this$0;

        IncrLoadTableMarkerListener(IncrLoadTableSavePoint this$0) {
            IncrLoadTableSavePoint incrLoadTableSavePoint = this$0;
            Objects.requireNonNull(incrLoadTableSavePoint);
            this.this$0 = incrLoadTableSavePoint;
        }

        @Override
        public boolean onNewRow(OlapBuilderContext context, IOlapBuilderTabularDataDef originalTable, IOlapBuilderTabularDataDef tabularData, List<IOlapBuilderDataColumnDef> columns, @Nullable IOlapBuilderTablePartitionKey partition, int rowNb, IOlapBuilderTableRow data) {
            Comparable cell = data.getJavaNativeDataValue(this.this$0.getIncrLoadColumn(columns));
            if (cell == null) {
                throw new CdShouldNotBeHereProgrammingException("NULL not supported in incremental load column");
            }
            return this.this$0.marker_.onNewRowForMarker(columns, data, cell);
        }
    }

    class IncrLoadTableBuilderListener
    extends OlapBuilderAbstractTableListener {
        final /* synthetic */ IncrLoadTableSavePoint this$0;

        IncrLoadTableBuilderListener(IncrLoadTableSavePoint this$0) {
            IncrLoadTableSavePoint incrLoadTableSavePoint = this$0;
            Objects.requireNonNull(incrLoadTableSavePoint);
            this.this$0 = incrLoadTableSavePoint;
        }

        @Override
        public boolean onNewRow(OlapBuilderContext context, IOlapBuilderTabularDataDef originalTable, IOlapBuilderTabularDataDef tabularData, List<IOlapBuilderDataColumnDef> columns, @Nullable IOlapBuilderTablePartitionKey partition, int rowNb, IOlapBuilderTableRow data) {
            this.this$0.table.addRow(data);
            return true;
        }
    }

    class IncrLoadTableFilterListener
    implements IOlapBuilderTableFilter {
        final /* synthetic */ IncrLoadTableSavePoint this$0;

        IncrLoadTableFilterListener(IncrLoadTableSavePoint this$0) {
            IncrLoadTableSavePoint incrLoadTableSavePoint = this$0;
            Objects.requireNonNull(incrLoadTableSavePoint);
            this.this$0 = incrLoadTableSavePoint;
        }

        @Override
        public boolean acceptRow(List<IOlapBuilderDataColumnDef> columns, IOlapBuilderTableRow data) {
            IOlapBuilderDataColumnDef incrLoadColumn = this.this$0.getIncrLoadColumn(columns);
            Comparable cell = data.getJavaNativeDataValue(incrLoadColumn);
            if (cell == null) {
                throw new CdShouldNotBeHereProgrammingException("NULL not supported in incremental load column");
            }
            return this.this$0.marker_.onNewRowForLoadingMarker(columns, data, cell);
        }
    }
}

