/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.goodies.incrload;

import crazydev.iccube.builder.OlapBuilderBaseToNoBaseMapper;
import crazydev.iccube.builder.OlapBuilderContext;
import crazydev.iccube.builder.OlapBuilderLoadMeasureGroupContext;
import crazydev.iccube.builder.datasource.buffer.OlapBuilderBufferDataSource;
import crazydev.iccube.builder.datasource.buffer.OlapBuilderFakeDataTable;
import crazydev.iccube.builder.datasource.empty.OlapBuilderEmptyDataTable;
import crazydev.iccube.builder.model.def.IOlapBuilderDataColumnDef;
import crazydev.iccube.builder.model.def.IOlapBuilderDataSource;
import crazydev.iccube.builder.model.def.IOlapBuilderDataTableDef;
import crazydev.iccube.builder.model.def.IOlapBuilderSchemaDef;
import crazydev.iccube.builder.model.impl.table.OlapBuilderBaseDataTable;
import crazydev.iccube.enums.OlapIncrementalLoadStrategy;
import crazydev.iccube.olap.component.context.IOlapContextLoggers;
import crazydev.iccube.olap.goodies.incrload.IncrLoadInstanceManager;
import crazydev.iccube.olap.goodies.incrload.IncrLoadPhase;
import crazydev.iccube.olap.goodies.incrload.IncrLoadRealTimeInstanceManager;
import crazydev.iccube.olap.goodies.incrload.IncrLoadTableSavePoint;
import crazydev.iccube.olap.loggers.OlapLoggers;
import crazydev.iccube.olap.schema.stats.OlapSavePointStats;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.io.IOUtils;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.Nullable;

public class IncrLoadSavePoints {
    private final AtomicReference<IncrLoadInstanceManager> manager = new AtomicReference();
    private final String schemaName;
    private final Map<String, IncrLoadTableSavePoint> savePoints = new HashMap<String, IncrLoadTableSavePoint>();
    private final OlapBuilderBaseToNoBaseMapper baseMapper;
    private IncrLoadPhase phase;
    private boolean deActivatedOnError;

    public IncrLoadSavePoints(IncrLoadInstanceManager manager, String schemaName) {
        this.manager.set(manager);
        this.schemaName = schemaName;
        this.phase = IncrLoadPhase.FULL_LOAD;
        this.baseMapper = new OlapBuilderBaseToNoBaseMapper();
    }

    public long sizeOf() {
        return this.baseMapper.sizeOf();
    }

    public void upgradeToRealTime() {
        IncrLoadInstanceManager manager_ = this.manager.get();
        if (!manager_.isRealTime()) {
            this.manager.set(new IncrLoadRealTimeInstanceManager());
        }
    }

    public IncrLoadInstanceManager getManager() {
        return this.manager.get();
    }

    public void onFullLoadStartDataProcessing(OlapBuilderContext context, IOlapBuilderDataTableDef table) {
        if (this.phase == IncrLoadPhase.FULL_LOAD && !(table instanceof OlapBuilderEmptyDataTable)) {
            IncrLoadTableSavePoint savePoint = this.savePoints.get(table.getId());
            if (savePoint == null) {
                savePoint = new IncrLoadTableSavePoint(table);
                IOlapContextLoggers loggers = context.getLoggers();
                Logger logger = loggers.incrLoad();
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("[incr-load] create save point for table [" + table.getName() + "] [" + table.getId() + "]"));
                }
                this.savePoints.put(table.getId(), savePoint);
            }
            savePoint.onFullLoadStartDataProcessing(table);
        }
    }

    public void addListener(IOlapBuilderDataTableDef dataTable) {
        OlapIncrementalLoadStrategy loadStrategy = dataTable.getIncrementalLoadStrategy();
        if (loadStrategy != null && loadStrategy.loadDataOnIncrementalLoad()) {
            IncrLoadTableSavePoint savePoint = this.savePoints.get(dataTable.getId());
            savePoint.addListener((OlapBuilderBaseDataTable)dataTable);
        }
    }

    public void onIncrLoadFinishAllDataProcessing(OlapBuilderContext context) {
        for (IncrLoadTableSavePoint savePoint : this.savePoints.values()) {
            savePoint.onIncrLoadFinishAllDataProcessing();
        }
        IOlapContextLoggers loggers = context.getLoggers();
        Logger logger = loggers.incrLoad();
        this.debugMarkers(logger, "incr. load processing completed");
    }

    @Nullable
    public IncrLoadTableSavePoint getIncrLoadTableSavePoint(String tableID) {
        return this.savePoints.get(tableID);
    }

    public OlapBuilderBufferDataSource createDataSource(IOlapBuilderSchemaDef schemaDef) {
        HashSet<String> uniqueUUIDs = new HashSet<String>();
        OlapBuilderBufferDataSource ds = new OlapBuilderBufferDataSource();
        for (IncrLoadTableSavePoint savePoint : this.savePoints.values()) {
            OlapBuilderBaseDataTable table = savePoint.getTable();
            ds.addTable(table);
            uniqueUUIDs.add(table.getId());
        }
        List<IOlapBuilderDataSource> dataSources = schemaDef.getDataSources();
        for (IOlapBuilderDataSource dataSource : dataSources) {
            List dataTables = dataSource.getTables();
            for (IOlapBuilderDataTableDef dataTable : dataTables) {
                String uuid = dataTable.getId();
                if (uniqueUUIDs.contains(uuid)) continue;
                ds.addTable(IncrLoadSavePoints.createFakeTable(dataTable));
                uniqueUUIDs.add(uuid);
            }
        }
        return ds;
    }

    private static IOlapBuilderDataTableDef createFakeTable(IOlapBuilderDataTableDef original) {
        String id = original.getId();
        String name = original.getName() + " (Fake)";
        List<IOlapBuilderDataColumnDef> columns = original.getAllColumns();
        return new OlapBuilderFakeDataTable(id, name, columns);
    }

    public boolean hasData() {
        for (IncrLoadTableSavePoint savePoint : this.savePoints.values()) {
            if (!savePoint.hasData()) continue;
            return true;
        }
        return false;
    }

    public boolean handlesTable(IOlapBuilderDataTableDef dataTable) {
        return this.savePoints.containsKey(dataTable.getId());
    }

    public IncrLoadPhase getPhase() {
        return this.phase;
    }

    public void setPhase(IncrLoadPhase phase) {
        this.phase = phase;
    }

    @Nullable
    public Comparable getIncrementalLoadMarker(IOlapBuilderDataTableDef table) {
        IncrLoadTableSavePoint savePoint = this.savePoints.get(table.getId());
        if (savePoint == null) {
            return null;
        }
        Comparable marker = savePoint.getMarker();
        return marker;
    }

    public void removeAllListeners() {
        for (IncrLoadTableSavePoint savePoint : this.savePoints.values()) {
            OlapBuilderBaseDataTable table = savePoint.getTable();
            if (table == null) continue;
            table.clearAllListeners();
            table.clearAllRowFilters();
        }
    }

    public void cleanup() {
        this.removeAllListeners();
        for (IncrLoadTableSavePoint savePoint : this.savePoints.values()) {
            savePoint.cleanup();
        }
    }

    public OlapBuilderBaseToNoBaseMapper getBaseMapper() {
        return this.baseMapper;
    }

    public void debugMarkers(Logger logger, String step) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("[incr-load] markers (" + this.savePoints.size() + ") on " + step));
            for (IncrLoadTableSavePoint savePoint : this.savePoints.values()) {
                OlapBuilderBaseDataTable table = savePoint.getTable();
                String marker = savePoint.getMarkerDebugInfo();
                logger.debug((Object)("[incr-load] save point for table [" + table.getName() + "] [" + table.getId() + "] " + marker));
            }
        }
    }

    public boolean isIncrLoadDeActivatedOnError() {
        return this.deActivatedOnError;
    }

    public void deActivateIncrLoadOnError() {
        this.deActivatedOnError = true;
    }

    public boolean redefinesTables() {
        for (IncrLoadTableSavePoint savePoint : this.savePoints.values()) {
            if (!savePoint.redefinesTables()) continue;
            return true;
        }
        return false;
    }

    public void updateIncrLoadSavePoints(OlapBuilderLoadMeasureGroupContext context, IOlapBuilderDataTableDef tableDef, IncrLoadTableSavePoint savePoint) {
        Logger logger = context.getSchemaLogger();
        OlapBuilderBaseDataTable savePointTableDef = savePoint.getTable();
        String tableDefId = tableDef.getId();
        String savePointTableDefId = savePointTableDef.getId();
        String tableDefName = tableDef.getName();
        String savePointTableDefName = savePointTableDef.getName();
        if (!tableDefId.equals(savePointTableDefId)) {
            throw new RuntimeException("internal error: inconsistent table (" + tableDefName + "/" + savePointTableDefName + ") IDs (" + tableDefId + "/" + savePointTableDefId + ")");
        }
        IncrLoadTableSavePoint existingSavePoint = this.savePoints.get(tableDefId);
        if (existingSavePoint == null) {
            throw new RuntimeException("internal error: missing incr. load save point for table (" + tableDefName + "/" + tableDefId + ")");
        }
        if (logger.isInfoEnabled()) {
            logger.info((Object)("[schema] " + context.commandForLogsAndErrors() + " update incr. load save point [facts:" + tableDef.getName() + "] " + savePoint.getMarkerDebugInfo()));
        }
        existingSavePoint.updateMarker(savePoint);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save(File dir) throws IOException {
        OlapLoggers.BACKUP.info((Object)("[backup] saving incr. load save points [" + this.savePoints.size() + "] for schema [" + this.schemaName + "]"));
        DataOutputStream out = null;
        try {
            out = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(new File(dir, "save-points.icc-data"))));
            out.writeInt(this.savePoints.size());
            for (Map.Entry<String, IncrLoadTableSavePoint> entry : this.savePoints.entrySet()) {
                IncrLoadTableSavePoint savePoint = entry.getValue();
                String tableId = entry.getKey();
                OlapLoggers.BACKUP.info((Object)("[backup] saving incr. load save point [" + savePoint.getTable().getName() + "] [" + tableId + "]"));
                out.writeUTF(tableId);
                savePoint.saveMarker(out);
            }
            out.flush();
            out.close();
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(out);
            throw throwable;
        }
        IOUtils.closeQuietly((OutputStream)out);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void restore(File dir, List<IOlapBuilderDataTableDef> tables) throws IOException {
        DataInputStream in = null;
        try {
            in = new DataInputStream(new BufferedInputStream(new FileInputStream(new File(dir, "save-points.icc-data"))));
            int count = in.readInt();
            for (int ii = 0; ii < count; ++ii) {
                String tableId = in.readUTF();
                IncrLoadTableSavePoint savePoint = this.savePoints.get(tableId);
                if (savePoint == null) {
                    savePoint = this.createSavePointOnRestore(tables, tableId);
                }
                if (savePoint == null) {
                    throw new IOException("missing save-point for table [" + tableId + "]");
                }
                savePoint.restoreMarker(in);
            }
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(in);
            throw throwable;
        }
        IOUtils.closeQuietly((InputStream)in);
    }

    @Nullable
    private IncrLoadTableSavePoint createSavePointOnRestore(List<IOlapBuilderDataTableDef> tables, String tableId) {
        for (IOlapBuilderDataTableDef table : tables) {
            if (!table.getId().equals(tableId)) continue;
            return this.savePoints.computeIfAbsent(table.getId(), key -> new IncrLoadTableSavePoint(table));
        }
        OlapLoggers.BACKUP.error((Object)("[backup] missing save-point table [" + tableId + "]"));
        return null;
    }

    @Nullable
    public List<OlapSavePointStats> createStats() {
        ArrayList<OlapSavePointStats> stats = new ArrayList<OlapSavePointStats>();
        for (Map.Entry<String, IncrLoadTableSavePoint> entry : this.savePoints.entrySet()) {
            String tableId = entry.getKey();
            IncrLoadTableSavePoint savePoint = entry.getValue();
            String marker = savePoint.createStats();
            if (marker == null) continue;
            stats.add(new OlapSavePointStats(tableId, marker));
        }
        return stats;
    }
}

