/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.goodies.incrload;

import crazydev.iccube.builder.factory.schema.IOlapBuilderSchemaDefFactory;
import crazydev.iccube.olap.component.context.OlapEngineRequestContext;
import crazydev.iccube.olap.goodies.incrload.IncrLoadLimitedInstanceManager;
import crazydev.iccube.olap.goodies.incrload.IncrLoadRealTimeInstanceManager;
import java.util.concurrent.TimeUnit;

public abstract class IncrLoadInstanceManager {
    public static IncrLoadInstanceManager setup(OlapEngineRequestContext requestContext, IOlapBuilderSchemaDefFactory factory) {
        if (factory.isMonitoring()) {
            return new IncrLoadRealTimeInstanceManager();
        }
        if (requestContext.isRealTimeLicensed()) {
            return new IncrLoadRealTimeInstanceManager();
        }
        int perDayLimit = requestContext.getIncrLoadCountPerDayLimit();
        if (Integer.MAX_VALUE == perDayLimit) {
            return new IncrLoadRealTimeInstanceManager();
        }
        return new IncrLoadLimitedInstanceManager(TimeUnit.DAYS.toMillis(1L), perDayLimit);
    }

    public abstract boolean isRealTime();

    public abstract void onIncrLoadSucceeded();

    public abstract boolean acceptIncrLoad();

    public abstract String incrLoads();
}

