/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.goodies.incrload;

import crazydev.iccube.builder.model.def.IOlapBuilderDataColumnDef;
import crazydev.iccube.builder.model.def.IOlapBuilderTableRow;
import crazydev.iccube.builder.offline.common.OlapBuilderOfflineSerializer;
import crazydev.iccube.olap.goodies.incrload.IncrLoadMarker;
import crazydev.iccube.olap.goodies.incrload.IncrLoadTableSavePoint;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class IncrLoadDefaultMarker
extends IncrLoadMarker {
    private Comparable loadingMarker;
    private Comparable marker;

    public IncrLoadDefaultMarker(IncrLoadTableSavePoint savePoint) {
        super(savePoint);
    }

    public Comparable getLoadingMarker() {
        return this.loadingMarker;
    }

    public Comparable getMarker() {
        return this.marker;
    }

    @Override
    public void setMarker(IncrLoadMarker marker) {
        if (marker instanceof IncrLoadDefaultMarker) {
            this.loadingMarker = null;
            this.marker = ((IncrLoadDefaultMarker)marker).marker;
            return;
        }
        throw new RuntimeException("internal error : incr. load marker type mismatch [" + marker.getClass().getName() + "]");
    }

    @Override
    @Nullable
    public String createStats() {
        if (this.marker == null) {
            return null;
        }
        return " : " + String.valueOf(this.marker);
    }

    @Override
    public String getMarkerDebugInfo() {
        return "[" + String.valueOf(this.marker) + "]";
    }

    @Override
    public void toggleLoadingMarker() {
        this.toggleLoadingMarker(this.savePoint.hasData());
    }

    public void toggleLoadingMarker(boolean hasData) {
        if (hasData) {
            this.marker = this.loadingMarker;
        }
        this.loadingMarker = null;
    }

    @Override
    public void resetLoadingMarker() {
        this.loadingMarker = null;
    }

    @Override
    public boolean onNewRowForLoadingMarker(List<IOlapBuilderDataColumnDef> columns, IOlapBuilderTableRow row, Comparable cell) {
        if (this.marker == null || cell.compareTo(this.marker) > 0) {
            this.loadingMarker = this.setMarker(cell, this.loadingMarker);
            return true;
        }
        return false;
    }

    @Override
    public boolean onNewRowForMarker(List<IOlapBuilderDataColumnDef> columns, IOlapBuilderTableRow row, Comparable cell) {
        this.marker = this.setMarker(cell, this.marker);
        return true;
    }

    @Override
    public void save(DataOutputStream out) throws IOException {
        OlapBuilderOfflineSerializer.Serializer serializer = OlapBuilderOfflineSerializer.getSerializerForNativeValue(this.marker);
        serializer.write(out, this.marker);
    }

    @Override
    public void restore(DataInputStream in) throws IOException {
        byte type = in.readByte();
        OlapBuilderOfflineSerializer.Serializer serializer = OlapBuilderOfflineSerializer.getSerializerForType(type);
        this.marker = serializer.read(in);
        this.loadingMarker = null;
    }

    private Comparable setMarker(Comparable cell, Comparable marker) {
        return marker == null ? cell : (cell == null ? marker : (cell.compareTo(marker) > 0 ? cell : marker));
    }
}

