/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.goodies.drillthrough.returns;

import crazydev.iccube.exception.OlapErrorCode;
import crazydev.iccube.mdx.parser.ast.expression.drillthrough.MdxDrillthroughIdentifierReturnExpression;
import crazydev.iccube.mdx.parser.ast.expression.id.MdxIdentifierExpression;
import crazydev.iccube.olap.component.naming.OlapNameContext;
import crazydev.iccube.olap.entity.OlapEntity;
import crazydev.iccube.olap.entity.dimension.OlapDimension;
import crazydev.iccube.olap.entity.member.OlapMeasureMember;
import crazydev.iccube.olap.eval.exception.OlapEvaluationException;
import crazydev.iccube.olap.eval.id.OlapIdentifierInstr;
import crazydev.iccube.olap.eval.instr.OlapInstr;
import crazydev.iccube.olap.eval.select.context.OlapEvaluationContext;
import crazydev.iccube.olap.goodies.drillthrough.OlapDrillthroughReturn;
import crazydev.iccube.olap.goodies.drillthrough.OlapDrillthroughReturnProcessor;
import crazydev.iccube.olap.goodies.drillthrough.processor.OlapDrillthroughMeasureReturnProcessor;
import crazydev.iccube.olap.goodies.drillthrough.processor.OlapDrillthroughMultiKeyReturnProcessor;
import crazydev.iccube.olap.goodies.drillthrough.processor.OlapDrillthroughNameReturnProcessor;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class OlapDrillthroughIdentifierReturn
extends OlapDrillthroughReturn {
    private final MdxIdentifierExpression id;
    private final OlapInstr attributeInstr;
    @Nullable
    private OlapDimension dimension;
    @Nullable
    private Boolean dimensionNameOnly;
    @Nullable
    private Boolean dimensionKeyOnly;
    @Nullable
    private OlapMeasureMember measure;

    public OlapDrillthroughIdentifierReturn(MdxDrillthroughIdentifierReturnExpression returnExpression, OlapInstr attributeInstr) {
        super(returnExpression);
        this.id = returnExpression.getIdentifier();
        this.attributeInstr = attributeInstr;
    }

    @Override
    public void setup(OlapEvaluationContext context) {
        OlapEntity attribute = null;
        try {
            attribute = this.attributeInstr.execute(context);
        }
        catch (OlapEvaluationException ex) {
            if (ex.isCausedBy(OlapErrorCode.UNKNOWN_ENTITY) && (attribute = this.executeForNameKey(context)) != null) {
                return;
            }
            throw ex;
        }
        if (attribute instanceof OlapDimension) {
            this.dimension = (OlapDimension)attribute;
        } else if (attribute instanceof OlapMeasureMember) {
            this.measure = (OlapMeasureMember)attribute;
        } else {
            throw new OlapEvaluationException(this.getLocationRange(), OlapErrorCode.DRILLTHROUGH_DIM_ATTRIBUTE_TYPE_MISMATCH, new Serializable[]{this.returnExpression.asMdx()});
        }
    }

    @Nullable
    private OlapEntity executeForNameKey(OlapEvaluationContext context) {
        boolean forKey;
        boolean forName;
        OlapIdentifierInstr instr;
        if (!(this.attributeInstr instanceof OlapIdentifierInstr)) {
            return null;
        }
        if (this.id.isLastPartDefinedAsKey()) {
            return null;
        }
        String lastPart = this.id.getLastPartAsString();
        if (lastPart.equalsIgnoreCase("name")) {
            instr = ((OlapIdentifierInstr)this.attributeInstr).removeLastPart();
            forName = true;
            forKey = false;
        } else if (lastPart.toLowerCase().startsWith("key")) {
            instr = ((OlapIdentifierInstr)this.attributeInstr).removeLastPart();
            forName = false;
            forKey = true;
        } else {
            instr = null;
            forName = false;
            forKey = false;
        }
        if (instr == null) {
            return null;
        }
        try {
            OlapEntity attribute = instr.execute(context);
            if (attribute instanceof OlapDimension) {
                this.dimension = (OlapDimension)attribute;
                if (forName) {
                    this.dimensionNameOnly = true;
                } else if (forKey) {
                    this.dimensionKeyOnly = true;
                }
                return attribute;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    @Override
    public List<OlapDrillthroughReturnProcessor> createProcessors(OlapNameContext nameContext) {
        if (this.dimension != null) {
            return OlapDrillthroughIdentifierReturn.createProcessors(nameContext, true, this.getUserDefinedColumnName(), this.dimension, this.dimensionNameOnly, this.dimensionKeyOnly);
        }
        if (this.measure != null) {
            return OlapDrillthroughIdentifierReturn.createProcessors(nameContext, true, this.getUserDefinedColumnName(), this.measure);
        }
        throw new RuntimeException("internal error: inconsistent drillthrough processing");
    }

    public static List<OlapDrillthroughReturnProcessor> createProcessors(OlapNameContext nameContext, boolean specifiedInRequest, @Nullable String userDefinedName, OlapDimension dimension) {
        return OlapDrillthroughIdentifierReturn.createProcessors(nameContext, specifiedInRequest, userDefinedName, dimension, null, null);
    }

    public static List<OlapDrillthroughReturnProcessor> createProcessors(OlapNameContext nameContext, boolean specifiedInRequest, @Nullable String userDefinedName, OlapDimension dimension, @Nullable Boolean dimensionNameOnly, @Nullable Boolean dimensionKeyOnly) {
        ArrayList<OlapDrillthroughReturnProcessor> processors = new ArrayList<OlapDrillthroughReturnProcessor>();
        if (dimensionNameOnly == null || !dimensionNameOnly.booleanValue()) {
            processors.add(new OlapDrillthroughMultiKeyReturnProcessor(nameContext, specifiedInRequest, userDefinedName, false, dimension));
        }
        if (dimensionKeyOnly == null || !dimensionKeyOnly.booleanValue()) {
            processors.add(new OlapDrillthroughNameReturnProcessor(nameContext, specifiedInRequest, userDefinedName, false, dimension));
        }
        return processors;
    }

    public static List<OlapDrillthroughReturnProcessor> createProcessors(OlapNameContext nameContext, boolean specifiedInRequest, @Nullable String userDefinedName, OlapMeasureMember measure) {
        ArrayList<OlapDrillthroughReturnProcessor> processors = new ArrayList<OlapDrillthroughReturnProcessor>();
        processors.add(new OlapDrillthroughMeasureReturnProcessor(nameContext, specifiedInRequest, userDefinedName, measure));
        return processors;
    }
}

