/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.goodies.drillthrough;

import crazydev.iccube.olap.component.naming.OlapNameContext;
import crazydev.iccube.olap.entity.OlapEmptyEntity;
import crazydev.iccube.olap.entity.dimension.OlapDimension;
import crazydev.iccube.olap.entity.member.OlapMeasureMember;
import crazydev.iccube.olap.entity.member.OlapMember;
import crazydev.iccube.olap.entity.scalar.OlapScalarEntity;
import crazydev.iccube.olap.entity.scalar.OlapStringEntity;
import crazydev.iccube.olap.entity.tuple.IOlapMembers;
import crazydev.iccube.olap.entity.tuple.OlapRegularTuple;
import crazydev.iccube.olap.entity.tuple.OlapTuple;
import crazydev.iccube.olap.eval.execinstr.gf.context.GFContext;
import java.util.Arrays;
import java.util.Set;
import org.jetbrains.annotations.Nullable;

public abstract class OlapDrillthroughReturnProcessor {
    public static final OlapScalarEntity[] EMPTY = new OlapScalarEntity[]{OlapEmptyEntity.INSTANCE};
    protected final OlapNameContext nameContext;
    @Nullable
    protected final String userDefinedName;
    private final boolean specifiedInRequest;

    public OlapDrillthroughReturnProcessor(OlapNameContext nameContext, boolean specifiedInRequest, @Nullable String userDefinedName) {
        this.nameContext = nameContext;
        this.specifiedInRequest = specifiedInRequest;
        this.userDefinedName = userDefinedName;
    }

    public boolean isSpecifiedInRequest() {
        return this.specifiedInRequest;
    }

    public boolean isRowId() {
        return false;
    }

    public boolean isForCell() {
        return false;
    }

    public boolean isForCalcMember() {
        return false;
    }

    public boolean isForMember() {
        return false;
    }

    public boolean isForIndexingDimension(Set<OlapDimension> indexingDimensions) {
        return false;
    }

    @Nullable
    public OlapDimension getAttachedDimension() {
        return null;
    }

    @Nullable
    public OlapMeasureMember getAttachedMeasure() {
        return null;
    }

    public abstract String[] getColumnIdentifier();

    public String[] getColumnIdentifierEx() {
        if (this.userDefinedName == null) {
            return this.getColumnIdentifier();
        }
        return new String[]{this.userDefinedName};
    }

    public OlapScalarEntity[] getEmptyValues() {
        String[] ids = this.getColumnIdentifier();
        Object[] values = new OlapScalarEntity[ids.length];
        Arrays.fill(values, OlapEmptyEntity.INSTANCE);
        return values;
    }

    public abstract OlapScalarEntity[] processIndexColumn(@Nullable OlapMember var1);

    public abstract OlapScalarEntity processIndexColumn(GFContext var1, int var2);

    protected OlapScalarEntity asString(GFContext context, @Nullable OlapTuple tuple) {
        if (tuple == null) {
            return OlapEmptyEntity.INSTANCE;
        }
        String value = OlapRegularTuple.toMdxString(tuple, context.getNameContext(), true, 512);
        return new OlapStringEntity(value);
    }

    protected OlapScalarEntity asString(GFContext context, @Nullable IOlapMembers tuple) {
        if (tuple == null) {
            return OlapEmptyEntity.INSTANCE;
        }
        String value = OlapRegularTuple.toMdxString(tuple, context.getNameContext(), true, 512);
        return new OlapStringEntity(value);
    }
}

