/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.goodies.drillthrough;

import crazydev.common.exception.ICdException;
import crazydev.iccube.configuration.component.properties.OlapProperties;
import crazydev.iccube.configuration.component.properties.OlapProperty;
import crazydev.iccube.exception.OlapErrorCode;
import crazydev.iccube.exception.OlapException;
import crazydev.iccube.mdx.parser.ast.expression.annotation.MdxAnnotation;
import crazydev.iccube.olap.component.context.OlapEngineRequestContext;
import crazydev.iccube.olap.cube.OlapCube;
import crazydev.iccube.olap.entity.OlapEntity;
import crazydev.iccube.olap.entity.result.OlapResDrillthroughStatementDataSet;
import crazydev.iccube.olap.entity.result.OlapResSelectStatementDataSetT;
import crazydev.iccube.olap.entity.result.OlapResStatementDataSet;
import crazydev.iccube.olap.eval.exception.OlapEvaluationException;
import crazydev.iccube.olap.eval.instr.OlapInstrExecListener;
import crazydev.iccube.olap.eval.instr.OlapInstrLocationRange;
import crazydev.iccube.olap.eval.instr.OlapInstrVisitor;
import crazydev.iccube.olap.eval.select.OlapMdxStatementInstr;
import crazydev.iccube.olap.eval.select.OlapTopLevelSelectInstr;
import crazydev.iccube.olap.eval.select.context.OlapCubeExpressionEvaluationContext;
import crazydev.iccube.olap.eval.select.context.OlapDrillthroughStatementExecutionContext;
import crazydev.iccube.olap.eval.select.context.OlapSelectStatementExecutionContext;
import crazydev.iccube.olap.goodies.drillthrough.OlapDrillthroughCollection;
import crazydev.iccube.olap.goodies.drillthrough.OlapDrillthroughReturn;
import crazydev.iccube.olap.schema.OlapSchema;
import crazydev.iccube.request.task.IcCubeSchemaAccessLockMode;
import java.io.Serializable;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class OlapDrillthroughInstr
extends OlapMdxStatementInstr<OlapDrillthroughStatementExecutionContext> {
    private final int maxRows;
    private final OlapTopLevelSelectInstr select;
    private final List<OlapDrillthroughReturn> returns;

    public OlapDrillthroughInstr(OlapInstrLocationRange range, int maxRows, OlapTopLevelSelectInstr select, List<OlapDrillthroughReturn> returns) {
        super(range);
        this.maxRows = maxRows;
        this.select = select;
        this.returns = returns;
        select.setParent(this);
    }

    @Override
    @Nullable
    public MdxAnnotation[] getAnnotations() {
        return this.select.getAnnotations();
    }

    @Override
    public boolean isResultCacheEnabled() {
        return true;
    }

    @Override
    public IcCubeSchemaAccessLockMode getSchemaAccessLockMode() {
        return IcCubeSchemaAccessLockMode.READ;
    }

    @Override
    public String typeForError() {
        return "DRILLTHROUGH";
    }

    @Override
    public void accept(OlapInstrVisitor v) {
        if (v.visit(this)) {
            this.select.accept(v);
        }
    }

    @Override
    protected OlapDrillthroughStatementExecutionContext doSetupExecutionContext(OlapEngineRequestContext requestContext, @Nullable List<OlapProperty> properties, @Nullable OlapInstrExecListener instrExecutionListener, OlapSchema schema) {
        if (requestContext.isDrillthroughDenied(schema)) {
            throw new OlapEvaluationException(this.getLocationRange(), OlapErrorCode.DRILLTHROUGH_NOT_AUTHORIZED, new Serializable[]{schema.getName()});
        }
        OlapProperties props = requestContext.getOlapEngineProperties().override(properties);
        OlapCube cube = this.select.getExistingCube(requestContext, schema);
        OlapSelectStatementExecutionContext selectExecutionContext = new OlapSelectStatementExecutionContext(requestContext, props, this.select.getAnnotations(), null, false, false, schema, cube);
        int tidyMaxRowCount = selectExecutionContext.getTidyMaxRowCount();
        int maxRows = Math.min(tidyMaxRowCount, this.maxRows);
        return new OlapDrillthroughStatementExecutionContext(selectExecutionContext, maxRows, this.returns);
    }

    @Override
    protected OlapEntity doExecute(OlapDrillthroughStatementExecutionContext context) {
        this.assertMaxRowsValue(context);
        OlapCubeExpressionEvaluationContext evaluationContext = new OlapCubeExpressionEvaluationContext(context);
        for (OlapDrillthroughReturn drillthroughReturn : this.returns) {
            drillthroughReturn.setup(evaluationContext);
        }
        OlapResStatementDataSet res = (OlapResStatementDataSet)this.select.execute(context);
        ICdException resError = res.getException();
        if (resError != null) {
            return res;
        }
        OlapException cellError = res.getCellError();
        if (cellError != null) {
            throw cellError;
        }
        OlapDrillthroughCollection collection = context.getCollection();
        if (collection == null) {
            throw new RuntimeException("internal error : missing DRILLTHROUGH collection");
        }
        Integer tidyMaxRowCount = null;
        Boolean tidyMaxRowCountReached = null;
        if (res instanceof OlapResSelectStatementDataSetT) {
            OlapResSelectStatementDataSetT dataSet = (OlapResSelectStatementDataSetT)res;
            tidyMaxRowCount = dataSet.getTidyMaxRowCount();
            tidyMaxRowCountReached = dataSet.isTidyMaxRowCountReached();
        }
        return new OlapResDrillthroughStatementDataSet(context, res.getCubeNameForMdxAudit(), this.getLocationRange().mdx(), collection, tidyMaxRowCount, tidyMaxRowCountReached);
    }

    private void assertMaxRowsValue(OlapDrillthroughStatementExecutionContext context) {
        if (this.maxRows < 0) {
            throw new OlapEvaluationException(this.getLocationRange(), OlapErrorCode.DRILLTHROUGH_INVALID_MAXROWS, Integer.valueOf(this.maxRows));
        }
    }

    @Override
    public String toStringForDebugger() {
        return "DRILLTHROUGH ...";
    }
}

