/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.goodies.drillthrough;

import crazydev.common.exception.programming.CdProgrammingException;
import crazydev.iccube.collection.OlapIterable;
import crazydev.iccube.collection.OlapIterator;
import crazydev.iccube.collection.olapiterator.OlapCombinationIterator;
import crazydev.iccube.collection.olapiterator.OlapIteratorFactory;
import crazydev.iccube.olap.component.naming.OlapNameContext;
import crazydev.iccube.olap.cube.OlapCube;
import crazydev.iccube.olap.entity.OlapEmptyEntity;
import crazydev.iccube.olap.entity.dimension.OlapDimension;
import crazydev.iccube.olap.entity.member.OlapMeasureMember;
import crazydev.iccube.olap.entity.member.OlapMember;
import crazydev.iccube.olap.entity.permissions.IOlapDimensionsPermission;
import crazydev.iccube.olap.entity.scalar.OlapAbstractScalarEntity;
import crazydev.iccube.olap.entity.scalar.OlapScalarEntity;
import crazydev.iccube.olap.entity.scalar.OlapStringEntity;
import crazydev.iccube.olap.entity.tuple.OlapTuple;
import crazydev.iccube.olap.entity.tuple.dimensionality.OlapTupleDimensionality;
import crazydev.iccube.olap.eval.execinstr.gf.context.GFContext;
import crazydev.iccube.olap.eval.filter.dimension.OlapMemberFilter;
import crazydev.iccube.olap.eval.select.context.OlapSelectStatementExecutionContext;
import crazydev.iccube.olap.facts.IOlapFactPartitionForDrillthrough;
import crazydev.iccube.olap.facts.column.columns.OlapScalarEntityFactColumn;
import crazydev.iccube.olap.goodies.drillthrough.OlapDrillthroughCollection;
import crazydev.iccube.olap.goodies.drillthrough.OlapDrillthroughCollectionHeader;
import crazydev.iccube.olap.goodies.drillthrough.OlapDrillthroughCollectionRow;
import crazydev.iccube.olap.goodies.drillthrough.OlapDrillthroughReturn;
import crazydev.iccube.olap.goodies.drillthrough.OlapDrillthroughReturnProcessor;
import crazydev.iccube.olap.goodies.drillthrough.processor.OlapDrillthroughMeasureReturnProcessor;
import crazydev.iccube.olap.goodies.drillthrough.processor.OlapDrillthroughPartitionIdReturnProcessor;
import crazydev.iccube.olap.loggers.OlapLoggers;
import crazydev.iccube.olap.schema.OlapSchema;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.jetbrains.annotations.Nullable;

public abstract class OlapDrillthroughCollectorLogic {
    protected final OlapSelectStatementExecutionContext sContext;
    protected final IOlapDimensionsPermission permissions;
    protected final OlapCube cube;
    protected final OlapNameContext nameContext;
    protected final List<OlapDrillthroughReturn> requestedReturns;
    protected final List<IndexColumn> collectedIndexColumns = new ArrayList<IndexColumn>();
    protected final List<MeasureColumn> collectedMeasureColumns = new ArrayList<MeasureColumn>();
    protected final List<Column> collectedColumns = new ArrayList<Column>();
    protected final FactsColumn collectedFactsColumn;
    protected final Set<OlapTuple> cellTuples = new HashSet<OlapTuple>();
    private final Object globalLOCK = new Object();
    private final int maxRowCount;
    protected boolean hasCollectedCalcMember;
    private int drillthroughRowsCount;
    @Nullable
    private OlapDrillthroughCollection collection;

    public OlapDrillthroughCollectorLogic(OlapSelectStatementExecutionContext executionContext, int maxRowCount, List<OlapDrillthroughReturn> requestedReturns, FactsColumn collectedFactsColumn) {
        this.sContext = executionContext;
        this.permissions = executionContext.getDimensionsPermissions();
        this.cube = executionContext.getCube();
        this.nameContext = executionContext.getNameContext();
        this.maxRowCount = maxRowCount;
        this.requestedReturns = requestedReturns;
        this.collectedFactsColumn = collectedFactsColumn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OlapDrillthroughCollection getCollection() {
        Object object = this.globalLOCK;
        synchronized (object) {
            if (this.collection == null) {
                throw new RuntimeException("internal error : missing DRILLTHROUGH collection");
            }
            return this.collection;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onCellsEvaluationStarted(@Nullable GFContext context, @Nullable IOlapFactPartitionForDrillthrough partition, @Nullable OlapScalarEntityFactColumn column) {
        Object object = this.globalLOCK;
        synchronized (object) {
            this.doOnCellsEvaluationStarted(context, partition, column);
        }
    }

    protected abstract void doOnCellsEvaluationStarted(@Nullable GFContext var1, @Nullable IOlapFactPartitionForDrillthrough var2, @Nullable OlapScalarEntityFactColumn var3);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onCellsEvaluationDone() {
        Object object = this.globalLOCK;
        synchronized (object) {
            this.doOnCellsEvaluationDone();
            this.performMemberReverseLookup();
            for (IndexColumn indexColumn : this.collectedIndexColumns) {
                if (this.collectedFactsColumn.size() == indexColumn.entities.size()) continue;
                throw new CdProgrammingException("internal error : inconsistent drillthrough (" + this.collectedFactsColumn.size() + "/" + indexColumn.entities.size() + ")!");
            }
            this.collection = this.createCollection();
        }
    }

    protected abstract void doOnCellsEvaluationDone();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void collectRange(GFContext context, IOlapFactPartitionForDrillthrough partition, OlapScalarEntityFactColumn column, int startRowId, int endRowId) {
        if (!context.isCellEvaluation()) {
            throw new CdProgrammingException("internal error: drillthrough outside cell-evaluation!");
        }
        Object object = this.globalLOCK;
        synchronized (object) {
            for (int rowId = startRowId; rowId < endRowId; ++rowId) {
                boolean isMaxRowReached;
                boolean bl = isMaxRowReached = this.collectedFactsColumn.size() >= this.maxRowCount;
                if (isMaxRowReached) {
                    this.collectTruncatedRow();
                    continue;
                }
                this.collectNonTruncatedRow(context, partition, column, rowId);
            }
        }
    }

    private void collectNonTruncatedRow(GFContext context, IOlapFactPartitionForDrillthrough partition, OlapScalarEntityFactColumn column, int rowId) {
        try {
            for (IndexColumn collectedIndexColumn : this.collectedIndexColumns) {
                OlapDrillthroughReturnProcessor returnProcessor = collectedIndexColumn.processor;
                if (returnProcessor.isForMember()) continue;
                OlapScalarEntity entity = returnProcessor.processIndexColumn(context, rowId);
                collectedIndexColumn.add(new OlapScalarEntity[]{entity});
            }
            this.collectedFactsColumn.add(partition, column, rowId);
            this.hasCollectedCalcMember = context.getCurrentCalcMemberForDrillthrough() != null;
            OlapTuple cellTuple = context.getCellTupleForDrillthrough();
            if (cellTuple != null) {
                this.cellTuples.add(cellTuple);
            }
            ++this.drillthroughRowsCount;
        }
        catch (RuntimeException ex) {
            OlapLoggers.MDX_EVALUATION.error((Object)"DRILLTHROUGH unexpected error", (Throwable)ex);
            throw ex;
        }
    }

    private void collectTruncatedRow() {
        ++this.drillthroughRowsCount;
    }

    private OlapDrillthroughCollection createCollection() {
        if (OlapLoggers.MDX_EVALUATION.isDebugEnabled()) {
            OlapLoggers.MDX_EVALUATION.debug((Object)("[drillthrough] creating collection (" + this.drillthroughRowsCount + ")"));
        }
        int rowSize = this.setupRowPos();
        ArrayList<String> columnNames = new ArrayList<String>();
        for (Column collectedColumn : this.collectedColumns) {
            collectedColumn.getColumnName(columnNames);
        }
        OlapDrillthroughCollectionHeader collectionHeader = new OlapDrillthroughCollectionHeader(columnNames);
        ArrayList<CRow> collectionRows = new ArrayList<CRow>();
        for (int collectedRowIndex = 0; collectedRowIndex < this.collectedFactsColumn.size(); ++collectedRowIndex) {
            ArrayList<CRow> collectedRows = new ArrayList<CRow>();
            this.setupIndexColumnInfo(collectedRows, collectedRowIndex, rowSize);
            boolean done = false;
            for (int rr = 0; rr < collectedRows.size(); ++rr) {
                if (rr % 100 == 0) {
                    this.sContext.assertNotCancelling("drillthrough");
                }
                CRow collectedRow = (CRow)collectedRows.get(rr);
                if (collectionRows.size() < this.maxRowCount) {
                    if (collectedRow.entities.length != collectionHeader.size()) {
                        throw new RuntimeException("internal error : inconsistent row/header sizes [" + collectedRow.entities.length + "] [" + collectionHeader.size() + "]");
                    }
                    collectionRows.add(collectedRow);
                    continue;
                }
                done = true;
            }
            if (done) break;
        }
        this.setupPartitionInfo(collectionRows);
        this.setupMeasuresInfo(collectionRows);
        ArrayList<OlapDrillthroughCollectionRow> rows = new ArrayList<OlapDrillthroughCollectionRow>();
        for (int rr = 0; rr < collectionRows.size(); ++rr) {
            if (rr % 100 == 0) {
                this.sContext.assertNotCancelling("drillthrough");
            }
            CRow collectionRow = (CRow)collectionRows.get(rr);
            rows.add(new OlapDrillthroughCollectionRow(collectionRow.entities));
        }
        if (OlapLoggers.MDX_EVALUATION.isDebugEnabled()) {
            OlapLoggers.MDX_EVALUATION.debug((Object)("[drillthrough] creating collection (" + this.drillthroughRowsCount + ") done"));
        }
        return new OlapDrillthroughCollection(this.sContext, this.maxRowCount, collectionHeader, rows, this.drillthroughRowsCount);
    }

    private int setupRowPos() {
        boolean hasPartitioning;
        if (this.requestedReturns.isEmpty() && (hasPartitioning = this.collectedFactsColumn.hasPartitioning())) {
            this.collectedColumns.add(0, new PartitionColumn(new OlapDrillthroughPartitionIdReturnProcessor(this.nameContext, false, null)));
        }
        int cRowPos = 0;
        for (Column collectedColumn : this.collectedColumns) {
            collectedColumn.setRowPos(cRowPos);
            cRowPos += collectedColumn.processor.getColumnIdentifierEx().length;
        }
        return cRowPos;
    }

    private void setupIndexColumnInfo(List<CRow> collectedRows, int collectedRowIndex, int rowSize) {
        boolean multiRows = false;
        for (IndexColumn column : this.collectedIndexColumns) {
            OlapScalarEntity[][] allValues = column.entities.get(collectedRowIndex);
            if (allValues.length <= 1) continue;
            multiRows = true;
            break;
        }
        if (multiRows) {
            this.setupIndexedColumnInfoForMany2Many(collectedRows, collectedRowIndex, rowSize);
            return;
        }
        CRow row = new CRow(collectedRowIndex, rowSize);
        for (IndexColumn column : this.collectedIndexColumns) {
            OlapScalarEntity[] values;
            OlapScalarEntity[][] allValues = column.entities.get(collectedRowIndex);
            if (IndexColumn.NULL_ == allValues) {
                values = column.processor.getEmptyValues();
                row.set(column.getRowPos(), values);
                continue;
            }
            if (allValues.length == 1) {
                values = allValues[0];
                if (values.length == 1 && values[0].isMdxNull()) {
                    OlapScalarEntity[] emptyValues = column.processor.getEmptyValues();
                    if (emptyValues.length > 1) {
                        row.set(column.getRowPos(), emptyValues);
                        continue;
                    }
                    row.set(column.getRowPos(), values);
                    continue;
                }
                row.set(column.getRowPos(), values);
                continue;
            }
            throw new RuntimeException("internal error: inconsistent drillthrough with many-2-many processing !");
        }
        collectedRows.add(row);
    }

    private void setupIndexedColumnInfoForMany2Many(List<CRow> collectedRows, int collectedRowIndex, int rowSize) {
        Integer[] combination;
        for (IndexColumn column : this.collectedIndexColumns) {
            column.resetGroupInfo();
        }
        HashMap<OlapDimension, IndexColumns> columnByDimensions = new HashMap<OlapDimension, IndexColumns>();
        IndexColumns others = new IndexColumns();
        for (IndexColumn column : this.collectedIndexColumns) {
            OlapDimension dimension = column.processor.getAttachedDimension();
            if (dimension == null) {
                others.add(column);
                continue;
            }
            IndexColumns dimColumns = (IndexColumns)columnByDimensions.get(dimension);
            if (dimColumns == null) {
                dimColumns = new IndexColumns(dimension);
                columnByDimensions.put(dimension, dimColumns);
            }
            dimColumns.add(column);
        }
        ArrayList<Object> groups = new ArrayList<Object>();
        groups.addAll(columnByDimensions.values());
        groups.add(others);
        for (int ii = 0; ii < groups.size(); ++ii) {
            IndexColumns group = (IndexColumns)groups.get(ii);
            group.setupIndex(ii);
            group.setupRowSize(collectedRowIndex);
        }
        OlapIterable[] iterators = new OlapIterable[groups.size()];
        for (int ii = 0; ii < iterators.length; ++ii) {
            final IndexColumns group = (IndexColumns)groups.get(ii);
            iterators[ii] = new OlapIterable<Integer>(){
                {
                    Objects.requireNonNull(this$0);
                }

                @Override
                public OlapIterator<Integer> getIterator(boolean forceCache) {
                    return OlapIteratorFactory.integers(group.collectedRowSize);
                }

                @Override
                @Nullable
                public OlapTupleDimensionality getTupleDimensionality() {
                    return null;
                }

                @Override
                public long fastEstimatedSize() {
                    return group.collectedRowSize;
                }

                @Override
                public boolean mightHaveCalcMember() {
                    return false;
                }
            };
        }
        OlapCombinationIterator<Integer> combinations = new OlapCombinationIterator<Integer>(Integer.class, iterators);
        combinations.reset();
        while ((combination = combinations.next()) != null) {
            CRow row = new CRow(collectedRowIndex, rowSize);
            for (IndexColumn column : this.collectedIndexColumns) {
                IndexColumns group = column.group;
                int groupRow = combination[group.index];
                group.addEntities(row, collectedRowIndex, groupRow, column);
            }
            collectedRows.add(row);
        }
    }

    private void setupPartitionInfo(List<CRow> collectedRows) {
        int partitionColumnIdx = -1;
        for (Column collectedColumn : this.collectedColumns) {
            if (!(collectedColumn instanceof PartitionColumn)) continue;
            partitionColumnIdx = collectedColumn.getRowPos();
        }
        if (partitionColumnIdx == -1) {
            return;
        }
        for (CRow collectedRow : collectedRows) {
            int collectedRowIndex = collectedRow.collectedRowIndex;
            String partitionId = this.collectedFactsColumn.partitions.get(collectedRowIndex).dt_getPartitionId();
            OlapAbstractScalarEntity partition = partitionId == null ? OlapEmptyEntity.INSTANCE : new OlapStringEntity(partitionId);
            collectedRow.entities[partitionColumnIdx] = partition;
        }
    }

    protected abstract void setupMeasuresInfo(List<CRow> var1);

    private void performMemberReverseLookup() {
        if (OlapLoggers.MDX_EVALUATION.isDebugEnabled()) {
            OlapLoggers.MDX_EVALUATION.debug((Object)"[drillthrough] performing reverse lookup (1)");
        }
        HashMap<IOlapFactPartitionForDrillthrough, FactsRowIdColumn> factRowIdColumns = new HashMap<IOlapFactPartitionForDrillthrough, FactsRowIdColumn>();
        for (int drillthroughIndex = 0; drillthroughIndex < this.collectedFactsColumn.size(); ++drillthroughIndex) {
            this.sContext.assertNotCancelling("drillthrough");
            IOlapFactPartitionForDrillthrough facts = this.collectedFactsColumn.partitions.get(drillthroughIndex);
            FactsRowIdColumn factRowIdColumn = (FactsRowIdColumn)factRowIdColumns.get(facts);
            if (factRowIdColumn == null) {
                factRowIdColumn = new FactsRowIdColumn(facts);
                factRowIdColumns.put(facts, factRowIdColumn);
            }
            int factRowId = this.collectedFactsColumn.rowIds.getInt(drillthroughIndex);
            factRowIdColumn.add(drillthroughIndex, factRowId);
        }
        if (OlapLoggers.MDX_EVALUATION.isDebugEnabled()) {
            OlapLoggers.MDX_EVALUATION.debug((Object)"[drillthrough] performing reverse lookup (2)");
        }
        for (Map.Entry measureColumnEntry : factRowIdColumns.entrySet()) {
            IOlapFactPartitionForDrillthrough facts = (IOlapFactPartitionForDrillthrough)measureColumnEntry.getKey();
            OlapSchema schema = this.sContext.getSchema();
            List<OlapDimension> dimensions = schema.getDimensions();
            List<OlapDimension> factsIndexingDimensions = facts.dt_getIndexingDimensions(dimensions);
            for (OlapDimension factsIndexingDimension : factsIndexingDimensions) {
                List<IndexColumn> indexColumns = this.getColumns(this.collectedIndexColumns, factsIndexingDimension);
                if (indexColumns.isEmpty()) continue;
                FactsRowIdColumn factRowIdColumn = (FactsRowIdColumn)measureColumnEntry.getValue();
                MemberColumn memberColumn = this.performReverseMemberLookup(facts, factsIndexingDimension, factRowIdColumn);
                for (IndexColumn indexColumn : indexColumns) {
                    this.sContext.assertNotCancelling("drillthrough");
                    this.populateColumn(indexColumn, memberColumn);
                }
            }
        }
        if (OlapLoggers.MDX_EVALUATION.isDebugEnabled()) {
            OlapLoggers.MDX_EVALUATION.debug((Object)"[drillthrough] performing reverse lookup (3)");
        }
        for (IndexColumn column : this.collectedIndexColumns) {
            for (int idx = column.entities.size(); idx < this.collectedFactsColumn.size(); ++idx) {
                column.add(idx, IndexColumn.NULL_);
            }
        }
        if (OlapLoggers.MDX_EVALUATION.isDebugEnabled()) {
            OlapLoggers.MDX_EVALUATION.debug((Object)"[drillthrough] performing reverse lookup done");
        }
    }

    private List<IndexColumn> getColumns(List<IndexColumn> columns, OlapDimension dimension) {
        HashSet<OlapDimension> dimension_ = new HashSet<OlapDimension>();
        dimension_.add(dimension);
        ArrayList<IndexColumn> cols = new ArrayList<IndexColumn>();
        for (IndexColumn column : columns) {
            if (!column.processor.isForMember() || !column.processor.isForIndexingDimension(dimension_)) continue;
            cols.add(column);
        }
        return cols;
    }

    private MemberColumn performReverseMemberLookup(IOlapFactPartitionForDrillthrough facts, OlapDimension dimension, FactsRowIdColumn factRowIdColumn) {
        MemberColumn column;
        if (facts.dt_isForManyToMany(dimension)) {
            List<List<OlapMember>> members = facts.dt_getFactIndexingMembersForManyToMany(this.sContext, dimension, factRowIdColumn.factRowIds);
            ManyToManyMemberColumn memberColumn = new ManyToManyMemberColumn(this.permissions.getMemberFilter());
            for (int idx = 0; idx < factRowIdColumn.size(); ++idx) {
                int drillthroughIndex = factRowIdColumn.drillthroughIndices.getInt(idx);
                List<OlapMember> member = members.get(idx);
                memberColumn.add(drillthroughIndex, member);
            }
            column = memberColumn;
        } else {
            List<OlapMember> members = facts.dt_getFactIndexingMembers(dimension, factRowIdColumn.factRowIds);
            RegularMemberColumn memberColumn = new RegularMemberColumn(this.permissions.getMemberFilter());
            for (int idx = 0; idx < factRowIdColumn.size(); ++idx) {
                int drillthroughIndex = factRowIdColumn.drillthroughIndices.getInt(idx);
                OlapMember member = members.get(idx);
                memberColumn.add(drillthroughIndex, member);
            }
            column = memberColumn;
        }
        return column;
    }

    private void populateColumn(IndexColumn indexColumn, MemberColumn memberColumn) {
        block6: {
            block5: {
                if (!(memberColumn instanceof RegularMemberColumn)) break block5;
                RegularMemberColumn regularMemberColumn = (RegularMemberColumn)memberColumn;
                for (int idx = 0; idx < regularMemberColumn.size(); ++idx) {
                    this.sContext.assertNotCancelling("drillthrough");
                    int drillthroughIndex = regularMemberColumn.drillthroughIndices.getInt(idx);
                    OlapMember member = regularMemberColumn.members.get(idx);
                    OlapScalarEntity[] entities = indexColumn.processor.processIndexColumn(member);
                    indexColumn.add(drillthroughIndex, entities);
                }
                break block6;
            }
            if (!(memberColumn instanceof ManyToManyMemberColumn)) break block6;
            ManyToManyMemberColumn manyToManyMemberColumn = (ManyToManyMemberColumn)memberColumn;
            for (int idx = 0; idx < manyToManyMemberColumn.size(); ++idx) {
                OlapScalarEntity[][] allEntities;
                this.sContext.assertNotCancelling("drillthrough");
                int drillthroughIndex = manyToManyMemberColumn.drillthroughIndices.getInt(idx);
                List<OlapMember> member = manyToManyMemberColumn.members.get(idx);
                if (member != null) {
                    allEntities = new OlapScalarEntity[member.size()][];
                    for (int ii = 0; ii < member.size(); ++ii) {
                        OlapScalarEntity[] entities = indexColumn.processor.processIndexColumn(member.get(ii));
                        allEntities[ii] = entities;
                    }
                } else {
                    allEntities = IndexColumn.NULL_;
                }
                indexColumn.add(drillthroughIndex, allEntities);
            }
        }
    }

    static class FactsColumn {
        final List<IOlapFactPartitionForDrillthrough> partitions = new ArrayList<IOlapFactPartitionForDrillthrough>();
        final IntArrayList rowIds = new IntArrayList();
        private boolean hasPartitioning;

        FactsColumn() {
        }

        int size() {
            return this.partitions.size();
        }

        void add(IOlapFactPartitionForDrillthrough partition, OlapScalarEntityFactColumn column, int rowId) {
            this.partitions.add(partition);
            this.rowIds.add(rowId);
            this.hasPartitioning |= partition.dt_getPartitionId() != null;
        }

        boolean hasPartitioning() {
            return this.hasPartitioning;
        }
    }

    static class IndexColumn
    extends Column {
        static final OlapScalarEntity[][] NULL_ = new OlapScalarEntity[0][];
        final List<OlapScalarEntity[][]> entities = new ArrayList<OlapScalarEntity[][]>();
        private IndexColumns group;

        IndexColumn(OlapDrillthroughReturnProcessor processor) {
            super(processor);
        }

        void resetGroupInfo() {
            this.group = null;
        }

        void add(OlapScalarEntity[] entity) {
            OlapScalarEntity[][] entry = new OlapScalarEntity[][]{entity};
            this.entities.add(entry);
        }

        void add(int pos, OlapScalarEntity[] entity) {
            if (pos < this.entities.size()) {
                if (this.entities.get(pos) != NULL_) {
                    throw new CdProgrammingException("internal error : inconsistent drillthrough processing!");
                }
                OlapScalarEntity[][] entry = new OlapScalarEntity[][]{entity};
                this.entities.set(pos, entry);
            } else {
                for (int idx = this.entities.size(); idx < pos; ++idx) {
                    this.entities.add(NULL_);
                }
                OlapScalarEntity[][] entry = new OlapScalarEntity[][]{entity};
                this.entities.add(entry);
            }
        }

        void add(int pos, OlapScalarEntity[][] entity) {
            if (pos < this.entities.size()) {
                if (this.entities.get(pos) != NULL_) {
                    throw new CdProgrammingException("internal error : inconsistent drillthrough processing!");
                }
                this.entities.set(pos, entity);
            } else {
                for (int idx = this.entities.size(); idx < pos; ++idx) {
                    this.entities.add(NULL_);
                }
                this.entities.add(entity);
            }
        }

        void setGroup(IndexColumns group) {
            if (this.group != null) {
                throw new RuntimeException("internal error : inconsistent drillthrough with many-2-many processing : group setup ");
            }
            this.group = group;
        }

        public String toString() {
            return "" + this.entities.size();
        }
    }

    static abstract class Column {
        final OlapDrillthroughReturnProcessor processor;
        int rowPos;

        Column(OlapDrillthroughReturnProcessor processor) {
            this.processor = processor;
            this.rowPos = -1;
        }

        void getColumnName(List<String> columnNames) {
            String[] identifiers;
            for (String identifier : identifiers = this.processor.getColumnIdentifierEx()) {
                columnNames.add(identifier);
            }
        }

        int getRowPos() {
            if (this.rowPos == -1) {
                throw new RuntimeException("internal error: inconsistent drillthrough processing");
            }
            return this.rowPos;
        }

        void setRowPos(int rowPos) {
            if (this.rowPos != -1) {
                throw new RuntimeException("internal error: inconsistent drillthrough processing");
            }
            this.rowPos = rowPos;
        }
    }

    static class CRow {
        final int collectedRowIndex;
        final OlapScalarEntity[] entities;

        CRow(int collectedRowIndex, int size) {
            this.collectedRowIndex = collectedRowIndex;
            this.entities = new OlapScalarEntity[size];
        }

        void set(int rowPos, OlapScalarEntity[] values) {
            System.arraycopy(values, 0, this.entities, rowPos, values.length);
        }
    }

    static class PartitionColumn
    extends Column {
        PartitionColumn(OlapDrillthroughPartitionIdReturnProcessor processor) {
            super(processor);
        }
    }

    static class IndexColumns {
        @Nullable
        final OlapDimension dimension;
        final List<IndexColumn> columns = new ArrayList<IndexColumn>();
        int collectedRowSize = -1;
        private int index = -1;

        IndexColumns() {
            this(null);
        }

        IndexColumns(@Nullable OlapDimension dimension) {
            this.dimension = dimension;
        }

        void add(IndexColumn column) {
            column.setGroup(this);
            this.columns.add(column);
        }

        void setupIndex(int index) {
            if (this.index != -1) {
                throw new RuntimeException("internal error : inconsistent drillthrough with many-2-many processing : group index ");
            }
            this.index = index;
        }

        void setupRowSize(int collectedRowIndex) {
            if (this.dimension == null) {
                this.collectedRowSize = 1;
                return;
            }
            for (IndexColumn column : this.columns) {
                OlapScalarEntity[][] allValues = column.entities.get(collectedRowIndex);
                if (this.collectedRowSize == -1) {
                    this.collectedRowSize = Math.max(1, allValues.length);
                    continue;
                }
                if (this.collectedRowSize == allValues.length) continue;
                this.collectedRowSize = Math.max(this.collectedRowSize, allValues.length);
            }
        }

        void addEntities(CRow row, int collectedRowIndex, int groupRow, IndexColumn column) {
            int columnRowPos = column.getRowPos();
            OlapScalarEntity[][] allValues = column.entities.get(collectedRowIndex);
            if (IndexColumn.NULL_ == allValues || groupRow >= allValues.length) {
                OlapScalarEntity[] values = column.processor.getEmptyValues();
                row.set(columnRowPos, values);
            } else {
                OlapScalarEntity[] values = allValues[groupRow];
                row.set(columnRowPos, values);
            }
        }
    }

    static class FactsRowIdColumn {
        final IOlapFactPartitionForDrillthrough partition;
        final IntArrayList drillthroughIndices = new IntArrayList();
        final IntArrayList factRowIds = new IntArrayList();

        FactsRowIdColumn(IOlapFactPartitionForDrillthrough partition) {
            this.partition = partition;
        }

        int size() {
            return this.drillthroughIndices.size();
        }

        void add(int drillthroughIndex, int factRowId) {
            this.drillthroughIndices.add(drillthroughIndex);
            this.factRowIds.add(factRowId);
        }
    }

    static abstract class MemberColumn {
        @Nullable
        final OlapMemberFilter perms;
        final IntArrayList drillthroughIndices = new IntArrayList();

        MemberColumn(@Nullable OlapMemberFilter perms) {
            this.perms = perms;
        }

        @Nullable
        static OlapMember firstAcceptableMember(OlapMemberFilter perms, @Nullable OlapMember member) {
            if (member == null) {
                return null;
            }
            if (perms.isAccepting(member)) {
                return member;
            }
            return MemberColumn.firstAcceptableMember(perms, member.getParent());
        }

        int size() {
            return this.drillthroughIndices.size();
        }

        @Nullable
        OlapMember firstAcceptableMember(@Nullable OlapMember member) {
            if (this.perms == null) {
                return member;
            }
            return MemberColumn.firstAcceptableMember(this.perms, member);
        }
    }

    static class ManyToManyMemberColumn
    extends MemberColumn {
        final List<List<OlapMember>> members = new ArrayList<List<OlapMember>>();

        ManyToManyMemberColumn(@Nullable OlapMemberFilter perms) {
            super(perms);
        }

        void add(int drillthroughIndex, @Nullable List<OlapMember> collectedMembers) {
            List<OlapMember> vMembers;
            if (collectedMembers == null) {
                vMembers = null;
            } else if (this.perms == null) {
                vMembers = collectedMembers;
            } else {
                vMembers = new ArrayList<OlapMember>();
                for (OlapMember collectedMember : collectedMembers) {
                    OlapMember vMember = this.firstAcceptableMember(collectedMember);
                    if (vMember == null) continue;
                    vMembers.add(vMember);
                }
            }
            this.drillthroughIndices.add(drillthroughIndex);
            this.members.add(vMembers == null ? null : (vMembers.isEmpty() ? null : vMembers));
        }
    }

    static class RegularMemberColumn
    extends MemberColumn {
        final List<OlapMember> members = new ArrayList<OlapMember>();

        RegularMemberColumn(@Nullable OlapMemberFilter perms) {
            super(perms);
        }

        void add(int drillthroughIndex, @Nullable OlapMember collectedMember) {
            OlapMember vMember = this.firstAcceptableMember(collectedMember);
            this.drillthroughIndices.add(drillthroughIndex);
            this.members.add(vMember);
        }
    }

    static class MeasureColumn
    extends Column {
        MeasureColumn(OlapDrillthroughMeasureReturnProcessor processor) {
            super(processor);
        }

        OlapMeasureMember getMeasure() {
            return ((OlapDrillthroughMeasureReturnProcessor)this.processor).getMeasure();
        }
    }
}

