/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.goodies.drillthrough;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.Strictness;
import com.google.gson.stream.JsonWriter;
import crazydev.common.utils.CdTimeUtils;
import crazydev.iccube.olap.component.context.OlapEngineRequestContext;
import crazydev.iccube.olap.entity.result.tidy.OlapResSerializableTidyTable;
import crazydev.iccube.olap.entity.result.tidy.TidyTableClassID;
import crazydev.iccube.olap.entity.result.tidy.serialize.IOlapSerializedTidyResource;
import crazydev.iccube.olap.entity.result.tidy.serialize.OlapSerializedTidyResourceFactory;
import crazydev.iccube.olap.entity.scalar.OlapNumericEntity;
import crazydev.iccube.olap.entity.scalar.OlapScalarEntity;
import crazydev.iccube.olap.eval.cache.result.store.OlapResultStoreInformation;
import crazydev.iccube.olap.eval.select.context.OlapMdxStatementExecutionContext;
import crazydev.iccube.olap.goodies.drillthrough.OlapDrillthroughCollectionHeader;
import crazydev.iccube.olap.goodies.drillthrough.OlapDrillthroughCollectionRow;
import crazydev.iccube.tidytable.drillthrough.MdxDrillthroughTidyTableColumn;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.Date;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class OlapDrillthroughCollection
extends OlapResSerializableTidyTable {
    private final OlapMdxStatementExecutionContext sContext;
    private final int maxRowCount;
    private final List<OlapDrillthroughCollectionRow> rows;
    private final int drillthroughRowsCount;
    private OlapDrillthroughCollectionHeader header;

    public OlapDrillthroughCollection(OlapMdxStatementExecutionContext sContext, int maxRowCount, OlapDrillthroughCollectionHeader header, List<OlapDrillthroughCollectionRow> rows, int drillthroughRowsCount) {
        this.sContext = sContext;
        this.maxRowCount = maxRowCount;
        this.header = header;
        this.rows = rows;
        this.drillthroughRowsCount = drillthroughRowsCount;
    }

    public int getMaxRowCount() {
        return this.maxRowCount;
    }

    public OlapDrillthroughCollectionHeader getHeader() {
        return this.header;
    }

    public List<OlapDrillthroughCollectionRow> getRows() {
        return this.rows;
    }

    public boolean isTruncated() {
        return this.getDrillthroughRowsCount() > this.getActualCollectedRowsCount();
    }

    public int getActualCollectedRowsCount() {
        return this.rows.size();
    }

    public int getDrillthroughRowsCount() {
        return this.drillthroughRowsCount;
    }

    public double _getMeasureValueAsDouble(String measureName) {
        double value = 0.0;
        int measureColumn = -1;
        List<String> identifiers = this.header.getIdentifiers();
        for (int idx = 0; idx < identifiers.size(); ++idx) {
            String identifier = identifiers.get(idx);
            if (!identifier.equals(measureName)) continue;
            measureColumn = idx;
            break;
        }
        if (measureColumn > -1) {
            for (OlapDrillthroughCollectionRow row : this.rows) {
                OlapScalarEntity val = row.getEntities().get(measureColumn);
                if (!(val instanceof OlapNumericEntity)) continue;
                value += ((OlapNumericEntity)val).doubleValue();
            }
        }
        return value;
    }

    public Double[] _getMeasureValueAsDoubles(String measureName) {
        Double[] values = new Double[this.rows.size()];
        int measureColumn = -1;
        List<String> identifiers = this.header.getIdentifiers();
        for (int idx = 0; idx < identifiers.size(); ++idx) {
            String identifier = identifiers.get(idx);
            if (!identifier.equals(measureName)) continue;
            measureColumn = idx;
            break;
        }
        if (measureColumn > -1) {
            for (int rowIdx = 0; rowIdx < this.rows.size(); ++rowIdx) {
                OlapDrillthroughCollectionRow row = this.rows.get(rowIdx);
                OlapScalarEntity val = row.getEntities().get(measureColumn);
                if (!(val instanceof OlapNumericEntity)) continue;
                values[rowIdx] = ((OlapNumericEntity)val).doubleValue();
            }
        }
        return values;
    }

    @Nullable
    public String _getMemberFunction(String function, String dimensionName, int rowNumber) {
        int pos = -1;
        List<String> identifiers = this.header.getIdentifiers();
        for (int idx = 0; idx < identifiers.size(); ++idx) {
            String identifier = identifiers.get(idx);
            if (!identifier.startsWith(function) && !identifier.endsWith(function) || !identifier.contains("[" + dimensionName + "]")) continue;
            pos = idx;
            break;
        }
        if (pos == -1) {
            return null;
        }
        OlapDrillthroughCollectionRow row = this.getRows().get(rowNumber);
        OlapScalarEntity entity = row.getEntities().get(pos);
        return entity.asXmlaString();
    }

    @Nullable
    public String _getPartitionId(int rowNumber) {
        int pos = -1;
        List<String> identifiers = this.header.getIdentifiers();
        for (int idx = 0; idx < identifiers.size(); ++idx) {
            String identifier = identifiers.get(idx);
            if (!identifier.startsWith("PartitionId")) continue;
            pos = idx;
            break;
        }
        if (pos == -1) {
            return null;
        }
        OlapDrillthroughCollectionRow row = this.getRows().get(rowNumber);
        OlapScalarEntity entity = row.getEntities().get(pos);
        return (String)entity.asJavaNativeValue(String.class);
    }

    @Nullable
    public Integer _getRowId(int rowNumber) {
        int pos = -1;
        List<String> identifiers = this.header.getIdentifiers();
        for (int idx = 0; idx < identifiers.size(); ++idx) {
            String identifier = identifiers.get(idx);
            if (!identifier.startsWith("RowId")) continue;
            pos = idx;
            break;
        }
        if (pos == -1) {
            return null;
        }
        OlapDrillthroughCollectionRow row = this.getRows().get(rowNumber);
        OlapScalarEntity entity = row.getEntities().get(pos);
        return (Integer)entity.asJavaNativeValue(Integer.class);
    }

    @Nullable
    public String _getMember(String function, int rowNumber) {
        int pos = -1;
        List<String> identifiers = this.header.getIdentifiers();
        for (int idx = 0; idx < identifiers.size(); ++idx) {
            String identifier = identifiers.get(idx);
            if (!identifier.startsWith(function)) continue;
            pos = idx;
            break;
        }
        if (pos == -1) {
            return null;
        }
        OlapDrillthroughCollectionRow row = this.getRows().get(rowNumber);
        OlapScalarEntity entity = row.getEntities().get(pos);
        return entity.asXmlaString();
    }

    @Nullable
    public String _getMemberName(String dimensionName, int rowNumber) {
        int pos = -1;
        List<String> identifiers = this.header.getIdentifiers();
        for (int idx = 0; idx < identifiers.size(); ++idx) {
            String identifier = identifiers.get(idx);
            if (!identifier.equals(dimensionName) && (!identifier.startsWith("[" + dimensionName + "]") || !identifier.endsWith(".Name")) && (!identifier.startsWith("Name") || !identifier.contains("[" + dimensionName + "]"))) continue;
            pos = idx;
            break;
        }
        if (pos == -1) {
            return null;
        }
        OlapDrillthroughCollectionRow row = this.getRows().get(rowNumber);
        OlapScalarEntity entity = row.getEntities().get(pos);
        return entity.asXmlaString();
    }

    @Nullable
    public String _getMemberKey(String dimensionName, int key, int rowNumber) {
        int pos = -1;
        List<String> identifiers = this.header.getIdentifiers();
        for (int idx = 0; idx < identifiers.size(); ++idx) {
            String identifier = identifiers.get(idx);
            if (!identifier.startsWith("[" + dimensionName + "]") || !identifier.endsWith(".Key" + key)) continue;
            pos = idx;
            break;
        }
        if (pos == -1) {
            return null;
        }
        OlapDrillthroughCollectionRow row = this.getRows().get(rowNumber);
        OlapScalarEntity entity = row.getEntities().get(pos);
        return entity.asXmlaString();
    }

    public IOlapSerializedTidyResource serializeAsJson(OlapEngineRequestContext context, int tidyMaxRowCount, boolean tidyMaxRowCountReached, @Nullable OlapResultStoreInformation info) throws IOException {
        return OlapSerializedTidyResourceFactory.create(OlapSerializedTidyResourceFactory.Prefix.mdx, context, out -> {
            JsonWriter w = new JsonWriter((Writer)new BufferedWriter(new OutputStreamWriter(out, StandardCharsets.UTF_8)));
            GsonBuilder gsonB = new GsonBuilder();
            w.setStrictness(Strictness.LENIENT);
            gsonB.serializeSpecialFloatingPointValues();
            Gson gson = gsonB.create();
            this.serializeTable(w, gson, context, true, tidyMaxRowCount, tidyMaxRowCountReached, info);
            w.close();
        });
    }

    public void serializeTable(JsonWriter w, Gson g, OlapEngineRequestContext context, boolean json, int tidyMaxRowCount, boolean tidyMaxRowCountReached, @Nullable OlapResultStoreInformation info) throws IOException {
        int rowCount = this.rows.size();
        w.beginObject();
        this.serialize(w, "classID", TidyTableClassID.MDX_DRILLTHROUGH_TABLE.name());
        this.serialize(w, "rowCount", rowCount);
        this.serialize(w, "tidyMaxRowCount", tidyMaxRowCount);
        this.serialize(w, "tidyMaxRowCountReached", tidyMaxRowCountReached);
        this.serializeQuery(w, context);
        if (rowCount > 0) {
            this.serializeColumns(w, g, context, json);
        }
        w.endObject();
    }

    protected void serializeQuery(JsonWriter w, OlapEngineRequestContext context) throws IOException {
        String schemaName = this.sContext.getSchemaName();
        Date schemaLastRefreshTimestamp = this.sContext.getNullableSchemaLastRefreshTimestamp();
        Date schemaLastDataUpdateTimestamp = this.sContext.getNullableSchemaLastDataUpdateTimestamp();
        w.name("query");
        w.beginObject();
        this.serialize(w, "schemaName", schemaName);
        if (schemaLastRefreshTimestamp != null) {
            this.serialize(w, "schemaLastRefreshTimestamp", schemaLastRefreshTimestamp.getTime());
            this.serialize(w, "schemaLastRefreshTime_ISO_8601", CdTimeUtils.formatServerTimeForJavascript((Date)schemaLastRefreshTimestamp));
        }
        if (schemaLastDataUpdateTimestamp != null) {
            this.serialize(w, "schemaLastDataUpdateTimestamp", schemaLastDataUpdateTimestamp.getTime());
            this.serialize(w, "schemaLastDataUpdateTime_ISO_8601", CdTimeUtils.formatServerTimeForJavascript((Date)schemaLastDataUpdateTimestamp));
        }
        w.endObject();
    }

    private void serializeColumns(JsonWriter w, Gson g, OlapEngineRequestContext context, boolean json) throws IOException {
        w.name("columns");
        w.beginArray();
        List<String> identifiers = this.header.getIdentifiers();
        for (int cc = 0; cc < identifiers.size(); ++cc) {
            context.assertNotCancelling("materialized-tidy:create-columns");
            this.serializeColumn(w, g, context, json, cc);
        }
        w.endArray();
    }

    private void serializeColumn(JsonWriter w, Gson g, OlapEngineRequestContext context, boolean json, int cc) throws IOException {
        MdxDrillthroughTidyTableColumn column = new MdxDrillthroughTidyTableColumn(this.header.getIdentifiers().get(cc));
        for (int rr = 0; rr < this.rows.size(); ++rr) {
            OlapDrillthroughCollectionRow row = this.rows.get(rr);
            List<OlapScalarEntity> rowEntities = row.getEntities();
            OlapScalarEntity columnEntity = rowEntities.get(cc);
            column.addScalarEntity(columnEntity);
        }
        column.inferType();
        column.compact();
        column.freeze();
        if (json) {
            column.setNaN();
        }
        String cellsJ = g.toJson((Object)column);
        w.jsonValue(cellsJ);
    }
}

