/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.goodies.debugger.model;

import crazydev.iccube.olap.component.naming.OlapNameContext;
import crazydev.iccube.olap.entity.OlapEntity;
import crazydev.iccube.olap.eval.execinstr.OlapPreparedInstr;
import crazydev.iccube.olap.eval.instr.OlapInstrLocationRange;
import crazydev.iccube.olap.goodies.debugger.OlapMdxDebugNodeCollector;
import crazydev.iccube.olap.goodies.debugger.model.OlapMdxDebugNode;
import org.jetbrains.annotations.Nullable;

public class OlapMdxDebugPreparedInstrNode
extends OlapMdxDebugNode {
    private final OlapPreparedInstr pInstr;
    private OlapEntity result;
    @Nullable
    private RuntimeException exception;

    public OlapMdxDebugPreparedInstrNode(OlapMdxDebugNodeCollector collector, OlapMdxDebugNode parentNode, OlapPreparedInstr pInstr) {
        super(collector, parentNode);
        this.pInstr = pInstr;
    }

    public void addResult(OlapEntity result) {
        this.result = result.asConstant();
    }

    public void addError(RuntimeException exception) {
        this.exception = exception;
    }

    @Override
    public String getTitle(OlapNameContext nameContext) {
        return this.pInstr.toStringForDebugger();
    }

    @Override
    protected OlapMdxDebugNode.Range doGetRange() {
        OlapInstrLocationRange instrRange = this.pInstr.getLocationRange();
        return new OlapMdxDebugNode.Range(instrRange.mdxHash(), instrRange.from(), instrRange.to(), instrRange.lineNumber());
    }

    @Override
    public String getReturnType() {
        if (this.exception != null) {
            return this.asReturnType(this.exception);
        }
        return this.asReturnType(this.result);
    }

    @Override
    public String getReturnValueExtraInfo(OlapNameContext nameContext) {
        if (this.exception != null) {
            return "";
        }
        return this.asReturnValueExtraInfo(nameContext, this.result);
    }

    @Override
    public String getReturnValue(OlapNameContext nameContext) {
        if (this.exception != null) {
            return this.asReturnValue(this.exception);
        }
        return this.asReturnValue(nameContext, this.result);
    }

    @Override
    public String getArgumentInfo(OlapNameContext nameContext) {
        return "";
    }

    public String getInstrClassName() {
        return this.pInstr.getClass().getSimpleName();
    }

    public boolean matchInstr(OlapPreparedInstr pInstr) {
        return this.pInstr == pInstr;
    }
}

