/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.goodies.debugger.model;

import crazydev.iccube.olap.component.naming.OlapNameContext;
import crazydev.iccube.olap.entity.OlapEntity;
import crazydev.iccube.olap.eval.execinstr.gf.nodes.GFAxisNode;
import crazydev.iccube.olap.eval.execinstr.gf.nodes.GFNode;
import crazydev.iccube.olap.eval.execinstr.gf.nodes.GFSlicerNode;
import crazydev.iccube.olap.eval.execinstr.gf.nodes.GFTupleNode;
import crazydev.iccube.olap.eval.instr.OlapInstrLocationRange;
import crazydev.iccube.olap.goodies.debugger.OlapMdxDebugNodeCollector;
import crazydev.iccube.olap.goodies.debugger.model.OlapMdxDebugNode;
import org.jetbrains.annotations.Nullable;

public class OlapMdxDebugNodeNode
extends OlapMdxDebugNode {
    private final GFNode node;
    private final boolean onDemand;
    private OlapEntity result;
    @Nullable
    private RuntimeException exception;

    public OlapMdxDebugNodeNode(OlapMdxDebugNodeCollector collector, OlapMdxDebugNode parentNode, GFNode node, boolean onDemand) {
        super(collector, parentNode);
        this.node = node;
        this.onDemand = onDemand;
    }

    public String getNodeClassName() {
        return this.node.getClass().getSimpleName();
    }

    public boolean isMatchingNode(GFNode node) {
        return this.node == node;
    }

    @Override
    public boolean isAxis() {
        return this.node instanceof GFAxisNode;
    }

    @Override
    public boolean isSlicer() {
        return this.node instanceof GFSlicerNode;
    }

    @Override
    public boolean isTupleNode() {
        return this.node instanceof GFTupleNode;
    }

    @Override
    public boolean isOnDemand() {
        return this.onDemand;
    }

    public void addResult(OlapEntity result) {
        this.result = result.asConstant();
    }

    public void addError(RuntimeException exception) {
        this.exception = exception;
    }

    @Override
    public String getTitle(OlapNameContext nameContext) {
        return this.node.toStringForDebugger();
    }

    @Override
    protected OlapMdxDebugNode.Range doGetRange() {
        OlapInstrLocationRange instrRange = this.node.getLocationRange();
        return new OlapMdxDebugNode.Range(instrRange.mdxHash(), instrRange.from(), instrRange.to(), instrRange.lineNumber());
    }

    @Override
    public String getReturnType() {
        if (this.exception != null) {
            return this.asReturnType(this.exception);
        }
        return this.asReturnType(this.result);
    }

    @Override
    public String getReturnValueExtraInfo(OlapNameContext nameContext) {
        if (this.exception != null) {
            return "";
        }
        return this.asReturnValueExtraInfo(nameContext, this.result);
    }

    @Override
    public String getReturnValue(OlapNameContext nameContext) {
        if (this.exception != null) {
            return this.asReturnValue(this.exception);
        }
        return this.asReturnValue(nameContext, this.result);
    }

    @Override
    public String getArgumentInfo(OlapNameContext nameContext) {
        return "";
    }
}

