/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.goodies.debugger.model;

import crazydev.iccube.olap.component.naming.OlapNameContext;
import crazydev.iccube.olap.entity.OlapEntity;
import crazydev.iccube.olap.entity.scalar.OlapScalarEntity;
import crazydev.iccube.olap.entity.scalar.OlapStringEntity;
import crazydev.iccube.olap.eval.function.OlapFunctionArgumentType;
import crazydev.iccube.olap.goodies.debugger.OlapMdxDebugNodeCollector;
import crazydev.iccube.olap.goodies.debugger.model.OlapMdxDebugNode;
import org.jetbrains.annotations.Nullable;

public class OlapMdxDebugFunctionArgEvaluationNode
extends OlapMdxDebugNode {
    private final String name;
    private final OlapFunctionArgumentType type;
    @Nullable
    private OlapEntity value;

    public OlapMdxDebugFunctionArgEvaluationNode(OlapMdxDebugNodeCollector collector, OlapMdxDebugNode parent, String name, OlapFunctionArgumentType type) {
        super(collector, parent);
        this.name = name;
        this.type = type;
    }

    @Override
    public String getTitle(OlapNameContext nameContext) {
        return "parameter: " + this.name;
    }

    @Nullable
    public OlapMdxDebugNode getOnlyChild() {
        if (this.getChildrenCount() == 1) {
            return this.getChild(0);
        }
        return null;
    }

    @Override
    public String getReturnType() {
        String rType = null;
        OlapMdxDebugNode child = this.getOnlyChild();
        rType = child != null ? child.getReturnType() : super.getReturnType();
        return "[as defined in parameter: " + String.valueOf(this.type) + "] " + rType;
    }

    @Override
    public String getReturnValueExtraInfo(OlapNameContext nameContext) {
        OlapMdxDebugNode child = this.getOnlyChild();
        if (child != null) {
            return child.getReturnValueExtraInfo(nameContext);
        }
        return super.getReturnValueExtraInfo(nameContext);
    }

    @Override
    public String getReturnValue(OlapNameContext nameContext) {
        OlapMdxDebugNode child = this.getOnlyChild();
        if (child != null) {
            return child.getReturnValue(nameContext);
        }
        return this.asReturnValue(nameContext, this.value);
    }

    public void setValue(OlapEntity value) {
        this.value = value instanceof OlapScalarEntity ? ((OlapScalarEntity)value).asConstant() : value;
    }

    public void setError(RuntimeException ex) {
        this.value = new OlapStringEntity(ex.getMessage());
    }
}

