/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.goodies.debugger.model;

import crazydev.iccube.olap.component.naming.OlapNameContext;
import crazydev.iccube.olap.entity.member.OlapMeasureMember;
import crazydev.iccube.olap.entity.scalar.OlapScalarEntity;
import crazydev.iccube.olap.entity.scalar.OlapStringEntity;
import crazydev.iccube.olap.eval.execinstr.gf.tuple.GFFactsEvalTuple;
import crazydev.iccube.olap.goodies.debugger.OlapMdxDebugNodeCollector;
import crazydev.iccube.olap.goodies.debugger.model.OlapMdxDebugNode;

public class OlapMdxDebugFactTupleAggregationNode
extends OlapMdxDebugNode {
    private final GFFactsEvalTuple tuple;
    private OlapScalarEntity value;

    public OlapMdxDebugFactTupleAggregationNode(OlapMdxDebugNodeCollector collector, OlapMdxDebugNode parent, GFFactsEvalTuple tuple) {
        super(collector, parent);
        this.tuple = tuple;
    }

    @Override
    public String getTitle(OlapNameContext nameContext) {
        return "Aggregation: " + this.tuple.asStringForDebugger(nameContext);
    }

    @Override
    public String getReturnType() {
        return this.asReturnType(this.value);
    }

    @Override
    public String getReturnValueExtraInfo(OlapNameContext nameContext) {
        OlapMeasureMember measure = this.tuple.getMeasure();
        return measure.getUniqueName(nameContext);
    }

    @Override
    public String getReturnValue(OlapNameContext nameContext) {
        return this.asReturnValue(nameContext, this.value);
    }

    @Override
    public String getArgumentInfo(OlapNameContext nameContext) {
        return this.tuple.asStringForDebugger(nameContext);
    }

    public void setValue(OlapScalarEntity value) {
        this.value = value.asConstant();
    }

    public void setError(RuntimeException ex) {
        this.value = new OlapStringEntity(ex.getMessage());
    }
}

