/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.goodies.debugger.model;

import crazydev.iccube.olap.component.naming.OlapNameContext;
import crazydev.iccube.olap.entity.result.OlapResAxisName;
import crazydev.iccube.olap.entity.result.tidy.OlapResMdxTidyTable;
import crazydev.iccube.olap.entity.result.tidy.builder.OlapResMdxTidyBuilderCellsColumn;
import crazydev.iccube.olap.entity.tuple.OlapTuple;
import crazydev.iccube.olap.eval.result.OlapEvalResultCellValue;
import crazydev.iccube.olap.eval.result.OlapEvalResultSi;
import crazydev.iccube.olap.eval.result.OlapEvalResultTidyInfo;
import crazydev.iccube.olap.goodies.debugger.OlapMdxDebugNodeCollector;
import crazydev.iccube.olap.goodies.debugger.model.OlapMdxDebugCellAxisNode;
import crazydev.iccube.olap.goodies.debugger.model.OlapMdxDebugCellNode;
import crazydev.iccube.olap.goodies.debugger.model.OlapMdxDebugCellTidyColumnNode;
import crazydev.iccube.olap.goodies.debugger.model.OlapMdxDebugCellTidyPageNode;
import crazydev.iccube.olap.goodies.debugger.model.OlapMdxDebugCellTidyRowNode;
import crazydev.iccube.olap.goodies.debugger.model.OlapMdxDebugCellValueNode;
import crazydev.iccube.olap.goodies.debugger.model.OlapMdxDebugNode;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Objects;
import org.jetbrains.annotations.Nullable;

public class OlapMdxDebugCellsNode
extends OlapMdxDebugNode {
    protected final OlapMdxDebugNode tree;

    public OlapMdxDebugCellsNode(OlapMdxDebugNodeCollector collector, OlapMdxDebugNode parent) {
        super(collector, parent);
        this.tree = new OlapMdxDebugNode(collector, null);
    }

    @Override
    public String getTitle(OlapNameContext nameContext) {
        return "Cells";
    }

    @Override
    public boolean isCells() {
        return true;
    }

    public void createCells(OlapResMdxTidyTable tidy) {
        if (this.children != null) {
            if (this.tree.getChildrenCount() == 0) {
                HashMap<Integer, OlapMdxDebugCellTidyRowNode> rowNodes = new HashMap<Integer, OlapMdxDebugCellTidyRowNode>();
                for (OlapMdxDebugNode child : this.children) {
                    if (!(child instanceof OlapMdxDebugCellValueNode)) continue;
                    OlapMdxDebugCellValueNode cellValueNode = (OlapMdxDebugCellValueNode)child;
                    child.setAsOrphan();
                    OlapEvalResultCellValue value = cellValueNode.getCellValue();
                    OlapEvalResultTidyInfo tidyInfo = value.getDebuggerTidyInfo();
                    if (tidyInfo == null) continue;
                    int rowIndex = tidyInfo.debuggerRowIndex();
                    OlapMdxDebugCellTidyRowNode rowNode = rowNodes.computeIfAbsent(rowIndex, r -> new OlapMdxDebugCellTidyRowNode(this.collector, this.tree, (int)r));
                    OlapResMdxTidyBuilderCellsColumn column = tidyInfo.debuggerTidyColumn();
                    OlapMdxDebugCellTidyColumnNode columnNode = rowNode.getOrCreateColumnNode(tidy, column);
                    if (tidy.isWithPaging()) {
                        int pageIndex = tidyInfo.debuggerPageIndex();
                        OlapMdxDebugCellTidyPageNode pageNode = columnNode.getOrCreatePageNode(pageIndex);
                        pageNode.adoptChildren(cellValueNode);
                        continue;
                    }
                    columnNode.adoptChildren(cellValueNode);
                }
                this.tree.sortChildren((o1, o2) -> {
                    OlapMdxDebugCellTidyRowNode left = (OlapMdxDebugCellTidyRowNode)o1;
                    OlapMdxDebugCellTidyRowNode right = (OlapMdxDebugCellTidyRowNode)o2;
                    return left.getRowIdx() - right.getRowIdx();
                });
                this.tree.getChildren().forEach(r -> r.sortChildren((o1, o2) -> {
                    OlapMdxDebugCellTidyColumnNode left = (OlapMdxDebugCellTidyColumnNode)o1;
                    OlapMdxDebugCellTidyColumnNode right = (OlapMdxDebugCellTidyColumnNode)o2;
                    return left.getTupleIdx() - right.getTupleIdx();
                }));
                if (tidy.isWithPaging()) {
                    this.tree.getChildren().forEach(r -> r.getChildren().forEach(c -> c.sortChildren((o1, o2) -> {
                        OlapMdxDebugCellTidyPageNode left = (OlapMdxDebugCellTidyPageNode)o1;
                        OlapMdxDebugCellTidyPageNode right = (OlapMdxDebugCellTidyPageNode)o2;
                        return left.getPageIdx() - right.getPageIdx();
                    })));
                }
            } else if (this.tree.getChildrenCount() == 1 && tidy.getRowCount() == 1 && tidy.getCellsColumnCount() == 1) {
                OlapMdxDebugNode col0 = this.tree.getChild(0);
                this.tree.adoptChildren(col0);
                this.tree.removeChild(col0);
            }
        }
    }

    @Override
    public void onEnd() {
        super.onEnd();
        this.clearChildren();
        this.adoptChildren(this.tree);
    }

    @Nullable
    public OlapMdxDebugCellValueNode getCellValueNode(OlapEvalResultSi cellValueSi) {
        int childrenCount = this.getChildrenCount();
        for (int idx = 0; idx < childrenCount; ++idx) {
            OlapMdxDebugCellValueNode cellValueNode;
            OlapMdxDebugNode child = this.getChild(idx);
            if (!(child instanceof OlapMdxDebugCellValueNode) || !(cellValueNode = (OlapMdxDebugCellValueNode)child).getSi().equals(cellValueSi)) continue;
            return cellValueNode;
        }
        return null;
    }

    public void addCellToTree(int[] Si, OlapMdxDebugCellNode cell) {
        this.addCellToTree(this.tree, Si, cell);
    }

    private void addCellToTree(OlapMdxDebugNode child, int[] Si, OlapMdxDebugCellNode cell) {
        for (int idx = Si.length - 1; idx > 0; --idx) {
            int pos = Si[idx];
            OlapMdxDebugCellAxisNode existingChildAxis = null;
            for (OlapMdxDebugNode xchild : child.getChildren()) {
                OlapMdxDebugCellAxisNode childAxis = (OlapMdxDebugCellAxisNode)xchild;
                if (childAxis.getPos() == pos) {
                    existingChildAxis = childAxis;
                    break;
                }
                if (childAxis.getPos() <= pos) continue;
                break;
            }
            if (existingChildAxis != null) {
                child = existingChildAxis;
                continue;
            }
            OlapResAxisName.Builtin axis = new OlapResAxisName(idx).getBuiltin();
            Object axisName = axis == null ? "Axis(" + idx + ")" : axis.name();
            OlapTuple[] cellTuples = cell.getCellTuples();
            OlapTuple axisTuple = null;
            if (cellTuples != null && idx < cellTuples.length) {
                axisTuple = cellTuples[idx];
            }
            existingChildAxis = new OlapMdxDebugCellAxisNode(this.collector, child, (String)axisName + "-" + pos, pos, axisTuple);
            child.sortChildren((o1, o2) -> {
                OlapMdxDebugCellAxisNode left = (OlapMdxDebugCellAxisNode)o1;
                OlapMdxDebugCellAxisNode right = (OlapMdxDebugCellAxisNode)o2;
                return left.getPos() - right.getPos();
            });
            child = existingChildAxis;
        }
        child.addChild(cell);
        cell.parent = child;
        child.sortChildren(new Comparator<OlapMdxDebugNode>(this){
            {
                Objects.requireNonNull(this$0);
            }

            @Override
            public int compare(OlapMdxDebugNode o1, OlapMdxDebugNode o2) {
                OlapMdxDebugCellNode left = (OlapMdxDebugCellNode)o1;
                OlapMdxDebugCellNode right = (OlapMdxDebugCellNode)o2;
                return left.getCell().getOrdinal() - right.getCell().getOrdinal();
            }
        });
    }
}

