/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.goodies.debugger.model;

import crazydev.iccube.olap.component.naming.OlapNameContext;
import crazydev.iccube.olap.entity.member.OlapMember;
import crazydev.iccube.olap.entity.tuple.OlapTuple;
import crazydev.iccube.olap.goodies.debugger.OlapMdxDebugNodeCollector;
import crazydev.iccube.olap.goodies.debugger.model.OlapMdxDebugNode;
import org.jetbrains.annotations.Nullable;

public class OlapMdxDebugCellAxisNode
extends OlapMdxDebugNode {
    private final String title;
    private final int pos;
    @Nullable
    private final OlapTuple tuple;
    @Nullable
    private final String columnInfo;

    public OlapMdxDebugCellAxisNode(OlapMdxDebugNodeCollector collector, @Nullable OlapMdxDebugNode parent, String title, int pos, @Nullable OlapTuple tuple) {
        super(collector, parent, 0L, 0L);
        this.title = title;
        this.pos = pos;
        this.tuple = tuple;
        if (tuple != null && tuple.getMemberCount() > 0) {
            StringBuilder ci = new StringBuilder();
            ci.append(" ( ");
            for (int ii = 0; ii < tuple.getMemberCount(); ++ii) {
                if (ii > 0) {
                    ci.append(", ");
                }
                OlapMember member = tuple.getMember(ii);
                ci.append(member.getNameX());
            }
            ci.append(" ) ");
            this.columnInfo = ci.toString();
        } else {
            this.columnInfo = null;
        }
    }

    @Override
    public String getTitle(OlapNameContext nameContext) {
        return this.title + (this.columnInfo != null ? this.columnInfo : "");
    }

    @Override
    public String getTuple(OlapNameContext nameContext) {
        if (this.tuple == null) {
            return super.getTuple(nameContext);
        }
        return this.tuple.toMdxString(nameContext, true, 512);
    }

    public int getPos() {
        return this.pos;
    }

    @Override
    public long getExecTimeMillis() {
        return this.getExecTimeMillisFromChildren();
    }
}

