/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.goodies.debugger;

import crazydev.common.exception.CdRuntimeException;
import crazydev.common.exception.programming.CdProgrammingException;
import crazydev.common.utils.CdStringUtils;
import crazydev.iccube.exception.OlapErrorCode;
import crazydev.iccube.olap.component.naming.OlapNameContext;
import crazydev.iccube.olap.entity.OlapEntity;
import crazydev.iccube.olap.entity.member.OlapCalculatedMember;
import crazydev.iccube.olap.entity.member.OlapMeasureMember;
import crazydev.iccube.olap.entity.member.OlapMember;
import crazydev.iccube.olap.entity.result.OlapResCell;
import crazydev.iccube.olap.entity.result.tidy.OlapResMdxTidyTable;
import crazydev.iccube.olap.entity.scalar.OlapScalarEntity;
import crazydev.iccube.olap.entity.tuple.IOlapMembers;
import crazydev.iccube.olap.entity.tuple.OlapTuple;
import crazydev.iccube.olap.eval.exception.OlapEvaluationException;
import crazydev.iccube.olap.eval.execinstr.OlapPreparedInstr;
import crazydev.iccube.olap.eval.execinstr.gf.nodes.GFCalcMemberEvalNode;
import crazydev.iccube.olap.eval.execinstr.gf.nodes.GFNode;
import crazydev.iccube.olap.eval.execinstr.gf.tuple.GFFactsEvalTuple;
import crazydev.iccube.olap.eval.function.OlapFunctionArgumentType;
import crazydev.iccube.olap.eval.instr.OlapInstr;
import crazydev.iccube.olap.eval.instr.OlapInstrExecListener;
import crazydev.iccube.olap.eval.result.OlapEvalResultCellValue;
import crazydev.iccube.olap.eval.result.OlapEvalResultSi;
import crazydev.iccube.olap.eval.script.OlapScriptInstr;
import crazydev.iccube.olap.eval.select.OlapStatementInstr;
import crazydev.iccube.olap.eval.select.statistics.OlapMdxStatementEvalStatistics;
import crazydev.iccube.olap.goodies.debugger.model.OlapMdxDebugAxesNode;
import crazydev.iccube.olap.goodies.debugger.model.OlapMdxDebugCalcMemberNode;
import crazydev.iccube.olap.goodies.debugger.model.OlapMdxDebugCellNode;
import crazydev.iccube.olap.goodies.debugger.model.OlapMdxDebugCellPropertiesNode;
import crazydev.iccube.olap.goodies.debugger.model.OlapMdxDebugCellValueNode;
import crazydev.iccube.olap.goodies.debugger.model.OlapMdxDebugCellsNode;
import crazydev.iccube.olap.goodies.debugger.model.OlapMdxDebugFactSetIterationNode;
import crazydev.iccube.olap.goodies.debugger.model.OlapMdxDebugFactSetTupleAggregationNode;
import crazydev.iccube.olap.goodies.debugger.model.OlapMdxDebugFactSetTupleIterationNode;
import crazydev.iccube.olap.goodies.debugger.model.OlapMdxDebugFactTupleAggregationNode;
import crazydev.iccube.olap.goodies.debugger.model.OlapMdxDebugFunctionArgEvaluationNode;
import crazydev.iccube.olap.goodies.debugger.model.OlapMdxDebugFunctionBodyEvaluationNode;
import crazydev.iccube.olap.goodies.debugger.model.OlapMdxDebugInstrNode;
import crazydev.iccube.olap.goodies.debugger.model.OlapMdxDebugInstrPrepareNode;
import crazydev.iccube.olap.goodies.debugger.model.OlapMdxDebugLambdaTruncatedNode;
import crazydev.iccube.olap.goodies.debugger.model.OlapMdxDebugNode;
import crazydev.iccube.olap.goodies.debugger.model.OlapMdxDebugNodeNode;
import crazydev.iccube.olap.goodies.debugger.model.OlapMdxDebugPerfNode;
import crazydev.iccube.olap.goodies.debugger.model.OlapMdxDebugPerfNodes;
import crazydev.iccube.olap.goodies.debugger.model.OlapMdxDebugPreparedInstrNode;
import crazydev.iccube.olap.goodies.debugger.model.OlapMdxDebugWithNode;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.Nullable;

public class OlapMdxDebugNodeCollector
implements OlapInstrExecListener {
    private final Map<GFNode, OlapMdxDebugNodeNode> iterableNodes = new HashMap<GFNode, OlapMdxDebugNodeNode>();
    private OlapMdxDebugNode iCurrentNode;
    private OlapMdxDebugNode root;
    private OlapMdxDebugNode currentNode;
    private int count;

    public void incrementNodeCount() {
        ++this.count;
    }

    public OlapMdxDebugNode getRoot() {
        if (this.root == null) {
            throw new CdRuntimeException("Missing root node!");
        }
        if (this.root.isScript() && this.root.getChildrenCount() > 0) {
            return this.root.getChild(0);
        }
        return this.root;
    }

    @Override
    public void onIterableNode(GFNode node) {
        this.iterableNodes.put(node, new OlapMdxDebugNodeNode(this, null, node, false));
    }

    @Override
    public void beginQuery() {
    }

    @Override
    public void endQuery(OlapMdxStatementEvalStatistics stats) {
        OlapMdxDebugCellsNode cellsNode;
        OlapMdxDebugNode slicerNode;
        OlapMdxDebugNode myRoot = this.getRoot();
        OlapMdxDebugNode subSelectNode = this.getTopLevelSubSelectNode();
        if (subSelectNode != null) {
            subSelectNode.moveToNode(myRoot);
        }
        if ((slicerNode = this.getTopLevelSlicerNode()) != null) {
            slicerNode.moveToNode(myRoot);
        }
        if ((cellsNode = this.getCellsNode()) != null) {
            cellsNode.moveLast();
        }
        ArrayList<OlapMdxDebugNode> emptyTopLevelNodes = new ArrayList<OlapMdxDebugNode>();
        for (OlapMdxDebugNode olapMdxDebugNode : myRoot.getChildren()) {
            if (olapMdxDebugNode.hasChildren()) continue;
            emptyTopLevelNodes.add(olapMdxDebugNode);
        }
        for (OlapMdxDebugNode olapMdxDebugNode : emptyTopLevelNodes) {
            olapMdxDebugNode.remove();
        }
        myRoot.fixTupleNodes();
        myRoot.fixOnDemandNodes();
        myRoot.fixPreparedAxisNodes();
        myRoot.addStats(stats);
        this.addPerf(myRoot);
        for (Map.Entry entry : this.iterableNodes.entrySet()) {
            OlapMdxDebugNode fCall;
            OlapMdxDebugNode iterationNode;
            GFNode iNodeGF = (GFNode)entry.getKey();
            OlapMdxDebugNodeNode iNode = (OlapMdxDebugNodeNode)entry.getValue();
            if (iNode.getChildrenCount() != 1 || !((iterationNode = iNode.getChild(0)) instanceof OlapMdxDebugFactSetIterationNode) || (fCall = myRoot.lookupNode(iNodeGF)) == null) continue;
            fCall.adoptChildren(iNode);
        }
    }

    private void addPerf(OlapMdxDebugNode myRoot) {
        HashMap map = new HashMap();
        OlapMdxDebugPerfNodes perfRoot = new OlapMdxDebugPerfNodes(this, null);
        myRoot.visitNodes(node -> {
            if (node instanceof OlapMdxDebugCalcMemberNode) {
                OlapMdxDebugCalcMemberNode calcMemberNode = (OlapMdxDebugCalcMemberNode)node;
                OlapMdxDebugPerfNode perfNode = map.computeIfAbsent(calcMemberNode.getCalculatedMember(), t -> new OlapMdxDebugPerfNode(this, perfRoot));
                perfNode.addPerfNode(calcMemberNode);
            }
            return true;
        });
        perfRoot.sortChildren((o1, o2) -> {
            if (o1 instanceof OlapMdxDebugPerfNode && o2 instanceof OlapMdxDebugPerfNode) {
                OlapMdxDebugPerfNode node1 = (OlapMdxDebugPerfNode)o1;
                OlapMdxDebugPerfNode node2 = (OlapMdxDebugPerfNode)o2;
                return Long.compare(node2.getTotalTime(), node1.getTotalTime());
            }
            return Long.compare(o2.getExecTimeMillis(), o1.getExecTimeMillis());
        });
        perfRoot.setRoot(myRoot);
    }

    @Override
    public void beginWith() {
        this.currentNode = new OlapMdxDebugWithNode(this, this.currentNode);
    }

    @Override
    public void endWith() {
        if (!(this.currentNode instanceof OlapMdxDebugWithNode)) {
            throw new CdProgrammingException("Debugger : endWith does not match beginWith");
        }
        this.currentNode.onEnd();
        this.currentNode = this.currentNode.getParent();
    }

    @Override
    public void endWithOnError(RuntimeException ex) {
        this.endWith();
    }

    @Override
    public void beginAxes() {
        this.currentNode = new OlapMdxDebugAxesNode(this, this.currentNode);
    }

    @Override
    public void endAxes() {
        if (!(this.currentNode instanceof OlapMdxDebugAxesNode)) {
            throw new CdProgrammingException("Debugger : endAxes does not match beginAxes");
        }
        this.currentNode.onEnd();
        this.currentNode = this.currentNode.getParent();
    }

    @Override
    public void endAxesOnError(RuntimeException ex) {
        this.endAxes();
    }

    @Override
    public void beginCellsEval() {
        this.currentNode = new OlapMdxDebugCellsNode(this, this.currentNode);
    }

    @Override
    public void endCellsEval() {
        if (!(this.currentNode instanceof OlapMdxDebugCellsNode)) {
            throw new CdProgrammingException("Debugger : endCellsEval does not match beginCellsEval");
        }
        this.currentNode.onEnd();
        this.currentNode = this.currentNode.getParent();
    }

    @Override
    public void beginCellValueEval(OlapTuple tuple, OlapEvalResultSi Si, OlapTuple[] cellTuples) {
        this.currentNode = new OlapMdxDebugCellValueNode(this, this.currentNode, Si, cellTuples, tuple);
    }

    @Override
    public void endCellValueEval(OlapEvalResultSi Si, OlapEvalResultCellValue cellValue) {
        OlapMdxDebugCellValueNode node;
        if (this.currentNode instanceof OlapMdxDebugCellValueNode) {
            node = (OlapMdxDebugCellValueNode)this.currentNode;
            if (!Si.equals(node.getSi())) {
                throw new CdProgrammingException("Debugger : endCellValueEval Si[] does not match beginCellValueEval Si[]");
            }
        } else {
            throw new CdProgrammingException("Debugger : endCellValueEval does not match beginCellValueEval");
        }
        node.addCellValue(cellValue);
        node.onEnd();
        this.currentNode = this.currentNode.getParent();
    }

    @Override
    public void beginCellProperties() {
        this.currentNode = new OlapMdxDebugCellPropertiesNode(this, this.currentNode);
    }

    @Override
    public void endCellProperties() {
        if (!(this.currentNode instanceof OlapMdxDebugCellPropertiesNode)) {
            throw new CdProgrammingException("Debugger : endCellProperties does not match beginCellProperties");
        }
        OlapMdxDebugNode cellPropertiesNode = this.currentNode;
        this.currentNode.onEnd();
        this.currentNode = this.currentNode.getParent();
        if (this.currentNode != null) {
            this.currentNode.removeChild(cellPropertiesNode);
        }
    }

    public void createCells(OlapResMdxTidyTable tidy) {
        OlapMdxDebugCellsNode cellsNode = this.getCellsNode();
        if (cellsNode == null) {
            throw new CdProgrammingException("internal error: create cells inconsistency (null)");
        }
        cellsNode.createCells(tidy);
    }

    @Override
    public void createCell(int[] Si, int ordinal, OlapResCell cell, OlapEvalResultSi cellValueSi, OlapEvalResultCellValue cellValue) {
        OlapMdxDebugCellsNode cellsNode = this.getCellsNode();
        if (cellsNode == null) {
            throw new CdProgrammingException("internal error: create cell inconsistency (null)");
        }
        OlapMdxDebugCellValueNode cellValueNode = cellsNode.getCellValueNode(cellValueSi);
        if (cellValueNode == null) {
            throw new CdProgrammingException("internal error: create cell inconsistency (Si)");
        }
        if (cell.getOrdinal() != ordinal) {
            throw new CdProgrammingException("internal error: create cell inconsistency (ordinal)");
        }
        if (!cellValue.isEmpty() && cellValue != cellValueNode.getCellValue()) {
            throw new CdProgrammingException("internal error: create cell inconsistency (value)");
        }
        OlapMdxDebugCellNode cellNode = new OlapMdxDebugCellNode(this, null, cellValueNode.getStartTime(), cellValueNode.getEndTime(), Si, cellValueNode.getCellTuples(), cellValueNode.getTuple(), cellValueNode.getDefaultMembers(), cell);
        cellNode.adoptChildren(cellValueNode);
        cellNode.onCachedTupleValue(cellValueNode.isEvalCached());
        cellsNode.addCellToTree(Si, cellNode);
    }

    @Override
    public void beginInstrPrepare(OlapInstr instr) {
        OlapMdxDebugInstrPrepareNode instrNode = new OlapMdxDebugInstrPrepareNode(this, this.currentNode, instr);
        if (this.currentNode == null) {
            this.root = instrNode;
        }
        this.currentNode = instrNode;
    }

    @Override
    public void endInstrPrepare(OlapInstr instr, OlapPreparedInstr pInstr) {
        OlapMdxDebugInstrPrepareNode instrNode;
        if (this.currentNode instanceof OlapMdxDebugInstrPrepareNode) {
            instrNode = (OlapMdxDebugInstrPrepareNode)this.currentNode;
            if (!instrNode.matchInstr(instr)) {
                throw new CdProgrammingException("Debugger : endInstrPrepare does not match beginInstrPrepare (unexpected instr.)");
            }
        } else {
            throw new CdProgrammingException("Debugger : endInstrPrepare does not match enterExecute");
        }
        instrNode.addResult(pInstr);
        instrNode.onEnd();
        this.currentNode = instrNode.getParent();
    }

    @Override
    public void endInstrPrepareOnError(OlapInstr instr, RuntimeException ex) {
        OlapMdxDebugInstrPrepareNode instrNode;
        if (this.currentNode instanceof OlapMdxDebugInstrPrepareNode) {
            instrNode = (OlapMdxDebugInstrPrepareNode)this.currentNode;
            if (!instrNode.matchInstr(instr)) {
                throw new CdProgrammingException("Debugger : endInstrPrepareOnError does not match beginInstrPrepare (unexpected instr.)", (Throwable)ex);
            }
        } else {
            throw new CdProgrammingException("Debugger : endInstrPrepareOnError does not match beginInstrPrepare", (Throwable)ex);
        }
        instrNode.addError(ex);
        instrNode.onEnd();
        this.currentNode = this.currentNode.getParent();
    }

    @Override
    public void beginInstrExecute(OlapInstr instr) {
        OlapMdxDebugInstrNode instrNode = new OlapMdxDebugInstrNode(this, this.currentNode, instr);
        if (this.currentNode == null) {
            this.root = instrNode;
        }
        this.currentNode = instrNode;
    }

    @Override
    public void endInstrExecute(OlapInstr instr, OlapEntity entity) {
        OlapMdxDebugInstrNode instrNode;
        if (this.currentNode instanceof OlapMdxDebugInstrNode) {
            instrNode = (OlapMdxDebugInstrNode)this.currentNode;
            if (!instrNode.matchInstr(instr)) {
                throw new CdProgrammingException("Debugger : endInstrExecute does not match beginInstrExecute (unexpected instr.)");
            }
        } else {
            throw new CdProgrammingException("Debugger : endInstrExecute does not match enterExecute");
        }
        instrNode.addResult(entity);
        instrNode.onEnd();
        this.currentNode = instrNode.getParent();
    }

    @Override
    public void endInstrExecuteOnError(OlapInstr instr, RuntimeException ex) {
        OlapMdxDebugInstrNode instrNode;
        if (this.currentNode instanceof OlapMdxDebugInstrNode) {
            instrNode = (OlapMdxDebugInstrNode)this.currentNode;
            if (!instrNode.matchInstr(instr)) {
                throw new CdProgrammingException("Debugger : endInstrExecuteOnError does not match beginInstrExecute (unexpected instr.)", (Throwable)ex);
            }
        } else {
            throw new CdProgrammingException("Debugger : endInstrExecuteOnError does not match beginInstrExecute", (Throwable)ex);
        }
        instrNode.addError(ex);
        instrNode.onEnd();
        this.currentNode = this.currentNode.getParent();
    }

    @Override
    public void beginPreparedInstrExecute(OlapPreparedInstr instr) {
        OlapMdxDebugPreparedInstrNode instrNode = new OlapMdxDebugPreparedInstrNode(this, this.currentNode, instr);
        if (this.currentNode == null) {
            this.root = instrNode;
        }
        this.currentNode = instrNode;
    }

    @Override
    public void endPreparedInstrExecute(OlapPreparedInstr instr, OlapEntity entity) {
        OlapMdxDebugPreparedInstrNode instrNode;
        if (this.currentNode instanceof OlapMdxDebugPreparedInstrNode) {
            instrNode = (OlapMdxDebugPreparedInstrNode)this.currentNode;
            if (!instrNode.matchInstr(instr)) {
                throw new CdProgrammingException("Debugger : endPreparedInstrExecute does not match beginPreparedInstrExecute (unexpected instr.)");
            }
        } else {
            throw new CdProgrammingException("Debugger : endInstrExecute does not match enterExecute");
        }
        instrNode.addResult(entity);
        instrNode.onEnd();
        this.currentNode = instrNode.getParent();
    }

    @Override
    public void endPreparedInstrExecuteOnError(OlapPreparedInstr instr, RuntimeException ex) {
        OlapMdxDebugPreparedInstrNode instrNode;
        if (this.currentNode instanceof OlapMdxDebugPreparedInstrNode) {
            instrNode = (OlapMdxDebugPreparedInstrNode)this.currentNode;
            if (!instrNode.matchInstr(instr)) {
                throw new CdProgrammingException("Debugger : endPreparedInstrExecuteOnError does not match beginPreparedInstrExecute (unexpected instr.)", (Throwable)ex);
            }
        } else {
            throw new CdProgrammingException("Debugger : endPreparedInstrExecuteOnError does not match beginPreparedInstrExecute", (Throwable)ex);
        }
        instrNode.addError(ex);
        instrNode.onEnd();
        this.currentNode = this.currentNode.getParent();
    }

    @Override
    public void beginNodeExecute(boolean onDemand, GFNode node) {
        if (node instanceof GFCalcMemberEvalNode) {
            this.beginCalculatedMember(node, ((GFCalcMemberEvalNode)node).getCalcMember());
            return;
        }
        OlapMdxDebugNodeNode instrNode = new OlapMdxDebugNodeNode(this, this.currentNode, node, onDemand);
        if (this.currentNode == null) {
            this.root = instrNode;
        }
        this.currentNode = instrNode;
    }

    @Override
    public void endNodeExecute(GFNode node, OlapEntity entity) {
        OlapMdxDebugNodeNode instrNode;
        if (node instanceof GFCalcMemberEvalNode) {
            this.endCalculatedMember(node, ((GFCalcMemberEvalNode)node).getCalcMember(), (OlapScalarEntity)entity);
            return;
        }
        if (this.currentNode instanceof OlapMdxDebugNodeNode) {
            instrNode = (OlapMdxDebugNodeNode)this.currentNode;
            if (!instrNode.isMatchingNode(node)) {
                throw new CdProgrammingException("Debugger : endNodeExecute does not match beginNodeExecute (unexpected instr.)");
            }
        } else {
            throw new CdProgrammingException("Debugger : endInstrExecute does not match enterExecute");
        }
        instrNode.addResult(entity);
        instrNode.onEnd();
        this.currentNode = instrNode.getParent();
    }

    @Override
    public void endNodeExecuteOnError(GFNode node, RuntimeException ex) {
        OlapMdxDebugNodeNode instrNode;
        if (node instanceof GFCalcMemberEvalNode) {
            this.endCalculatedMemberOnError(node, ((GFCalcMemberEvalNode)node).getCalcMember(), ex);
            return;
        }
        if (this.currentNode instanceof OlapMdxDebugNodeNode) {
            instrNode = (OlapMdxDebugNodeNode)this.currentNode;
            if (!instrNode.isMatchingNode(node)) {
                throw new CdProgrammingException("Debugger : endNodeExecuteOnError does not match beginNodeExecute (unexpected instr.)", (Throwable)ex);
            }
        } else {
            throw new CdProgrammingException("Debugger : endNodeExecuteOnError does not match beginNodeExecute", (Throwable)ex);
        }
        instrNode.addError(ex);
        instrNode.onEnd();
        this.currentNode = this.currentNode.getParent();
    }

    private void beginCalculatedMember(GFNode node, OlapCalculatedMember member) {
        this.currentNode = new OlapMdxDebugCalcMemberNode(this, this.currentNode, member);
    }

    private void endCalculatedMember(GFNode node, OlapCalculatedMember member, OlapScalarEntity value) {
        if (!(this.currentNode instanceof OlapMdxDebugCalcMemberNode)) {
            throw new CdProgrammingException("Debugger : endCalculatedMember does not match beginCalculatedMember");
        }
        OlapMdxDebugCalcMemberNode debuggerCalculatedMember = (OlapMdxDebugCalcMemberNode)this.currentNode;
        debuggerCalculatedMember.setValue(value);
        this.currentNode.onEnd();
        this.currentNode = this.currentNode.getParent();
    }

    private void endCalculatedMemberOnError(GFNode node, OlapCalculatedMember member, Throwable ex) {
        if (!(this.currentNode instanceof OlapMdxDebugCalcMemberNode)) {
            throw new CdProgrammingException("Debugger : endCalculatedMemberOnError does not match beginCalculatedMember", ex);
        }
        OlapMdxDebugCalcMemberNode debuggerCalculatedMember = (OlapMdxDebugCalcMemberNode)this.currentNode;
        debuggerCalculatedMember.setError(ex);
        this.currentNode.onEnd();
        this.currentNode = this.currentNode.getParent();
    }

    @Override
    public void beginFunctionArgEvaluation(String name, OlapFunctionArgumentType type) {
        this.currentNode = new OlapMdxDebugFunctionArgEvaluationNode(this, this.currentNode, name, type);
    }

    @Override
    public void endFunctionArgEvaluation(OlapEntity value) {
        if (!(this.currentNode instanceof OlapMdxDebugFunctionArgEvaluationNode)) {
            throw new CdProgrammingException("Debugger : endFunctionArgEvaluation does not match beginFunctionArgEvaluation");
        }
        OlapMdxDebugFunctionArgEvaluationNode node = (OlapMdxDebugFunctionArgEvaluationNode)this.currentNode;
        node.setValue(value);
        this.currentNode.onEnd();
        this.currentNode = this.currentNode.getParent();
    }

    @Override
    public void endFunctionArgEvaluationOnError(RuntimeException ex) {
        if (!(this.currentNode instanceof OlapMdxDebugFunctionArgEvaluationNode)) {
            throw new CdProgrammingException("Debugger : endFunctionArgEvaluation does not match beginFunctionArgEvaluation");
        }
        OlapMdxDebugFunctionArgEvaluationNode node = (OlapMdxDebugFunctionArgEvaluationNode)this.currentNode;
        node.setError(ex);
        this.currentNode.onEnd();
        this.currentNode = this.currentNode.getParent();
    }

    @Override
    public void beginFunctionBodyEvaluation() {
        this.currentNode = new OlapMdxDebugFunctionBodyEvaluationNode(this, this.currentNode);
    }

    @Override
    public void endFunctionBodyEvaluation() {
        if (!(this.currentNode instanceof OlapMdxDebugFunctionBodyEvaluationNode)) {
            throw new CdProgrammingException("Debugger : endFunctionBodyEvaluation does not match beginFunctionBodyEvaluation");
        }
        this.currentNode.onEnd();
        this.currentNode = this.currentNode.getParent();
    }

    @Override
    public void beginFactTupleAggregation(GFFactsEvalTuple tuple) {
        this.currentNode = new OlapMdxDebugFactTupleAggregationNode(this, this.currentNode, tuple);
    }

    @Override
    public void endFactTupleAggregation(GFFactsEvalTuple tuple, OlapScalarEntity value) {
        if (!(this.currentNode instanceof OlapMdxDebugFactTupleAggregationNode)) {
            throw new CdProgrammingException("Debugger : endFactTupleAggregation does not match beginFactTupleAggregation");
        }
        OlapMdxDebugFactTupleAggregationNode node = (OlapMdxDebugFactTupleAggregationNode)this.currentNode;
        node.setValue(value);
        this.currentNode.onEnd();
        this.currentNode = this.currentNode.getParent();
    }

    @Override
    public void endFactTupleAggregationOnError(GFFactsEvalTuple tuple, RuntimeException ex) {
        if (!(this.currentNode instanceof OlapMdxDebugFactTupleAggregationNode)) {
            throw new CdProgrammingException("Debugger : endFactTupleAggregation does not match beginFactTupleAggregation");
        }
        OlapMdxDebugFactTupleAggregationNode node = (OlapMdxDebugFactTupleAggregationNode)this.currentNode;
        node.setError(ex);
        this.currentNode.onEnd();
        this.currentNode = this.currentNode.getParent();
    }

    @Override
    public void beginFactSetIteration() {
        this.currentNode = new OlapMdxDebugFactSetIterationNode(this, this.currentNode);
    }

    @Override
    public void endFactSetIteration() {
        if (!(this.currentNode instanceof OlapMdxDebugFactSetIterationNode)) {
            throw new CdProgrammingException("Debugger : endFactSetIteration does not match beginFactSetIteration");
        }
        OlapMdxDebugFactSetIterationNode node = (OlapMdxDebugFactSetIterationNode)this.currentNode;
        this.currentNode.onEnd();
        this.currentNode = this.currentNode.getParent();
    }

    @Override
    public void onFactSetTupleIteration(@Nullable GFNode iterableNode) {
        if (iterableNode != null) {
            OlapMdxDebugNodeNode iNode = this.iterableNodes.get(iterableNode);
            if (iNode != null) {
                if (iNode.getChildrenCount() == 0) {
                    new OlapMdxDebugFactSetIterationNode(this, iNode);
                }
                OlapMdxDebugFactSetIterationNode iterationNode = (OlapMdxDebugFactSetIterationNode)iNode.getChild(0);
                iterationNode.onTupleIteration();
            }
        } else {
            OlapMdxDebugNode olapMdxDebugNode = this.currentNode;
            if (olapMdxDebugNode instanceof OlapMdxDebugFactSetIterationNode) {
                OlapMdxDebugFactSetIterationNode iterationNode = (OlapMdxDebugFactSetIterationNode)olapMdxDebugNode;
                iterationNode.onTupleIteration();
            }
        }
    }

    @Override
    public void onFactSetTupleIterationCompleted(@Nullable GFNode iterableNode) {
        OlapMdxDebugNodeNode iNode;
        if (iterableNode != null && (iNode = this.iterableNodes.get(iterableNode)) != null) {
            if (iNode.getChildrenCount() == 0) {
                new OlapMdxDebugFactSetIterationNode(this, iNode);
            }
            OlapMdxDebugFactSetIterationNode iterationNode = (OlapMdxDebugFactSetIterationNode)iNode.getChild(0);
            iterationNode.setEndTime();
        }
    }

    @Override
    public void beginFactSetTupleIteration(@Nullable GFNode iterableNode, IOlapMembers tuple) {
        if (iterableNode != null) {
            OlapMdxDebugNodeNode iNode = this.iterableNodes.get(iterableNode);
            if (iNode != null) {
                OlapMdxDebugFactSetIterationNode iterationNode = (OlapMdxDebugFactSetIterationNode)iNode.getChild(0);
                this.iCurrentNode = this.currentNode;
                this.currentNode = new OlapMdxDebugFactSetTupleIterationNode(this, iterationNode, tuple);
            }
        } else {
            this.currentNode = new OlapMdxDebugFactSetTupleIterationNode(this, this.currentNode, tuple);
        }
    }

    @Override
    public void endFactSetTupleIteration(@Nullable GFNode iterableNode, IOlapMembers tuple, @Nullable OlapEntity value) {
        if (iterableNode != null) {
            OlapMdxDebugNode olapMdxDebugNode = this.currentNode;
            if (!(olapMdxDebugNode instanceof OlapMdxDebugFactSetTupleIterationNode)) {
                throw new CdProgrammingException("Debugger : endFactSetTupleIteration does not match beginFactSetTupleIteration (iterable)");
            }
            OlapMdxDebugFactSetTupleIterationNode node = (OlapMdxDebugFactSetTupleIterationNode)olapMdxDebugNode;
            if (value != null) {
                node.setValue(value);
            }
            this.currentNode.onEnd();
            this.currentNode = this.iCurrentNode;
            this.iCurrentNode = null;
        } else {
            OlapMdxDebugNode olapMdxDebugNode = this.currentNode;
            if (!(olapMdxDebugNode instanceof OlapMdxDebugFactSetTupleIterationNode)) {
                throw new CdProgrammingException("Debugger : endFactSetTupleIteration does not match beginFactSetTupleIteration");
            }
            OlapMdxDebugFactSetTupleIterationNode node = (OlapMdxDebugFactSetTupleIterationNode)olapMdxDebugNode;
            if (value != null) {
                node.setValue(value);
            }
            this.currentNode.onEnd();
            this.currentNode = this.currentNode.getParent();
        }
    }

    @Override
    public void beginFactSetTupleAggregation(OlapMeasureMember measure, GFFactsEvalTuple tuple) {
        this.currentNode = new OlapMdxDebugFactSetTupleAggregationNode(this, this.currentNode, measure, tuple);
    }

    @Override
    public void endFactSetTupleAggregation(OlapMeasureMember measure, GFFactsEvalTuple tuple, OlapScalarEntity value) {
        if (!(this.currentNode instanceof OlapMdxDebugFactSetTupleAggregationNode)) {
            throw new CdProgrammingException("Debugger : endFactSetTupleAggregation does not match beginFactSetTupleAggregation");
        }
        OlapMdxDebugFactSetTupleAggregationNode node = (OlapMdxDebugFactSetTupleAggregationNode)this.currentNode;
        node.setValue(value);
        this.currentNode.onEnd();
        this.currentNode = this.currentNode.getParent();
    }

    @Override
    public void onCachedTupleValue() {
        if (this.currentNode != null) {
            this.currentNode.onCachedTupleValue(true);
        }
    }

    @Override
    public void onDefaultMember(OlapMember member) {
        if (this.currentNode != null) {
            this.currentNode.onDefaultMember(member);
        }
    }

    @Override
    public void onFastCrossjoinNonEmptyBehavior(String nonEmptyBehavior) {
        if (this.currentNode != null) {
            this.currentNode.onFastCrossjoinNonEmptyBehavior(nonEmptyBehavior);
        }
    }

    @Override
    public void onStoppedListening(@Nullable GFNode iterableNode) {
        if (iterableNode != null) {
            OlapMdxDebugFactSetIterationNode iterations;
            OlapMdxDebugNode iterationNode;
            OlapMdxDebugNodeNode iNode = this.iterableNodes.get(iterableNode);
            if (iNode != null && iNode.getChildrenCount() == 1 && (iterationNode = iNode.getChild(0)) instanceof OlapMdxDebugFactSetIterationNode && !(iterations = (OlapMdxDebugFactSetIterationNode)iterationNode).isTruncated()) {
                iterations.setTruncated(true);
                new OlapMdxDebugLambdaTruncatedNode(this, iterationNode);
            }
        } else {
            this.currentNode = new OlapMdxDebugLambdaTruncatedNode(this, this.currentNode);
            this.currentNode.onEnd();
            this.currentNode = this.currentNode.getParent();
        }
    }

    @Nullable
    private OlapMdxDebugNode getTopLevelSlicerNode() {
        OlapMdxDebugNode from = this.getRoot();
        return this.doGetTopLevelSlicerNode(from);
    }

    @Nullable
    private OlapMdxDebugNode doGetTopLevelSlicerNode(OlapMdxDebugNode from) {
        for (OlapMdxDebugNode node : from.getChildren()) {
            if (node.isSlicer()) {
                return node;
            }
            OlapMdxDebugNode slicer = this.doGetTopLevelSlicerNode(node);
            if (slicer == null || !this.isTopLevelSlicer(slicer)) continue;
            return slicer;
        }
        return null;
    }

    private boolean isTopLevelSlicer(OlapMdxDebugNode slicer) {
        for (OlapMdxDebugNode parent = slicer.getParent(); parent != null; parent = parent.getParent()) {
            if (!parent.isSubSelect()) continue;
            return false;
        }
        return true;
    }

    @Nullable
    private OlapMdxDebugNode getTopLevelSubSelectNode() {
        OlapMdxDebugNode from = this.getRoot();
        return this.doGetTopLevelSubSelectNode(from);
    }

    @Nullable
    private OlapMdxDebugNode doGetTopLevelSubSelectNode(OlapMdxDebugNode from) {
        for (OlapMdxDebugNode node : from.getChildren()) {
            if (node.isSubSelect()) {
                return node;
            }
            OlapMdxDebugNode slicer = this.doGetTopLevelSubSelectNode(node);
            if (slicer == null || !this.isTopLevelSubSelect(slicer)) continue;
            return slicer;
        }
        return null;
    }

    private boolean isTopLevelSubSelect(OlapMdxDebugNode subSelect) {
        for (OlapMdxDebugNode parent = subSelect.getParent(); parent != null; parent = parent.getParent()) {
            if (!parent.isSubSelect()) continue;
            return false;
        }
        return true;
    }

    @Nullable
    private OlapMdxDebugCellsNode getCellsNode() {
        for (OlapMdxDebugNode node : this.getRoot().getChildren()) {
            if (!(node instanceof OlapMdxDebugCellsNode)) continue;
            return (OlapMdxDebugCellsNode)node;
        }
        return null;
    }

    private void toInfo(OlapNameContext nameContext, StringBuilder builder, OlapMdxDebugNode node) {
        builder.append(CdStringUtils.multiply((int)node.getDepth(), (char)'.'));
        builder.append(node.getClass().getSimpleName());
        if (node instanceof OlapMdxDebugInstrNode) {
            builder.append("(").append(((OlapMdxDebugInstrNode)node).getInstrClassName()).append(")");
        }
        if (node instanceof OlapMdxDebugPreparedInstrNode) {
            builder.append("(").append(((OlapMdxDebugPreparedInstrNode)node).getInstrClassName()).append(")");
        }
        if (node instanceof OlapMdxDebugNodeNode) {
            builder.append("(").append(((OlapMdxDebugNodeNode)node).getNodeClassName()).append(")");
        }
        builder.append("\t {").append(node.getArgumentInfo(nameContext)).append("}");
        builder.append("\t").append(node.getReturnValue(nameContext));
        builder.append("\t {").append(node.getReturnType()).append("}");
        builder.append("\t    ").append(node.getExecTimeMillis()).append(" ms.");
        builder.append("\n");
        for (OlapMdxDebugNode child : node.getChildren()) {
            this.toInfo(nameContext, builder, child);
        }
    }

    public String toInfo(OlapNameContext nameContext) {
        StringBuilder builder = new StringBuilder();
        this.toInfo(nameContext, builder, this.getRoot());
        return builder.toString();
    }

    @Override
    public void assertExecution(OlapScriptInstr instr) {
        List<OlapStatementInstr> statements = instr.getStatements();
        if (statements.size() > 1) {
            throw new OlapEvaluationException(instr.getLocationRange(), OlapErrorCode.DEBUGGER_SCRIPT_ERROR, new Serializable[0]);
        }
    }
}

