/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.facts.column.memmaplist;

import crazydev.common.collection.CdComparableArray;
import crazydev.common.exception.programming.CdShouldNotBeHereProgrammingException;
import crazydev.common.thread.CdThreadSupport;
import crazydev.common.thread.CdThreadSupportLevel;
import crazydev.iccube.olap.entity.scalar.IOlapDoubleValueIterable;
import crazydev.iccube.olap.facts.column.columns.OlapScalarEntityFactColumn;
import crazydev.iccube.olap.facts.column.list.IOlapFactShortList;
import crazydev.iccube.olap.facts.column.memmaplist.OlapFactBaseMemMapList;
import crazydev.iccube.olap.facts.column.memmaplist.OlapFactMemMapListConfiguration;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.ShortBuffer;
import java.util.Objects;

public class OlapFactShortMemMapList
extends OlapFactBaseMemMapList<ShortBuffer>
implements IOlapFactShortList {
    private OlapFactShortMemMapList(OlapFactMemMapListConfiguration configuration) {
        super(configuration);
    }

    public static IOlapFactShortList create(OlapFactMemMapListConfiguration configuration) {
        return new OlapFactShortMemMapList(configuration);
    }

    @Override
    protected String getFriendlyTypeName() {
        return "short";
    }

    @Override
    public int getValueByteCount() {
        return 2;
    }

    protected ShortBuffer[] createBuffers(int count) {
        return new ShortBuffer[count];
    }

    @Override
    protected ShortBuffer createBuffer(MappedByteBuffer buffer) {
        return buffer.asShortBuffer();
    }

    @Override
    public void add(short val) {
        this.ensureCapacity();
        ((ShortBuffer)this.currentBuffer).put(this.currentBufferPos++, val);
        ++this.size;
    }

    @Override
    public void addVector(CdComparableArray values) {
        for (int ii = 0; ii < values.size(); ++ii) {
            this.add((Short)values.get(ii));
        }
    }

    @Override
    public IOlapDoubleValueIterable getVector(final int from, final int to) {
        return new IOlapDoubleValueIterable(){
            final /* synthetic */ OlapFactShortMemMapList this$0;
            {
                OlapFactShortMemMapList olapFactShortMemMapList = this$0;
                Objects.requireNonNull(olapFactShortMemMapList);
                this.this$0 = olapFactShortMemMapList;
            }

            @Override
            public int size() {
                return to - from;
            }

            @Override
            public double value(int pos) {
                return this.this$0.getQuick(from + pos);
            }
        };
    }

    @Override
    public Comparable getComparable(int from, int to) {
        Comparable[] values = new Short[to - from];
        for (int ii = 0; ii < values.length; ++ii) {
            values[ii] = Short.valueOf(this.getQuick(from + ii));
        }
        return new CdComparableArray(values);
    }

    @Override
    public void setQuick(int offset, short val) {
        ((ShortBuffer[])this.buffers)[offset >> this.bufferItemCountBits].put(offset & this.bufferItemCountMask, val);
    }

    @Override
    public short getQuick(int rowId) {
        return ((ShortBuffer[])this.buffers)[rowId >> this.bufferItemCountBits].get(rowId & this.bufferItemCountMask);
    }

    @Override
    public int lookup(short lookupValue, int start) {
        if (start < 0 || start >= this.size) {
            return -1;
        }
        int startIdx = start >> this.bufferItemCountBits;
        int startBufferIdx = start & this.bufferItemCountMask;
        int rowId = start;
        for (int idx = startIdx; idx < ((ShortBuffer[])this.buffers).length; ++idx) {
            ShortBuffer buffer = ((ShortBuffer[])this.buffers)[idx];
            int limit = buffer.limit();
            for (int pageIdx = startBufferIdx; rowId < this.size && pageIdx < limit; ++rowId, ++pageIdx) {
                short value = buffer.get(pageIdx);
                if (lookupValue != value) continue;
                return rowId;
            }
            startBufferIdx = 0;
        }
        return -1;
    }

    @Override
    @CdThreadSupport(value=CdThreadSupportLevel.THREAD_SAFE)
    public void setNew(int rowId, short val) {
        throw new CdShouldNotBeHereProgrammingException();
    }

    @Override
    protected void aggregateSingleBufferPoints(OlapScalarEntityFactColumn.Aggregator aggregator, int buffer, int[] rowIds, int len) {
        ShortBuffer values = ((ShortBuffer[])this.buffers)[buffer];
        for (int row = 0; row < len; ++row) {
            int rowId = rowIds[row];
            short value = values.get(rowId & this.bufferItemCountMask);
            if (value == Short.MIN_VALUE) continue;
            aggregator.aggregate(value);
        }
    }

    @Override
    public final void aggregatePoint(OlapScalarEntityFactColumn.Aggregator aggregator, int rowId) {
        short value = this.getQuick(rowId);
        if (value != Short.MIN_VALUE) {
            aggregator.aggregate(value);
        }
    }

    @Override
    protected void doAggregateRange(OlapScalarEntityFactColumn.Aggregator aggregator, int bufferNumber, int startOffset, int endOffset) {
        ShortBuffer buffer = ((ShortBuffer[])this.buffers)[bufferNumber];
        for (int offset = startOffset; offset < endOffset; ++offset) {
            short value = buffer.get(offset);
            if (value == Short.MIN_VALUE) continue;
            aggregator.aggregate(value);
        }
    }

    @Override
    protected void addValues(ByteBuffer buffer) {
        ShortBuffer typedBuffer = ((ShortBuffer[])this.buffers)[((ShortBuffer[])this.buffers).length - 1];
        typedBuffer.rewind();
        typedBuffer.put(buffer.asShortBuffer());
    }
}

