/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.facts.column.memmaplist;

import crazydev.common.exception.programming.CdProgrammingException;
import crazydev.common.fs.CdVFileSystem;
import crazydev.iccube.olap.facts.column.columns.IOlapFactColumn;
import crazydev.iccube.olap.facts.column.columns.IOlapFactColumnId;
import crazydev.iccube.olap.facts.column.columns.OlapComparableEntityFactColumn;
import crazydev.iccube.olap.facts.column.columns.OlapFactMeasureColumnWithMeasureGroup;
import crazydev.iccube.olap.facts.column.columns.OlapNewCountScalarEntityFactColumn;
import crazydev.iccube.olap.facts.column.list.IOlapFactBoolList;
import crazydev.iccube.olap.facts.column.list.IOlapFactBooleanList;
import crazydev.iccube.olap.facts.column.list.IOlapFactCharStringList;
import crazydev.iccube.olap.facts.column.list.IOlapFactComparableList;
import crazydev.iccube.olap.facts.column.list.IOlapFactDateList;
import crazydev.iccube.olap.facts.column.list.IOlapFactDateTimeList;
import crazydev.iccube.olap.facts.column.list.IOlapFactDoubleList;
import crazydev.iccube.olap.facts.column.list.IOlapFactDoubleVectorList;
import crazydev.iccube.olap.facts.column.list.IOlapFactFloatList;
import crazydev.iccube.olap.facts.column.list.IOlapFactFloatVectorList;
import crazydev.iccube.olap.facts.column.list.IOlapFactIntList;
import crazydev.iccube.olap.facts.column.list.IOlapFactIntVectorList;
import crazydev.iccube.olap.facts.column.list.IOlapFactListFactory;
import crazydev.iccube.olap.facts.column.list.IOlapFactLongList;
import crazydev.iccube.olap.facts.column.list.IOlapFactLongVectorList;
import crazydev.iccube.olap.facts.column.list.IOlapFactModifiedUtf8StringList;
import crazydev.iccube.olap.facts.column.list.IOlapFactShortList;
import crazydev.iccube.olap.facts.column.list.IOlapFactShortVectorList;
import crazydev.iccube.olap.facts.column.memlist.OlapFactCharStringPaginatedList;
import crazydev.iccube.olap.facts.column.memlist.OlapFactPaginatedListFactory;
import crazydev.iccube.olap.facts.column.memlist.vector.OlapFactDoubleVectorList;
import crazydev.iccube.olap.facts.column.memlist.vector.OlapFactFloatVectorList;
import crazydev.iccube.olap.facts.column.memlist.vector.OlapFactIntVectorList;
import crazydev.iccube.olap.facts.column.memlist.vector.OlapFactLongVectorList;
import crazydev.iccube.olap.facts.column.memlist.vector.OlapFactShortVectorList;
import crazydev.iccube.olap.facts.column.memmaplist.OlapFactBoolMemMapList;
import crazydev.iccube.olap.facts.column.memmaplist.OlapFactBooleanMemMapList;
import crazydev.iccube.olap.facts.column.memmaplist.OlapFactDateMemMapList;
import crazydev.iccube.olap.facts.column.memmaplist.OlapFactDateTimeMemMapList;
import crazydev.iccube.olap.facts.column.memmaplist.OlapFactDoubleMemMapList;
import crazydev.iccube.olap.facts.column.memmaplist.OlapFactFloatMemMapList;
import crazydev.iccube.olap.facts.column.memmaplist.OlapFactIntMemMapList;
import crazydev.iccube.olap.facts.column.memmaplist.OlapFactLongMemMapList;
import crazydev.iccube.olap.facts.column.memmaplist.OlapFactMemMapListConfiguration;
import crazydev.iccube.olap.facts.column.memmaplist.OlapFactModifiedUtf8StringMemMapList;
import crazydev.iccube.olap.facts.column.memmaplist.OlapFactShortMemMapList;
import java.io.File;
import org.jetbrains.annotations.Nullable;

public class OlapFactMemMapListFactory
implements IOlapFactListFactory {
    private final CdVFileSystem vfs;
    private final OlapFactPaginatedListFactory fallback;
    private final File mmapDirectory;
    private final int fileBits;
    private final int bufferBits;

    public OlapFactMemMapListFactory(CdVFileSystem vfs, OlapFactPaginatedListFactory fallback, int fileBits, int bufferBits, File mmapDirectory) {
        this.vfs = vfs;
        this.fallback = fallback;
        this.mmapDirectory = mmapDirectory;
        this.fileBits = fileBits;
        this.bufferBits = bufferBits;
    }

    @Override
    public boolean isInMemory() {
        return false;
    }

    @Override
    public File getMmapDirectory() {
        return this.mmapDirectory;
    }

    private OlapFactMemMapListConfiguration createConfiguration(IOlapFactColumn column) {
        File file = this.mmapDirectory;
        synchronized (file) {
            IOlapFactColumnId id = column.getId();
            if (id instanceof OlapFactMeasureColumnWithMeasureGroup) {
                OlapFactMeasureColumnWithMeasureGroup columnId = (OlapFactMeasureColumnWithMeasureGroup)id;
                String cubeName = columnId.getCubeName();
                File cubeDirectory = this.getOrCreateDirectory(new File(this.mmapDirectory, CdVFileSystem.toFileName((String)cubeName)));
                String measureGroupName = columnId.getMeasureGroupName();
                File measureGroupDirectory = this.getOrCreateDirectory(new File(cubeDirectory, CdVFileSystem.toFileName((String)measureGroupName)));
                boolean distinctCount = columnId.isDistinctCount();
                return new OlapFactMemMapListConfiguration(this.vfs, columnId, measureGroupDirectory, columnId.getColumnName(), distinctCount, this.fileBits, this.bufferBits);
            }
            throw new CdProgrammingException("internal error: no directory setup for [" + column.getClass().getSimpleName() + "]!");
        }
    }

    private File getOrCreateDirectory(File directory) {
        if (directory.exists()) {
            if (!directory.isDirectory()) {
                throw new RuntimeException(String.format("The (existing) requested directory [%s] is not a directory", directory.getPath()));
            }
            return directory;
        }
        if (!this.vfs.mkdir(directory)) {
            throw new RuntimeException(String.format("Could not created the requested directory [%s]", directory.getPath()));
        }
        return directory;
    }

    @Override
    public IOlapFactDoubleList createDoubleList(IOlapFactColumn column) {
        return this.createDoubleList(column, null);
    }

    @Override
    public IOlapFactDoubleList createDoubleList(IOlapFactColumn column, @Nullable String extra) {
        OlapFactMemMapListConfiguration configuration = this.createConfiguration(column);
        if (extra != null) {
            configuration = configuration.copyForExtra(extra);
        }
        return OlapFactDoubleMemMapList.create(configuration);
    }

    @Override
    public IOlapFactDoubleVectorList createDoubleVectorList(IOlapFactColumn column) {
        return new OlapFactDoubleVectorList(this, column);
    }

    @Override
    public IOlapFactFloatList createFloatList(IOlapFactColumn column) {
        return this.createFloatList(column, null);
    }

    @Override
    public IOlapFactFloatList createFloatList(IOlapFactColumn column, @Nullable String extra) {
        OlapFactMemMapListConfiguration configuration = this.createConfiguration(column);
        if (extra != null) {
            configuration = configuration.copyForExtra(extra);
        }
        return OlapFactFloatMemMapList.create(configuration);
    }

    @Override
    public IOlapFactFloatVectorList createFloatVectorList(IOlapFactColumn column) {
        return new OlapFactFloatVectorList(this, column);
    }

    @Override
    public IOlapFactLongList createLongList(IOlapFactColumn column) {
        return this.createLongList(column, null);
    }

    @Override
    public IOlapFactLongList createLongList(IOlapFactColumn column, @Nullable String extra) {
        OlapFactMemMapListConfiguration configuration = this.createConfiguration(column);
        if (extra != null) {
            configuration = configuration.copyForExtra(extra);
        }
        return OlapFactLongMemMapList.create(configuration);
    }

    @Override
    public IOlapFactLongVectorList createLongVectorList(IOlapFactColumn column) {
        return new OlapFactLongVectorList(this, column);
    }

    @Override
    public IOlapFactIntList createIntList(IOlapFactColumn column) {
        return this.createIntList(column, null);
    }

    @Override
    public IOlapFactIntList createIntList(IOlapFactColumn column, @Nullable String extra) {
        OlapFactMemMapListConfiguration configuration = this.createConfiguration(column);
        if (extra != null) {
            configuration = configuration.copyForExtra(extra);
        }
        return OlapFactIntMemMapList.create(configuration);
    }

    @Override
    public IOlapFactIntVectorList createIntVectorList(IOlapFactColumn column) {
        return new OlapFactIntVectorList(this, column);
    }

    @Override
    public IOlapFactShortList createShortList(IOlapFactColumn column) {
        return this.createShortList(column, null);
    }

    @Override
    public IOlapFactShortList createShortList(IOlapFactColumn column, @Nullable String extra) {
        OlapFactMemMapListConfiguration configuration = this.createConfiguration(column);
        if (extra != null) {
            configuration = configuration.copyForExtra(extra);
        }
        return OlapFactShortMemMapList.create(configuration);
    }

    @Override
    public IOlapFactShortVectorList createShortVectorList(IOlapFactColumn column) {
        return new OlapFactShortVectorList(this, column);
    }

    @Override
    public IOlapFactShortList createByteList(IOlapFactColumn column) {
        return OlapFactShortMemMapList.create(this.createConfiguration(column));
    }

    @Override
    public IOlapFactBooleanList createBooleanList(IOlapFactColumn column) {
        return new OlapFactBooleanMemMapList(this.createConfiguration(column));
    }

    @Override
    public IOlapFactBoolList createBoolList(OlapNewCountScalarEntityFactColumn column) {
        return new OlapFactBoolMemMapList(this.createConfiguration(column));
    }

    @Override
    public IOlapFactDateList createDateList(IOlapFactColumn column) {
        return new OlapFactDateMemMapList(this.createConfiguration(column));
    }

    @Override
    public IOlapFactDateTimeList createDateTimeList(IOlapFactColumn column) {
        return new OlapFactDateTimeMemMapList(this.createConfiguration(column));
    }

    @Override
    public IOlapFactModifiedUtf8StringList createModifiedUtf8StringList(IOlapFactColumn column) {
        return new OlapFactModifiedUtf8StringMemMapList(this.createConfiguration(column));
    }

    @Override
    public IOlapFactCharStringList createCharStringList(IOlapFactColumn column) {
        return new OlapFactCharStringPaginatedList();
    }

    @Override
    public IOlapFactComparableList createComparableList(OlapComparableEntityFactColumn column) {
        return this.fallback.createComparableList(column);
    }
}

