/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.facts.column.memmaplist;

import crazydev.common.collection.CdComparableArray;
import crazydev.common.exception.programming.CdShouldNotBeHereProgrammingException;
import crazydev.iccube.olap.entity.scalar.IOlapDoubleValueIterable;
import crazydev.iccube.olap.facts.column.columns.OlapScalarEntityFactColumn;
import crazydev.iccube.olap.facts.column.list.IOlapFactLongList;
import crazydev.iccube.olap.facts.column.memmaplist.OlapFactBaseMemMapList;
import crazydev.iccube.olap.facts.column.memmaplist.OlapFactMemMapListConfiguration;
import java.nio.ByteBuffer;
import java.nio.LongBuffer;
import java.nio.MappedByteBuffer;
import java.util.Objects;

public final class OlapFactLongMemMapList
extends OlapFactBaseMemMapList<LongBuffer>
implements IOlapFactLongList {
    private OlapFactLongMemMapList(OlapFactMemMapListConfiguration configuration) {
        super(configuration);
    }

    public static IOlapFactLongList create(OlapFactMemMapListConfiguration configuration) {
        return new OlapFactLongMemMapList(configuration);
    }

    @Override
    public IOlapFactLongList createForBooleanNulls() {
        return new OlapFactLongMemMapList(this.configuration.copyForBooleanNulls());
    }

    @Override
    protected String getFriendlyTypeName() {
        return "long";
    }

    @Override
    public int getValueByteCount() {
        return 8;
    }

    protected LongBuffer[] createBuffers(int count) {
        return new LongBuffer[count];
    }

    @Override
    protected LongBuffer createBuffer(MappedByteBuffer buffer) {
        return buffer.asLongBuffer();
    }

    @Override
    public void add(long val) {
        this.ensureCapacity();
        ((LongBuffer)this.currentBuffer).put(this.currentBufferPos++, val);
        ++this.size;
    }

    @Override
    public void addVector(CdComparableArray values) {
        for (int ii = 0; ii < values.size(); ++ii) {
            this.add((Long)values.get(ii));
        }
    }

    @Override
    public IOlapDoubleValueIterable getVector(final int from, final int to) {
        return new IOlapDoubleValueIterable(){
            final /* synthetic */ OlapFactLongMemMapList this$0;
            {
                OlapFactLongMemMapList olapFactLongMemMapList = this$0;
                Objects.requireNonNull(olapFactLongMemMapList);
                this.this$0 = olapFactLongMemMapList;
            }

            @Override
            public int size() {
                return to - from;
            }

            @Override
            public double value(int pos) {
                return this.this$0.getQuick(from + pos);
            }
        };
    }

    @Override
    public Comparable getComparable(int from, int to) {
        Comparable[] values = new Long[to - from];
        for (int ii = 0; ii < values.length; ++ii) {
            values[ii] = Long.valueOf(this.getQuick(from + ii));
        }
        return new CdComparableArray(values);
    }

    @Override
    public void setQuick(int offset, long val) {
        ((LongBuffer[])this.buffers)[offset >> this.bufferItemCountBits].put(offset & this.bufferItemCountMask, val);
    }

    @Override
    public long getQuick(int rowId) {
        return ((LongBuffer[])this.buffers)[rowId >> this.bufferItemCountBits].get(rowId & this.bufferItemCountMask);
    }

    @Override
    public int lookup(long lookupValue, int start) {
        if (start < 0 || start >= this.size) {
            return -1;
        }
        int startIdx = start >> this.bufferItemCountBits;
        int startBufferIdx = start & this.bufferItemCountMask;
        int rowId = start;
        for (int idx = startIdx; idx < ((LongBuffer[])this.buffers).length; ++idx) {
            LongBuffer buffer = ((LongBuffer[])this.buffers)[idx];
            int limit = buffer.limit();
            for (int pageIdx = startBufferIdx; rowId < this.size && pageIdx < limit; ++rowId, ++pageIdx) {
                long value = buffer.get(pageIdx);
                if (lookupValue != value) continue;
                return rowId;
            }
            startBufferIdx = 0;
        }
        return -1;
    }

    @Override
    public void setNew(int rowId, long val) {
        throw new CdShouldNotBeHereProgrammingException();
    }

    @Override
    public long[] ensureCapacity(int offset) {
        return null;
    }

    @Override
    protected void aggregateSingleBufferPoints(OlapScalarEntityFactColumn.Aggregator aggregator, int buffer, int[] rowIds, int len) {
        LongBuffer values = ((LongBuffer[])this.buffers)[buffer];
        for (int row = 0; row < len; ++row) {
            int rowId = rowIds[row];
            long value = values.get(rowId & this.bufferItemCountMask);
            if (value == Long.MIN_VALUE) continue;
            aggregator.aggregate(value);
        }
    }

    @Override
    public final void aggregatePoint(OlapScalarEntityFactColumn.Aggregator aggregator, int rowId) {
        long value = this.getQuick(rowId);
        if (value != Long.MIN_VALUE) {
            aggregator.aggregate(value);
        }
    }

    @Override
    protected void doAggregateRange(OlapScalarEntityFactColumn.Aggregator aggregator, int bufferNumber, int startOffset, int endOffset) {
        LongBuffer buffer = ((LongBuffer[])this.buffers)[bufferNumber];
        for (int offset = startOffset; offset < endOffset; ++offset) {
            long value = buffer.get(offset);
            if (value == Long.MIN_VALUE) continue;
            aggregator.aggregate(value);
        }
    }

    @Override
    protected void addValues(ByteBuffer buffer) {
        LongBuffer typedBuffer = ((LongBuffer[])this.buffers)[((LongBuffer[])this.buffers).length - 1];
        typedBuffer.rewind();
        typedBuffer.put(buffer.asLongBuffer());
    }
}

