/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.facts.column.memmaplist;

import crazydev.common.exception.CdRuntimeException;
import crazydev.common.exception.programming.CdProgrammingException;
import crazydev.common.fs.CdVFileSystem;
import crazydev.common.fs.CdVFileSystemUtils;
import crazydev.common.utils.CdSizeUtils;
import crazydev.common.utils.CdSystemUtils;
import crazydev.iccube.cleaner.OlapFileCleaner;
import crazydev.iccube.cluster.node.backup.N_BackupContext;
import crazydev.iccube.cluster.node.backup.N_RestoreContext;
import crazydev.iccube.cluster.shared.backup.S_BackupInputStream;
import crazydev.iccube.cluster.shared.backup.S_BackupOutputStream;
import crazydev.iccube.olap.facts.column.columns.OlapScalarEntityFactColumn;
import crazydev.iccube.olap.facts.column.list.OlapFactListException;
import crazydev.iccube.olap.facts.column.memmaplist.OlapFactMemMapList;
import crazydev.iccube.olap.facts.column.memmaplist.OlapFactMemMapListConfiguration;
import crazydev.iccube.olap.loggers.OlapLoggers;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.log4j.Logger;

public abstract class OlapFactBaseMemMapList<BUFFER extends Buffer>
extends OlapFactMemMapList {
    private static final AtomicLong uniqueRunId = new AtomicLong(System.currentTimeMillis());
    private static final Object ensureUniquenessLOCK = new Object();
    protected final OlapFactMemMapListConfiguration configuration;
    protected final int bufferItemCount;
    protected final int bufferItemCountBits;
    protected final int bufferItemCountMask;
    private final List<FileInfo> files = new ArrayList<FileInfo>();
    private final long maxFileSizeB;
    protected BUFFER currentBuffer;
    protected int currentBufferPos;
    protected int size;
    protected BUFFER[] buffers;
    private ByteBuffer[] bBuffers;
    private int currentBufferInFile;

    public OlapFactBaseMemMapList(OlapFactMemMapListConfiguration configuration) {
        this.configuration = configuration;
        this.maxFileSizeB = configuration.getFileBits() == -1 ? -1L : (long)(1 << configuration.getFileBits());
        int bits = configuration.getBufferBits();
        int valueBits = Integer.numberOfTrailingZeros(this.getValueByteCount());
        this.bufferItemCountBits = bits - valueBits <= 0 ? 20 - valueBits : bits - valueBits;
        this.bufferItemCountMask = (1 << this.bufferItemCountBits) - 1;
        this.bufferItemCount = 1 << this.bufferItemCountBits;
        if (OlapLoggers.FACTS.isDebugEnabled()) {
            OlapLoggers.FACTS.debug((Object)("MDX facts : mmap file configuration [" + configuration.getColumnName() + "] [fileSize:" + (this.maxFileSizeB == -1L ? "unlimited" : CdSizeUtils.format((double)this.maxFileSizeB)) + "] [bufferSizeB:" + CdSizeUtils.format((double)(this.bufferItemCount * this.getValueByteCount())) + "]"));
        }
        this.currentBufferPos = -1;
    }

    public int getBufferItemCount() {
        return this.bufferItemCount;
    }

    protected abstract String getFriendlyTypeName();

    public abstract int getValueByteCount();

    public void cleanupResources(OlapFileCleaner cleaner) {
        this.destroyAllBuffers();
        for (FileInfo file : this.files) {
            boolean deleted;
            try {
                file.raFile.close();
            }
            catch (IOException exception) {
                OlapLoggers.FACTS.warn((Object)("MDX Facts : could not close the file [" + file.file.getAbsolutePath() + "]"));
            }
            if (deleted = CdVFileSystemUtils.deleteQuietly((File)file.file)) continue;
            cleaner.register(file.file);
        }
    }

    private void destroyAllBuffers() {
        if (this.buffers == null) {
            return;
        }
        for (int ii = 0; ii < this.buffers.length; ++ii) {
            ByteBuffer buffer = this.bBuffers[ii];
            CdSystemUtils.unmap((Logger)OlapLoggers.SERVER, (ByteBuffer)buffer);
            this.bBuffers[ii] = null;
            this.buffers[ii] = null;
        }
    }

    public void trimToSize() {
    }

    private void addFile() {
        String columnName_ = this.configuration.getColumnName();
        String columnName = CdVFileSystem.toFileName((String)columnName_);
        String extraColumnName = this.configuration.getExtraColumnName() != null ? "_" + CdVFileSystem.toFileName((String)this.configuration.getExtraColumnName()) : "";
        String filename = columnName + extraColumnName + "_" + uniqueRunId.getAndIncrement();
        File dataDirectory = this.configuration.getDataDirectory();
        CdVFileSystem vfs = this.configuration.getVfs();
        File uniqueFile = this.ensureUniqueness(new File(dataDirectory, filename));
        File file = new File(uniqueFile.getParent(), uniqueFile.getName() + ".icc-data");
        if (file.exists()) {
            throw new CdRuntimeException("internal error : existing file for column [" + columnName_ + "] [" + file.getAbsolutePath() + "]");
        }
        try {
            RandomAccessFile raFile = new RandomAccessFile(file, "rw");
            FileChannel raFileChannel = raFile.getChannel();
            this.files.add(new FileInfo(file, raFile, raFileChannel));
            this.currentBufferInFile = 0;
            if (OlapLoggers.FACTS.isDebugEnabled()) {
                OlapLoggers.FACTS.debug((Object)("MDX facts : mmap file [" + this.getFriendlyTypeName() + "] created for [" + columnName_ + "] [" + file.getAbsolutePath() + "]"));
            }
        }
        catch (FileNotFoundException ex) {
            String message = "could not create the facts [" + columnName_ + "][" + file.getAbsolutePath() + "]";
            OlapLoggers.FACTS.error((Object)("MDX Facts : " + message), (Throwable)ex);
            throw new OlapFactListException(message + " - " + ex.getMessage(), ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File ensureUniqueness(File file) {
        Object object = ensureUniquenessLOCK;
        synchronized (object) {
            File parent = file.getParentFile();
            String name = file.getName();
            File uniqueFile = file;
            int count = 1;
            while (uniqueFile.exists()) {
                uniqueFile = new File(parent, name + "_" + count);
                ++count;
            }
            return uniqueFile;
        }
    }

    protected MappedByteBuffer addByteBuffer() {
        FileInfo currentFile = this.lastFile();
        try {
            long sizeB = this.bufferItemCount * this.getValueByteCount();
            long positionB = (long)this.currentBufferInFile++ * sizeB;
            FileChannel raFileChannel = currentFile.raFileChannel;
            MappedByteBuffer buffer = raFileChannel.map(FileChannel.MapMode.READ_WRITE, positionB, sizeB);
            buffer.order(ByteOrder.nativeOrder());
            return buffer;
        }
        catch (IOException ex) {
            String message = "could not create the facts buffer [" + this.configuration.getColumnName() + "][" + currentFile.file.getAbsolutePath() + "]";
            OlapLoggers.FACTS.error((Object)("MDX Facts : " + message), (Throwable)ex);
            throw new OlapFactListException(message + " - " + ex.getMessage(), ex);
        }
    }

    private void addBuffer(MappedByteBuffer buffer) {
        if (this.buffers == null) {
            this.buffers = this.createBuffers(1);
            this.bBuffers = new ByteBuffer[1];
        } else {
            Buffer[] newBuffers = this.createBuffers(this.buffers.length + 1);
            System.arraycopy(this.buffers, 0, newBuffers, 0, this.buffers.length);
            this.buffers = newBuffers;
            newBuffers = new ByteBuffer[this.bBuffers.length + 1];
            System.arraycopy(this.bBuffers, 0, newBuffers, 0, this.bBuffers.length);
            this.bBuffers = newBuffers;
        }
        this.buffers[this.buffers.length - 1] = this.createBuffer(buffer);
        this.bBuffers[this.buffers.length - 1] = buffer;
        this.currentBuffer = this.buffers[this.buffers.length - 1];
        this.currentBufferPos = 0;
    }

    protected abstract BUFFER[] createBuffers(int var1);

    protected abstract BUFFER createBuffer(MappedByteBuffer var1);

    public int getCurrentBufferPos() {
        return this.currentBufferPos;
    }

    public int getBufferCount() {
        return this.buffers == null ? 0 : this.buffers.length;
    }

    public ByteBuffer getByteBuffer(int index) {
        return this.bBuffers[index];
    }

    private FileInfo lastFile() {
        if (this.files.isEmpty()) {
            throw new CdProgrammingException("internal error : no mmap file!");
        }
        return this.files.get(this.files.size() - 1);
    }

    protected void ensureCapacity() {
        if (this.currentBufferPos == -1 || this.currentBufferPos > this.bufferItemCount - 1) {
            this.addBuffer();
        }
    }

    protected void addBuffer() {
        if (this.files.isEmpty()) {
            this.addFile();
        } else if (this.maxFileSizeB != -1L) {
            FileInfo currentFile = this.lastFile();
            long currentFileSizeB = currentFile.file.length();
            long nextFileSizeB = currentFileSizeB + (long)(this.bufferItemCount * this.getValueByteCount());
            if (nextFileSizeB > this.maxFileSizeB) {
                this.addFile();
            }
        }
        this.addBuffer(this.addByteBuffer());
    }

    public long sizeOf() {
        return 0L;
    }

    public long sizeOfFiles() {
        long size = 0L;
        for (FileInfo file : this.files) {
            size += file.file.length();
        }
        return size;
    }

    public int size() {
        return this.size;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public void aggregateRange(OlapScalarEntityFactColumn.Aggregator aggregator, int startRowId, int endRowId) {
        int startPageNb = startRowId >> this.bufferItemCountBits;
        int startPageOffset = startRowId & this.bufferItemCountMask;
        int endPageNb = endRowId >> this.bufferItemCountBits;
        int endPageOffset = endRowId & this.bufferItemCountMask;
        this.doAggregateRange(aggregator, startPageNb, startPageOffset, startPageNb == endPageNb ? endPageOffset : this.bufferItemCount);
        for (int pageNb = startPageNb + 1; pageNb < endPageNb; ++pageNb) {
            this.doAggregateRange(aggregator, pageNb, 0, this.bufferItemCount);
        }
        if (endPageNb > startPageNb && endPageOffset != 0) {
            this.doAggregateRange(aggregator, endPageNb, 0, endPageOffset);
        }
    }

    protected abstract void doAggregateRange(OlapScalarEntityFactColumn.Aggregator var1, int var2, int var3, int var4);

    public void aggregatePoints(OlapScalarEntityFactColumn.Aggregator aggregator, int[] rowIds, int len) {
        int b1 = rowIds[0] >> this.bufferItemCountBits;
        int b2 = rowIds[len - 1] >> this.bufferItemCountBits;
        if (b1 == b2) {
            this.aggregateSingleBufferPoints(aggregator, b1, rowIds, len);
        } else {
            this.aggregateMultiBufferPoints(aggregator, rowIds, len);
        }
    }

    protected abstract void aggregateSingleBufferPoints(OlapScalarEntityFactColumn.Aggregator var1, int var2, int[] var3, int var4);

    protected void aggregateMultiBufferPoints(OlapScalarEntityFactColumn.Aggregator aggregator, int[] rowIds, int len) {
        for (int row = 0; row < len; ++row) {
            this.aggregatePoint(aggregator, rowIds[row]);
        }
    }

    protected abstract void aggregatePoint(OlapScalarEntityFactColumn.Aggregator var1, int var2);

    public void save(N_BackupContext context, S_BackupOutputStream out) throws IOException {
        int endRowId = this.size();
        out.writeInt(endRowId);
        if (endRowId == 0) {
            return;
        }
        int endPageNb = endRowId >> this.bufferItemCountBits;
        int endPageOffset = endRowId & this.bufferItemCountMask;
        if (out.getByteOrder() != ByteOrder.nativeOrder()) {
            throw new RuntimeException("internal error: inconsistent backup byte order [" + String.valueOf(out.getByteOrder()) + "] [" + String.valueOf(ByteOrder.nativeOrder()) + "]");
        }
        this.saveBuffer(context, out, 0, 0 == endPageNb ? endPageOffset : this.bufferItemCount);
        for (int pageNb = 1; pageNb < endPageNb; ++pageNb) {
            this.saveBuffer(context, out, pageNb, this.bufferItemCount);
        }
        if (endPageNb > 0 && endPageOffset != 0) {
            this.saveBuffer(context, out, endPageNb, endPageOffset);
        }
        out.writeInt(this.currentBufferPos);
    }

    private void saveBuffer(N_BackupContext context, S_BackupOutputStream out, int bufferNb, int len) throws IOException {
        if (context.isCancelling()) {
            return;
        }
        ByteBuffer bBuffer = this.bBuffers[bufferNb];
        int bLen = len * this.getValueByteCount();
        bBuffer.rewind();
        out.writeBytes(bBuffer, bLen);
    }

    public void restore(N_RestoreContext context, S_BackupInputStream in) throws IOException {
        int endRowId = in.readInt();
        if (endRowId == 0) {
            return;
        }
        int endPageNb = endRowId >> this.bufferItemCountBits;
        int endPageOffset = endRowId & this.bufferItemCountMask;
        ByteOrder byteOrder = in.getByteOrder();
        this.restoreBuffer(context, in, byteOrder, 0 == endPageNb ? endPageOffset : this.bufferItemCount);
        for (int pageNb = 1; pageNb < endPageNb; ++pageNb) {
            this.restoreBuffer(context, in, byteOrder, this.bufferItemCount);
        }
        if (endPageNb > 0 && endPageOffset != 0) {
            this.restoreBuffer(context, in, byteOrder, endPageOffset);
        }
        this.size = endRowId;
        this.currentBufferPos = in.readInt();
    }

    private void restoreBuffer(N_RestoreContext context, S_BackupInputStream in, ByteOrder byteOrder, int len) throws IOException {
        if (context.isCancelling()) {
            return;
        }
        this.addBuffer();
        int bLen = len * this.getValueByteCount();
        if (this.getValueByteCount() == 1 || byteOrder == ByteOrder.nativeOrder()) {
            ByteBuffer bBuffer = this.bBuffers[this.bBuffers.length - 1];
            bBuffer.rewind();
            in.readBytes(bBuffer, bLen);
        } else {
            ByteBuffer bBuffer = ByteBuffer.allocate(bLen);
            bBuffer.order(byteOrder);
            bBuffer.rewind();
            in.readBytes(bBuffer, bLen);
            bBuffer.rewind();
            this.addValues(bBuffer);
        }
    }

    protected abstract void addValues(ByteBuffer var1);

    static class FileInfo {
        final File file;
        final RandomAccessFile raFile;
        final FileChannel raFileChannel;

        FileInfo(File file, RandomAccessFile raFile, FileChannel raFileChannel) {
            this.file = file;
            this.raFile = raFile;
            this.raFileChannel = raFileChannel;
        }
    }
}

