/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.facts.column.memlist.utf8;

import crazydev.common.collection.CdPaginatedIntList;
import crazydev.common.exception.programming.CdProgrammingException;
import crazydev.common.exception.programming.CdShouldNotBeHereProgrammingException;
import crazydev.common.olap.OlapConfiguration;
import crazydev.common.system.CdRamUsageEstimator;
import crazydev.common.utils.CdModifiedUTF8StringUtils;
import crazydev.iccube.cleaner.OlapFileCleaner;
import crazydev.iccube.cluster.node.backup.N_BackupContext;
import crazydev.iccube.cluster.node.backup.N_RestoreContext;
import crazydev.iccube.cluster.shared.backup.S_BackupInputStream;
import crazydev.iccube.cluster.shared.backup.S_BackupOutputStream;
import crazydev.iccube.olap.entity.OlapEmptyEntity;
import crazydev.iccube.olap.entity.scalar.OlapScalarEntity;
import crazydev.iccube.olap.entity.scalar.OlapStringEntity;
import crazydev.iccube.olap.facts.column.columns.IOlapFactExtraComparator;
import crazydev.iccube.olap.facts.column.columns.OlapScalarEntityFactColumn;
import crazydev.iccube.olap.facts.column.list.IOlapFactByteList;
import crazydev.iccube.olap.facts.column.list.IOlapFactIntList;
import crazydev.iccube.olap.facts.column.list.IOlapFactList;
import java.io.IOException;
import java.util.Arrays;
import org.jetbrains.annotations.Nullable;

public class OlapFactModifiedUtf8StringPaginatedListHelper {
    private static final char[] LOWER_CASE_MAP = new char[128];
    private static final int LIMIT_BYTES = OlapConfiguration.LIST_UTF8_LIMIT_BYTES;
    private static long SHALLOW_SIZE_OF = -1L;
    private final Factory factory;
    private IOlapFactIntList[] positions;
    private IOlapFactByteList[] modifiedUTF8;
    private int[] startPosition;

    public OlapFactModifiedUtf8StringPaginatedListHelper(Factory factory) {
        this.factory = factory;
        this.positions = new IOlapFactIntList[]{factory.createInt()};
        this.modifiedUTF8 = new IOlapFactByteList[]{factory.createBytes()};
        this.startPosition = new int[]{0};
    }

    public void cleanupResources(OlapFileCleaner cleaner) {
        int i;
        for (i = 0; i < this.positions.length; ++i) {
            this.positions[i].cleanupResources(cleaner);
        }
        for (i = 0; i < this.modifiedUTF8.length; ++i) {
            this.modifiedUTF8[i].cleanupResources(cleaner);
        }
    }

    public int getBufferCount() {
        return -1;
    }

    public void addNewValue(@Nullable String val) {
        int lastArray = this.positions.length - 1;
        IOlapFactByteList byteList = this.modifiedUTF8[lastArray];
        this.positions[lastArray].add(byteList.size());
        byteList.add(CdModifiedUTF8StringUtils.toModifiedUTF8((String)val, (byte)0));
        if (byteList.size() > LIMIT_BYTES) {
            this.positions = Arrays.copyOf(this.positions, this.positions.length + 1);
            this.modifiedUTF8 = Arrays.copyOf(this.modifiedUTF8, this.modifiedUTF8.length + 1);
            this.startPosition = Arrays.copyOf(this.startPosition, this.startPosition.length + 1);
            this.startPosition[this.startPosition.length - 1] = this.startPosition[this.startPosition.length - 2] + this.positions[this.startPosition.length - 2].size();
            this.positions[this.positions.length - 1] = this.factory.createInt();
            this.modifiedUTF8[this.modifiedUTF8.length - 1] = this.factory.createBytes();
        }
    }

    public byte[] getUnderlyingHackValue(int rowId) {
        int pageIdx = this.getPage(rowId);
        int pos = this.positions[pageIdx].getQuick(rowId - this.startPosition[pageIdx]);
        byte[] utf8 = this.modifiedUTF8[pageIdx].getQuick(pos, (byte)0);
        return utf8;
    }

    @Nullable
    public String getValueAsObject(int rowId) {
        int pageIdx = this.getPage(rowId);
        int pos = this.positions[pageIdx].getQuick(rowId - this.startPosition[pageIdx]);
        byte[] utf8 = this.modifiedUTF8[pageIdx].getQuick(pos, (byte)0);
        String value = CdModifiedUTF8StringUtils.toString((byte[])utf8);
        return value;
    }

    public int hashCode(int rowId) {
        int pageIdx = this.getPage(rowId);
        int pos = this.positions[pageIdx].getQuick(rowId - this.startPosition[pageIdx]);
        byte[] utf8 = this.modifiedUTF8[pageIdx].getQuick(pos, (byte)0);
        return Arrays.hashCode(utf8);
    }

    private int getPage(int pos) {
        if (this.startPosition.length == 1) {
            return 0;
        }
        int idx = Arrays.binarySearch(this.startPosition, pos);
        return idx >= 0 ? idx : -idx - 2;
    }

    public void trimToSize() {
        int i;
        for (i = 0; i < this.positions.length; ++i) {
            this.positions[i].trimToSize();
        }
        for (i = 0; i < this.modifiedUTF8.length; ++i) {
            this.modifiedUTF8[i].trimToSize();
        }
    }

    public long sizeOf() {
        int i;
        long size = SHALLOW_SIZE_OF != -1L ? SHALLOW_SIZE_OF : (SHALLOW_SIZE_OF = CdRamUsageEstimator.shallowSizeOf((Object)this));
        for (i = 0; i < this.positions.length; ++i) {
            size += this.positions[i].sizeOf();
        }
        for (i = 0; i < this.modifiedUTF8.length; ++i) {
            size += this.modifiedUTF8[i].sizeOf();
        }
        return size;
    }

    public long sizeOfFiles() {
        int i;
        long size = 0L;
        for (i = 0; i < this.positions.length; ++i) {
            size += this.positions[i].sizeOfFiles();
        }
        for (i = 0; i < this.modifiedUTF8.length; ++i) {
            size += this.modifiedUTF8[i].sizeOfFiles();
        }
        return size;
    }

    public int size() {
        int size = 0;
        for (int i = 0; i < this.positions.length; ++i) {
            size += this.positions[i].size();
        }
        return size;
    }

    public boolean isEmpty() {
        return this.positions.length == 0 || this.positions[0].isEmpty();
    }

    public int lookup(Comparable lookupValue, int start) {
        int size = this.size();
        if (start < 0 || start >= size || !(lookupValue instanceof String)) {
            return -1;
        }
        String lookupString = (String)((Object)lookupValue);
        byte[] lookupUTF8 = CdModifiedUTF8StringUtils.toModifiedUTF8((String)lookupString);
        for (int idx = start; idx < size; ++idx) {
            if (!this.equals(lookupUTF8, idx)) continue;
            return idx;
        }
        return -1;
    }

    private boolean equals(byte[] values, int rowId) {
        int pageIdx = this.getPage(rowId);
        int posInUTF = pageIdx == 0 ? rowId : rowId - this.startPosition[pageIdx];
        int pos = this.positions[pageIdx].getQuick(posInUTF);
        IOlapFactByteList bytes = this.modifiedUTF8[pageIdx];
        int utf8size = bytes.size();
        for (int valuesPos = 0; valuesPos < values.length; ++valuesPos) {
            byte b2;
            byte b1 = values[valuesPos];
            byte by = b2 = pos < utf8size ? bytes.getQuick(pos++) : (byte)0;
            if (b1 == b2) continue;
            return false;
        }
        return pos < bytes.size() && bytes.getQuick(pos) == 0;
    }

    public int binarySearch(CdPaginatedIntList sortList, String compKey, @Nullable IOlapFactExtraComparator extraComparator) {
        int low = 0;
        int high = sortList.size() - 1;
        while (low <= high) {
            int mid = low + high >>> 1;
            int misKeySortedIdx = sortList.getInt(mid);
            int comp = this.compareTo(compKey, misKeySortedIdx);
            if (comp == 0 && extraComparator != null) {
                comp = extraComparator.compareOtherColumns(misKeySortedIdx);
            }
            if (comp > 0) {
                low = mid + 1;
                continue;
            }
            if (comp < 0) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        return -low - 1;
    }

    public byte[] getModifiedUtf8(String value) {
        return CdModifiedUTF8StringUtils.toModifiedUTF8((String)value);
    }

    public int compareToModifiedUtf8(String value, int rowId) {
        return this.compareTo(value, rowId);
    }

    private int compareTo(String lookup, int rowId) {
        int i;
        boolean isNull;
        int pageIdx = this.getPage(rowId);
        int posInUTF = pageIdx == 0 ? rowId : rowId - this.startPosition[pageIdx];
        int pos = this.positions[pageIdx].getQuick(posInUTF);
        IOlapFactByteList bytes = this.modifiedUTF8[pageIdx];
        int utf8size = bytes.size();
        boolean bl = isNull = pos + 2 < utf8size && bytes.getQuick(pos) == -36 && bytes.getQuick(pos + 1) == -128 && bytes.getQuick(pos + 2) == 0;
        if (lookup == null) {
            return isNull ? 0 : -1;
        }
        if (isNull) {
            return 1;
        }
        for (i = 0; i < lookup.length() && pos < utf8size; ++i) {
            int comp;
            int cUTF8;
            if ((cUTF8 = bytes.getQuick(pos++) & 0xFF) == 0) {
                return 1;
            }
            char lookupCharUTF16 = lookup.charAt(i);
            if (cUTF8 <= 127) {
                cUTF16 = (char)cUTF8;
                comp = lookupCharUTF16 - cUTF16;
            } else {
                cUTF16 = this.toUTF16(bytes, pos, cUTF8);
                comp = lookupCharUTF16 - cUTF16;
                ++pos;
                if (cUTF8 >> 4 == 14) {
                    ++pos;
                }
            }
            if (comp == 0) continue;
            return comp;
        }
        if (pos >= utf8size) {
            return 1;
        }
        if (bytes.getQuick(pos) == 0) {
            return 0;
        }
        if (i >= lookup.length()) {
            return -1;
        }
        return 1;
    }

    private char toUTF16(IOlapFactByteList bytes, int pos, int c1) {
        switch (c1 >> 4) {
            case 12: 
            case 13: {
                byte c2 = bytes.getQuick(pos);
                char ch = (char)((c1 & 0x1F) << 6 | c2 & 0x3F);
                return ch;
            }
            case 14: {
                byte c2 = bytes.getQuick(pos);
                byte c3 = bytes.getQuick(pos + 1);
                char ch = (char)((c1 & 0xF) << 12 | (c2 & 0x3F) << 6 | c3 & 0x3F);
                return ch;
            }
        }
        throw new CdShouldNotBeHereProgrammingException();
    }

    public int binarySearchIgnoreCase(CdPaginatedIntList sortList, String lookupName) {
        int low = 0;
        int high = sortList.size() - 1;
        while (low <= high) {
            int mid = low + high >>> 1;
            int misKeySortedIdx = sortList.getInt(mid);
            int comp = this.compareWordIgnoreCase(lookupName, misKeySortedIdx);
            if (comp > 0) {
                low = mid + 1;
                continue;
            }
            if (comp < 0) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        return -low - 1;
    }

    public boolean equalsIgnoreCase(int rowId, String name) {
        return this.compareWordIgnoreCase(name, rowId) == 0;
    }

    private int compareWordIgnoreCase(String lookup, int rowId) {
        int i;
        boolean isNull;
        int pageIdx = this.getPage(rowId);
        int posInUTF = pageIdx == 0 ? rowId : rowId - this.startPosition[pageIdx];
        int pos = this.positions[pageIdx].getQuick(posInUTF);
        IOlapFactByteList bytes = this.modifiedUTF8[pageIdx];
        int utf8size = bytes.size();
        boolean bl = isNull = pos + 2 < utf8size && bytes.getQuick(pos) == -36 && bytes.getQuick(pos + 1) == -128 && bytes.getQuick(pos + 2) == 0;
        if (lookup == null) {
            return isNull ? 0 : -1;
        }
        if (isNull) {
            return 1;
        }
        for (i = 0; i < lookup.length() && pos < utf8size; ++i) {
            int comp;
            int cUTF8;
            if ((cUTF8 = bytes.getQuick(pos++) & 0xFF) == 0) {
                return 1;
            }
            if (cUTF8 <= 127) {
                v = Character.toLowerCase(lookup.charAt(i));
                c = LOWER_CASE_MAP[cUTF8];
                comp = v - c;
            } else {
                v = Character.toLowerCase(lookup.charAt(i));
                comp = v - (c = this.toExtendedIgnoreCase(bytes, true, pos, cUTF8));
                if (comp != 0) {
                    v = Character.toUpperCase(lookup.charAt(i));
                    c = this.toExtendedIgnoreCase(bytes, false, pos, cUTF8);
                    comp = v - c;
                }
                ++pos;
                if (cUTF8 >> 4 == 14) {
                    ++pos;
                }
            }
            if (comp == 0) continue;
            return comp;
        }
        if (pos >= utf8size) {
            return 1;
        }
        if (bytes.getQuick(pos) == 0) {
            return 0;
        }
        if (i >= lookup.length()) {
            return -1;
        }
        return 1;
    }

    private char toExtendedIgnoreCase(IOlapFactByteList bytes, boolean lowerCase, int pos, int c1) {
        switch (c1 >> 4) {
            case 12: 
            case 13: {
                byte c2 = bytes.getQuick(pos);
                char ch = (char)((c1 & 0x1F) << 6 | c2 & 0x3F);
                return lowerCase ? Character.toLowerCase(ch) : Character.toUpperCase(ch);
            }
            case 14: {
                byte c2 = bytes.getQuick(pos);
                byte c3 = bytes.getQuick(pos + 1);
                char ch = (char)((c1 & 0xF) << 12 | (c2 & 0x3F) << 6 | c3 & 0x3F);
                return lowerCase ? Character.toLowerCase(ch) : Character.toUpperCase(ch);
            }
        }
        throw new CdShouldNotBeHereProgrammingException();
    }

    public void aggregateRange(OlapScalarEntityFactColumn.Aggregator aggregator, int startRowId, int endRowId) {
        for (int rowId = startRowId; rowId < endRowId; ++rowId) {
            this.aggregatePoint(aggregator, rowId);
        }
    }

    public void aggregatePoints(OlapScalarEntityFactColumn.Aggregator aggregator, int[] rowIds, int len) {
        for (int row = 0; row < len; ++row) {
            this.aggregatePoint(aggregator, rowIds[row]);
        }
    }

    public final void aggregatePoint(OlapScalarEntityFactColumn.Aggregator aggregator, int rowId) {
        String value = this.getValueAsObject(rowId);
        OlapScalarEntity scalar = this.createScalarEntity(value);
        aggregator.aggregate(scalar);
    }

    private OlapScalarEntity createScalarEntity(@Nullable String value) {
        if (value != null) {
            return new OlapStringEntity(value);
        }
        return OlapEmptyEntity.INSTANCE;
    }

    public void setValueAsObject(int rowId, @Nullable String value) {
        throw new CdProgrammingException("internal error: operation not supported");
    }

    public void save(N_BackupContext context, S_BackupOutputStream out) throws IOException {
        if (context.isCancelling()) {
            return;
        }
        out.writeInt(this.startPosition == null ? -1 : this.startPosition.length);
        if (this.startPosition != null) {
            out.writeInts(this.startPosition);
        }
        out.writeInt(this.positions == null ? -1 : this.positions.length);
        if (this.positions != null) {
            for (IOlapFactIntList iOlapFactIntList : this.positions) {
                iOlapFactIntList.save(context, out);
            }
        }
        out.writeInt(this.modifiedUTF8 == null ? -1 : this.modifiedUTF8.length);
        if (this.modifiedUTF8 != null) {
            for (IOlapFactList iOlapFactList : this.modifiedUTF8) {
                iOlapFactList.save(context, out);
            }
        }
    }

    public void restore(N_RestoreContext context, S_BackupInputStream in) throws IOException {
        int modifiedUTF8Len;
        int positionsLen;
        if (context.isCancelling()) {
            return;
        }
        int startPositionLen = in.readInt();
        if (startPositionLen != -1) {
            this.startPosition = new int[startPositionLen];
            in.readInts(this.startPosition);
        }
        if ((positionsLen = in.readInt()) != -1) {
            this.positions = new IOlapFactIntList[positionsLen];
            for (int ii = 0; ii < this.positions.length; ++ii) {
                this.positions[ii] = this.factory.createInt();
                this.positions[ii].restore(context, in);
            }
        }
        if ((modifiedUTF8Len = in.readInt()) != -1) {
            this.modifiedUTF8 = new IOlapFactByteList[modifiedUTF8Len];
            for (int ii = 0; ii < this.modifiedUTF8.length; ++ii) {
                this.modifiedUTF8[ii] = this.factory.createBytes();
                this.modifiedUTF8[ii].restore(context, in);
            }
        }
    }

    static {
        for (int ii = 0; ii < LOWER_CASE_MAP.length; ++ii) {
            OlapFactModifiedUtf8StringPaginatedListHelper.LOWER_CASE_MAP[ii] = Character.toLowerCase((char)ii);
        }
    }

    public static interface Factory {
        public IOlapFactIntList createInt();

        public IOlapFactByteList createBytes();
    }
}

