/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.facts.column.memlist.date;

import crazydev.common.exception.programming.CdProgrammingException;
import crazydev.common.system.CdRamUsageEstimator;
import crazydev.iccube.cleaner.OlapFileCleaner;
import crazydev.iccube.cluster.node.backup.N_BackupContext;
import crazydev.iccube.cluster.node.backup.N_RestoreContext;
import crazydev.iccube.cluster.shared.backup.S_BackupInputStream;
import crazydev.iccube.cluster.shared.backup.S_BackupOutputStream;
import crazydev.iccube.olap.entity.OlapEmptyEntity;
import crazydev.iccube.olap.entity.scalar.OlapDateTimeEntity;
import crazydev.iccube.olap.entity.scalar.OlapScalarEntity;
import crazydev.iccube.olap.facts.column.columns.OlapScalarEntityFactColumn;
import crazydev.iccube.olap.facts.column.list.IOlapFactDoubleList;
import crazydev.iccube.olap.facts.column.list.IOlapFactFloatList;
import crazydev.iccube.olap.facts.column.list.IOlapFactLongList;
import java.io.IOException;
import java.util.Objects;
import org.jetbrains.annotations.Nullable;
import org.joda.time.CdJodaTimeUtil;
import org.joda.time.LocalDate;
import org.joda.time.LocalDateTime;

public class OlapFactDateTimePaginatedListHelper {
    private static long SHALLOW_SIZE_OF = -1L;
    private final IOlapFactLongList iLocalMillis;

    public OlapFactDateTimePaginatedListHelper(IOlapFactLongList iLocalMillis) {
        this.iLocalMillis = iLocalMillis;
    }

    public IOlapFactLongList getLocalMillis() {
        return this.iLocalMillis;
    }

    public void cleanupResources(OlapFileCleaner cleaner) {
        this.iLocalMillis.cleanupResources(cleaner);
    }

    public long sizeOf() {
        long size = SHALLOW_SIZE_OF != -1L ? SHALLOW_SIZE_OF : (SHALLOW_SIZE_OF = CdRamUsageEstimator.shallowSizeOf((Object)this));
        return size += this.iLocalMillis.sizeOf();
    }

    public long sizeOfFiles() {
        return this.iLocalMillis.sizeOfFiles();
    }

    public int size() {
        return this.iLocalMillis.size();
    }

    public boolean isEmpty() {
        return this.iLocalMillis.isEmpty();
    }

    @Nullable
    public LocalDateTime getQuick(int rowId) {
        return OlapFactDateTimePaginatedListHelper.asLocalDateTime(this.iLocalMillis.getQuick(rowId));
    }

    public long getQuickMillis(int rowId) {
        return this.iLocalMillis.getQuick(rowId);
    }

    @Nullable
    private static LocalDateTime asLocalDateTime(long millis) {
        if (OlapFactDateTimePaginatedListHelper.isNotNull(millis)) {
            return CdJodaTimeUtil.toDefaultChronologyDateTime((long)millis);
        }
        return null;
    }

    private static boolean isNotNull(long millis) {
        return millis != Long.MIN_VALUE;
    }

    public void setQuick(int rowId, @Nullable LocalDateTime dateTime) {
        this.iLocalMillis.setQuick(rowId, dateTime == null ? Long.MIN_VALUE : CdJodaTimeUtil.toDefaultChronologyMillis((LocalDateTime)dateTime));
    }

    public void add(@Nullable LocalDateTime val) {
        if (val == null) {
            this.iLocalMillis.add(Long.MIN_VALUE);
        } else {
            this.iLocalMillis.add(CdJodaTimeUtil.toDefaultChronologyMillis((LocalDateTime)val));
        }
    }

    public void trimToSize() {
        this.iLocalMillis.trimToSize();
    }

    public IOlapFactFloatList copyAsFloat() {
        throw new CdProgrammingException("internal error: date cannot be converted to float");
    }

    public IOlapFactDoubleList copyAsDouble() {
        throw new CdProgrammingException("internal error: date cannot be converted to double");
    }

    public void aggregatePoints(OlapScalarEntityFactColumn.Aggregator aggregator, int[] rowIds, int len) {
        for (int row = 0; row < len; ++row) {
            this.aggregatePoint(aggregator, rowIds[row]);
        }
    }

    public final void aggregatePoint(OlapScalarEntityFactColumn.Aggregator aggregator, int rowId) {
        if (aggregator.useLongInDates()) {
            long millis = this.iLocalMillis.getQuick(rowId);
            if (OlapFactDateTimePaginatedListHelper.isNotNull(millis)) {
                aggregator.aggregate(millis);
            }
        } else {
            LocalDateTime dateTime = this.getQuick(rowId);
            OlapScalarEntity entity = OlapFactDateTimePaginatedListHelper.createScalarEntity(dateTime);
            aggregator.aggregate(entity);
        }
    }

    public void aggregateRange(final OlapScalarEntityFactColumn.Aggregator aggregator, int startRowId, int endRowId) {
        if (aggregator.useLongInDates()) {
            this.iLocalMillis.aggregateRange(new Aggregator(this){
                {
                    Objects.requireNonNull(this$0);
                }

                @Override
                public void aggregate(long value) {
                    aggregator.aggregate(value);
                }
            }, startRowId, endRowId);
        } else {
            this.iLocalMillis.aggregateRange(new Aggregator(this){
                {
                    Objects.requireNonNull(this$0);
                }

                @Override
                public void aggregate(long value) {
                    LocalDateTime dateTime = OlapFactDateTimePaginatedListHelper.asLocalDateTime(value);
                    OlapScalarEntity entity = OlapFactDateTimePaginatedListHelper.createScalarEntity(dateTime);
                    aggregator.aggregate(entity);
                }
            }, startRowId, endRowId);
        }
    }

    private static OlapScalarEntity createScalarEntity(@Nullable LocalDateTime dateTime) {
        if (dateTime != null) {
            return new OlapDateTimeEntity(dateTime);
        }
        return OlapEmptyEntity.INSTANCE;
    }

    public int lookup(Comparable lookupValue, int start) {
        if (start < 0 || start >= this.size()) {
            return -1;
        }
        if (lookupValue instanceof LocalDateTime) {
            return this.iLocalMillis.lookup(CdJodaTimeUtil.localMillis((LocalDateTime)((LocalDateTime)lookupValue)), start);
        }
        if (lookupValue instanceof LocalDate) {
            return this.iLocalMillis.lookup(CdJodaTimeUtil.localMillis((LocalDate)((LocalDate)lookupValue)), start);
        }
        return -1;
    }

    public void save(N_BackupContext context, S_BackupOutputStream out) throws IOException {
        this.iLocalMillis.save(context, out);
    }

    public void restore(N_RestoreContext context, S_BackupInputStream in) throws IOException {
        this.iLocalMillis.restore(context, in);
    }

    protected static class Aggregator
    extends OlapScalarEntityFactColumn.Aggregator {
        protected Aggregator() {
        }

        @Override
        public OlapScalarEntity asScalarEntity() {
            return OlapEmptyEntity.INSTANCE;
        }
    }
}

