/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.facts.column.memlist.date;

import crazydev.common.exception.programming.CdProgrammingException;
import crazydev.common.system.CdRamUsageEstimator;
import crazydev.iccube.cleaner.OlapFileCleaner;
import crazydev.iccube.cluster.node.backup.N_BackupContext;
import crazydev.iccube.cluster.node.backup.N_RestoreContext;
import crazydev.iccube.cluster.shared.backup.S_BackupInputStream;
import crazydev.iccube.cluster.shared.backup.S_BackupOutputStream;
import crazydev.iccube.olap.entity.OlapEmptyEntity;
import crazydev.iccube.olap.entity.scalar.OlapDateEntity;
import crazydev.iccube.olap.entity.scalar.OlapScalarEntity;
import crazydev.iccube.olap.facts.column.columns.OlapScalarEntityFactColumn;
import crazydev.iccube.olap.facts.column.list.IOlapFactDoubleList;
import crazydev.iccube.olap.facts.column.list.IOlapFactFloatList;
import crazydev.iccube.olap.facts.column.list.IOlapFactIntList;
import crazydev.iccube.olap.facts.column.memlist.date.OlapFactDateTimePaginatedListHelper;
import java.io.IOException;
import java.util.Objects;
import org.jetbrains.annotations.Nullable;
import org.joda.time.CdJodaTimeUtil;
import org.joda.time.LocalDate;

public class OlapFactDatePaginatedListHelper {
    private static long SHALLOW_SIZE_OF = -1L;
    private final IOlapFactIntList iDays;

    public OlapFactDatePaginatedListHelper(IOlapFactIntList iDays) {
        this.iDays = iDays;
    }

    public IOlapFactIntList getLocalMillis() {
        return this.iDays;
    }

    public void cleanupResources(OlapFileCleaner cleaner) {
        this.iDays.cleanupResources(cleaner);
    }

    public long sizeOf() {
        long size = SHALLOW_SIZE_OF != -1L ? SHALLOW_SIZE_OF : (SHALLOW_SIZE_OF = CdRamUsageEstimator.shallowSizeOf((Object)this));
        return size += this.iDays.sizeOf();
    }

    public long sizeOfFiles() {
        return this.iDays.sizeOfFiles();
    }

    public int size() {
        return this.iDays.size();
    }

    public boolean isEmpty() {
        return this.iDays.isEmpty();
    }

    @Nullable
    public LocalDate getQuick(int rowId) {
        return OlapFactDatePaginatedListHelper.asLocalDate(this.iDays.getQuick(rowId));
    }

    public void setQuick(int rowId, @Nullable LocalDate days) {
        this.iDays.setQuick(rowId, days == null ? Integer.MIN_VALUE : CdJodaTimeUtil.toDefaultChronologyDays((LocalDate)days));
    }

    @Nullable
    private static LocalDate asLocalDate(int days) {
        if (OlapFactDatePaginatedListHelper.isNotNull(days)) {
            return CdJodaTimeUtil.toDefaultChronologyDate((int)days);
        }
        return null;
    }

    private static boolean isNotNull(int days) {
        return days != Integer.MIN_VALUE;
    }

    public void add(@Nullable LocalDate val) {
        if (val == null) {
            this.iDays.add(Integer.MIN_VALUE);
        } else {
            this.iDays.add(CdJodaTimeUtil.toDefaultChronologyDays((LocalDate)val));
        }
    }

    public void trimToSize() {
        this.iDays.trimToSize();
    }

    public IOlapFactFloatList copyAsFloat() {
        throw new CdProgrammingException("internal error: date cannot be converted to float");
    }

    public IOlapFactDoubleList copyAsDouble() {
        throw new CdProgrammingException("internal error: date cannot be converted to double");
    }

    public void aggregatePoints(OlapScalarEntityFactColumn.Aggregator aggregator, int[] rowIds, int len) {
        for (int row = 0; row < len; ++row) {
            this.aggregatePoint(aggregator, rowIds[row]);
        }
    }

    public final void aggregatePoint(OlapScalarEntityFactColumn.Aggregator aggregator, int rowId) {
        if (aggregator.useLongInDates()) {
            int millis = this.iDays.getQuick(rowId);
            if (OlapFactDatePaginatedListHelper.isNotNull(millis)) {
                aggregator.aggregate(millis);
            }
        } else {
            LocalDate dateTime = this.getQuick(rowId);
            OlapScalarEntity entity = OlapFactDatePaginatedListHelper.createScalarEntity(dateTime);
            aggregator.aggregate(entity);
        }
    }

    public void aggregateRange(final OlapScalarEntityFactColumn.Aggregator aggregator, int startRowId, int endRowId) {
        if (aggregator.useLongInDates()) {
            this.iDays.aggregateRange(new OlapFactDateTimePaginatedListHelper.Aggregator(this){
                {
                    Objects.requireNonNull(this$0);
                }

                @Override
                public void aggregate(long value) {
                    aggregator.aggregate(value);
                }
            }, startRowId, endRowId);
        } else {
            this.iDays.aggregateRange(new OlapFactDateTimePaginatedListHelper.Aggregator(this){
                {
                    Objects.requireNonNull(this$0);
                }

                @Override
                public void aggregate(long value) {
                    LocalDate dateTime = OlapFactDatePaginatedListHelper.asLocalDate((int)value);
                    OlapScalarEntity entity = OlapFactDatePaginatedListHelper.createScalarEntity(dateTime);
                    aggregator.aggregate(entity);
                }
            }, startRowId, endRowId);
        }
    }

    private static OlapScalarEntity createScalarEntity(@Nullable LocalDate dateTime) {
        if (dateTime != null) {
            return new OlapDateEntity(dateTime);
        }
        return OlapEmptyEntity.INSTANCE;
    }

    public int lookup(Comparable lookupValue, int start) {
        if (start < 0 || start >= this.size()) {
            return -1;
        }
        if (lookupValue instanceof LocalDate) {
            return this.iDays.lookup(CdJodaTimeUtil.toDefaultChronologyDays((LocalDate)((LocalDate)lookupValue)), start);
        }
        return -1;
    }

    public void save(N_BackupContext context, S_BackupOutputStream out) throws IOException {
        this.iDays.save(context, out);
    }

    public void restore(N_RestoreContext context, S_BackupInputStream in) throws IOException {
        this.iDays.restore(context, in);
    }

    public int getQuickDateMillis(int rowId) {
        return this.iDays.getQuick(rowId);
    }
}

