/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.facts.column.memlist.bool;

import crazydev.common.exception.programming.CdProgrammingException;
import crazydev.common.system.CdRamUsageEstimator;
import crazydev.iccube.cleaner.OlapFileCleaner;
import crazydev.iccube.cluster.node.backup.N_BackupContext;
import crazydev.iccube.cluster.node.backup.N_RestoreContext;
import crazydev.iccube.cluster.shared.backup.S_BackupInputStream;
import crazydev.iccube.cluster.shared.backup.S_BackupOutputStream;
import crazydev.iccube.olap.entity.scalar.OlapBooleanEntity;
import crazydev.iccube.olap.facts.column.columns.OlapScalarEntityFactColumn;
import crazydev.iccube.olap.facts.column.list.IOlapFactDoubleList;
import crazydev.iccube.olap.facts.column.list.IOlapFactFloatList;
import crazydev.iccube.olap.facts.column.list.IOlapFactLongList;
import java.io.IOException;

public class OlapFactBooleanPaginatedListHelper {
    private static long SHALLOW_SIZE_OF = -1L;
    private static final int BITS = 6;
    private static final int MASK = 63;
    private final IOlapFactLongList nullsBuffers;
    private final IOlapFactLongList factsBuffers;
    private int size;

    public OlapFactBooleanPaginatedListHelper(IOlapFactLongList nullsBuffers, IOlapFactLongList factsBuffers) {
        this.nullsBuffers = nullsBuffers;
        this.factsBuffers = factsBuffers;
    }

    public IOlapFactLongList getNullsBuffers() {
        return this.nullsBuffers;
    }

    public IOlapFactLongList getFactsBuffers() {
        return this.factsBuffers;
    }

    public void cleanupResources(OlapFileCleaner cleaner) {
        this.nullsBuffers.cleanupResources(cleaner);
        this.factsBuffers.cleanupResources(cleaner);
    }

    public long sizeOf() {
        long size = SHALLOW_SIZE_OF != -1L ? SHALLOW_SIZE_OF : (SHALLOW_SIZE_OF = CdRamUsageEstimator.shallowSizeOf((Object)this));
        size += this.nullsBuffers.sizeOf();
        return size += this.factsBuffers.sizeOf();
    }

    public long sizeOfFiles() {
        return this.nullsBuffers.sizeOfFiles() + this.factsBuffers.sizeOfFiles();
    }

    public int size() {
        return this.size;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public boolean getQuick(int rowId) {
        return OlapFactBooleanPaginatedListHelper.get(this.factsBuffers, rowId);
    }

    public boolean isNull(int rowId) {
        return OlapFactBooleanPaginatedListHelper.get(this.nullsBuffers, rowId);
    }

    public static boolean get(IOlapFactLongList where, int rowId) {
        long buffer = where.getQuick(rowId >> 6);
        return (buffer & 1L << rowId) != 0L;
    }

    public void add(boolean val) {
        OlapFactBooleanPaginatedListHelper.add(this.factsBuffers, val, this.size);
        OlapFactBooleanPaginatedListHelper.add(this.nullsBuffers, false, this.size);
        ++this.size;
    }

    public void addNull() {
        OlapFactBooleanPaginatedListHelper.add(this.factsBuffers, false, this.size);
        OlapFactBooleanPaginatedListHelper.add(this.nullsBuffers, true, this.size);
        ++this.size;
    }

    public void setNewNull(int rowId) {
        this.ensureCapacity(rowId);
        OlapFactBooleanPaginatedListHelper.add(this.factsBuffers, false, this.size);
        OlapFactBooleanPaginatedListHelper.add(this.nullsBuffers, true, this.size);
    }

    public void setNew(int rowId, Boolean val) {
        this.ensureCapacity(rowId);
        OlapFactBooleanPaginatedListHelper.add(this.factsBuffers, val, this.size);
        OlapFactBooleanPaginatedListHelper.add(this.nullsBuffers, false, this.size);
    }

    public void setQuickNull(int rowId) {
        OlapFactBooleanPaginatedListHelper.set(this.nullsBuffers, rowId, true);
    }

    public static void add(IOlapFactLongList where, boolean val, int size) {
        int offset = size >> 6;
        if (offset >= where.size()) {
            long buffer = 0L;
            if (val) {
                buffer |= 1L << size;
            }
            where.add(buffer);
        } else if (val) {
            long buffer = where.getQuick(offset);
            where.setQuick(offset, buffer |= 1L << size);
        }
    }

    public void setQuick(int rowId, boolean val) {
        OlapFactBooleanPaginatedListHelper.set(this.factsBuffers, rowId, val);
        OlapFactBooleanPaginatedListHelper.set(this.nullsBuffers, rowId, false);
    }

    private void ensureCapacity(int rowId) {
        this.factsBuffers.ensureCapacity(OlapFactBooleanPaginatedListHelper.sizeForLong(rowId));
        this.nullsBuffers.ensureCapacity(OlapFactBooleanPaginatedListHelper.sizeForLong(rowId));
    }

    public static int sizeForLong(int rowId) {
        return rowId >> 6;
    }

    public static void set(IOlapFactLongList where, int rowId, boolean val) {
        long buffer = where.getQuick(rowId >> 6);
        buffer = val ? (buffer |= 1L << rowId) : (buffer &= 1L << rowId ^ 0xFFFFFFFFFFFFFFFFL);
        where.setQuick(rowId >> 6, buffer);
    }

    public void trimToSize() {
        this.nullsBuffers.trimToSize();
        this.factsBuffers.trimToSize();
    }

    public final void aggregatePoints(OlapScalarEntityFactColumn.Aggregator aggregator, int[] rowIds, int len) {
        for (int row = 0; row < len; ++row) {
            this.aggregatePoint(aggregator, rowIds[row]);
        }
    }

    public final void aggregatePoint(OlapScalarEntityFactColumn.Aggregator aggregator, int rowId) {
        if (!this.isNull(rowId)) {
            boolean value = this.getQuick(rowId);
            aggregator.aggregate(OlapBooleanEntity.value(value));
        }
    }

    public void aggregateRange(OlapScalarEntityFactColumn.Aggregator aggregator, int startRowId, int endRowId) {
        int wordStart = startRowId >> 6;
        int wordStartOffset = startRowId & 0x3F;
        int wordEnd = endRowId >> 6;
        int wordEndOffset = endRowId & 0x3F;
        this.doAggregateRange(aggregator, wordStart, wordStartOffset, wordStart == wordEnd ? wordEndOffset : 64);
        for (int word = wordStart + 1; word < wordEnd; ++word) {
            this.doAggregateRange(aggregator, word, 0, 64);
        }
        if (wordEnd > wordStart && wordEndOffset != 0) {
            this.doAggregateRange(aggregator, wordEnd, 0, wordEndOffset);
        }
    }

    private void doAggregateRange(OlapScalarEntityFactColumn.Aggregator aggregator, int word, int wordStartOffset, int wordEndOffset) {
        long nulls = this.nullsBuffers.getQuick(word);
        long facts = this.factsBuffers.getQuick(word);
        for (int offset = wordStartOffset; offset < wordEndOffset; ++offset) {
            if ((nulls & 1L << offset) != 0L) continue;
            boolean val = (facts & 1L << offset) != 0L;
            aggregator.aggregate(OlapBooleanEntity.value(val));
        }
    }

    public IOlapFactFloatList copyAsFloat() {
        throw new CdProgrammingException("internal error: boolean cannot be converted to float");
    }

    public IOlapFactDoubleList copyAsDouble() {
        throw new CdProgrammingException("internal error: boolean cannot be converted to double");
    }

    public int lookup(Boolean lookupValue, int start) {
        int size = this.size();
        if (start < 0 || start >= size) {
            return -1;
        }
        for (int rowId = start; rowId < size; ++rowId) {
            if (this.isNull(rowId) || lookupValue.booleanValue() != this.getQuick(rowId)) continue;
            return rowId;
        }
        return -1;
    }

    public void save(N_BackupContext context, S_BackupOutputStream out) throws IOException {
        out.writeInt(this.size);
        this.nullsBuffers.save(context, out);
        this.factsBuffers.save(context, out);
    }

    public void restore(N_RestoreContext context, S_BackupInputStream in) throws IOException {
        this.size = in.readInt();
        this.nullsBuffers.restore(context, in);
        this.factsBuffers.restore(context, in);
    }
}

